/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.ElementAttributeInfo;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.XPathParts;

public class JsonConverter {
    private static final String FILES = "el.*";
    private static final String MAIN_DIRECTORY = CLDRPaths.MAIN_DIRECTORY;
    private static final String OUT_DIRECTORY = CLDRPaths.GEN_DIRECTORY + "/jason/";
    private static boolean COMPACT = false;
    static final Set<String> REPLACING_BASE = !COMPACT ? Collections.EMPTY_SET : new HashSet<String>(Arrays.asList("type id key count".split("\\s")));
    static final Set<String> EXTRA_DISTINGUISHING = new HashSet<String>(Arrays.asList("locales territory desired supported".split("\\s")));
    static final Relation<String, String> mainInfo = ElementAttributeInfo.getInstance(DtdType.ldml).getElement2Attributes();
    static final Relation<String, String> suppInfo = ElementAttributeInfo.getInstance(DtdType.supplementalData).getElement2Attributes();
    static Relation<String, String> extraDistinguishing = Relation.of(new TreeMap(), LinkedHashSet.class);

    public static void main(String[] args) throws IOException {
        String subdirectory = new File(MAIN_DIRECTORY).getName();
        Factory cldrFactory = Factory.make(MAIN_DIRECTORY, FILES);
        TreeSet<String> locales = new TreeSet<String>(cldrFactory.getAvailable());
        XPathParts parts = new XPathParts();
        for (String locale : locales) {
            System.out.println("Converting:\t" + locale);
            CLDRFile file = cldrFactory.make(locale, false);
            Relation<String, String> element2Attributes = file.isNonInheriting() ? suppInfo : mainInfo;
            TableItem main = new TableItem(null);
            DtdType dtdType = null;
            Iterator<String> it = file.iterator("", file.getComparator());
            while (it.hasNext()) {
                String xpath = it.next();
                String fullXpath = file.getFullXPath(xpath);
                String value = file.getStringValue(xpath);
                XPathParts oldParts = XPathParts.getFrozenInstance(fullXpath).cloneAsThawed();
                if (dtdType == null) {
                    dtdType = DtdType.valueOf(parts.getElement(0));
                }
                JsonConverter.rewrite(dtdType, oldParts, value, element2Attributes, parts);
                System.out.println(parts);
                Item current = main;
                int size = parts.size();
                for (int i = 0; i < size - 1; ++i) {
                    String element = parts.getElement(i);
                    Map<String, String> actualAttributeKeys = parts.getAttributes(i);
                    Set<String> keySet = actualAttributeKeys.keySet();
                    if (keySet.size() != 0) {
                        Item temp = ((Item)current).makeSubItem(element, Item.Type.unorderedItem);
                        for (String attribute : keySet) {
                            temp.put(attribute, actualAttributeKeys.get(attribute));
                        }
                    }
                    if (i < size - 2) {
                        current = ((Item)current).makeSubItem(element, actualAttributeKeys.containsKey("_q") ? Item.Type.orderedItem : Item.Type.unorderedItem);
                        continue;
                    }
                    ((Item)current).put(element, parts.getElement(i + 1));
                }
            }
            PrintWriter out = FileUtilities.openUTF8Writer(OUT_DIRECTORY + subdirectory, locale + ".json");
            ((Item)main).print(out, 0);
            out.close();
        }
    }

    static <K, V> void putAll(Relation r, K key, V ... values) {
        r.putAll(key, Arrays.asList(values));
    }

    private static boolean isDistinguishing(DtdType dtdType, String element, String attribute) {
        Set<String> extras;
        if (element.equals("deprecatedItems")) {
            // empty if block
        }
        if ((extras = extraDistinguishing.getAll(element)) != null && extras.contains(attribute)) {
            return true;
        }
        if (EXTRA_DISTINGUISHING.contains(attribute)) {
            return true;
        }
        return CLDRFile.isDistinguishing(dtdType, element, attribute);
    }

    private static void rewrite(DtdType dtdType, XPathParts parts, String value, Relation<String, String> element2Attributes, XPathParts out) {
        String key;
        out.clear();
        int size = parts.size();
        for (int i = 1; i < size; ++i) {
            String attributeValue;
            String element = parts.getElement(i);
            out.addElement(element);
            Collection<String> actualAttributeKeys = parts.getAttributeKeys(i);
            boolean isOrdered = actualAttributeKeys.contains("_q");
            Set<String> possibleAttributeKeys = element2Attributes.getAll(element);
            for (String attribute : actualAttributeKeys) {
                attributeValue = parts.getAttributeValue(i, attribute);
                if (JsonConverter.isDistinguishing(dtdType, element, attribute)) continue;
                out.addAttribute(attribute, attributeValue);
            }
            if (possibleAttributeKeys != null) {
                for (String attribute : possibleAttributeKeys) {
                    if (!JsonConverter.isDistinguishing(dtdType, element, attribute) || attribute.equals("alt")) continue;
                    attributeValue = parts.getAttributeValue(i, attribute);
                    out.addElement("_" + attribute);
                    if (attributeValue == null) {
                        attributeValue = "?";
                    }
                    out.addElement(attributeValue);
                }
            }
            if (!isOrdered) continue;
            Map<String, String> lastAttributes = out.getAttributes(-2);
            lastAttributes.put("_q", "_q");
        }
        if (value.length() > 0) {
            out.addElement(value);
        }
        if (!COMPACT) {
            return;
        }
        if (parts.getElement(-1).equals("type") && (key = parts.getAttributeValue(-1, "key")) != null) {
            parts.setElement(-2, key + "Key");
            parts.putAttributeValue(-1, "key", null);
        }
        if (parts.getElement(1).equals("localeDisplayNames")) {
            String element2 = parts.getElement(2);
            if (!element2.endsWith("Pattern")) {
                if (element2.endsWith("s")) {
                    element2 = element2.substring(0, element2.length() - 1);
                }
                parts.setElement(2, element2 + "Names");
            }
            parts.removeElement(1);
        }
        if (parts.getElement(1).equals("dates")) {
            parts.removeElement(1);
            String element1 = parts.getElement(1);
            if (element1.equals("timeZoneNames")) {
                String main = parts.getElement(2);
                if (main.equals("zone") || main.equals("metazone")) {
                    parts.setElement(1, main + "Names");
                }
                return;
            }
        }
        if (parts.getElement(1).equals("numbers") && parts.getElement(2).equals("currencies")) {
            parts.removeElement(1);
            return;
        }
    }

    static {
        JsonConverter.putAll(extraDistinguishing, "dayPeriodRule", "earlyMorning", "before", "from");
    }

    static class StringItem
    extends Item {
        private String value;

        public StringItem(String value2) {
            super(null);
            this.value = value2;
        }

        @Override
        public Appendable print(Appendable result, int i) {
            try {
                return this.appendString(result, this.value, i + 1);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public Item makeSubItem(String element, Item.Type ordered) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void put(String element, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }
    }

    static class ArrayItem
    extends Item {
        private List<Row.R2<String, Item>> list = new ArrayList<Row.R2<String, Item>>();

        public ArrayItem(Item parent) {
            super(parent);
        }

        @Override
        public Appendable print(Appendable result, int i) {
            try {
                if (this.list.size() == 0) {
                    result.append("[]");
                    return result;
                }
                result.append("[\n");
                for (int j = 0; j < this.list.size(); ++j) {
                    if (j != 0) {
                        result.append(",\n");
                    }
                    this.indent(result, i + 1);
                    Row.R2<String, Item> row = this.list.get(j);
                    result.append("{");
                    this.appendString(result, (String)row.get0(), i + 1);
                    result.append(" : ");
                    ((Item)row.get1()).print(result, i + 1);
                    result.append("}");
                }
                result.append("\n");
                this.indent(result, i).append("]");
                return result;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public Item makeSubItem(String element, Item.Type ordered) {
            Item result = this.create(ordered);
            this.list.add(Row.of(element, result));
            return result;
        }

        @Override
        public void put(String element, String value) {
            this.list.add(Row.of(element, new StringItem(value)));
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }

    static class TableItem
    extends Item {
        private Map<String, Item> map = new LinkedHashMap<String, Item>();

        public TableItem(Item parent) {
            super(parent);
        }

        public Item get(String element) {
            return this.map.get(element);
        }

        @Override
        public void put(String element, String value) {
            Item old = this.map.get(element);
            if (old != null) {
                if (old instanceof StringItem && value.equals(((StringItem)old).value)) {
                    return;
                }
                throw new IllegalArgumentException("ERROR: Table already has object: " + element + ", " + old + ", " + value + ", " + this.getRoot().toString());
            }
            this.map.put(element, new StringItem(value));
        }

        @Override
        public Item makeSubItem(String element, Item.Type ordered) {
            Item result = this.map.get(element);
            if (result != null) {
                return result;
            }
            result = this.create(ordered);
            result.parent = this;
            this.map.put(element, result);
            return result;
        }

        @Override
        public Appendable print(Appendable result, int i) {
            try {
                if (this.map.size() == 0) {
                    result.append("{}");
                    return result;
                }
                result.append("{\n");
                boolean first = true;
                for (String key : this.map.keySet()) {
                    Item value = this.map.get(key);
                    if (first) {
                        first = false;
                    } else {
                        result.append(",\n");
                    }
                    this.indent(result, i + 1);
                    this.appendString(result, key, -1).append(" : ");
                    value.print(result, i + 1);
                }
                result.append("\n");
                this.indent(result, i).append("}");
                return result;
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    static abstract class Item {
        protected Item parent;

        public Item(Item parent) {
            this.parent = parent;
        }

        public abstract int size();

        public abstract Appendable print(Appendable var1, int var2);

        protected Appendable indent(Appendable result, int i) throws IOException {
            return result.append(this.getIndent(i));
        }

        protected String getIndent(int i) {
            return Utility.repeat("    ", i);
        }

        public Appendable appendString(Appendable result, String string, int indent) throws IOException {
            result.append('\"');
            block10: for (int i = 0; i < string.length(); ++i) {
                char ch = string.charAt(i);
                switch (ch) {
                    case '\"': {
                        result.append("\\\"");
                        continue block10;
                    }
                    case '\\': {
                        result.append("\\\\");
                        continue block10;
                    }
                    case '/': {
                        result.append("\\/");
                        continue block10;
                    }
                    case '\b': {
                        result.append("\\b");
                        continue block10;
                    }
                    case '\f': {
                        result.append("\\f");
                        continue block10;
                    }
                    case '\n': {
                        if (indent < 0) {
                            result.append("\\n");
                            continue block10;
                        }
                        result.append('\n').append(this.getIndent(indent));
                        continue block10;
                    }
                    case '\r': {
                        result.append("\\r");
                        continue block10;
                    }
                    case '\t': {
                        result.append("\\t");
                        continue block10;
                    }
                    default: {
                        if (ch <= '\u001f' || '\u007f' <= ch && ch <= '\u009f') {
                            result.append("\\u").append(Utility.hex(ch, 4));
                            continue block10;
                        }
                        result.append(ch);
                    }
                }
            }
            return result.append('\"');
        }

        public String toString() {
            return this.print(new StringBuilder(), 0).toString();
        }

        protected Item create(Type ordered) {
            switch (ordered) {
                case unorderedItem: {
                    return new TableItem(this);
                }
                case orderedItem: {
                    return new ArrayItem(this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public abstract Item makeSubItem(String var1, Type var2);

        public abstract void put(String var1, String var2);

        public Item getRoot() {
            if (this.parent == null) {
                return this;
            }
            return this.parent.getRoot();
        }

        static enum Type {
            unorderedItem,
            orderedItem;

        }
    }

    static class ElementName {
        String oldBase;
        String base;
        boolean replacedBase;
        StringBuilder suffix = new StringBuilder();

        ElementName() {
        }

        public void reset(String element) {
            this.suffix.setLength(0);
            this.base = this.oldBase = element;
            this.replacedBase = false;
        }

        public void add(String attribute, String attributeValue) {
            if (REPLACING_BASE.contains(attribute)) {
                if (this.replacedBase) {
                    System.out.println("ERROR: Two replacement types on same element!!\t" + this.oldBase + "," + this.base + "," + attribute + "," + attributeValue);
                } else {
                    this.replacedBase = true;
                    this.base = attributeValue;
                    return;
                }
            }
            this.suffix.append('$').append(attribute).append('=').append(attributeValue);
        }

        public String toString() {
            if (this.suffix == null) {
                return this.base;
            }
            return this.base + this.suffix;
        }
    }
}

