/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.json;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import com.ibm.icu.number.IntegerWidth;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.NoUnit;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.json.CldrItem;
import org.unicode.cldr.json.CldrNode;
import org.unicode.cldr.json.LdmlConvertRules;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.Annotations;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileProcessor;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

@CLDRTool(alias="ldml2json", description="Convert CLDR data to JSON")
public class Ldml2JsonConverter {
    private static final String CLDR_PKG_PREFIX = "cldr-";
    private static final String FULL_TIER_SUFFIX = "-full";
    private static final String MODERN_TIER_SUFFIX = "-modern";
    private static boolean DEBUG = false;
    private static final StandardCodes sc = StandardCodes.make();
    private Set<String> defaultContentLocales = SupplementalDataInfo.getInstance().getDefaultContentLocales();
    private Set<String> skippedDefaultContentLocales = new TreeSet<String>();
    private availableLocales avl = new availableLocales();
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Option.Options options = new Option.Options("Usage: LDML2JsonConverter [OPTIONS] [FILES]\nThis program converts CLDR data to the JSON format.\nPlease refer to the following options. \n\texample: org.unicode.cldr.json.Ldml2JsonConverter -c xxx -d yyy").add("commondir", Character.valueOf('c'), ".*", CLDRPaths.COMMON_DIRECTORY, "Common directory for CLDR files, defaults to CldrUtility.COMMON_DIRECTORY").add("destdir", Character.valueOf('d'), ".*", CLDRPaths.GEN_DIRECTORY, "Destination directory for output files, defaults to CldrUtility.GEN_DIRECTORY").add("match", Character.valueOf('m'), ".*", ".*", "Regular expression to define only specific locales or files to be generated").add("type", Character.valueOf('t'), "(main|supplemental|segments|rbnf|annotations|annotationsDerived)", "main", "Type of CLDR data being generated, main, supplemental, or segments.").add("resolved", Character.valueOf('r'), "(true|false)", "false", "Whether the output JSON for the main directory should be based on resolved or unresolved data").add("draftstatus", Character.valueOf('s'), "(approved|contributed|provisional|unconfirmed)", "unconfirmed", "The minimum draft status of the output data").add("coverage", Character.valueOf('l'), "(minimal|basic|moderate|modern|comprehensive|optional)", "optional", "The maximum coverage level of the output data").add("fullnumbers", Character.valueOf('n'), "(true|false)", "false", "Whether the output JSON should output data for all numbering systems, even those not used in the locale").add("other", Character.valueOf('o'), "(true|false)", "false", "Whether to write out the 'other' section, which contains any unmatched paths").add("packages", Character.valueOf('p'), "(true|false)", "false", "Whether to group data files into installable packages").add("identity", Character.valueOf('i'), "(true|false)", "true", "Whether to copy the identity info into all sections containing data").add("konfig", Character.valueOf('k'), ".*", null, "LDML to JSON configuration file").add("pkgversion", Character.valueOf('V'), ".*", Ldml2JsonConverter.getDefaultVersion(), "Version to be used in writing package files");
    private String cldrCommonDir;
    private String outputDir;
    private boolean fullNumbers;
    private boolean resolve;
    private String match;
    private int coverageValue;
    private boolean writePackages;
    private final RunType type;
    private Map<String, String> dependencies;
    private List<JSONSection> sections;
    private Set<String> packages;
    private final String pkgVersion;
    static final Pattern ANNOTATION_CP_REMAP = PatternCache.get("^(.*)\\[@cp=\"(\\[|\\]|'|\"|@|/|=)\"\\](.*)$");
    LocalizedNumberFormatter percentFormatter = (LocalizedNumberFormatter)((LocalizedNumberFormatter)((LocalizedNumberFormatter)NumberFormatter.withLocale(Locale.ENGLISH).unit(NoUnit.PERCENT)).integerWidth(IntegerWidth.zeroFillTo(3))).precision(Precision.integer());
    private static final Pattern escapePattern = PatternCache.get("\\\\(?!u)");

    public static void main(String[] args) throws Exception {
        options.parse(args, true);
        Ldml2JsonConverter l2jc = new Ldml2JsonConverter(options.get("commondir").getValue(), options.get("destdir").getValue(), options.get("type").getValue(), Boolean.parseBoolean(options.get("fullnumbers").getValue()), Boolean.parseBoolean(options.get("resolved").getValue()), options.get("coverage").getValue(), options.get("match").getValue(), Boolean.parseBoolean(options.get("packages").getValue()), options.get("konfig").getValue(), options.get("pkgversion").getValue());
        long start = System.currentTimeMillis();
        CLDRFile.DraftStatus status = CLDRFile.DraftStatus.valueOf(options.get("draftstatus").getValue());
        l2jc.processDirectory(options.get("type").getValue(), status);
        long end = System.currentTimeMillis();
        System.out.println("Finished in " + (end - start) + " ms");
    }

    public Ldml2JsonConverter(String cldrDir, String outputDir, String runType, boolean fullNumbers, boolean resolve, String coverage, String match, boolean writePackages, String configFile, String pkgVersion) {
        this.cldrCommonDir = cldrDir;
        this.outputDir = outputDir;
        this.type = RunType.valueOf(runType);
        this.fullNumbers = fullNumbers;
        this.resolve = resolve;
        this.match = match;
        this.writePackages = writePackages;
        this.coverageValue = Level.get(coverage).getLevel();
        this.pkgVersion = pkgVersion;
        LdmlConvertRules.addVersionHandler(pkgVersion.split("\\.")[0]);
        this.sections = new ArrayList<JSONSection>();
        this.packages = new TreeSet<String>();
        this.dependencies = new HashMap<String, String>();
        FileProcessor myReader = new FileProcessor(){

            @Override
            protected boolean handleLine(int lineCount, String line) {
                String[] lineParts = line.trim().split("\\s*;\\s*");
                String section = null;
                String path = null;
                String packageName = null;
                String dependency = null;
                boolean hasSection = false;
                boolean hasPath = false;
                boolean hasPackage = false;
                boolean hasDependency = false;
                for (String linePart : lineParts) {
                    int pos = linePart.indexOf(61);
                    if (pos < 0) {
                        throw new IllegalArgumentException();
                    }
                    String key = linePart.substring(0, pos);
                    String value = linePart.substring(pos + 1);
                    if (key.equals("section")) {
                        hasSection = true;
                        section = value;
                        continue;
                    }
                    if (key.equals("path")) {
                        hasPath = true;
                        path = value;
                        continue;
                    }
                    if (key.equals("package")) {
                        hasPackage = true;
                        packageName = value;
                        continue;
                    }
                    if (!key.equals("dependency")) continue;
                    hasDependency = true;
                    dependency = value;
                }
                if (hasSection && hasPath) {
                    JSONSection j = new JSONSection();
                    j.section = section;
                    j.pattern = PatternCache.get(path);
                    if (hasPackage) {
                        j.packageName = packageName;
                    }
                    Ldml2JsonConverter.this.sections.add(j);
                }
                if (hasDependency && hasPackage) {
                    Ldml2JsonConverter.this.dependencies.put(packageName, dependency);
                }
                return true;
            }
        };
        if (configFile != null) {
            myReader.process(configFile);
        } else {
            switch (this.type) {
                case main: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config.txt");
                    break;
                }
                case supplemental: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config_supplemental.txt");
                    break;
                }
                case segments: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config_segments.txt");
                    break;
                }
                case rbnf: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config_rbnf.txt");
                    break;
                }
                default: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config_" + this.type.name() + ".txt");
                }
            }
        }
        JSONSection j = new JSONSection();
        j.section = "other";
        j.pattern = PatternCache.get(".*");
        this.sections.add(j);
    }

    private String transformPath(String pathStr, String pathPrefix) {
        String result = pathStr;
        Matcher cpm = ANNOTATION_CP_REMAP.matcher(result);
        if (cpm.matches()) {
            String badCodepointRange = cpm.group(2);
            StringBuilder sb = new StringBuilder(cpm.group(1)).append("[@cp=\"");
            if (badCodepointRange.codePointCount(0, badCodepointRange.length()) != 1) {
                throw new IllegalArgumentException("Need exactly one codepoint in the @cp string, but got " + badCodepointRange + " in xpath " + pathStr);
            }
            badCodepointRange.codePoints().forEach(cp -> sb.append("U+").append(Integer.toHexString(cp).toUpperCase()));
            sb.append("\"]").append(cpm.group(3));
            result = sb.toString();
        }
        if (DEBUG) {
            System.out.println(" IN pathStr : " + result);
        }
        result = LdmlConvertRules.PathTransformSpec.applyAll(result);
        result = result.replaceFirst("/ldml/", pathPrefix);
        if ((result = result.replaceFirst("/supplementalData/", pathPrefix)).contains("languages") || result.contains("languageAlias") || result.contains("languageMatches") || result.contains("likelySubtags") || result.contains("parentLocale") || result.contains("locales=")) {
            result = this.localeIdToLangTag(result);
        }
        if (DEBUG) {
            System.out.println("OUT pathStr : " + result);
        }
        if (DEBUG) {
            System.out.println("result: " + result);
        }
        return result;
    }

    private Map<JSONSection, List<CldrItem>> mapPathsToSections(AtomicInteger readCount, int totalCount, CLDRFile file, String pathPrefix, SupplementalDataInfo sdi) throws IOException, ParseException {
        TreeMap<JSONSection, List<CldrItem>> sectionItems = new TreeMap<JSONSection, List<CldrItem>>();
        String locID = file.getLocaleID();
        Matcher noNumberingSystemMatcher = LdmlConvertRules.NO_NUMBERING_SYSTEM_PATTERN.matcher("");
        Matcher numberingSystemMatcher = LdmlConvertRules.NUMBERING_SYSTEM_PATTERN.matcher("");
        Matcher rootIdentityMatcher = LdmlConvertRules.ROOT_IDENTITY_PATTERN.matcher("");
        TreeSet<String> activeNumberingSystems = new TreeSet<String>();
        activeNumberingSystems.add("latn");
        for (String np : LdmlConvertRules.ACTIVE_NUMBERING_SYSTEM_XPATHS) {
            String ns = file.getWinningValue(np);
            if (ns == null || ns.length() <= 0) continue;
            activeNumberingSystems.add(ns);
        }
        DtdType fileDtdType = CLDRFile.isSupplementalName(locID) ? DtdType.supplementalData : DtdType.ldml;
        CoverageInfo covInfo = CLDRConfig.getInstance().getCoverageInfo();
        Iterator<String> it = file.iterator("", DtdData.getInstance(fileDtdType).getDtdComparator(null));
        block1: while (it.hasNext()) {
            XPathParts xpp;
            String currentNS;
            int cv = Level.UNDETERMINED.getLevel();
            String path = it.next();
            String fullPath = file.getFullXPath(path);
            String value = file.getWinningValue(path);
            if (path.startsWith("//ldml/localeDisplayNames/languages") && file.getSourceLocaleID(path, null).equals("code-fallback")) {
                value = file.getConstructedBaileyValue(path, null, null);
            }
            if (fullPath == null) {
                fullPath = path;
            }
            if (!CLDRFile.isSupplementalName(locID) && path.startsWith("//ldml/") && !path.contains("/identity")) {
                cv = covInfo.getCoverageValue(path, locID);
            }
            if (cv > this.coverageValue) continue;
            rootIdentityMatcher.reset(fullPath);
            if (rootIdentityMatcher.matches() && !"root".equals(locID)) continue;
            noNumberingSystemMatcher.reset(fullPath);
            if (noNumberingSystemMatcher.matches()) continue;
            numberingSystemMatcher.reset(fullPath);
            if (numberingSystemMatcher.matches() && !this.fullNumbers && (currentNS = (xpp = XPathParts.getFrozenInstance(fullPath)).getAttributeValue(2, "numberSystem")) != null && !activeNumberingSystems.contains(currentNS) || this.resolve && CldrUtility.NO_INHERITANCE_MARKER.equals(value)) continue;
            String transformedPath = this.transformPath(path, pathPrefix);
            String transformedFullPath = this.transformPath(fullPath, pathPrefix);
            if (transformedPath.isEmpty()) continue;
            for (JSONSection js : this.sections) {
                if (!js.pattern.matcher(transformedPath).matches()) continue;
                CldrItem item = new CldrItem(transformedPath, transformedFullPath, path, fullPath, value);
                ArrayList<CldrItem> cldrItems = (ArrayList<CldrItem>)sectionItems.get(js);
                if (cldrItems == null) {
                    cldrItems = new ArrayList<CldrItem>();
                }
                cldrItems.add(item);
                sectionItems.put(js, cldrItems);
                continue block1;
            }
        }
        Matcher versionInfoMatcher = PatternCache.get(".*/(identity|version).*").matcher("");
        JSONSection otherSection = this.sections.get(this.sections.size() - 1);
        List others = (List)sectionItems.get(otherSection);
        if (others == null) {
            return sectionItems;
        }
        ArrayList otherSectionItems = new ArrayList(others);
        int addedItemCount = 0;
        boolean copyIdentityInfo = Boolean.parseBoolean(options.get("identity").getValue());
        for (CldrItem item : otherSectionItems) {
            String thisPath = item.getPath();
            versionInfoMatcher.reset(thisPath);
            if (!versionInfoMatcher.matches()) continue;
            for (JSONSection js : this.sections) {
                List hit;
                if (sectionItems.get(js) != null && !js.section.equals("other") && copyIdentityInfo) {
                    hit = (List)sectionItems.get(js);
                    hit.add(addedItemCount, item);
                    sectionItems.put(js, hit);
                }
                if (!js.section.equals("other")) continue;
                hit = (List)sectionItems.get(js);
                hit.remove(item);
                sectionItems.put(js, hit);
            }
            ++addedItemCount;
        }
        return sectionItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int convertCldrItems(AtomicInteger readCount, int totalCount, String dirName, String filename, String pathPrefix, Map<JSONSection, List<CldrItem>> sectionItems) throws IOException, ParseException {
        int totalItemsInFile = 0;
        LinkedList<Pair<String, Integer>> outputProgress = new LinkedList<Pair<String, Integer>>();
        for (JSONSection js : this.sections) {
            File dir;
            if (js.section.equals("IGNORE")) continue;
            String filenameAsLangTag = this.localeIdToLangTag(filename);
            if (this.type == RunType.rbnf) {
                String string = filenameAsLangTag + ".json";
            } else if (js.section.equals("other")) {
                String string = js.section + "-" + filenameAsLangTag + ".json";
            } else {
                String string = js.section + ".json";
            }
            String tier = "";
            boolean writeOther = Boolean.parseBoolean(options.get("other").getValue());
            if (js.section.equals("other") && !writeOther) continue;
            StringBuilder outputDirname = new StringBuilder(this.outputDir);
            if (this.writePackages) {
                if (this.type.tiered()) {
                    LocaleIDParser lp = new LocaleIDParser();
                    lp.set(filename);
                    if (this.defaultContentLocales.contains(filename) && lp.getRegion().length() > 0) {
                        if (this.type != RunType.main) continue;
                        this.skippedDefaultContentLocales.add(filenameAsLangTag);
                        continue;
                    }
                    boolean isModernTier = this.localeIsModernTier(filename);
                    if (isModernTier) {
                        tier = MODERN_TIER_SUFFIX;
                        if (this.type == RunType.main) {
                            this.avl.modern.add(filenameAsLangTag);
                        }
                    } else {
                        tier = FULL_TIER_SUFFIX;
                    }
                    if (this.type == RunType.main) {
                        this.avl.full.add(filenameAsLangTag);
                    }
                } else if (this.type == RunType.rbnf) {
                    js.packageName = "rbnf";
                    tier = "";
                }
                if (js.packageName != null) {
                    String packageName = CLDR_PKG_PREFIX + js.packageName + tier;
                    outputDirname.append("/" + packageName);
                    this.packages.add(packageName);
                }
                outputDirname.append("/" + dirName + "/");
                if (this.type.tiered()) {
                    outputDirname.append(filenameAsLangTag);
                }
                if (DEBUG) {
                    System.out.println("outDir: " + outputDirname);
                    System.out.println("pack: " + js.packageName);
                    System.out.println("dir: " + dirName);
                }
            } else {
                outputDirname.append("/" + filename);
            }
            if (!(dir = new File(outputDirname.toString())).exists()) {
                dir.mkdirs();
            }
            assert (tier.isEmpty() == !this.type.tiered());
            ArrayList<String> outputDirs = new ArrayList<String>();
            outputDirs.add(outputDirname.toString());
            if (this.writePackages && tier.equals(MODERN_TIER_SUFFIX) && js.packageName != null) {
                outputDirs.add(outputDirname.toString().replaceFirst(MODERN_TIER_SUFFIX, FULL_TIER_SUFFIX));
                this.packages.add(CLDR_PKG_PREFIX + js.packageName + FULL_TIER_SUFFIX);
            }
            for (String outputDir : outputDirs) {
                void var11_11;
                List<CldrItem> theItems = sectionItems.get(js);
                if (theItems == null || theItems.size() == 0) {
                    if (!DEBUG) continue;
                    System.out.println(">" + this.progressPrefix(readCount, totalCount) + outputDir + " - no items to write in " + js.section);
                    continue;
                }
                if (DEBUG) {
                    System.out.print("?" + this.progressPrefix(readCount, totalCount, filename, js.section) + " - " + theItems.size() + " item(s)\r");
                }
                PrintWriter outf = FileUtilities.openUTF8Writer(outputDir, (String)var11_11);
                JsonWriter out = new JsonWriter(outf);
                out.setIndent("  ");
                ArrayList<CldrItem> sortingItems = new ArrayList<CldrItem>();
                ArrayList<CldrItem> arrayItems = new ArrayList<CldrItem>();
                ArrayList<CldrNode> nodesForLastItem = new ArrayList<CldrNode>();
                String lastLeadingArrayItemPath = null;
                String leadingArrayItemPath = "";
                int valueCount = 0;
                String previousIdentityPath = null;
                for (CldrItem item : theItems) {
                    CldrItem[] items;
                    if (item.getPath().isEmpty()) {
                        throw new IllegalArgumentException("empty xpath in " + filename + " section " + js.packageName + "/" + js.section);
                    }
                    if (this.type == RunType.rbnf) {
                        item.adjustRbnfPath();
                    }
                    if (item.getPath().contains("/identity/")) {
                        String[] parts = item.getPath().split("\\[");
                        if (parts[0].equals(previousIdentityPath)) continue;
                        XPathParts xpp = XPathParts.getFrozenInstance(item.getPath());
                        String territory = xpp.findAttributeValue("territory", "type");
                        LocaleIDParser lp = new LocaleIDParser().set(filename);
                        if (territory != null && territory.length() > 0 && !territory.equals(lp.getRegion())) continue;
                        previousIdentityPath = parts[0];
                    }
                    if ((items = item.split()) == null) {
                        items = new CldrItem[]{item};
                    }
                    valueCount += items.length;
                    if (item.getUntransformedPath().contains("unitPreference")) continue;
                    for (CldrItem newItem : items) {
                        if (newItem.isAliasItem()) {
                            --valueCount;
                        }
                        if (newItem.needsSort()) {
                            this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                            sortingItems.add(newItem);
                            continue;
                        }
                        Matcher matcher = LdmlConvertRules.ARRAY_ITEM_PATTERN.matcher(newItem.getPath());
                        if (matcher.matches()) {
                            this.resolveSortingItems(out, nodesForLastItem, sortingItems);
                            leadingArrayItemPath = matcher.group(1);
                            if (lastLeadingArrayItemPath != null && !lastLeadingArrayItemPath.equals(leadingArrayItemPath)) {
                                this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                            }
                            lastLeadingArrayItemPath = leadingArrayItemPath;
                            arrayItems.add(newItem);
                            continue;
                        }
                        this.resolveSortingItems(out, nodesForLastItem, sortingItems);
                        this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                        this.outputCldrItem(out, nodesForLastItem, newItem);
                        lastLeadingArrayItemPath = "";
                    }
                }
                this.resolveSortingItems(out, nodesForLastItem, sortingItems);
                this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                if (js.section.contains("unitPreferenceData")) {
                    this.outputUnitPreferenceData(js, theItems, out, nodesForLastItem);
                }
                this.closeNodes(out, nodesForLastItem.size() - 2, 0);
                outf.println();
                out.close();
                String outPath = new File(outputDir.substring(this.outputDir.length()), (String)var11_11).getPath();
                outputProgress.add(Pair.of(js.section + ' ' + outPath, valueCount));
                if (DEBUG) {
                    String outStr = ">" + this.progressPrefix(readCount, totalCount, filename, js.section) + String.format("\u2026%s (%d values)", outPath, valueCount);
                    AtomicInteger atomicInteger = readCount;
                    synchronized (atomicInteger) {
                        System.out.println(outStr);
                    }
                }
                totalItemsInFile += valueCount;
            }
        }
        StringBuilder outStr = new StringBuilder();
        if (!outputProgress.isEmpty()) {
            for (Pair pair : outputProgress) {
                outStr.append(String.format("\t%s (%d)\n", pair.getFirst(), pair.getSecond()));
            }
            outStr.append(String.format("%s%s (%d values in %d sections)\n", this.progressPrefix(readCount, totalCount), filename, totalItemsInFile, outputProgress.size()));
        } else {
            outStr.append(String.format("%s%s (no items output)\n", this.progressPrefix(readCount, totalCount), filename));
        }
        AtomicInteger atomicInteger = readCount;
        synchronized (atomicInteger) {
            System.out.print(outStr);
        }
        return totalItemsInFile;
    }

    private boolean localeIsModernTier(String filename) {
        Level localeCoverageLevel = sc.getLocaleCoverageLevel("Cldr", filename);
        boolean isModernTier = localeCoverageLevel == Level.MODERN || filename.equals("root");
        return isModernTier;
    }

    private String localeIdToLangTag(String filename) {
        return filename.replaceAll("_", "-");
    }

    private void outputUnitPreferenceData(JSONSection js, List<CldrItem> theItems, JsonWriter out, ArrayList<CldrNode> nodesForLastItem) throws ParseException, IOException {
        CldrNode unitPrefNode = CldrNode.createNode("supplemental", js.section, js.section);
        this.startNonleafNode(out, unitPrefNode, 1);
        TreeMap<Pair, Map> catUsagetoRegionItems = new TreeMap<Pair, Map>();
        for (CldrItem item : theItems) {
            if (!item.getUntransformedPath().contains("unitPref")) continue;
            CldrItem[] items = item.split();
            if (items == null) {
                throw new IllegalArgumentException("expected unit pref to split: " + item);
            }
            for (CldrItem subItem : items) {
                XPathParts xpp = XPathParts.getFrozenInstance(subItem.getPath());
                String category2 = xpp.findFirstAttributeValue("category");
                String usage = xpp.findFirstAttributeValue("usage");
                String region = xpp.findFirstAttributeValue("regions");
                Pair<String, String> key = Pair.of(category2, usage);
                Map regionMap = catUsagetoRegionItems.computeIfAbsent(key, ignored -> new TreeMap());
                List perRegion = regionMap.computeIfAbsent(region, ignored -> new ArrayList());
                perRegion.add(subItem);
            }
        }
        catUsagetoRegionItems.keySet().stream().map(p -> (String)p.getFirst()).distinct().forEach(category -> {
            try {
                out.name((String)category).beginObject();
                catUsagetoRegionItems.entrySet().stream().filter(p -> ((String)((Pair)p.getKey()).getFirst()).equals(category)).forEach(ent -> {
                    String usage = (String)((Pair)ent.getKey()).getSecond();
                    try {
                        out.name(usage);
                        out.beginObject();
                        ((Map)ent.getValue()).forEach((region, list) -> {
                            try {
                                out.name((String)region);
                                out.beginArray();
                                list.forEach(item -> {
                                    try {
                                        XPathParts xpp = XPathParts.getFrozenInstance(item.getPath());
                                        out.beginObject();
                                        out.name("unit");
                                        out.value(item.getValue());
                                        if (xpp.containsAttribute("geq")) {
                                            out.name("geq");
                                            out.value(Double.parseDouble(xpp.findFirstAttributeValue("geq")));
                                        }
                                        out.endObject();
                                    }
                                    catch (IOException e) {
                                        throw new ICUUncheckedIOException(e);
                                    }
                                });
                                out.endArray();
                            }
                            catch (IOException e) {
                                throw new ICUUncheckedIOException(e);
                            }
                        });
                        out.endObject();
                    }
                    catch (IOException e) {
                        throw new ICUUncheckedIOException(e);
                    }
                });
                out.endObject();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ICUUncheckedIOException(e);
            }
        });
        nodesForLastItem.add(unitPrefNode);
    }

    public void writePackagingFiles(String outputDir, String packageName) throws IOException {
        this.writePackageJson(outputDir, packageName);
        this.writeBowerJson(outputDir, packageName);
    }

    public void writeBasicInfo(JsonObject obj, String packageName, boolean isNPM) {
        obj.addProperty("name", packageName);
        obj.addProperty("version", this.pkgVersion);
        String[] packageNameParts = packageName.split("-");
        String dependency = this.dependencies.get(packageNameParts[1]);
        if (dependency != null) {
            String[] dependentPackageNames = new String[1];
            String tier = packageNameParts[packageNameParts.length - 1];
            dependentPackageNames[0] = dependency.equals("core") ? "cldr-core" : CLDR_PKG_PREFIX + dependency + "-" + tier;
            JsonObject dependencies = new JsonObject();
            for (String dependentPackageName : dependentPackageNames) {
                if (dependentPackageName == null) continue;
                dependencies.addProperty(dependentPackageName, this.pkgVersion);
            }
            obj.add(isNPM ? "peerDependencies" : "dependencies", dependencies);
        }
    }

    private static String getDefaultVersion() {
        String versionString = "39";
        while (versionString.split("\\.").length < 3) {
            versionString = versionString + ".0";
        }
        return versionString;
    }

    public void writePackageJson(String outputDir, String packageName) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/" + packageName, "package.json");
        System.out.println("Creating packaging file => " + outputDir + File.separator + packageName + File.separator + "package.json");
        JsonObject obj = new JsonObject();
        this.writeBasicInfo(obj, packageName, true);
        JsonArray maintainers = new JsonArray();
        JsonObject primaryMaintainer = new JsonObject();
        obj.addProperty("homepage", "http://cldr.unicode.org");
        obj.addProperty("author", "The Unicode Consortium");
        primaryMaintainer.addProperty("name", "John Emmons");
        primaryMaintainer.addProperty("email", "emmo@us.ibm.com");
        primaryMaintainer.addProperty("url", "https://github.com/JCEmmons");
        maintainers.add(primaryMaintainer);
        obj.add("maintainers", maintainers);
        JsonObject repository = new JsonObject();
        repository.addProperty("type", "git");
        repository.addProperty("url", "git://github.com/unicode-cldr/cldr-json.git");
        obj.add("repository", repository);
        obj.addProperty("license", "Unicode-DFS-2016");
        obj.addProperty("bugs", "http://cldr.unicode.org/index/bug-reports#TOC-Filing-a-Ticket");
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writeBowerJson(String outputDir, String packageName) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/" + packageName, "bower.json");
        System.out.println("Creating packaging file => " + outputDir + File.separator + packageName + File.separator + "bower.json");
        JsonObject obj = new JsonObject();
        this.writeBasicInfo(obj, packageName, false);
        if (this.type == RunType.supplemental) {
            JsonArray mainPaths = new JsonArray();
            mainPaths.add(new JsonPrimitive("availableLocales.json"));
            mainPaths.add(new JsonPrimitive("defaultContent.json"));
            mainPaths.add(new JsonPrimitive("scriptMetadata.json"));
            mainPaths.add(new JsonPrimitive(this.type.toString() + "/*.json"));
            obj.add("main", mainPaths);
        } else if (this.type == RunType.rbnf) {
            obj.addProperty("main", this.type.toString() + "/*.json");
        } else {
            obj.addProperty("main", this.type.toString() + "/**/*.json");
        }
        JsonArray ignorePaths = new JsonArray();
        ignorePaths.add(new JsonPrimitive(".gitattributes"));
        ignorePaths.add(new JsonPrimitive("README.md"));
        obj.add("ignore", ignorePaths);
        obj.addProperty("license", "Unicode-DFS-2016");
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writeDefaultContent(String outputDir) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/cldr-core", "defaultContent.json");
        System.out.println("Creating packaging file => " + outputDir + "cldr-core" + File.separator + "defaultContent.json");
        JsonObject obj = new JsonObject();
        obj.add("defaultContent", this.gson.toJsonTree(this.skippedDefaultContentLocales));
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writeAvailableLocales(String outputDir) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/cldr-core", "availableLocales.json");
        System.out.println("Creating packaging file => " + outputDir + "cldr-core" + File.separator + "availableLocales.json");
        JsonObject obj = new JsonObject();
        obj.add("availableLocales", this.gson.toJsonTree(this.avl));
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writeScriptMetadata(String outputDir) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/cldr-core", "scriptMetadata.json");
        System.out.println("Creating script metadata file => " + outputDir + File.separator + "cldr-core" + File.separator + "scriptMetadata.json");
        TreeMap<String, ScriptMetadata.Info> scriptInfo = new TreeMap<String, ScriptMetadata.Info>();
        for (String script : ScriptMetadata.getScripts()) {
            ScriptMetadata.Info i = ScriptMetadata.getInfo(script);
            scriptInfo.put(script, i);
        }
        if (ScriptMetadata.errors.size() > 0) {
            System.err.println(Joiner.on("\n\t").join(ScriptMetadata.errors));
        }
        JsonObject obj = new JsonObject();
        obj.add("scriptMetadata", this.gson.toJsonTree(scriptInfo));
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    private void resolveSortingItems(JsonWriter out, ArrayList<CldrNode> nodesForLastItem, ArrayList<CldrItem> sortingItems) throws IOException, ParseException {
        ArrayList<CldrItem> arrayItems = new ArrayList<CldrItem>();
        String lastLeadingArrayItemPath = null;
        if (!sortingItems.isEmpty()) {
            Collections.sort(sortingItems);
            for (CldrItem item : sortingItems) {
                Matcher matcher = LdmlConvertRules.ARRAY_ITEM_PATTERN.matcher(item.getPath());
                if (matcher.matches()) {
                    String leadingArrayItemPath = matcher.group(1);
                    if (lastLeadingArrayItemPath != null && !lastLeadingArrayItemPath.equals(leadingArrayItemPath)) {
                        this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                    }
                    lastLeadingArrayItemPath = leadingArrayItemPath;
                    arrayItems.add(item);
                    continue;
                }
                this.outputCldrItem(out, nodesForLastItem, item);
            }
            sortingItems.clear();
            this.resolveArrayItems(out, nodesForLastItem, arrayItems);
        }
    }

    private void resolveArrayItems(JsonWriter out, ArrayList<CldrNode> nodesForLastItem, ArrayList<CldrItem> arrayItems) throws IOException, ParseException {
        if (!arrayItems.isEmpty()) {
            CldrItem firstItem = arrayItems.get(0);
            if (firstItem.needsSort()) {
                Collections.sort(arrayItems);
                firstItem = arrayItems.get(0);
            }
            int arrayLevel = this.getArrayIndentLevel(firstItem);
            this.outputStartArray(out, nodesForLastItem, firstItem, arrayLevel);
            for (int len = nodesForLastItem.size(); len > arrayLevel; --len) {
                nodesForLastItem.remove(len - 1);
            }
            for (CldrItem insideItem : arrayItems) {
                this.outputArrayItem(out, insideItem, nodesForLastItem, arrayLevel);
            }
            arrayItems.clear();
            int lastLevel = nodesForLastItem.size() - 1;
            this.closeNodes(out, lastLevel, arrayLevel);
            out.endArray();
            for (int i = arrayLevel - 1; i < lastLevel; ++i) {
                nodesForLastItem.remove(i);
            }
        }
    }

    private int getArrayIndentLevel(CldrItem item) throws ParseException {
        Matcher matcher = LdmlConvertRules.ARRAY_ITEM_PATTERN.matcher(item.getPath());
        if (!matcher.matches()) {
            System.out.println("No match found for " + item.getPath() + ", this shouldn't happen.");
            return 0;
        }
        String leadingPath = matcher.group(1);
        CldrItem fakeItem = new CldrItem(leadingPath, leadingPath, leadingPath, leadingPath, "");
        return fakeItem.getNodesInPath().size() - 1;
    }

    private void outputStartArray(JsonWriter out, ArrayList<CldrNode> nodesForLastItem, CldrItem item, int arrayLevel) throws IOException, ParseException {
        int i;
        ArrayList<CldrNode> nodesInPath = item.getNodesInPath();
        this.closeNodes(out, nodesForLastItem.size() - 2, i);
        for (i = this.findFirstDiffNodeIndex(nodesForLastItem, nodesInPath); i < arrayLevel - 1; ++i) {
            this.startNonleafNode(out, nodesInPath.get(i), i);
        }
        String objName = nodesInPath.get(i).getNodeKeyName();
        out.name(objName);
        out.beginArray();
    }

    private void outputCldrItem(JsonWriter out, ArrayList<CldrNode> nodesForLastItem, CldrItem item) throws IOException, ParseException {
        if (item.isAliasItem()) {
            return;
        }
        ArrayList<CldrNode> nodesInPath = item.getNodesInPath();
        int arraySize = nodesInPath.size();
        int i = this.findFirstDiffNodeIndex(nodesForLastItem, nodesInPath);
        if (i == nodesInPath.size() && this.type != RunType.rbnf) {
            System.err.println("This nodes and last nodes has identical path. (" + item.getPath() + ") Some distinguishing attributes wrongly removed?");
            return;
        }
        this.closeNodes(out, nodesForLastItem.size() - 2, i);
        while (i < nodesInPath.size() - 1) {
            this.startNonleafNode(out, nodesInPath.get(i), i);
            ++i;
        }
        this.writeLeafNode(out, nodesInPath.get(i), item.getValue(), i);
        nodesForLastItem.clear();
        nodesForLastItem.addAll(nodesInPath);
    }

    private void closeNodes(JsonWriter out, int last, int firstDiff) throws IOException {
        for (int i = last; i >= firstDiff; --i) {
            if (i == 0) {
                out.endObject();
                break;
            }
            out.endObject();
        }
    }

    private void startNonleafNode(JsonWriter out, CldrNode node, int level) throws IOException {
        String objName = node.getNodeKeyName();
        if (objName == null) {
            return;
        }
        if (level == 0) {
            out.beginObject();
            return;
        }
        Map<String, String> attrAsValueMap = node.getAttrAsValueMap();
        if (this.type == RunType.annotations || this.type == RunType.annotationsDerived) {
            if (objName.startsWith("U+")) {
                out.name(UTF16.valueOf(Integer.parseInt(objName.substring(2), 16)));
            } else {
                out.name(objName);
            }
        } else {
            out.name(objName);
        }
        out.beginObject();
        for (String key : attrAsValueMap.keySet()) {
            String value = this.escapeValue(attrAsValueMap.get(key));
            out.name("_" + key).value(value);
        }
    }

    private void outputArrayItem(JsonWriter out, CldrItem item, ArrayList<CldrNode> nodesForLastItem, int arrayLevel) throws IOException, ParseException {
        ArrayList<CldrNode> nodesInPath = item.getNodesInPath();
        String value = this.escapeValue(item.getValue());
        int nodesNum = nodesInPath.size();
        int diff = this.findFirstDiffNodeIndex(nodesForLastItem, nodesInPath);
        CldrNode cldrNode = nodesInPath.get(nodesNum - 1);
        if (diff > arrayLevel) {
            this.closeNodes(out, nodesForLastItem.size() - 1, diff + 1);
            for (int i = diff; i < nodesNum - 1; ++i) {
                this.startNonleafNode(out, nodesInPath.get(i), i + 1);
            }
            this.writeLeafNode(out, cldrNode, value, nodesNum);
            return;
        }
        if (arrayLevel == nodesNum - 1) {
            Map<String, String> attrAsValueMap;
            String objName;
            int pos;
            if (nodesForLastItem.size() - 1 - arrayLevel > 0) {
                this.closeNodes(out, nodesForLastItem.size() - 1, arrayLevel);
            }
            if ((pos = (objName = cldrNode.getNodeKeyName()).indexOf(45)) > 0) {
                objName = objName.substring(0, pos);
            }
            if ((attrAsValueMap = cldrNode.getAttrAsValueMap()).isEmpty()) {
                out.beginObject();
                out.name(objName).value(value);
                out.endObject();
            } else if (objName.equals("rbnfrule")) {
                this.writeRbnfLeafNode(out, item, attrAsValueMap);
            } else {
                out.beginObject();
                this.writeLeafNode(out, objName, attrAsValueMap, value, nodesNum, cldrNode.getName(), cldrNode.getParent());
                out.endObject();
            }
            nodesInPath.remove(nodesNum - 1);
        } else {
            if (nodesForLastItem.size() - 1 - arrayLevel > 0) {
                this.closeNodes(out, nodesForLastItem.size() - 1, arrayLevel);
            }
            out.beginObject();
            CldrNode node = nodesInPath.get(arrayLevel);
            String objName = node.getNodeKeyName();
            int pos = objName.indexOf(45);
            if (pos > 0) {
                objName = objName.substring(0, pos);
            }
            Map<String, String> attrAsValueMap = node.getAttrAsValueMap();
            out.name(objName);
            out.beginObject();
            for (String key : attrAsValueMap.keySet()) {
                out.name("_" + key).value(this.escapeValue(attrAsValueMap.get(key)));
            }
            for (int i = arrayLevel + 1; i < nodesInPath.size() - 1; ++i) {
                this.startNonleafNode(out, nodesInPath.get(i), i + 1);
            }
            this.writeLeafNode(out, cldrNode, value, nodesNum);
        }
        nodesForLastItem.clear();
        nodesForLastItem.addAll(nodesInPath);
    }

    private void writeRbnfLeafNode(JsonWriter out, CldrItem item, Map<String, String> attrAsValueMap) throws IOException {
        if (attrAsValueMap.size() != 1) {
            throw new IllegalArgumentException("Error, attributes seem wrong for RBNF " + item.getUntransformedPath());
        }
        Map.Entry<String, String> entry = attrAsValueMap.entrySet().iterator().next();
        out.beginArray().value(entry.getKey()).value(entry.getValue()).endArray();
    }

    private int findFirstDiffNodeIndex(ArrayList<CldrNode> nodesForLastItem, ArrayList<CldrNode> nodesInPath) {
        int i;
        for (i = 0; i < nodesInPath.size() && i < nodesForLastItem.size() && nodesInPath.get(i).getNodeDistinguishingName().equals(nodesForLastItem.get(i).getNodeDistinguishingName()); ++i) {
        }
        return i;
    }

    private String progressPrefix(AtomicInteger readCount, int totalCount, String filename, String section) {
        return this.progressPrefix(readCount.get(), totalCount, filename, section);
    }

    private String progressPrefix(int readCount, int totalCount, String filename, String section) {
        return this.progressPrefix(readCount, totalCount) + filename + "\t" + section + "\t";
    }

    private final String progressPrefix(AtomicInteger readCount, int totalCount) {
        return this.progressPrefix(readCount.get(), totalCount);
    }

    private final String progressPrefix(int readCount, int totalCount) {
        double asPercent = (double)readCount / (double)totalCount * 100.0;
        return String.format("[%s]:\t", this.percentFormatter.format(asPercent));
    }

    public void processDirectory(String dirName, CLDRFile.DraftStatus minimalDraftStatus) throws IOException, ParseException {
        SupplementalDataInfo sdi = SupplementalDataInfo.getInstance(this.cldrCommonDir + "supplemental");
        Factory cldrFactory = Factory.make(this.cldrCommonDir + dirName + "/", ".*");
        Set files = cldrFactory.getAvailable().stream().filter(filename -> filename.matches(this.match) && !LdmlConvertRules.IGNORE_FILE_SET.contains(filename)).collect(Collectors.toSet());
        int total = files.size();
        AtomicInteger readCount = new AtomicInteger(0);
        TreeMap errs = new TreeMap();
        System.out.println(this.progressPrefix(0, total) + " Beginning parallel process of " + total + " file(s)");
        Object[] noOutputFiles = ((Stream)files.parallelStream().unordered()).map(filename -> {
            CLDRFile file = cldrFactory.make((String)filename, this.resolve && this.type == RunType.main, minimalDraftStatus);
            readCount.incrementAndGet();
            if (DEBUG) {
                System.out.print("<" + this.progressPrefix(readCount, total, dirName, (String)filename) + "\r");
            }
            String pathPrefix = this.type == RunType.main ? "/cldr/" + dirName + "/" + this.localeIdToLangTag((String)filename) + "/" : "/cldr/" + dirName + "/";
            int totalForThisFile = 0;
            try {
                totalForThisFile = this.convertCldrItems(readCount, total, dirName, (String)filename, pathPrefix, this.mapPathsToSections(readCount, total, file, pathPrefix, sdi));
            }
            catch (IOException | ParseException t) {
                t.printStackTrace();
                System.err.println("!" + this.progressPrefix(readCount, total) + filename + " - err - " + t);
                errs.put(filename, t);
            }
            finally {
                if (DEBUG) {
                    System.out.println("." + this.progressPrefix(readCount, total) + "Completing " + dirName + "/" + filename);
                }
            }
            return new Pair<String, Integer>(dirName + "/" + filename, totalForThisFile);
        }).filter(p -> (Integer)p.getSecond() == 0).map(p -> (String)p.getFirst()).toArray();
        System.out.println(this.progressPrefix(total, total) + " Completed parallel process of " + total + " file(s)");
        if (noOutputFiles.length > 0) {
            System.err.println("WARNING: These " + noOutputFiles.length + " file(s) did not produce any output (check JSON config):");
            for (Iterator<Object> iterator : noOutputFiles) {
                System.err.println("\t- " + iterator.toString());
            }
        }
        if (!errs.isEmpty()) {
            System.err.println("Errors in these files:");
            for (Map.Entry entry : errs.entrySet()) {
                System.err.println((String)entry.getKey() + " - " + entry.getValue());
            }
            Iterator<Object> iterator = errs.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (entry.getValue() instanceof IOException) {
                    throw (IOException)entry.getValue();
                }
                if (entry.getValue() instanceof ParseException) {
                    throw (ParseException)entry.getValue();
                }
                throw new RuntimeException("Other exception thrown: " + entry.getValue());
            }
        }
        if (this.writePackages) {
            for (String string : this.packages) {
                this.writePackagingFiles(this.outputDir, string);
            }
            if (this.type == RunType.main) {
                this.writeDefaultContent(this.outputDir);
                this.writeAvailableLocales(this.outputDir);
            } else if (this.type == RunType.supplemental) {
                this.writeScriptMetadata(this.outputDir);
            }
        }
    }

    private String escapeValue(String value) {
        Matcher match = escapePattern.matcher(value);
        String ret = match.replaceAll("\\\\\\\\");
        return ret.replace("\"", "\\\"").replace("\n", " ").replace("\t", " ");
    }

    private void writeLeafNode(JsonWriter out, CldrNode node, String value, int level) throws IOException {
        String objName = node.getNodeKeyName();
        Map<String, String> attrAsValueMaps = node.getAttrAsValueMap();
        this.writeLeafNode(out, objName, attrAsValueMaps, value, level, node.getName(), node.getParent());
    }

    private void writeLeafNode(JsonWriter out, String objName, Map<String, String> attrAsValueMap, String value, int level, String nodeName, String parent) throws IOException {
        if (objName == null) {
            return;
        }
        value = this.escapeValue(value);
        boolean valueIsSpacesepArray = LdmlConvertRules.valueIsSpacesepArray(nodeName, parent);
        if (attrAsValueMap.isEmpty()) {
            out.name(objName);
            if (value.isEmpty()) {
                if (valueIsSpacesepArray) {
                    out.beginArray();
                    out.endArray();
                } else {
                    out.beginObject();
                    out.endObject();
                }
            } else if (this.type == RunType.annotations || this.type == RunType.annotationsDerived) {
                out.beginArray();
                for (String s2 : Annotations.splitter.split(value.trim())) {
                    out.value(s2);
                }
                out.endArray();
            } else if (valueIsSpacesepArray) {
                this.outputSpaceSepArray(out, value);
            } else {
                out.value(value);
            }
            return;
        }
        if (value.isEmpty() && attrAsValueMap.containsKey("_")) {
            String v = attrAsValueMap.get("_");
            out.name(objName);
            if (valueIsSpacesepArray) {
                this.outputSpaceSepArray(out, v);
            } else {
                out.value(v);
            }
            return;
        }
        out.name(objName);
        out.beginObject();
        if (!value.isEmpty()) {
            out.name("_value").value(value);
        }
        for (String key : attrAsValueMap.keySet()) {
            String attrValue = this.escapeValue(attrAsValueMap.get(key));
            if (LdmlConvertRules.ATTRVALUE_AS_ARRAY_SET.contains(key)) {
                String[] strings = attrValue.trim().split("\\s+");
                out.name("_" + key);
                out.beginArray();
                for (String s3 : strings) {
                    out.value(s3);
                }
                out.endArray();
                continue;
            }
            out.name("_" + key).value(attrValue);
        }
        out.endObject();
    }

    private void outputSpaceSepArray(JsonWriter out, String v) throws IOException {
        out.beginArray();
        for (String s2 : v.trim().split(" ")) {
            if (s2.isEmpty()) continue;
            out.value(s2);
        }
        out.endArray();
    }

    private class JSONSection
    implements Comparable<JSONSection> {
        public String section;
        public Pattern pattern;
        public String packageName;

        private JSONSection() {
        }

        @Override
        public int compareTo(JSONSection other) {
            return this.section.compareTo(other.section);
        }
    }

    private class availableLocales {
        Set<String> modern = new TreeSet<String>();
        Set<String> full = new TreeSet<String>();

        private availableLocales() {
        }
    }

    private static enum RunType {
        main,
        supplemental(false),
        segments,
        rbnf(false),
        annotations,
        annotationsDerived;

        private final boolean isTiered;

        private RunType() {
            this.isTiered = true;
        }

        private RunType(boolean isTiered) {
            this.isTiered = isTiered;
        }

        public boolean tiered() {
            return this.isTiered;
        }
    }
}

