/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.SAXException;

public class CLDRTest
extends TestFmwk {
    private static String MATCH;
    private static String MAIN_DIR;
    private static boolean SKIP_DRAFT;
    private Set<String> locales;
    private Set<String> languageLocales;
    private Factory cldrFactory;
    private CLDRFile resolvedRoot;
    private CLDRFile resolvedEnglish;
    private final UnicodeSet commonAndInherited = new UnicodeSet("[[:script=common:][:script=inherited:][:alphabetic=false:]]");
    private static final String[] WIDTHS;
    private static final String[] MONTHORDAYS;
    private Map<String, String> localeNameCache = new HashMap<String, String>();
    private CLDRFile english = null;
    private Set<String> surveyInfo = new TreeSet<String>();
    static String[] EXEMPLAR_SKIPS;
    static final long disableDate;
    CldrUtility.CollectionTransform EnglishName = new CldrUtility.CollectionTransform(){

        @Override
        public Object transform(Object source) {
            return CLDRTest.this.getLocalization(source.toString()) + " (" + source + ")";
        }
    };
    CldrUtility.CollectionTransform EnglishCurrencyName = new CldrUtility.CollectionTransform(){

        @Override
        public Object transform(Object source) {
            if (CLDRTest.this.english == null) {
                CLDRTest.this.english = CLDRTest.this.cldrFactory.make("en", true);
            }
            return CLDRTest.this.english.getName("currency", source.toString()) + " (" + source + ")";
        }
    };
    static final UnicodeSet XGRAPHEME;
    static final UnicodeSet DIGIT;

    public static void main(String[] args) throws Exception {
        MATCH = System.getProperty("XML_MATCH");
        if (MATCH == null) {
            MATCH = ".*";
        } else {
            System.out.println("Resetting MATCH:" + MATCH);
        }
        MAIN_DIR = System.getProperty("XML_MAIN_DIR");
        if (MAIN_DIR == null) {
            MAIN_DIR = CLDRPaths.MAIN_DIRECTORY;
        } else {
            System.out.println("Resetting MAIN_DIR:" + MAIN_DIR);
        }
        boolean bl = SKIP_DRAFT = System.getProperty("XML_SKIP_DRAFT") != null;
        if (SKIP_DRAFT) {
            System.out.println("Skipping Draft locales");
        }
        double deltaTime = System.currentTimeMillis();
        new CLDRTest().run(args);
        deltaTime = (double)System.currentTimeMillis() - deltaTime;
        System.out.println("Seconds: " + deltaTime / 1000.0);
    }

    public void TestZZZZHack() throws IOException {
        PrintWriter surveyFile = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "surveyInfo.txt");
        for (String s2 : this.surveyInfo) {
            surveyFile.println(s2);
        }
        surveyFile.close();
    }

    public CLDRTest() throws SAXException, IOException {
        this.cldrFactory = Factory.make(MAIN_DIR, MATCH);
        this.locales = this.cldrFactory.getAvailable();
        this.languageLocales = this.cldrFactory.getAvailableLanguages();
        this.resolvedRoot = this.cldrFactory.make("root", true);
        this.resolvedEnglish = this.cldrFactory.make("en", true);
    }

    public void TestCurrencyFormats() {
        for (String locale : this.locales) {
            boolean isPOSIX = locale.indexOf("POSIX") >= 0;
            this.logln("Testing: " + locale);
            CLDRFile item = this.cldrFactory.make(locale, false);
            for (String xpath : item) {
                String value;
                String pattern;
                DisplayAndInputProcessor.NumericType type = DisplayAndInputProcessor.NumericType.getNumericType(xpath);
                if (type == DisplayAndInputProcessor.NumericType.NOT_NUMERIC || (pattern = DisplayAndInputProcessor.getCanonicalPattern(value = item.getStringValue(xpath), type, isPOSIX)).equals(value)) continue;
                String draft = "";
                if (item.getFullXPath(xpath).indexOf("[@draft=\"unconfirmed\"]") >= 0) {
                    draft = " [draft]";
                }
                this.assertEquals(this.getLocaleAndName(locale) + draft + " " + (Object)((Object)type) + " pattern incorrect", pattern, value);
            }
        }
    }

    public void TestCommonChildren() {
        if (this.disableUntilLater("TestCommonChildren")) {
            return;
        }
        TreeMap<String, ValueCount> currentValues = new TreeMap<String, ValueCount>();
        TreeSet<String> okValues = new TreeSet<String>();
        for (String parent : this.languageLocales) {
            this.logln("Testing: " + parent);
            currentValues.clear();
            okValues.clear();
            Set<String> availableWithParent = this.cldrFactory.getAvailableWithParent(parent, true);
            for (String locale : availableWithParent) {
                this.logln("\tTesting: " + locale);
                CLDRFile item = this.cldrFactory.make(locale, false);
                for (String xpath : item) {
                    if (okValues.contains(xpath) || xpath.startsWith("//ldml/identity/")) continue;
                    String v = item.getStringValue(xpath);
                    ValueCount last = (ValueCount)currentValues.get(xpath);
                    if (last == null) {
                        ValueCount vc = new ValueCount();
                        vc.value = v;
                        vc.fullxpath = item.getFullXPath(xpath);
                        currentValues.put(xpath, vc);
                        continue;
                    }
                    if (v.equals(last.value)) {
                        ++last.count;
                        continue;
                    }
                    okValues.add(xpath);
                    currentValues.remove(xpath);
                }
            }
            if (currentValues.size() == 0) continue;
            int size = availableWithParent.size();
            CLDRFile parentCLDR = this.cldrFactory.make(parent, true);
            for (String xpath : currentValues.keySet()) {
                ValueCount vc = (ValueCount)currentValues.get(xpath);
                if (vc.count != size && (!vc.value.equals(parentCLDR.getStringValue(xpath)) || !vc.fullxpath.equals(parentCLDR.getStringValue(xpath)))) continue;
                String draft = "";
                if (vc.fullxpath.indexOf("[@draft=\"unconfirmed\"]") >= 0) {
                    draft = " [draft]";
                }
                String count = (vc.count == size ? "" : vc.count + "/") + size;
                this.warnln(this.getLocaleAndName(parent) + draft + "\tall children (" + count + ") have same value for:\t" + xpath + ";\t" + vc.value);
            }
        }
    }

    public void TestThatExemplarsContainAll() {
        UnicodeSet allExemplars = new UnicodeSet();
        if (this.disableUntilLater("TestThatExemplarsContainAll")) {
            return;
        }
        TreeSet<String> counts = new TreeSet<String>();
        int totalCount = 0;
        UnicodeSet localeMissing = new UnicodeSet();
        for (String locale : this.locales) {
            if (locale.equals("root")) continue;
            CLDRFile resolved = this.cldrFactory.make(locale, false);
            UnicodeSet exemplars = this.getFixedExemplarSet(locale, resolved);
            CLDRFile plain = this.cldrFactory.make(locale, false);
            int count = 0;
            localeMissing.clear();
            block1: for (String xpath : plain) {
                String fullxpath;
                for (int i = 0; i < EXEMPLAR_SKIPS.length; ++i) {
                    if (xpath.indexOf(EXEMPLAR_SKIPS[i]) > 0) continue block1;
                }
                if (SKIP_DRAFT && (fullxpath = plain.getFullXPath(xpath)).indexOf("[@draft=\"unconfirmed\"") > 0 || xpath.startsWith("//ldml/posix/messages")) continue;
                String value = plain.getStringValue(xpath);
                allExemplars.addAll(value);
                if (exemplars.containsAll(value)) continue;
                ++count;
                UnicodeSet missing = new UnicodeSet().addAll(value).removeAll(exemplars);
                localeMissing.addAll(missing);
                this.logln(this.getLocaleAndName(locale) + "\t" + xpath + "\t<" + value + "> contains " + missing + ", not in exemplars");
                this.surveyInfo.add(locale + "\t" + xpath + "\t'" + value + "' contains characters " + missing.toPattern(false) + ", which are not in exemplars");
            }
            DecimalFormat nf = new DecimalFormat("000");
            if (count != 0) {
                totalCount += count;
                counts.add(nf.format(count) + "\t" + this.getLocaleAndName(locale) + "\t" + localeMissing);
            }
            if (localeMissing.size() == 0) continue;
            this.errln(this.getLocaleAndName(locale) + "\t uses " + localeMissing + ", not in exemplars");
        }
        for (String c : counts) {
            this.logln(c);
        }
        this.logln("Total Count: " + totalCount);
        System.out.println("All exemplars: " + allExemplars.toPattern(true));
    }

    private static long getDateTimeinMillis(int year, int month, int date) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, date);
        return cal.getTimeInMillis();
    }

    private boolean disableUntilLater(String string) {
        if (new Date().getTime() >= disableDate) {
            return false;
        }
        this.warnln("Disabling " + string + " until " + new Date(disableDate));
        return true;
    }

    private UnicodeSet getFixedExemplarSet(String locale, CLDRFile cldrfile) {
        UnicodeSet exemplars = this.getExemplarSet(cldrfile, "");
        if (exemplars.size() == 0) {
            this.errln(this.getLocaleAndName(locale) + " has empty exemplar set");
        }
        exemplars.addAll(this.getExemplarSet(cldrfile, "standard"));
        UnicodeSet auxiliary = this.getExemplarSet(cldrfile, "auxiliary");
        if (exemplars.containsSome(auxiliary)) {
            this.errln(this.getLocaleAndName(locale) + "Auxiliary & main exemplars should be disjoint, but overlap with " + new UnicodeSet(exemplars).retainAll(auxiliary) + ": change auxiliary to " + auxiliary.removeAll(exemplars));
        }
        exemplars.addAll(auxiliary);
        exemplars.addAll(this.commonAndInherited);
        return exemplars;
    }

    public UnicodeSet getExemplarSet(CLDRFile cldrfile, String type) {
        String v;
        if (type.length() != 0) {
            type = "[@type=\"" + type + "\"]";
        }
        if ((v = cldrfile.getStringValue("//ldml/characters/exemplarCharacters" + type)) == null) {
            return new UnicodeSet();
        }
        String pattern = v;
        if (pattern.indexOf("[:") >= 0 || pattern.indexOf("\\p{") > 0) {
            this.errln(this.getLocaleName(cldrfile.getLocaleID()) + " exemplar pattern contains property: " + pattern);
        }
        try {
            UnicodeSet result = new UnicodeSet(v, 2);
            result.remove(32);
            return result;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.errln(this.getLocaleAndName(cldrfile.getLocaleID()) + " has illegal exemplar set: <" + v + ">");
            return new UnicodeSet();
        }
    }

    public String getLocaleAndName(String locale) {
        return locale + " (" + this.getLocaleName(locale) + ")";
    }

    public String getIDAndLocalization(String id) {
        return id + " " + this.getLocalization(id);
    }

    public String getLocalization(String id) {
        if (this.english == null) {
            this.english = this.cldrFactory.make("en", true);
        }
        if (id.length() == 0) {
            return "?";
        }
        char ch = id.charAt(0);
        if ('a' <= ch && ch <= 'z') {
            return this.getName(this.english, "languages/language", id);
        }
        if (id.length() == 4 && 'A' <= ch && ch <= 'Z') {
            return this.getName(this.english, "scripts/script", id);
        }
        return this.getName(this.english, "territories/territory", id);
    }

    private String getIDAndLocalization(Set<String> missing) {
        StringBuffer buffer = new StringBuffer();
        for (String next : missing) {
            if (buffer.length() != 0) {
                buffer.append("; ");
            }
            buffer.append(this.getIDAndLocalization(next));
        }
        return buffer.toString();
    }

    public String getLocaleName(String locale) {
        String name = this.localeNameCache.get(locale);
        if (name != null) {
            return name;
        }
        if (this.english == null) {
            this.english = this.cldrFactory.make("en", true);
        }
        String result = this.english.getName(locale);
        this.localeNameCache.put(locale, result);
        return result;
    }

    private String getName(CLDRFile english, String kind, String type) {
        String v = english.getStringValue("//ldml/localeDisplayNames/" + kind + "[@type=\"" + type + "\"]");
        if (v == null) {
            return "<" + type + ">";
        }
        return v;
    }

    public void TestForIllegalAttributeValues() {
        TreeMap<String, Set<String>> result = new TreeMap<String, Set<String>>();
        TreeMap totalResult = new TreeMap();
        for (String locale : this.locales) {
            this.logln("Testing: " + locale);
            CLDRFile item = this.cldrFactory.make(locale, false);
            result.clear();
            Set<String> xpathFailures = null;
            CLDRTest.checkAttributeValidity(item, result, xpathFailures);
            for (String code : result.keySet()) {
                Set avalues = (Set)result.get(code);
                this.errln(this.getLocaleAndName(locale) + "\tillegal attribute value for " + code + ", value:\t" + this.show(avalues));
                TreeSet totalvalues = (TreeSet)totalResult.get(code);
                if (totalvalues == null) {
                    totalvalues = new TreeSet();
                    totalResult.put(code, totalvalues);
                }
                totalvalues.addAll(avalues);
            }
        }
        for (String code : totalResult.keySet()) {
            Set avalues = (Set)totalResult.get(code);
            this.errln("All illegal attribute values for " + code + ", value:\t" + this.show(avalues));
        }
    }

    public void TestDisplayNameCollisions() {
        if (this.disableUntilLater("TestDisplayNameCollisions")) {
            return;
        }
        HashMap[] maps = new HashMap[15];
        for (int i = 0; i < maps.length; ++i) {
            maps[i] = new HashMap();
        }
        TreeSet<String> collisions = new TreeSet<String>();
        for (String locale : this.locales) {
            CLDRFile item = this.cldrFactory.make(locale, true);
            for (int i = 0; i < maps.length; ++i) {
                maps[i].clear();
            }
            collisions.clear();
            for (String xpath : item) {
                int nameType = CLDRFile.getNameType(xpath);
                if (nameType < 0) continue;
                String value = item.getStringValue(xpath);
                String xpath2 = (String)maps[nameType].get(value);
                if (xpath2 == null) {
                    maps[nameType].put(value, xpath);
                    continue;
                }
                collisions.add(CLDRFile.getNameTypeName(nameType) + "\t" + value + "\t" + xpath + "\t" + xpath2);
                this.surveyInfo.add(locale + "\t" + xpath + "\t'" + value + "' is a duplicate of what is in " + xpath2);
            }
            String name = this.getLocaleAndName(locale) + "\t";
            Iterator it2 = collisions.iterator();
            while (it2.hasNext()) {
                this.errln(name + (String)it2.next());
            }
        }
    }

    public static void checkAttributeValidity(CLDRFile item, Map<String, Set<String>> badCodes, Set<String> xpathFailures) {
        for (String xpath : item) {
            XPathParts parts = XPathParts.getFrozenInstance(item.getFullXPath(xpath));
            for (int i = 0; i < parts.size(); ++i) {
                if (parts.getAttributeCount(i) == 0) continue;
                String element = parts.getElement(i);
                Map<String, String> attributes = parts.getAttributes(i);
                for (String attribute : attributes.keySet()) {
                    String avalue = attributes.get(attribute);
                    CLDRTest.checkValidity(xpath, element, attribute, avalue, badCodes, xpathFailures);
                }
            }
        }
    }

    private String show(Collection<String> avalues) {
        StringBuffer result = new StringBuffer("{");
        boolean first = true;
        Iterator<String> it3 = avalues.iterator();
        while (it3.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(it3.next().toString());
        }
        result.append("}");
        return result.toString();
    }

    private static void checkValidity(String xpath, String element, String attribute, String avalue, Map<String, Set<String>> results, Set<String> xpathsFailing) {
        StandardCodes codes = StandardCodes.make();
        if (attribute.equals("type")) {
            boolean checkReplacements;
            boolean bl = checkReplacements = xpath.indexOf("/identity") < 0;
            if (element.equals("currency")) {
                CLDRTest.checkCodes(xpath, "currency", avalue, codes, results, xpathsFailing, checkReplacements);
            } else if (element.equals("script")) {
                CLDRTest.checkCodes(xpath, "script", avalue, codes, results, xpathsFailing, checkReplacements);
            } else if (element.equals("territory")) {
                CLDRTest.checkCodes(xpath, "territory", avalue, codes, results, xpathsFailing, checkReplacements);
            } else if (element.equals("language")) {
                CLDRTest.checkCodes(xpath, "language", avalue, codes, results, xpathsFailing, checkReplacements);
            } else if (element.equals("zone")) {
                CLDRTest.checkCodes(xpath, "tzid", avalue, codes, results, xpathsFailing, checkReplacements);
            }
        }
    }

    private static void checkCodes(String xpath, String code, String avalue, StandardCodes codes, Map<String, Set<String>> results, Set<String> xpathFailures, boolean checkReplacements) {
        if (!(codes.getData(code, avalue) == null || checkReplacements && codes.getReplacement(code, avalue) != null)) {
            return;
        }
        if (xpathFailures != null) {
            xpathFailures.add(xpath);
        }
        if (results == null) {
            return;
        }
        Set<String> s2 = results.get(code);
        if (s2 == null) {
            s2 = new TreeSet<String>();
            results.put(code, s2);
        }
        s2.add(avalue);
    }

    public void TestCompleteLocales() {
        if (this.english == null) {
            this.english = this.cldrFactory.make("en", true);
        }
        this.checkTranslatedCodes(this.english);
    }

    private void checkTranslatedCodes(CLDRFile cldrfile) {
        StandardCodes codes = StandardCodes.make();
        this.checkTranslatedCode(cldrfile, codes, "currency", "//ldml/numbers/currencies/currency", "/displayName");
        this.checkTranslatedCode(cldrfile, codes, "language", "//ldml/localeDisplayNames/languages/language", "");
        this.checkTranslatedCode(cldrfile, codes, "script", "//ldml/localeDisplayNames/scripts/script", "");
        this.checkTranslatedCode(cldrfile, codes, "territory", "//ldml/localeDisplayNames/territories/territory", "");
        this.checkTranslatedCode(cldrfile, codes, "variant", "//ldml/localeDisplayNames/variants/variant", "");
    }

    private void checkTranslatedCode(CLDRFile cldrfile, StandardCodes codes, String type, String prefix, String postfix) {
        HashMap completionExceptions = new HashMap();
        HashSet<String> scriptExceptions = new HashSet<String>();
        scriptExceptions.add("Cham");
        scriptExceptions.add("Thai");
        completionExceptions.put("script", scriptExceptions);
        Set<String> codeItems = codes.getGoodAvailableCodes(type);
        int count = 0;
        Set exceptions = (Set)completionExceptions.get(type);
        for (String code : codeItems) {
            String rfcname = codes.getData(type, code);
            ++count;
            if (rfcname.equals("PRIVATE USE")) continue;
            String fullFragment = prefix + "[@type=\"" + code + "\"]" + postfix;
            String v = cldrfile.getStringValue(fullFragment);
            if (v == null) {
                this.errln("Missing translation for:\t<" + type + " type=\"" + code + "\">" + rfcname + "</" + type + ">");
                continue;
            }
            String translation = v;
            if (!translation.equals(code) || exceptions != null && exceptions.contains(code)) continue;
            this.errln("Translation = code for:\t<" + type + " type=\"" + code + "\">" + rfcname + "</" + type + ">");
        }
        this.logln("Total " + type + ":\t" + count);
    }

    void getSupplementalData(Map<String, Set<String>> language_scripts, Map<String, Set<String>> language_territories, Map<String, Set<String>> group_territory, Map<String, Set<String>> territory_currencies, Map<String, Map<String, String>> aliases) {
        boolean SHOW = false;
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        CLDRFile supp = cldrFactory.make("supplementalData", false);
        for (String path : supp) {
            try {
                Map<String, String> m3;
                XPathParts parts = XPathParts.getFrozenInstance(supp.getFullXPath(path));
                String type = "";
                if (aliases != null && parts.findElement("alias") >= 0) {
                    type = "languageAlias";
                    m3 = parts.findAttributes("languageAlias");
                    if (m3 == null) {
                        type = "territoryAlias";
                        m3 = parts.findAttributes("territoryAlias");
                    }
                    if (m3 != null) {
                        Map<String, String> top = aliases.get(type);
                        if (top == null) {
                            top = new TreeMap<String, String>();
                            aliases.put(type, top);
                        }
                        top.put(m3.get("type"), m3.get("replacement"));
                    }
                }
                if (territory_currencies != null && (m3 = parts.findAttributes("region")) != null) {
                    String region = m3.get("iso3166");
                    Set<String> s2 = territory_currencies.get(region);
                    if (s2 == null) {
                        s2 = new LinkedHashSet<String>();
                        territory_currencies.put(region, s2);
                    }
                    if ((m3 = parts.findAttributes("currency")) == null) {
                        this.warnln("missing currency for region: " + path);
                        continue;
                    }
                    String currency = m3.get("iso4217");
                    s2.add(currency);
                    m3 = parts.findAttributes("alternate");
                    String alternate = m3 == null ? null : m3.get("iso4217");
                    if (alternate == null) continue;
                    s2.add(alternate);
                    continue;
                }
                m3 = parts.findAttributes("group");
                if (m3 != null) {
                    if (group_territory == null) continue;
                    type = m3.get("type");
                    String contains = m3.get("contains");
                    group_territory.put(type, new TreeSet<String>(CldrUtility.splitList(contains, ' ', true)));
                    continue;
                }
                m3 = parts.findAttributes("language");
                if (m3 == null) continue;
                String language = m3.get("type");
                String scripts = m3.get("scripts");
                if (scripts == null) {
                    language_scripts.put(language, new TreeSet());
                } else {
                    language_scripts.put(language, new TreeSet<String>(CldrUtility.splitList(scripts, ' ', true)));
                    if (SHOW) {
                        System.out.println(this.getIDAndLocalization(language) + "\t\t" + this.getIDAndLocalization(language_scripts.get(language)));
                    }
                }
                String territories = m3.get("territories");
                if (territories == null) {
                    language_territories.put(language, new TreeSet());
                    continue;
                }
                language_territories.put(language, new TreeSet<String>(CldrUtility.splitList(territories, ' ', true)));
                if (!SHOW) continue;
                System.out.println(this.getIDAndLocalization(language) + "\t\t" + this.getIDAndLocalization(language_territories.get(language)));
            }
            catch (RuntimeException e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Failure with: " + path).initCause(e);
            }
        }
    }

    public void TestMinimalLocalization() throws IOException {
        if (this.disableUntilLater("TestMinimalLocalization")) {
            return;
        }
        boolean testDraft = false;
        HashMap<String, Set<String>> language_scripts = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> language_territories = new HashMap<String, Set<String>>();
        this.getSupplementalData(language_scripts, language_territories, null, null, null);
        LanguageTagParser localIDParser = new LanguageTagParser();
        int[] failureCount = new int[1];
        int[] warningCount = new int[1];
        for (String locale : this.languageLocales) {
            if (locale.equals("root")) continue;
            CLDRFile item = this.cldrFactory.make(locale, true);
            if (!testDraft && item.isDraft()) {
                this.logln(this.getLocaleAndName(locale) + "\tskipping draft");
                continue;
            }
            UnicodeSet exemplars = this.getFixedExemplarSet(locale, item);
            CLDRFile missing = SimpleFactory.makeFile(locale);
            failureCount[0] = 0;
            warningCount[0] = 0;
            localIDParser.set(locale);
            String language = localIDParser.getLanguage();
            this.logln("Testing: " + locale);
            TreeSet<String> languages = new TreeSet<String>(CldrUtility.MINIMUM_LANGUAGES);
            languages.add(language);
            this.checkForItems(item, languages, 0, missing, failureCount, null);
            TreeSet<String> scripts = new TreeSet<String>();
            scripts.add("Latn");
            Set others = (Set)language_scripts.get(language);
            if (others != null) {
                scripts.addAll(others);
            }
            this.checkForItems(item, scripts, 1, missing, failureCount, null);
            TreeSet<String> countries = new TreeSet<String>(CldrUtility.MINIMUM_TERRITORIES);
            others = (Set)language_territories.get(language);
            if (others != null) {
                countries.addAll(others);
            }
            this.checkForItems(item, countries, 2, missing, failureCount, null);
            TreeSet<String> currencies = new TreeSet<String>();
            StandardCodes sc = StandardCodes.make();
            for (String country : countries) {
                Set<String> countryCurrencies = sc.getMainCurrencies(country);
                if (countryCurrencies == null) {
                    this.errln("Internal Error: no currencies for " + country + ", locale: " + locale);
                    continue;
                }
                currencies.addAll(countryCurrencies);
            }
            this.checkForItems(item, currencies, 4, missing, failureCount, null);
            this.checkForItems(item, currencies, 5, missing, failureCount, exemplars);
            TreeSet<String> months = new TreeSet<String>();
            for (int i = 1; i <= 12; ++i) {
                months.add(i + "");
            }
            TreeSet<String> days = new TreeSet<String>(Arrays.asList("sun", "mon", "tue", "wed", "thu", "fri", "sat"));
            for (int i = -7; i < 0; ++i) {
                this.checkForItems(item, i < -4 ? months : days, i, missing, failureCount, null);
            }
            String filename = "missing_" + locale + ".xml";
            if (failureCount[0] > 0 || warningCount[0] > 0) {
                PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "missing/", filename);
                missing.write(out);
                out.close();
                String message = "missing localizations, creating file" + PathUtilities.getNormalizedPath(CLDRPaths.GEN_DIRECTORY, "missing", filename);
                if (failureCount[0] > 0) {
                    this.warnln(this.getLocaleAndName(locale) + "\t" + message);
                    continue;
                }
                this.logln(this.getLocaleAndName(locale) + "\tpossibly " + message);
                continue;
            }
            new File(CLDRPaths.GEN_DIRECTORY + "missing/", filename).delete();
        }
    }

    private String getDateKey(String monthOrDay, String width, String code) {
        return "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/" + monthOrDay + "s/" + monthOrDay + "Context[@type=\"format\"]/" + monthOrDay + "Width[@type=\"" + width + "\"]/" + monthOrDay + "[@type=\"" + code + "\"]";
    }

    private String getDateKey(int type, String code) {
        int monthOrDayType = 0;
        int widthType = type;
        if (type >= 4) {
            monthOrDayType = 1;
            widthType -= 4;
        }
        return this.getDateKey(MONTHORDAYS[monthOrDayType], WIDTHS[widthType], code);
    }

    private void checkForItems(CLDRFile item, Set<String> codes, int type, CLDRFile missing, int[] failureCount, UnicodeSet exemplarTest) {
        for (String code : codes) {
            String key = type >= 0 ? CLDRFile.getKey(type, code) : this.getDateKey(-type - 1, code);
            String v = item.getStringValue(key);
            String rootValue = this.resolvedRoot.getStringValue(key);
            if (v == null || v.equals(rootValue) && (exemplarTest == null || !exemplarTest.containsAll(rootValue))) {
                String englishValue = this.resolvedEnglish.getStringValue(key);
                String transValue = englishValue != null ? englishValue : code;
                missing.add(key, "TODO " + transValue);
                failureCount[0] = failureCount[0] + 1;
                continue;
            }
            this.logln("\t" + code + "\t" + v);
        }
    }

    public void TestSupplementalData() {
        TreeSet<Object> extras;
        TreeSet<Object> extras2;
        TreeMap<String, Set<String>> language_scripts = new TreeMap<String, Set<String>>();
        TreeMap<String, Set<String>> language_territories = new TreeMap<String, Set<String>>();
        TreeMap<String, Set<String>> groups = new TreeMap<String, Set<String>>();
        TreeMap<String, Set<String>> territory_currencies = new TreeMap<String, Set<String>>();
        TreeMap<String, Map<String, String>> aliases = new TreeMap<String, Map<String, String>>();
        this.getSupplementalData(language_scripts, language_territories, groups, territory_currencies, aliases);
        TreeSet sTerritories = new TreeSet();
        Iterator it = language_territories.values().iterator();
        while (it.hasNext()) {
            sTerritories.addAll((Collection)it.next());
        }
        StandardCodes sc = StandardCodes.make();
        Set<String> fullTerritories = sc.getAvailableCodes("territory");
        Set<String> fullLanguages = sc.getAvailableCodes("language");
        TreeSet allLanguages = new TreeSet(language_scripts.keySet());
        allLanguages.addAll(language_territories.keySet());
        for (Object language : allLanguages) {
            Set scripts = (Set)language_scripts.get(language);
            Set territories = (Set)language_territories.get(language);
            this.logln(this.EnglishName.transform(language) + " scripts: " + this.EnglishName.transform(scripts) + " territories: " + this.EnglishName.transform(territories));
        }
        TreeMap<String, String> changedLanguage = new TreeMap<String, String>();
        for (String code : fullLanguages) {
            List<String> data = sc.getFullData("language", code);
            if (data.size() < 3) {
                System.out.println("data problem: " + data);
                continue;
            }
            String replacement = data.get(2);
            if (replacement.equals("") || replacement.equals("--")) continue;
            changedLanguage.put(code, replacement);
        }
        TreeSet<String> standardTerritories = new TreeSet<String>();
        TreeMap<String, String> changedTerritory = new TreeMap<String, String>();
        for (String code : fullTerritories) {
            List<String> data;
            if (code.equals("200") || (data = sc.getFullData("territory", code)).get(0).equals("PRIVATE USE")) continue;
            if (!data.get(2).equals("")) {
                if (data.get(2).equals("--")) continue;
                changedTerritory.put(code, data.get(2));
                continue;
            }
            standardTerritories.add(code);
        }
        standardTerritories.removeAll(groups.keySet());
        if (!standardTerritories.containsAll(sTerritories)) {
            TreeSet extras22 = new TreeSet(sTerritories);
            extras22.removeAll(standardTerritories);
            this.errln("Supplemental Language Territories contain illegal values: " + this.EnglishName.transform(extras22));
        }
        if (!sTerritories.containsAll(standardTerritories)) {
            extras2 = new TreeSet(standardTerritories);
            extras2.removeAll(sTerritories);
            this.warnln("Missing Language Territories: " + this.EnglishName.transform(extras2));
        }
        this.logln("Check that no illegal territories are used");
        if (!standardTerritories.containsAll(territory_currencies.keySet())) {
            extras2 = new TreeSet(territory_currencies.keySet());
            extras2.removeAll(fullTerritories);
            if (extras2.size() != 0) {
                this.errln("Currency info -- Illegal Territories: " + this.EnglishName.transform(extras2));
            }
            extras2 = new TreeSet(territory_currencies.keySet());
            extras2.retainAll(fullTerritories);
            extras2.removeAll(standardTerritories);
            if (extras2.size() != 0) {
                this.warnln("Currency info -- Archaic Territories: " + this.EnglishName.transform(extras2));
            }
        }
        this.logln("Check that no territories are missing");
        if (!territory_currencies.keySet().containsAll(standardTerritories)) {
            extras2 = new TreeSet(standardTerritories);
            extras2.removeAll(territory_currencies.keySet());
            this.errln("Currency info -- Missing Territories: " + this.EnglishName.transform(extras2));
        }
        TreeSet currencies = new TreeSet();
        Iterator it2 = territory_currencies.values().iterator();
        while (it2.hasNext()) {
            currencies.addAll((Collection)it2.next());
        }
        this.logln("Check that no illegal currencies are used");
        TreeSet<String> legalCurrencies = new TreeSet<String>(sc.getAvailableCodes("currency"));
        Iterator it3 = legalCurrencies.iterator();
        while (it3.hasNext()) {
            String code = (String)it3.next();
            List<String> data = sc.getFullData("currency", code);
            if (!"X".equals(data.get(3))) continue;
            it3.remove();
        }
        if (!legalCurrencies.containsAll(currencies)) {
            extras = new TreeSet(currencies);
            extras.removeAll(legalCurrencies);
            this.errln("Currency info -- Illegal Currencies: " + this.EnglishCurrencyName.transform(extras));
        }
        this.logln("Check that there are no missing currencies");
        if (!currencies.containsAll(legalCurrencies)) {
            extras = new TreeSet<String>((Collection<String>)legalCurrencies);
            extras.removeAll(currencies);
            TreeMap<String, TreeSet<String>> failures = new TreeMap<String, TreeSet<String>>();
            for (String string : extras) {
                List<String> data = sc.getFullData("currency", string);
                if (data.get(1).equals("ZZ")) continue;
                String type = data.get(3) + "/" + data.get(1);
                TreeSet<String> s2 = (TreeSet<String>)failures.get(type);
                if (s2 == null) {
                    s2 = new TreeSet<String>();
                    failures.put(type, s2);
                }
                s2.add(string);
            }
            for (String string : failures.keySet()) {
                Set s3 = (Set)failures.get(string);
                this.warnln("Currency info -- Missing Currencies: " + string + "\t \u2192 " + this.EnglishCurrencyName.transform(s3));
            }
        }
        this.logln("Missing English currency names");
        for (String currency : legalCurrencies) {
            String name = this.english.getName("currency", currency);
            if (name != null) continue;
            String string = sc.getFullData("currency", currency).get(0);
            this.logln("\t\t\t<currency type=\"" + currency + "\">");
            this.logln("\t\t\t\t<displayName>" + string + "</displayName>");
            this.logln("\t\t\t</currency>");
        }
        this.logln("Check Aliases");
        for (String key : aliases.keySet()) {
            Map submap = (Map)aliases.get(key);
            if (key.equals("territoryAlias")) {
                this.checkEqual(key, submap, changedTerritory);
                continue;
            }
            if (!key.equals("languageAlias")) continue;
            Iterator iterator = submap.keySet().iterator();
            while (iterator.hasNext()) {
                String k = (String)iterator.next();
                String value = (String)submap.get(k);
                if (value.indexOf("_") < 0) continue;
                iterator.remove();
            }
            this.checkEqual(key, submap, changedLanguage);
        }
    }

    private void checkEqual(String title, Map map1, Map map2) {
        Set foo = new TreeSet(map1.keySet());
        foo.removeAll(map2.keySet());
        if (!foo.isEmpty()) {
            this.errln("Extraneous Aliases: " + title + "\t" + foo);
        }
        foo = new TreeSet(map2.keySet());
        foo.removeAll(map1.keySet());
        if (!foo.isEmpty()) {
            this.errln("Missing Aliases: " + title + "\t" + foo);
        }
        foo = map2.keySet();
        foo.retainAll(map1.keySet());
        for (Object key : foo) {
            Object result2;
            Object result1 = map1.get(key);
            if (result1.equals(result2 = map2.get(key))) continue;
            this.errln("Missing Aliases: " + title + "\t" + key + "\t" + result1 + " != " + result2);
        }
    }

    public void TestZones() {
        StandardCodes sc = StandardCodes.make();
        TreeMap<String, String> defaultNames = new TreeMap<String, String>();
        Map<String, String> old_new = sc.getZoneLinkold_new();
        Set<String> core = sc.getZoneData().keySet();
        this.logln("Checking for collisions with last field");
        for (String currentItem : core) {
            String defaultName = TimezoneFormatter.getFallbackName(currentItem);
            String fullName = (String)defaultNames.get(defaultName);
            if (fullName == null) {
                defaultNames.put(defaultName, currentItem);
                continue;
            }
            this.errln("Collision between: " + currentItem + " AND " + fullName);
        }
        this.logln("Checking that all links are TO canonical zones");
        TreeSet<String> s2 = new TreeSet<String>(old_new.values());
        s2.removeAll(core);
        if (s2.size() != 0) {
            this.errln("Links go TO zones that are not canonical! " + s2);
        }
        this.logln("Checking that no links are FROM canonical zones");
        s2 = new TreeSet<String>(core);
        s2.retainAll(old_new.keySet());
        if (s2.size() != 0) {
            this.errln("Links go FROM zones that are canonical! " + s2);
        }
        this.logln("Checking that the zones with rule data are all canonical");
        Set<String> zonesWithRules = sc.getZone_rules().keySet();
        s2.clear();
        s2.addAll(zonesWithRules);
        s2.removeAll(core);
        if (s2.size() != 0) {
            this.logln("Zones with rules that are not canonical: " + s2);
        }
        this.logln("Checking that the rule data are all canonical");
        s2.clear();
        s2.addAll(core);
        s2.removeAll(zonesWithRules);
        s2.removeAll(old_new.keySet());
        if (s2.size() != 0) {
            this.logln("Canonical zones that don't have rules or links: " + s2);
        }
        for (String oldItem : old_new.keySet()) {
            this.logln("old: " + oldItem + "\tnew: " + old_new.get(oldItem));
        }
        TreeMap new_old = new TreeMap();
        Iterator<String> it = core.iterator();
        while (it.hasNext()) {
            new_old.put(it.next(), new TreeSet());
        }
        for (String oldItem : old_new.keySet()) {
            String newItem = old_new.get(oldItem);
            Set oldItems = (Set)new_old.get(newItem);
            if (oldItems == null) {
                this.logln("!!!!Skipping " + oldItem + " \u2192 " + newItem);
                continue;
            }
            oldItems.add(oldItem);
        }
        for (String newOne : new_old.keySet()) {
            Set oldItems = (Set)new_old.get(newOne);
            this.logln(newOne + "\t" + oldItems);
        }
    }

    public void TestNarrowForms() {
        if (this.disableUntilLater("TestMinimalLocalization")) {
            return;
        }
        for (String locale : this.locales) {
            this.logln("Testing: " + this.getLocaleAndName(locale));
            BreakIterator bi = BreakIterator.getCharacterInstance(new ULocale(locale));
            CLDRFile item = this.cldrFactory.make(locale, false);
            for (String xpath : item) {
                String value;
                int end;
                if (xpath.indexOf("[@type=\"narrow\"]") < 0 || (end = this.getXGraphemeClusterBoundary(bi, value = item.getStringValue(xpath), 0)) == value.length()) continue;
                this.errln(this.getLocaleAndName(locale) + "\tillegal narrow value " + value + "\t path: " + xpath);
                this.surveyInfo.add(locale + "\t" + xpath + "\t'" + value + "' is too wide for a \"narrow\" value.");
            }
        }
    }

    private int getXGraphemeClusterBoundary(BreakIterator bi, String value, int start) {
        int current;
        if (value.length() <= 1) {
            return 1;
        }
        bi.setText(value);
        if (start != 0) {
            bi.preceding(start + 1);
        }
        if (DIGIT.contains(UTF16.charAt(value, (current = bi.next()) - 1))) {
            current = DIGIT.findIn(value, current, true);
        }
        return XGRAPHEME.findIn(value, current, true);
    }

    static {
        WIDTHS = new String[]{"narrow", "wide", "abbreviated", "short"};
        MONTHORDAYS = new String[]{"day", "month"};
        EXEMPLAR_SKIPS = new String[]{"/hourFormat", "/exemplarCharacters", "/pattern", "/localizedPatternChars"};
        disableDate = CLDRTest.getDateTimeinMillis(2005, 5, 3);
        XGRAPHEME = new UnicodeSet("[[:mark:][:grapheme_extend:]]");
        DIGIT = new UnicodeSet("[:decimal_number:]");
    }

    private static class ValueCount {
        int count = 1;
        String value;
        String fullxpath;

        private ValueCount() {
        }
    }
}

