/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;

public class CheckAlt
extends CheckCLDR {
    Set<String> seenSoFar = new HashSet<String>();

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (fullPath == null) {
            return this;
        }
        if (path.indexOf("[@alt=") <= 0) {
            return this;
        }
        if (path.indexOf("proposed") <= 0) {
            return this;
        }
        String strippedPath = CLDRFile.getNondraftNonaltXPath(path);
        if (strippedPath.equals(path)) {
            return this;
        }
        String otherValue = this.getCldrFileToCheck().getStringValue(strippedPath);
        if (otherValue != null) {
            return this;
        }
        result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.noUnproposedVariant).setCheckOnSubmit(false).setMessage("Proposed item but no unproposed variant", new Object[0]));
        this.seenSoFar.add(strippedPath);
        return this;
    }

    @Override
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        if (CheckCLDR.Phase.FINAL_TESTING != this.getPhase() && CheckCLDR.Phase.BUILD != this.getPhase()) {
            this.setSkipTest(true);
            return this;
        }
        this.setSkipTest(false);
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.seenSoFar.clear();
        return this;
    }
}

