/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.ImmutableSet;
import com.ibm.icu.dev.util.ElapsedTimer;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.ListFormatter;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckAlt;
import org.unicode.cldr.test.CheckCasing;
import org.unicode.cldr.test.CheckChildren;
import org.unicode.cldr.test.CheckConsistentCasing;
import org.unicode.cldr.test.CheckCoverage;
import org.unicode.cldr.test.CheckCurrencies;
import org.unicode.cldr.test.CheckDates;
import org.unicode.cldr.test.CheckDisplayCollisions;
import org.unicode.cldr.test.CheckExemplars;
import org.unicode.cldr.test.CheckForCopy;
import org.unicode.cldr.test.CheckForExemplars;
import org.unicode.cldr.test.CheckForInheritanceMarkers;
import org.unicode.cldr.test.CheckLogicalGroupings;
import org.unicode.cldr.test.CheckMetazones;
import org.unicode.cldr.test.CheckNames;
import org.unicode.cldr.test.CheckNew;
import org.unicode.cldr.test.CheckNumbers;
import org.unicode.cldr.test.CheckPlaceHolders;
import org.unicode.cldr.test.CheckQuotes;
import org.unicode.cldr.test.CheckUnits;
import org.unicode.cldr.test.CheckWidths;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRInfo;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.InternalCldrException;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexFileParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.VoteResolver;

public abstract class CheckCLDR {
    public static final boolean LIMITED_SUBMISSION = false;
    private static CLDRFile displayInformation;
    private CLDRFile cldrFileToCheck;
    private CLDRFile englishFile = null;
    private boolean skipTest = false;
    private Phase phase;
    private Map<CheckStatus.Subtype, List<Pattern>> filtersForLocale = new HashMap<CheckStatus.Subtype, List<Pattern>>();
    private static final HashMap<String, Phase> PHASE_NAMES;
    private static List<Row.R3<Pattern, CheckStatus.Subtype, Pattern>> allFilters;

    public boolean isSkipTest() {
        return this.skipTest;
    }

    public void setSkipTest(boolean skipTest) {
        this.skipTest = skipTest;
    }

    public static CompoundCheckCLDR getCheckAll(Factory factory, String nameMatcher) {
        return new CompoundCheckCLDR().setFilter(Pattern.compile(nameMatcher, 2).matcher("")).add(new CheckChildren(factory)).add(new CheckCoverage(factory)).add(new CheckDates(factory)).add(new CheckForCopy(factory)).add(new CheckDisplayCollisions(factory)).add(new CheckExemplars(factory)).add(new CheckForExemplars(factory)).add(new CheckForInheritanceMarkers()).add(new CheckNames()).add(new CheckNumbers(factory)).add(new CheckMetazones()).add(new CheckLogicalGroupings(factory)).add(new CheckAlt()).add(new CheckCurrencies()).add(new CheckCasing()).add(new CheckConsistentCasing(factory)).add(new CheckQuotes()).add(new CheckUnits()).add(new CheckWidths()).add(new CheckPlaceHolders()).add(new CheckNew(factory));
    }

    public static synchronized CLDRFile getDisplayInformation() {
        return displayInformation;
    }

    public static synchronized void setDisplayInformation(CLDRFile inputDisplayInformation) {
        displayInformation = inputDisplayInformation;
    }

    public final CLDRFile getCldrFileToCheck() {
        return this.cldrFileToCheck;
    }

    @Deprecated
    public final CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Map<String, String> options, List<CheckStatus> possibleErrors) {
        return this.setCldrFileToCheck(cldrFileToCheck, new Options(options), possibleErrors);
    }

    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Options options, List<CheckStatus> possibleErrors) {
        this.cldrFileToCheck = cldrFileToCheck;
        this.loadFilters();
        String locale = cldrFileToCheck.getLocaleID();
        this.filtersForLocale.clear();
        for (Row.R3<Pattern, CheckStatus.Subtype, Pattern> filter : allFilters) {
            if (filter.get0() == null || !((Pattern)filter.get0()).matcher(locale).matches()) continue;
            CheckStatus.Subtype subtype = (CheckStatus.Subtype)((Object)filter.get1());
            List<Pattern> xpaths = this.filtersForLocale.get((Object)subtype);
            if (xpaths == null) {
                xpaths = new ArrayList<Pattern>();
                this.filtersForLocale.put(subtype, xpaths);
            }
            xpaths.add((Pattern)filter.get2());
        }
        return this;
    }

    @Deprecated
    public final CheckCLDR check(String path, String fullPath, String value, Map<String, String> options, List<CheckStatus> result) {
        return this.check(path, fullPath, value, new Options(options), result);
    }

    public final CheckCLDR check(String path, String fullPath, String value, Options options, List<CheckStatus> result) {
        if (this.cldrFileToCheck == null) {
            throw new InternalCldrException("CheckCLDR problem: cldrFileToCheck must not be null");
        }
        if (path == null) {
            throw new InternalCldrException("CheckCLDR problem: path must not be null");
        }
        result.clear();
        if (value != null && !value.equals(this.cldrFileToCheck.getWinningValue(path)) && this.cldrFileToCheck.getUnresolved().getStringValue(path) == null) {
            return this;
        }
        if (CldrUtility.INHERITANCE_MARKER.equals(value) && CldrUtility.INHERITANCE_MARKER.equals(value = this.cldrFileToCheck.getConstructedBaileyValue(path, null, null))) {
            return this;
        }
        CheckCLDR instance = this.handleCheck(path, fullPath, value, options, result);
        Iterator<CheckStatus> iterator = result.iterator();
        while (iterator.hasNext()) {
            CheckStatus status = iterator.next();
            if (!this.shouldExcludeStatus(fullPath, status)) continue;
            iterator.remove();
        }
        return instance;
    }

    public final CheckCLDR getExamples(String path, String fullPath, String value, Options options, List<CheckStatus> result) {
        result.clear();
        return this.handleGetExamples(path, fullPath, value, options, result);
    }

    protected CheckCLDR handleGetExamples(String path, String fullPath, String value, Options options2, List<CheckStatus> result) {
        return this;
    }

    public abstract CheckCLDR handleCheck(String var1, String var2, String var3, Options var4, List<CheckStatus> var5);

    public void handleFinish() {
    }

    public static Transliterator getTransliteratorFromFile(String ID, String file) {
        try {
            String line;
            BufferedReader br = CldrUtility.getUTF8Data(file);
            StringBuffer input = new StringBuffer();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                input.append(line);
                input.append('\n');
            }
            return Transliterator.createFromRules(ID, input.toString(), 0);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Can't open transliterator file " + file, e);
        }
    }

    public Phase getPhase() {
        return this.phase;
    }

    public void setPhase(Phase phase) {
        this.phase = phase;
    }

    private void loadFilters() {
        if (allFilters != null) {
            return;
        }
        allFilters = new ArrayList<Row.R3<Pattern, CheckStatus.Subtype, Pattern>>();
        RegexFileParser fileParser = new RegexFileParser();
        fileParser.setLineParser(new RegexFileParser.RegexLineParser(){

            @Override
            public void parse(String line) {
                String[] fields = line.split("\\s*;\\s*");
                CheckStatus.Subtype subtype = CheckStatus.Subtype.valueOf(fields[0]);
                Pattern locale = PatternCache.get(fields[1]);
                Pattern xpathRegex = PatternCache.get(fields[2].replaceAll("\\[@", "\\\\[@"));
                allFilters.add(new Row.R3<Pattern, CheckStatus.Subtype, Pattern>(locale, subtype, xpathRegex));
            }
        });
        fileParser.parse(CheckCLDR.class, "/org/unicode/cldr/util/data/CheckCLDR-exceptions.txt");
    }

    private boolean shouldExcludeStatus(String xpath, CheckStatus status) {
        List<Pattern> xpathPatterns = this.filtersForLocale.get((Object)status.getSubtype());
        if (xpathPatterns == null) {
            return false;
        }
        for (Pattern xpathPattern : xpathPatterns) {
            if (!xpathPattern.matcher(xpath).matches()) continue;
            return true;
        }
        return false;
    }

    public CLDRFile getEnglishFile() {
        return this.englishFile;
    }

    public void setEnglishFile(CLDRFile englishFile) {
        this.englishFile = englishFile;
    }

    public CharSequence fixedValueIfInherited(String value, String path) {
        return !CldrUtility.INHERITANCE_MARKER.equals(value) ? value : this.getCldrFileToCheck().getStringValueWithBailey(path);
    }

    static {
        PHASE_NAMES = new HashMap();
    }

    static class CompoundCheckCLDR
    extends CheckCLDR {
        private Matcher filter;
        private List<CheckCLDR> checkList = new ArrayList<CheckCLDR>();
        private List<CheckCLDR> filteredCheckList = new ArrayList<CheckCLDR>();

        CompoundCheckCLDR() {
        }

        public CompoundCheckCLDR add(CheckCLDR item) {
            this.checkList.add(item);
            if (this.filter == null) {
                this.filteredCheckList.add(item);
            } else {
                String className = item.getClass().getName();
                if (this.filter.reset(className).find()) {
                    this.filteredCheckList.add(item);
                }
            }
            return this;
        }

        @Override
        public CheckCLDR handleCheck(String path, String fullPath, String value, Options options, List<CheckStatus> result) {
            result.clear();
            if (CldrUtility.INHERITANCE_MARKER.equals(value)) {
                value = this.getCldrFileToCheck().getConstructedBaileyValue(path, null, null);
            }
            for (CheckCLDR item : this.filteredCheckList) {
                if (Phase.FINAL_TESTING == item.getPhase() && path.contains("proposed") && path.contains("[@alt=")) continue;
                try {
                    if (item.isSkipTest()) continue;
                    item.handleCheck(path, fullPath, value, options, result);
                }
                catch (Exception e) {
                    this.addError(result, item, e);
                    return this;
                }
            }
            return this;
        }

        @Override
        public void handleFinish() {
            for (CheckCLDR item : this.filteredCheckList) {
                item.handleFinish();
            }
        }

        @Override
        protected CheckCLDR handleGetExamples(String path, String fullPath, String value, Options options, List<CheckStatus> result) {
            result.clear();
            for (CheckCLDR item : this.filteredCheckList) {
                try {
                    item.handleGetExamples(path, fullPath, value, options, result);
                }
                catch (Exception e) {
                    this.addError(result, item, e);
                    return this;
                }
            }
            return this;
        }

        private void addError(List<CheckStatus> result, CheckCLDR item, Exception e) {
            result.add(new CheckStatus().setCause(this).setMainType(CheckStatus.errorType).setSubtype(CheckStatus.Subtype.internalError).setMessage("Internal error in {0}. Exception: {1}, Message: {2}, Trace: {3}", item.getClass().getName(), e.getClass().getName(), e, Arrays.asList(e.getStackTrace())));
        }

        @Override
        public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Options options, List<CheckStatus> possibleErrors) {
            ElapsedTimer testTime = null;
            ElapsedTimer testOverallTime = null;
            if (cldrFileToCheck == null) {
                return this;
            }
            boolean SHOW_TIMES = options.contains(Options.Option.SHOW_TIMES);
            this.setPhase(Phase.forString(options.get(Options.Option.phase)));
            if (SHOW_TIMES) {
                testOverallTime = new ElapsedTimer("Test setup time for setCldrFileToCheck: {0}");
            }
            super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
            possibleErrors.clear();
            for (CheckCLDR item : this.filteredCheckList) {
                if (SHOW_TIMES) {
                    testTime = new ElapsedTimer("Test setup time for " + item.getClass().toString() + ": {0}");
                }
                try {
                    item.setPhase(this.getPhase());
                    item.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
                    if (!SHOW_TIMES) continue;
                    if (item.isSkipTest()) {
                        System.out.println("Disabled : " + testTime);
                        continue;
                    }
                    System.out.println("OK : " + testTime);
                }
                catch (RuntimeException e) {
                    this.addError(possibleErrors, item, e);
                    if (!SHOW_TIMES) continue;
                    System.out.println("ERR: " + testTime + " - " + e.toString());
                }
            }
            if (SHOW_TIMES) {
                System.out.println("Overall: " + testOverallTime + ": {0}");
            }
            return this;
        }

        public Matcher getFilter() {
            return this.filter;
        }

        public CompoundCheckCLDR setFilter(Matcher filter) {
            this.filter = filter;
            this.filteredCheckList.clear();
            for (CheckCLDR item : this.checkList) {
                if (filter != null && !filter.reset(item.getClass().getName()).matches()) continue;
                this.filteredCheckList.add(item);
                item.setCldrFileToCheck(this.getCldrFileToCheck(), (Options)null, null);
            }
            return this;
        }

        public String getFilteredTests() {
            return this.filteredCheckList.toString();
        }

        public List<CheckCLDR> getFilteredTestList() {
            return this.filteredCheckList;
        }
    }

    public static abstract class FormatDemo
    extends SimpleDemo {
        protected String currentPattern;
        protected String currentInput;
        protected String currentFormatted;
        protected String currentReparsed;
        protected ParsePosition parsePosition = new ParsePosition(0);

        protected abstract String getPattern();

        protected abstract String getSampleInput();

        protected abstract void getArguments(Map<String, String> var1);

        @Override
        public String getHTML(Map<String, String> postArguments) throws Exception {
            this.getArguments(postArguments);
            StringBuffer htmlMessage = new StringBuffer();
            FormatDemo.appendTitle(htmlMessage);
            FormatDemo.appendLine(htmlMessage, this.currentPattern, this.currentInput, this.currentFormatted, this.currentReparsed);
            htmlMessage.append("</table>");
            return htmlMessage.toString();
        }

        public String getPlainText(Map<String, String> postArguments) {
            this.getArguments(postArguments);
            return MessageFormat.format("<\"\u200e{0}\u200e\", \"{1}\"> \u2192 \"\u200e{2}\u200e\" \u2192 \"{3}\"", this.currentPattern, this.currentInput, this.currentFormatted, this.currentReparsed);
        }

        public static void appendLine(StringBuffer htmlMessage, String pattern, String input, String formatted, String reparsed) {
            htmlMessage.append("<tr><td><input type='text' name='pattern' value='").append(TransliteratorUtilities.toXML.transliterate(pattern)).append("'></td><td><input type='text' name='input' value='").append(TransliteratorUtilities.toXML.transliterate(input)).append("'></td><td>").append("<input type='submit' value='Test' name='Test'>").append("</td><td><input type='text' name='formatted' value='").append(TransliteratorUtilities.toXML.transliterate(formatted)).append("'></td><td><input type='text' name='reparsed' value='").append(TransliteratorUtilities.toXML.transliterate(reparsed)).append("'></td></tr>");
        }

        public static void appendTitle(StringBuffer htmlMessage) {
            htmlMessage.append("<table border='1' cellspacing='0' cellpadding='2'><tr><th>Pattern</th><th>Unlocalized Input</th><th></th><th>Localized Format</th><th>Re-Parsed</th></tr>");
        }
    }

    public static abstract class SimpleDemo {
        Map<String, String> internalPostArguments = new HashMap<String, String>();

        public abstract String getHTML(Map<String, String> var1) throws Exception;

        public final String getHTML(String path, String fullPath, String value) throws Exception {
            return this.getHTML(this.internalPostArguments);
        }

        public final boolean processPost(Map<String, String> postArguments) {
            this.internalPostArguments.clear();
            this.internalPostArguments.putAll(postArguments);
            return true;
        }
    }

    public static class CheckStatus {
        public static final Type alertType = Type.Comment;
        public static final Type warningType = Type.Warning;
        public static final Type errorType = Type.Error;
        public static final Type exampleType = Type.Example;
        public static final Type demoType = Type.Demo;
        public static Set<Subtype> crossCheckSubtypes = ImmutableSet.of(Subtype.dateSymbolCollision, Subtype.displayCollision, Subtype.inconsistentDraftStatus, Subtype.incompleteLogicalGroup, Subtype.inconsistentPeriods, Subtype.abbreviatedDateFieldTooWide, new Subtype[]{Subtype.narrowDateFieldTooWide, Subtype.coverageLevel});
        public static Set<Subtype> errorCodesPath = ImmutableSet.of(Subtype.duplicatePlaceholders, Subtype.extraPlaceholders, Subtype.gapsInPlaceholderNumbers, Subtype.invalidPlaceHolder, Subtype.missingPlaceholders, Subtype.shouldntHavePlaceholders, new Subtype[0]);
        private Type type;
        private Subtype subtype = Subtype.none;
        private String messageFormat;
        private Object[] parameters;
        private String htmlMessage;
        private CheckCLDR cause;
        private boolean checkOnSubmit = true;

        public boolean isCheckOnSubmit() {
            return this.checkOnSubmit;
        }

        public CheckStatus setCheckOnSubmit(boolean dependent) {
            this.checkOnSubmit = dependent;
            return this;
        }

        public Type getType() {
            return this.type;
        }

        public CheckStatus setMainType(Type type) {
            this.type = type;
            return this;
        }

        public String getMessage() {
            Exception[] exceptionParameters;
            String message = this.messageFormat;
            if (this.messageFormat != null && this.parameters != null) {
                try {
                    String fixedApos = MessageFormat.autoQuoteApostrophe(this.messageFormat);
                    MessageFormat format = new MessageFormat(fixedApos);
                    message = format.format(this.parameters);
                    if (errorCodesPath.contains((Object)this.subtype)) {
                        message = message + "; see <a href='http://cldr.unicode.org/translation/error-codes#" + this.subtype.name() + "'  target='cldr_error_codes'>" + (Object)((Object)this.subtype) + "</a>.";
                    }
                }
                catch (Exception e) {
                    message = this.messageFormat;
                    System.err.println("MessageFormat Failure: " + (Object)((Object)this.subtype) + "; " + this.messageFormat + "; " + (this.parameters == null ? null : Arrays.asList(this.parameters)));
                }
            }
            if ((exceptionParameters = this.getExceptionParameters()) != null) {
                for (Exception exception : exceptionParameters) {
                    message = message + "; " + exception.getMessage();
                }
            }
            return message.replace('\t', ' ');
        }

        @Deprecated
        public String getHTMLMessage() {
            return this.htmlMessage;
        }

        @Deprecated
        public CheckStatus setHTMLMessage(String message) {
            this.htmlMessage = message;
            return this;
        }

        public CheckStatus setMessage(String message) {
            if (this.cause == null) {
                throw new IllegalArgumentException("Must have cause set.");
            }
            if (message == null) {
                throw new IllegalArgumentException("Message cannot be null.");
            }
            this.messageFormat = message;
            this.parameters = null;
            return this;
        }

        public CheckStatus setMessage(String message, Object ... messageArguments) {
            if (this.cause == null) {
                throw new IllegalArgumentException("Must have cause set.");
            }
            this.messageFormat = message;
            this.parameters = messageArguments;
            return this;
        }

        public String toString() {
            return (Object)((Object)this.getType()) + ": " + this.getMessage();
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public Exception[] getExceptionParameters() {
            if (this.parameters == null) {
                return null;
            }
            ArrayList<Exception> errors = new ArrayList<Exception>();
            for (Object o : this.parameters) {
                if (!(o instanceof Exception)) continue;
                errors.add((Exception)o);
            }
            if (errors.size() == 0) {
                return null;
            }
            return errors.toArray(new Exception[errors.size()]);
        }

        public CheckStatus setParameters(Object[] parameters) {
            if (this.cause == null) {
                throw new IllegalArgumentException("Must have cause set.");
            }
            this.parameters = parameters;
            return this;
        }

        public SimpleDemo getDemo() {
            return null;
        }

        public CheckCLDR getCause() {
            return this.cause;
        }

        public CheckStatus setCause(CheckCLDR cause) {
            this.cause = cause;
            return this;
        }

        public Subtype getSubtype() {
            return this.subtype;
        }

        public CheckStatus setSubtype(Subtype subtype) {
            this.subtype = subtype;
            return this;
        }

        public static final boolean hasError(List<CheckStatus> result) {
            return CheckStatus.hasType(result, errorType);
        }

        public static boolean hasType(List<CheckStatus> result, Type type) {
            if (result == null) {
                return false;
            }
            for (CheckStatus s2 : result) {
                if (!s2.getType().equals((Object)type)) continue;
                return true;
            }
            return false;
        }

        public static enum Subtype {
            none,
            noUnproposedVariant,
            deprecatedAttribute,
            illegalPlural,
            invalidLocale,
            incorrectCasing,
            valueMustBeOverridden,
            valueAlwaysOverridden,
            nullChildFile,
            internalError,
            coverageLevel,
            missingPluralInfo,
            currencySymbolTooWide,
            incorrectDatePattern,
            abbreviatedDateFieldTooWide,
            displayCollision,
            illegalExemplarSet,
            missingAuxiliaryExemplars,
            extraPlaceholders,
            missingPlaceholders,
            shouldntHavePlaceholders,
            couldNotAccessExemplars,
            noExemplarCharacters,
            modifiedEnglishValue,
            invalidCurrencyMatchSet,
            multipleMetazoneMappings,
            noMetazoneMapping,
            noMetazoneMappingAfter1970,
            noMetazoneMappingBeforeNow,
            cannotCreateZoneFormatter,
            insufficientCoverage,
            missingLanguageTerritoryInfo,
            missingEuroCountryInfo,
            deprecatedAttributeWithReplacement,
            missingOrExtraDateField,
            internalUnicodeSetFormattingError,
            auxiliaryExemplarsOverlap,
            missingPunctuationCharacters,
            charactersNotInCurrencyExemplars,
            asciiCharactersNotInCurrencyExemplars,
            charactersNotInMainOrAuxiliaryExemplars,
            asciiCharactersNotInMainOrAuxiliaryExemplars,
            narrowDateFieldTooWide,
            illegalCharactersInExemplars,
            orientationDisagreesWithExemplars,
            inconsistentDatePattern,
            inconsistentTimePattern,
            missingDatePattern,
            illegalDatePattern,
            missingMainExemplars,
            mustNotStartOrEndWithSpace,
            illegalCharactersInNumberPattern,
            numberPatternNotCanonical,
            currencyPatternMissingCurrencySymbol,
            missingMinusSign,
            badNumericType,
            percentPatternMissingPercentSymbol,
            illegalNumberFormat,
            unexpectedAttributeValue,
            metazoneContainsDigit,
            tooManyGroupingSeparators,
            inconsistentPluralFormat,
            missingZeros,
            sameAsEnglish,
            sameAsCode,
            dateSymbolCollision,
            incompleteLogicalGroup,
            extraMetazoneString,
            inconsistentDraftStatus,
            errorOrWarningInLogicalGroup,
            valueTooWide,
            valueTooNarrow,
            nameContainsYear,
            patternCannotContainDigits,
            patternContainsInvalidCharacters,
            parenthesesNotAllowed,
            illegalNumberingSystem,
            unexpectedOrderOfEraYear,
            invalidPlaceHolder,
            asciiQuotesNotAllowed,
            badMinimumGroupingDigits,
            inconsistentPeriods,
            inheritanceMarkerNotAllowed,
            invalidDurationUnitPattern,
            invalidDelimiter,
            illegalCharactersInPattern,
            badParseLenient,
            tooManyValues,
            invalidSymbol,
            invalidGenderCode,
            mismatchedUnitComponent,
            longPowerWithSubscripts,
            gapsInPlaceholderNumbers,
            duplicatePlaceholders,
            largerDifferences;

            static Pattern TO_STRING;

            public String toString() {
                return TO_STRING.matcher(this.name()).replaceAll(" $1").toLowerCase();
            }

            static {
                TO_STRING = PatternCache.get("([A-Z])");
            }
        }

        public static enum Type {
            Comment,
            Warning,
            Error,
            Example,
            Demo;

        }
    }

    public static final class Options
    implements Comparable<Options> {
        private static StandardCodes sc = StandardCodes.make();
        private final boolean DEBUG_OPTS = false;
        String[] options = new String[Option.values().length];
        CLDRLocale locale = null;
        private final String key;

        public Options(Map<String, String> fromOptions) {
            this.clear();
            this.setAll(fromOptions);
            this.key = null;
        }

        private void setAll(Map<String, String> fromOptions) {
            for (Map.Entry<String, String> e : fromOptions.entrySet()) {
                this.set(e.getKey(), e.getValue());
            }
        }

        public void set(String key, String value) {
            for (Option o : Option.values()) {
                if (!o.getKey().equals(key)) continue;
                this.set(o, value);
                return;
            }
            throw new IllegalArgumentException("Unknown CLDR option: '" + key + "' - valid keys are: " + Options.getValidKeys());
        }

        private static String getValidKeys() {
            TreeSet<String> allkeys = new TreeSet<String>();
            for (Option o : Option.values()) {
                allkeys.add(o.getKey());
            }
            return ListFormatter.getInstance().format(allkeys);
        }

        public Options() {
            this.clear();
            this.key = "".intern();
        }

        public Options(Options options2) {
            this.options = Arrays.copyOf(options2.options, options2.options.length);
            this.key = options2.key;
        }

        public Options(CLDRLocale locale, Phase testPhase, String requiredLevel, String localeType) {
            this.locale = locale;
            this.options = new String[Option.values().length];
            StringBuilder sb = new StringBuilder();
            this.set(Option.locale, locale.getBaseName());
            sb.append(locale.getBaseName()).append('/');
            this.set(Option.CoverageLevel_requiredLevel, requiredLevel);
            sb.append(requiredLevel).append('/');
            this.set(Option.CoverageLevel_localeType, localeType);
            sb.append(localeType).append('/');
            this.set(Option.phase, testPhase.name().toLowerCase());
            sb.append(localeType).append('/');
            this.key = sb.toString().intern();
        }

        public Options clone() {
            return new Options(this);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Options)) {
                return false;
            }
            if (this.key != null && ((Options)other).key != null) {
                return this.key == ((Options)other).key;
            }
            return this.compareTo((Options)other) == 0;
        }

        private Options clear() {
            for (int i = 0; i < this.options.length; ++i) {
                this.options[i] = null;
            }
            return this;
        }

        private Options set(Option o, String v) {
            this.options[o.ordinal()] = v;
            return this;
        }

        public String get(Option o) {
            String v = this.options[o.ordinal()];
            return v;
        }

        public CLDRLocale getLocale() {
            if (this.locale != null) {
                return this.locale;
            }
            return CLDRLocale.getInstance(this.get(Option.locale));
        }

        public Level getRequiredLevel(String localeID) {
            Level result;
            String localeType = this.get(Option.CoverageLevel_requiredLevel);
            if (localeType != null && (result = Level.get(localeType)) != Level.UNDETERMINED) {
                return result;
            }
            return sc.getLocaleCoverageLevel("Cldr", localeID);
        }

        public boolean contains(Option o) {
            String s2 = this.get(o);
            return s2 != null && !s2.isEmpty();
        }

        @Override
        public int compareTo(Options other) {
            if (other == this) {
                return 0;
            }
            if (this.key != null && other.key != null) {
                if (this.key == other.key) {
                    return 0;
                }
                return this.key.compareTo(other.key);
            }
            for (int i = 0; i < this.options.length; ++i) {
                String s1 = this.options[i];
                String s2 = other.options[i];
                if (s1 == null && s2 == null) continue;
                if (s1 == null) {
                    return -1;
                }
                if (s2 == null) {
                    return 1;
                }
                int rv = s1.compareTo(s2);
                if (rv == 0) continue;
                return rv;
            }
            return 0;
        }

        public int hashCode() {
            if (this.key != null) {
                return this.key.hashCode();
            }
            int h2 = 1;
            for (int i = 0; i < this.options.length; ++i) {
                if (this.options[i] == null) {
                    h2 *= 11;
                    continue;
                }
                h2 = h2 * 11 + this.options[i].hashCode();
            }
            return h2;
        }

        public String toString() {
            if (this.key != null) {
                return "Options:" + this.key;
            }
            StringBuilder sb = new StringBuilder();
            for (Option o : Option.values()) {
                if (this.options[o.ordinal()] == null) continue;
                sb.append((Object)o).append('=').append(this.options[o.ordinal()]).append(' ');
            }
            return sb.toString();
        }

        public static enum Option {
            locale,
            CoverageLevel_requiredLevel("CoverageLevel.requiredLevel"),
            CoverageLevel_localeType("CoverageLevel.localeType"),
            SHOW_TIMES,
            phase,
            lgWarningCheck,
            CheckCoverage_skip("CheckCoverage.skip"),
            exemplarErrors;

            private String key;

            public String getKey() {
                return this.key;
            }

            private Option(String key) {
                this.key = key;
            }

            private Option() {
                this.key = this.name();
            }
        }
    }

    public static enum Phase {
        BUILD(new String[0]),
        SUBMISSION(new String[0]),
        VETTING(new String[0]),
        FINAL_TESTING("RESOLUTION");


        private Phase(String ... alternateName) {
            for (String name : alternateName) {
                PHASE_NAMES.put(name.toUpperCase(Locale.ENGLISH), this);
            }
        }

        public static Phase forString(String value) {
            if (value == null) {
                return CLDRConfig.getInstance().getPhase();
            }
            value = value.toUpperCase(Locale.ENGLISH);
            Phase result = (Phase)((Object)PHASE_NAMES.get(value));
            return result != null ? result : Phase.valueOf(value);
        }

        public StatusAction getShowRowAction(CLDRInfo.PathValueInfo pathValueInfo, InputMethod inputMethod, PathHeader.SurveyToolStatus status, CLDRInfo.UserInfo userInfo) {
            if (status == PathHeader.SurveyToolStatus.DEPRECATED) {
                return StatusAction.FORBID_READONLY;
            }
            if (status == PathHeader.SurveyToolStatus.READ_ONLY) {
                return StatusAction.ALLOW_TICKET_ONLY;
            }
            if (inputMethod == InputMethod.BULK && this != SUBMISSION) {
                return StatusAction.FORBID_UNLESS_DATA_SUBMISSION;
            }
            if (userInfo != null && userInfo.getVoterInfo().getLevel().compareTo(VoteResolver.Level.tc) >= 0) {
                return StatusAction.ALLOW;
            }
            if (status == PathHeader.SurveyToolStatus.HIDE) {
                return StatusAction.FORBID_READONLY;
            }
            CLDRInfo.CandidateInfo winner = pathValueInfo.getCurrentItem();
            ValueStatus valueStatus = this.getValueStatus(winner, ValueStatus.NONE, null);
            if (this == SUBMISSION) {
                return status == PathHeader.SurveyToolStatus.READ_WRITE || status == PathHeader.SurveyToolStatus.LTR_ALWAYS ? StatusAction.ALLOW : StatusAction.ALLOW_VOTING_AND_TICKET;
            }
            if (valueStatus != ValueStatus.NONE) {
                return status == PathHeader.SurveyToolStatus.READ_WRITE || status == PathHeader.SurveyToolStatus.LTR_ALWAYS ? StatusAction.ALLOW : StatusAction.ALLOW_VOTING_AND_TICKET;
            }
            return StatusAction.ALLOW_VOTING_BUT_NO_ADD;
        }

        public StatusAction getAcceptNewItemAction(CLDRInfo.CandidateInfo enteredValue, CLDRInfo.PathValueInfo pathValueInfo, InputMethod inputMethod, PathHeader.SurveyToolStatus status, CLDRInfo.UserInfo userInfo) {
            if (status != PathHeader.SurveyToolStatus.READ_WRITE && status != PathHeader.SurveyToolStatus.LTR_ALWAYS) {
                return StatusAction.FORBID_READONLY;
            }
            if (userInfo == null) {
                return StatusAction.FORBID_ERRORS;
            }
            if (enteredValue == null) {
                return StatusAction.ALLOW;
            }
            if (userInfo.getVoterInfo().getLevel().compareTo(VoteResolver.Level.tc) >= 0) {
                return StatusAction.ALLOW;
            }
            ValueStatus valueStatus = this.getValueStatus(enteredValue, ValueStatus.NONE, CheckStatus.crossCheckSubtypes);
            if (valueStatus == ValueStatus.ERROR) {
                return StatusAction.FORBID_ERRORS;
            }
            if (this == SUBMISSION) {
                return StatusAction.ALLOW;
            }
            valueStatus = ValueStatus.NONE;
            for (CLDRInfo.CandidateInfo candidateInfo : pathValueInfo.getValues()) {
                if (candidateInfo == enteredValue) {
                    return StatusAction.ALLOW;
                }
                valueStatus = this.getValueStatus(candidateInfo, valueStatus, CheckStatus.crossCheckSubtypes);
            }
            if (valueStatus != ValueStatus.NONE) {
                return StatusAction.ALLOW;
            }
            return StatusAction.FORBID_UNLESS_DATA_SUBMISSION;
        }

        public ValueStatus getValueStatus(CLDRInfo.CandidateInfo value, ValueStatus previous, Set<CheckStatus.Subtype> changeErrorToWarning) {
            if (previous == ValueStatus.ERROR || value == null) {
                return previous;
            }
            for (CheckStatus item : value.getCheckStatusList()) {
                CheckStatus.Type type = item.getType();
                if (type.equals((Object)CheckStatus.Type.Error)) {
                    if (changeErrorToWarning != null && changeErrorToWarning.contains((Object)item.getSubtype())) {
                        return ValueStatus.WARNING;
                    }
                    return ValueStatus.ERROR;
                }
                if (!type.equals((Object)CheckStatus.Type.Warning)) continue;
                previous = ValueStatus.WARNING;
            }
            return previous;
        }

        public static enum ValueStatus {
            ERROR,
            WARNING,
            NONE;

        }
    }

    public static enum StatusAction {
        ALLOW,
        ALLOW_VOTING_AND_TICKET,
        ALLOW_VOTING_BUT_NO_ADD,
        ALLOW_TICKET_ONLY,
        FORBID_ERRORS(true),
        FORBID_READONLY(true),
        FORBID_UNLESS_DATA_SUBMISSION(true),
        FORBID_NULL(true),
        FORBID_ROOT(true),
        FORBID_CODE(true),
        FORBID_PERMANENT_WITHOUT_FORUM(true);

        private final boolean isForbidden;

        private StatusAction() {
            this.isForbidden = false;
        }

        private StatusAction(boolean isForbidden) {
            this.isForbidden = isForbidden;
        }

        public boolean isForbidden() {
            return this.isForbidden;
        }

        public boolean canShow() {
            return !this.isForbidden;
        }
    }

    public static enum InputMethod {
        DIRECT,
        BULK;

    }
}

