/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.util.ApproximateWidth;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.SupplementalDataInfo;

public class CheckWidths
extends CheckCLDR {
    private static CoverageLevel2 coverageLevel;
    private Level requiredLevel;
    public static final int WARN_COMPONENTS_PER_ANNOTATION = 7;
    public static final int MAX_COMPONENTS_PER_ANNOTATION = 16;
    SupplementalDataInfo supplementalData;
    private static final double EM;
    private static final boolean DEBUG = true;
    private static final Pattern PLACEHOLDER_PATTERN;
    static final String ALLOW_LONGER = "(area-acre|area-square-foot|area-square-mile|length-foot|length-inch|length-mile|length-light-year|length-yard|mass-ounce|mass-pound|power-horsepower|pressure-inch-ofhg|pressure-millimeter-ofhg|speed-mile-per-hour|temperature-fahrenheit|volume-cubic-mile|acceleration-g-force|speed-kilometer-per-hour|speed-meter-per-second|pressure-pound-force-per-square-inch|energy-therm-us)";
    static final String ALLOW_LONGEST = "consumption-liter-per-100-kilometer";
    static RegexLookup<Limit[]> lookup;
    Set<Limit> found = new LinkedHashSet<Limit>();

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (value == null) {
            return this;
        }
        Limit[] items = lookup.get(path);
        CLDRFile.Status status = new CLDRFile.Status();
        this.getCldrFileToCheck().getSourceLocaleID(path, status);
        Boolean aliasedAndComprenehsive = coverageLevel.getLevel(path).compareTo(Level.COMPREHENSIVE) == 0 && status.pathWhereFound.compareTo(path) != 0;
        if (items != null) {
            for (Limit item : items) {
                if (!item.hasProblem(value, result, this, aliasedAndComprenehsive)) continue;
                if (this.found.contains(item)) break;
                this.found.add(item);
                break;
            }
        }
        return this;
    }

    @Override
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        String localeID = cldrFileToCheck.getLocaleID();
        this.supplementalData = SupplementalDataInfo.getInstance(cldrFileToCheck.getSupplementalDirectory());
        coverageLevel = CoverageLevel2.getInstance(this.supplementalData, localeID);
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        return this;
    }

    static {
        EM = ApproximateWidth.getWidth("\u6708");
        PLACEHOLDER_PATTERN = PatternCache.get("\\{\\d\\}");
        lookup = new RegexLookup().setPatternTransform(RegexLookup.RegexFinderTransformPath).addVariable("%A", "\"[^\"]+\"").addVariable("%P", "\"[ap]m\"").addVariable("%Q", "[^ap].*|[ap][^m].*").add("//ldml/delimiters/(quotation|alternateQuotation)", new Limit[]{new Limit(1.0, 1.0, Measure.CODE_POINTS, LimitType.MAXIMUM, Special.NONE)}).add("//ldml/numbers/symbols[@numberSystem=%A]/(decimal|group|minus|percent|perMille|plus)", new Limit[]{new Limit(1.0, 1.0, Measure.CODE_POINTS, LimitType.MAXIMUM, Special.NUMBERSYMBOLS)}).add("//ldml/characters/ellipsis[@type=\"(final|initial|medial)\"]", new Limit[]{new Limit(2.0 * EM, 5.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.PLACEHOLDERS)}).add("//ldml/localeDisplayNames/localeDisplayPattern/", new Limit[]{new Limit(2.0 * EM, 3.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.PLACEHOLDERS)}).add("//ldml/listPatterns/listPattern/listPatternPart[@type=%A]", new Limit[]{new Limit(5.0 * EM, 10.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.PLACEHOLDERS)}).add("//ldml/dates/timeZoneNames/fallbackFormat", new Limit[]{new Limit(2.0 * EM, 3.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.PLACEHOLDERS)}).add("//ldml/dates/timeZoneNames/(regionFormat|hourFormat)", new Limit[]{new Limit(10.0 * EM, 20.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.PLACEHOLDERS)}).add("//ldml/dates/timeZoneNames/(gmtFormat|gmtZeroFormat)", new Limit[]{new Limit(5.0 * EM, 10.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.PLACEHOLDERS)}).add("//ldml/dates/calendars/calendar[@type=\"japanese\"]/.*/eraAbbr/era[@type=%A]", new Limit[]{new Limit(12.0 * EM, 16.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.NONE)}).add("//ldml/dates/calendars/calendar[@type=\"roc\"]/.*/eraAbbr/era[@type=%A]", new Limit[]{new Limit(4.0 * EM, 8.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.NONE)}).add("//ldml/dates/calendars/calendar.*/eraAbbr/era[@type=%A]", new Limit[]{new Limit(3.0 * EM, 6.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.NONE)}).add("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/.*/dayPeriodWidth[@type=\"abbreviated\"]/dayPeriod[@type=%P]", new Limit[]{new Limit(4.0 * EM, 6.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.NONE)}).add("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/.*/dayPeriodWidth[@type=\"abbreviated\"]/dayPeriod[@type=%Q]", new Limit[]{new Limit(8.0 * EM, 12.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.NONE)}).add("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/.*/dayPeriodWidth[@type=\"wide\"]/dayPeriod[@type=%P]", new Limit[]{new Limit(5.0 * EM, 10.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.NONE)}).add("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/.*/dayPeriodWidth[@type=\"wide\"]/dayPeriod[@type=%Q]", new Limit[]{new Limit(10.0 * EM, 20.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.NONE)}).add("//ldml/dates/calendars/calendar.*[@type=\"narrow\"](?!/cyclic|/dayPeriod|/monthPattern)", new Limit[]{new Limit(1.5 * EM, 2.25 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.NONE)}).add("//ldml/numbers/decimalFormats[@numberSystem=%A]/decimalFormatLength[@type=\"short\"]/decimalFormat[@type=%A]/pattern[@type=\"100000000000000", new Limit[]{new Limit(4.0 * EM, 6.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.NUMBERFORMAT)}).add("//ldml/numbers/decimalFormats[@numberSystem=%A]/decimalFormatLength[@type=\"short\"]/decimalFormat[@type=%A]/pattern[@type=\"1", new Limit[]{new Limit(4.0 * EM, 5.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.NUMBERFORMAT)}).add("//ldml/units/unitLength[@type=\"narrow\"]/unit[@type=\"[^\"]+-(future|past)\"]/unitPattern", new Limit[]{new Limit(10.0 * EM, 15.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.PLACEHOLDERS)}).add("//ldml/units/unitLength[@type=\"narrow\"]/unit[@type=\"consumption-liter-per-100-kilometer\"]/unitPattern", new Limit[]{new Limit(5.0 * EM, 6.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.PLACEHOLDERS)}).add("//ldml/units/unitLength[@type=\"narrow\"]/unit[@type=\"(area-acre|area-square-foot|area-square-mile|length-foot|length-inch|length-mile|length-light-year|length-yard|mass-ounce|mass-pound|power-horsepower|pressure-inch-ofhg|pressure-millimeter-ofhg|speed-mile-per-hour|temperature-fahrenheit|volume-cubic-mile|acceleration-g-force|speed-kilometer-per-hour|speed-meter-per-second|pressure-pound-force-per-square-inch|energy-therm-us)\"]/unitPattern", new Limit[]{new Limit(4.0 * EM, 5.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.PLACEHOLDERS)}).add("//ldml/units/unitLength[@type=\"narrow\"]/unit[@type=%A]/unitPattern", new Limit[]{new Limit(3.0 * EM, 4.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.PLACEHOLDERS)}).add("//ldml/units/unitLength[@type=\"short\"]/unit[@type=%A]/unitPattern", new Limit[]{new Limit(5.0 * EM, 10.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.PLACEHOLDERS)}).add("//ldml/numbers/currencies/currency[@type=%A]/symbol", new Limit[]{new Limit(3.0 * EM, 5.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.PLACEHOLDERS)}).add("//ldml/annotations/annotation[@cp=%A][@type=%A]", new Limit[]{new Limit(20.0 * EM, 100.0 * EM, Measure.DISPLAY_WIDTH, LimitType.MAXIMUM, Special.NONE)}).add("//ldml/annotations/annotation[@cp=%A]", new Limit[]{new Limit(7.0, 16.0, Measure.SET_ELEMENTS, LimitType.MAXIMUM, Special.BARS)});
    }

    private static class Limit {
        final double warningReference;
        final double errorReference;
        final LimitType limit;
        final Measure measure;
        final Special special;
        final String message;
        final CheckCLDR.CheckStatus.Subtype subtype;
        final boolean debug;

        public Limit(double warningReference, double errorReference, Measure measure, LimitType limit, Special special, boolean debug) {
            this.debug = debug;
            this.warningReference = warningReference;
            this.errorReference = errorReference;
            this.limit = limit;
            this.measure = measure;
            this.special = special;
            block0 : switch (limit) {
                case MINIMUM: {
                    this.subtype = CheckCLDR.CheckStatus.Subtype.valueTooNarrow;
                    switch (measure) {
                        case CODE_POINTS: {
                            this.message = "Expected no fewer than {0} character(s), but was {1}.";
                            break block0;
                        }
                        case DISPLAY_WIDTH: {
                            this.message = "Too narrow by about {2}% (with common fonts).";
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException();
                }
                case MAXIMUM: {
                    switch (measure) {
                        case CODE_POINTS: {
                            this.message = "Expected no more than {0} character(s), but was {1}.";
                            this.subtype = CheckCLDR.CheckStatus.Subtype.valueTooWide;
                            break block0;
                        }
                        case DISPLAY_WIDTH: {
                            this.message = "Too wide by about {2}% (with common fonts).";
                            this.subtype = CheckCLDR.CheckStatus.Subtype.valueTooWide;
                            break block0;
                        }
                        case SET_ELEMENTS: {
                            this.message = "Expected no more than {0} items(s), but was {1}.";
                            this.subtype = CheckCLDR.CheckStatus.Subtype.tooManyValues;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException();
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public Limit(double d, double e, Measure displayWidth, LimitType maximum, Special placeholders) {
            this(d, e, displayWidth, maximum, placeholders, false);
        }

        boolean hasProblem(String value, List<CheckCLDR.CheckStatus> result, CheckCLDR cause, Boolean aliasedAndComprenehsive) {
            switch (this.special) {
                case NUMBERFORMAT: {
                    String[] values = value.split(";", 2);
                    value = values.length == 2 && values[1].length() > values[0].length() ? values[1] : values[0];
                    value = value.replace("'", "");
                    break;
                }
                case QUOTES: {
                    value = value.replace("'", "");
                    break;
                }
                case PLACEHOLDERS: {
                    value = PLACEHOLDER_PATTERN.matcher(value).replaceAll("");
                    break;
                }
                case NUMBERSYMBOLS: {
                    value = value.replaceAll("[\u200e\u200f\u061c]", "");
                    break;
                }
                case BARS: {
                    value = value.replaceAll("[^|]", "") + "|";
                    break;
                }
            }
            double valueMeasure = this.measure == Measure.DISPLAY_WIDTH ? (double)ApproximateWidth.getWidth(value) : (double)value.codePointCount(0, value.length());
            CheckCLDR.CheckStatus.Type errorType = CheckCLDR.CheckStatus.warningType;
            switch (this.limit) {
                case MINIMUM: {
                    if (valueMeasure >= this.warningReference) {
                        return false;
                    }
                    if (!(valueMeasure < this.errorReference) || cause.getPhase() == CheckCLDR.Phase.BUILD || aliasedAndComprenehsive.booleanValue()) break;
                    errorType = CheckCLDR.CheckStatus.errorType;
                    break;
                }
                case MAXIMUM: {
                    if (valueMeasure <= this.warningReference) {
                        return false;
                    }
                    if (!(valueMeasure > this.errorReference) || cause.getPhase() == CheckCLDR.Phase.BUILD || aliasedAndComprenehsive.booleanValue()) break;
                    errorType = cause.getPhase() == CheckCLDR.Phase.SUBMISSION && this.measure.equals((Object)Measure.SET_ELEMENTS) ? CheckCLDR.CheckStatus.warningType : CheckCLDR.CheckStatus.errorType;
                }
            }
            double percent = (int)(Math.abs(115.0 * valueMeasure / this.warningReference - 100.0) / 10.0 + 0.49999) * 10;
            result.add(new CheckCLDR.CheckStatus().setCause(cause).setMainType(errorType).setSubtype(this.subtype).setMessage(this.message, this.warningReference, valueMeasure, percent));
            return true;
        }
    }

    private static enum Special {
        NONE,
        QUOTES,
        PLACEHOLDERS,
        NUMBERSYMBOLS,
        NUMBERFORMAT,
        BARS;

    }

    private static enum LimitType {
        MINIMUM,
        MAXIMUM;

    }

    private static enum Measure {
        CODE_POINTS,
        DISPLAY_WIDTH,
        SET_ELEMENTS;

    }
}

