/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.ibm.icu.lang.CharSequences;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.StringRange;
import org.unicode.cldr.util.SupplementalDataInfo;

public class CompareIso3166_1Status {
    private static final Joiner SPACE_JOINER = Joiner.on(" ");
    static SupplementalDataInfo SDI = SupplementalDataInfo.getInstance();

    public static void main(String[] args) {
        TreeMap<String, Iso3166Status> isoStatus = new TreeMap<String, Iso3166Status>();
        TreeMap<String, String> isoDescription = new TreeMap<String, String>();
        Splitter semi = Splitter.on(';').trimResults();
        for (String line : FileUtilities.in(StandardCodes.class, "data/external/iso_3166_status.txt")) {
            if (line.startsWith("#")) continue;
            List<String> parts = semi.splitToList(line);
            String regionCode2 = parts.get(0);
            isoStatus.put(regionCode2, Iso3166Status.valueOf(parts.get(1).toLowerCase(Locale.ROOT).replace(' ', '_')));
            isoDescription.put(regionCode2, parts.get(1));
        }
        Map<String, Map<StandardCodes.LstrField, String>> lstregRegions = StandardCodes.getEnumLstreg().get((Object)StandardCodes.LstrType.region);
        Map<String, Map<StandardCodes.LstrField, String>> lstregRegionsRaw = StandardCodes.getLstregEnumRaw().get((Object)StandardCodes.LstrType.region);
        HashSet<String> seen = new HashSet<String>();
        ChainedMap.M5 ordered = ChainedMap.of(new TreeMap(), new TreeMap(), new TreeMap(), new TreeMap(), Boolean.class);
        TreeMap<String, CldrStatus> cldrStatus = new TreeMap<String, CldrStatus>();
        TreeMap<String, CldrStatus> bcp47Status = new TreeMap<String, CldrStatus>();
        for (Map.Entry<String, Map<StandardCodes.LstrField, String>> entry : lstregRegions.entrySet()) {
            String string = entry.getKey();
            Map<StandardCodes.LstrField, String> cldrData = entry.getValue();
            String description = CompareIso3166_1Status.setStatus(string, cldrData, cldrStatus, true);
            Map<StandardCodes.LstrField, String> bcp47Data = lstregRegionsRaw.get(string);
            CompareIso3166_1Status.setStatus(string, bcp47Data, bcp47Status, false);
            Iso3166Status isoStatus2 = CldrUtility.ifNull(isoStatus.get(string), Iso3166Status.out_of_scope);
            ordered.put(cldrStatus.get(string), bcp47Status.get(string), isoStatus2, string, Boolean.TRUE);
            System.out.println(string + "\t" + cldrStatus.get(string) + "\t" + bcp47Status.get(string) + "\t" + (Object)((Object)isoStatus2) + "\t" + bcp47Data);
            seen.add(string);
        }
        for (Map.Entry<String, Map<StandardCodes.LstrField, String>> entry : lstregRegionsRaw.entrySet()) {
            String string = entry.getKey();
            Map<StandardCodes.LstrField, String> bcp47Data = entry.getValue();
            CompareIso3166_1Status.setStatus(string, bcp47Data, bcp47Status, false);
        }
        TreeSet missing = new TreeSet(isoStatus.keySet());
        missing.removeAll(seen);
        for (String string : missing) {
            Iso3166Status isoStatus2 = (Iso3166Status)((Object)isoStatus.get(string));
            cldrStatus.put(string, CldrStatus.unused);
            bcp47Status.put(string, CldrStatus.unused);
            ordered.put(cldrStatus.get(string), bcp47Status.get(string), isoStatus2, string, Boolean.TRUE);
            System.out.println(string + "\t" + cldrStatus.get(string) + "\t" + bcp47Status.get(string) + "\t" + (Object)((Object)isoStatus2) + "\t" + (String)isoDescription.get(string));
        }
        System.out.println();
        for (Map.Entry entry : ordered) {
            CldrStatus cldrStatus2 = (CldrStatus)((Object)entry.getKey());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                CldrStatus bcp47Status2 = (CldrStatus)((Object)entry2.getKey());
                for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                    Iso3166Status isoStatus2 = (Iso3166Status)((Object)entry3.getKey());
                    Set<String> codes = ((Map)entry3.getValue()).keySet();
                    System.out.println("||\t" + (Object)((Object)cldrStatus2) + "\t||\t" + (Object)((Object)bcp47Status2) + "\t||\t" + (Object)((Object)isoStatus2) + "\t||\t" + codes.size() + "\t||\t" + CompareIso3166_1Status.compactDisplay(codes) + "\t||");
                }
            }
        }
    }

    private static String compactDisplay(Set<String> codes) {
        final StringBuilder b = new StringBuilder();
        StringRange.Adder myAdder = new StringRange.Adder(){

            @Override
            public void add(String start, String end) {
                if (b.length() != 0) {
                    b.append(' ');
                }
                b.append(start);
                if (end != null) {
                    b.append('-').append(end);
                }
            }
        };
        StringRange.compact(codes, myAdder, false);
        return b.toString();
    }

    private static int toNumber(String code) {
        int num = 0;
        for (int cp : CharSequences.codePoints(code)) {
            num <<= 7;
            num += cp;
        }
        return num;
    }

    private static String fromNumber(int cp) {
        StringBuilder b = new StringBuilder();
        while (cp != 0) {
            int part = cp & 0x7F;
            b.insert(0, (char)part);
            cp >>= 7;
        }
        return b.toString();
    }

    private static String setStatus(String regionCode, Map<StandardCodes.LstrField, String> cldrData, Map<String, CldrStatus> cldrStatus, boolean showMacro) {
        String description = cldrData.get((Object)StandardCodes.LstrField.Description);
        if (cldrData.containsKey((Object)StandardCodes.LstrField.Deprecated)) {
            cldrStatus.put(regionCode, CldrStatus.deprecated);
        } else if (description.equalsIgnoreCase("Private use")) {
            cldrStatus.put(regionCode, CldrStatus.privateUse);
        } else if (showMacro && SDI.getContained(regionCode) != null) {
            cldrStatus.put(regionCode, CldrStatus.macroregion);
        } else {
            cldrStatus.put(regionCode, CldrStatus.region);
        }
        return description;
    }

    public static enum CldrStatus {
        region,
        macroregion,
        deprecated,
        privateUse,
        unused;

    }

    public static enum Iso3166Status {
        officially_assigned,
        private_use,
        exceptionally_reserved,
        indeterminately_reserved,
        transitionally_reserved,
        formerly_used,
        out_of_scope;

    }
}

