/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileReaders;
import org.unicode.cldr.util.SupplementalDataInfo;

public class GeneratePluralList {
    static final String stock = "km|lo|ne|br|dz|nl|si|en|ar|de|es|fr|it|ja|ko|nl|pl|ru|th|tr|pt|zh|zh_Hant|bg|ca|cs|da|el|fa|fi|fil|hi|hr|hu|id|lt|lv|ro|sk|sl|sr|sv|uk|vi|he|no|et|ms|am|bn|gu|is|kn|ml|mr|sw|ta|te|ur|eu|gl|af|zu|en_GB|es_419|pt_PT|fr_CA|zh_Hant_HK";
    private static final Map<String, Integer> keywordIndex = Builder.with(new HashMap()).put("zero", 0).put("one", 1).put("two", 2).put("few", 3).put("many", 4).put("other", 5).get();
    private DecimalFormat format = new DecimalFormat();
    private PrintWriter out;
    private PluralRules rules;
    private Map<String, Map<String, String>> localesToNouns = new HashMap<String, Map<String, String>>();
    static String[] units = new String[]{"second", "minute", "hour", "day", "month", "year"};

    private GeneratePluralList(PrintWriter out) {
        if (out == null) {
            out = new PrintWriter(System.out);
        }
        this.out = out;
    }

    private void loadNouns() throws IOException {
        BufferedReader reader = FileReaders.openFile(GeneratePluralList.class, "fractionnum.csv");
        String line = reader.readLine();
        while (line != null) {
            String[] fields = line.split(",");
            String locale = fields[0];
            String count = fields[1];
            String format = fields[5];
            Map<String, String> nouns = this.localesToNouns.get(locale);
            if (nouns == null) {
                nouns = new HashMap<String, String>();
                this.localesToNouns.put(locale, nouns);
            }
            nouns.put(count, format);
            line = reader.readLine();
        }
    }

    public static GeneratePluralList build(PrintWriter out) {
        GeneratePluralList generator = new GeneratePluralList(out);
        return generator;
    }

    private void getExamples(String locale) {
        this.rules = PluralRules.forLocale(new ULocale(locale));
        SupplementalDataInfo.PluralInfo.Count[] digits = new SupplementalDataInfo.PluralInfo.Count[1000];
        HashSet<SupplementalDataInfo.PluralInfo.Count> missingTypes = new HashSet<SupplementalDataInfo.PluralInfo.Count>();
        for (String keyword : this.rules.getKeywords()) {
            missingTypes.add(SupplementalDataInfo.PluralInfo.Count.valueOf(keyword));
        }
        HashMap<String, List<Integer>> integerMap = new HashMap<String, List<Integer>>();
        digits[0] = SupplementalDataInfo.PluralInfo.Count.zero;
        missingTypes.remove((Object)SupplementalDataInfo.PluralInfo.Count.zero);
        GeneratePluralList.put(integerMap, "zero", 0);
        GeneratePluralList.put(integerMap, "zero|zero", 0);
        for (int i = 1; i < digits.length; ++i) {
            SupplementalDataInfo.PluralInfo.Count type;
            digits[i] = type = SupplementalDataInfo.PluralInfo.Count.valueOf(this.rules.select(i));
            missingTypes.remove((Object)type);
            GeneratePluralList.put(integerMap, type.toString(), i);
            SupplementalDataInfo.PluralInfo.Count digitType = i < 10 ? type : digits[i % 10];
            String key = type.toString() + '|' + (Object)((Object)digitType);
            GeneratePluralList.put(integerMap, key, i);
        }
        missingTypes.remove((Object)SupplementalDataInfo.PluralInfo.Count.other);
        if (missingTypes.size() > 0) {
            System.out.println("WARNING: the following plural types may not be represented fully for " + locale + ": " + missingTypes);
            for (SupplementalDataInfo.PluralInfo.Count type : missingTypes) {
                Collection<Double> values = this.rules.getSamples(type.toString());
                if (values == null) continue;
                int value = values.iterator().next().intValue();
                GeneratePluralList.put(integerMap, type.toString(), value);
            }
        }
        for (int i = 1; i <= 3; ++i) {
            this.getExamples(locale, integerMap, i);
        }
    }

    private void getExamples(String locale, Map<String, List<Integer>> integerMap, int numDigits) {
        Map<String, String> nouns = this.localesToNouns.get(locale);
        if (nouns == null) {
            return;
        }
        int limit = (int)Math.pow(10.0, numDigits);
        HashMap<String, String> exampleMap = new HashMap<String, String>();
        HashMap<String, ExampleManager> positionedExamples = new HashMap<String, ExampleManager>();
        HashSet<String> allKeywords = new HashSet<String>(this.rules.getKeywords());
        allKeywords.add("zero");
        allKeywords.retainAll(integerMap.keySet());
        this.format.setMinimumIntegerDigits(numDigits);
        for (String string : allKeywords) {
            List<Integer> values;
            int integer = values.get((values = integerMap.get(string)).size() > 1 ? 1 : 0);
            for (String y : integerMap.keySet()) {
                String key;
                String[] keywords;
                int fraction;
                if (!y.contains("|") || (fraction = values.get((values = integerMap.get(y)).size() > 1 ? 1 : 0).intValue()) >= limit || !(keywords = (key = string + '|' + y).split("\\|"))[0].equals("zero") && keywords[0].equals(keywords[1])) continue;
                for (int i = 0; i < keywords.length; ++i) {
                    String position = i + keywords[i];
                    ExampleManager manager = (ExampleManager)positionedExamples.get(position);
                    if (manager == null) {
                        manager = new ExampleManager();
                        positionedExamples.put(position, manager);
                    }
                    manager.add(key);
                }
                String example = integer + "." + this.format.format(fraction);
                exampleMap.put(key, example);
            }
        }
        TreeSet<String> finalExamples = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                String[] forms1 = arg1.split("\\|");
                String[] forms0 = arg0.split("\\|");
                for (int i = 0; i < forms0.length; ++i) {
                    int compare = (Integer)keywordIndex.get(forms0[i]) - (Integer)keywordIndex.get(forms1[i]);
                    if (compare == 0) continue;
                    return compare;
                }
                return 0;
            }
        });
        for (ExampleManager manager : positionedExamples.values()) {
            finalExamples.addAll(manager.getAll());
        }
        String string = this.rules.select(0.0);
        for (String category : finalExamples) {
            String exampleValue = (String)exampleMap.get(category);
            this.out.println(locale + "\t" + exampleValue + "\t" + category.replace("zero", string).replace('|', '\t'));
        }
        this.out.flush();
    }

    private static <A, B> void put(Map<A, List<B>> map, A key, B value) {
        List<B> list = map.get(key);
        if (list == null) {
            list = new ArrayList<B>();
            map.put(key, list);
        }
        list.add(value);
    }

    private void getForms(CLDRFile file) {
        this.rules = PluralRules.forLocale(new ULocale(file.getLocaleID()));
        System.out.println(file.getLocaleID());
        for (String plural : this.rules.getKeywords()) {
            this.out.print(file.getLocaleID() + '\t' + plural + '\t' + this.rules.getSamples(plural).iterator().next());
            for (String unit : units) {
                this.printUnit(file, unit, plural);
                this.printUnit(file, unit + "-past", plural);
                this.printUnit(file, unit + "-future", plural);
            }
            this.out.println();
            this.out.flush();
        }
    }

    private void printUnit(CLDRFile file, String unit, String plural) {
        String path = "//ldml/units/unit[@type=\"" + unit + "\"]/unitPattern[@count=\"" + plural + "\"]";
        String value = file.getStringValue(path);
        this.out.print('\t');
        if (value == null) {
            System.out.println(file.getLocaleID() + " has no example for " + plural + " " + unit);
        } else {
            this.out.print(value);
        }
    }

    public static void main(String[] args) throws Exception {
        PrintWriter out = FileUtilities.openUTF8Writer("/Users/jchye/Desktop", "plurals.tsv");
        GeneratePluralList generator = new GeneratePluralList(out);
        generator.loadNouns();
        Factory factory = Factory.make(CLDRPaths.MAIN_DIRECTORY, stock);
        for (String locale : factory.getAvailable()) {
            generator.getExamples(locale);
        }
        out.close();
    }

    private class ExampleManager
    implements Iterable<String> {
        private Set<String> list3 = new HashSet<String>();

        public void add(String example) {
            this.list3.add(example);
        }

        public String toString() {
            return this.list3.toString();
        }

        @Override
        public Iterator<String> iterator() {
            return this.list3.iterator();
        }

        public Set<String> getAll() {
            return this.list3;
        }
    }
}

