/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.FixedDecimal;
import com.ibm.icu.text.PluralRules;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.tool.WritePluralRules;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TempPrintWriter;

public class GeneratedPluralSamples {
    private static final double VALUE_TO_CHECK = 7.1;
    static CLDRConfig testInfo = ToolConfig.getToolInstance();
    static Info INFO = new Info();
    private static final boolean THROW = true;
    private static final int SAMPLE_LIMIT = 8;
    private static final int UNBOUNDED_LIMIT = 20;
    private static final String RANGE_SEPARATOR = "~";
    public static final String SEQUENCE_SEPARATOR = ", ";
    static SupplementalDataInfo sInfo = CLDRConfig.getInstance().getSupplementalDataInfo();
    static final Double CELTIC_SPECIAL = new Double(1000000.0);
    private final TreeMap<String, DataSamples> keywordToData = new TreeMap();
    private final SupplementalDataInfo.PluralType type;
    static final Option.Options myOptions = new Option.Options();
    private static boolean CHECK_VALUE = false;

    private static void append(StringBuilder b, long startValue2, long visibleFractionDigitCount2) {
        int len = b.length();
        int i = 0;
        while ((long)i < visibleFractionDigitCount2) {
            b.insert(len, startValue2 % 10L);
            startValue2 /= 10L;
            ++i;
        }
        b.insert(len, '.');
        b.insert(len, startValue2);
    }

    public static long getFlatValue(FixedDecimal start) {
        int temp = 1;
        for (long i = (long)start.getVisibleDecimalDigitCount(); i != 0L; i /= 10L) {
            temp *= 10;
        }
        return start.getIntegerValue() * (long)temp + start.getDecimalDigits();
    }

    private static int getDigit(FixedDecimal ni) {
        int result = 0;
        long value = ni.getIntegerValue();
        do {
            ++result;
        } while ((value /= 10L) != 0L);
        return result;
    }

    GeneratedPluralSamples(SupplementalDataInfo.PluralInfo pluralInfo, SupplementalDataInfo.PluralType type, Set<String> equivalentLocales) {
        this.type = type;
        this.collect(pluralInfo, 0L, 10000L, 0);
        this.collect10s(pluralInfo, 10000L, 1000000L, 0);
        if (type == SupplementalDataInfo.PluralType.cardinal) {
            this.collect(pluralInfo, 0L, 10000L, 1);
            this.collect10s(pluralInfo, 10000L, 1000000L, 1);
            this.collect(pluralInfo, 0L, 1000L, 2);
            this.collect10s(pluralInfo, 1000L, 1000000L, 2);
            this.collect(pluralInfo, 0L, 100L, 3);
            this.collect10s(pluralInfo, 100L, 1000000L, 3);
            this.collect(pluralInfo, 0L, 10L, 4);
            this.collect10s(pluralInfo, 10L, 1000000L, 4);
            if (equivalentLocales.contains("fr")) {
                int i;
                PluralRules pluralRules = pluralInfo.getPluralRules();
                for (i = 1; i < 15; ++i) {
                    this.add(pluralRules, i, 0, 3);
                    this.add(pluralRules, i, 0, 6);
                    this.add(pluralRules, i, 0, 9);
                    this.add(pluralRules, (double)i + 0.1, 1, 3);
                    this.add(pluralRules, (double)i + 0.1, 1, 6);
                    this.add(pluralRules, (double)i + 0.1, 1, 9);
                    this.add(pluralRules, (double)i + 1.0E-4, 4, 3);
                    this.add(pluralRules, (double)i + 1.0E-7, 7, 6);
                    this.add(pluralRules, (double)i + 1.0E-10, 10, 9);
                }
                i = 0;
            }
        }
        for (Map.Entry<String, DataSamples> entry : this.keywordToData.entrySet()) {
            entry.getValue().freeze();
        }
    }

    private void collect10s(SupplementalDataInfo.PluralInfo pluralInfo, long start, long end, int decimals) {
        double power = Math.pow(10.0, decimals);
        for (long i = start * (long)((int)power); i <= end * (long)((int)power); i *= 10L) {
            this.add(pluralInfo, (double)i / power, decimals);
        }
    }

    private void collect(SupplementalDataInfo.PluralInfo pluralInfo, long start, long limit, int decimals) {
        double power = Math.pow(10.0, decimals);
        for (long i = start; i <= limit * (long)((int)power); ++i) {
            this.add(pluralInfo, (double)i / power, decimals);
        }
    }

    private void add(SupplementalDataInfo.PluralInfo pluralInfo, double d, int visibleDecimals) {
        FixedDecimal ni = new FixedDecimal(d, visibleDecimals);
        PluralRules pluralRules = pluralInfo.getPluralRules();
        if (CHECK_VALUE && d == 7.1) {
            boolean bl = false;
        }
        String keyword = pluralRules.select(ni);
        INFO.add(Info.Type.Warning, GeneratedPluralSamples.checkForDuplicates(pluralRules, ni));
        this.add(pluralRules, keyword, ni);
    }

    public void add(PluralRules pluralRules, double n, int v, int e) {
        FixedDecimal ni = FixedDecimal.createWithExponent(n * Math.pow(10.0, e), v, e);
        String keyword = pluralRules.select(ni);
        System.out.println("{" + n + SEQUENCE_SEPARATOR + v + SEQUENCE_SEPARATOR + e + "} " + ni + " => " + keyword + SEQUENCE_SEPARATOR + (ni.getVisibleDecimalDigitCount() == 0 ? "integer" : "decimal"));
        this.add(pluralRules, keyword, ni);
    }

    public void add(PluralRules pluralRules, String keyword, FixedDecimal ni) {
        DataSamples data = this.keywordToData.get(keyword);
        if (data == null) {
            data = new DataSamples(keyword, pluralRules);
            this.keywordToData.put(keyword, data);
        }
        data.add(ni);
    }

    public static String checkForDuplicates(PluralRules pluralRules, FixedDecimal ni) {
        return null;
    }

    private DataSamples getData(String keyword) {
        return this.keywordToData.get(keyword);
    }

    public boolean equals(Object obj) {
        return this.keywordToData.equals(((GeneratedPluralSamples)obj).keywordToData);
    }

    public int hashCode() {
        return this.keywordToData.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        myOptions.parse(MyOptions.filter, args, true);
        Matcher localeMatcher = !MyOptions.filter.option.doesOccur() ? null : PatternCache.get(MyOptions.filter.option.getValue()).matcher("");
        boolean fileFormat = true;
        boolean multiline = MyOptions.multiline.option.doesOccur();
        boolean sortNew = MyOptions.sortNew.option.doesOccur();
        int failureCount = 0;
        PluralRules pluralRules2 = PluralRules.createRules("one: n is 3..9; two: n is 7..12");
        System.out.println("Check: " + GeneratedPluralSamples.checkForDuplicates(pluralRules2, new FixedDecimal("8e1")));
        for (SupplementalDataInfo.PluralType type : SupplementalDataInfo.PluralType.values()) {
            try (TempPrintWriter out = TempPrintWriter.openUTF8Writer(MyOptions.output.option.getValue(), type == SupplementalDataInfo.PluralType.cardinal ? "plurals.xml" : "ordinals.xml");){
                out.print(WritePluralRules.formatPluralHeader(type, "GeneratedPluralSamples"));
                System.out.println("\n");
                Set<String> locales = testInfo.getSupplementalDataInfo().getPluralLocales(type);
                Relation<SupplementalDataInfo.PluralInfo, String> seenAlready = Relation.of(new TreeMap(), TreeSet.class);
                for (String string : locales) {
                    if (localeMatcher != null && !localeMatcher.reset(string).find()) continue;
                    SupplementalDataInfo.PluralInfo pluralInfo = testInfo.getSupplementalDataInfo().getPlurals(type, string);
                    seenAlready.put(pluralInfo, string);
                }
                AbstractSet sorted = sortNew ? new LinkedHashSet() : new TreeSet<Map.Entry<SupplementalDataInfo.PluralInfo, Set<String>>>(new HackComparator(type == SupplementalDataInfo.PluralType.cardinal ? WritePluralRules.HACK_ORDER_PLURALS : WritePluralRules.HACK_ORDER_ORDINALS));
                for (Map.Entry entry : seenAlready.keyValuesSet()) {
                    sorted.add(entry);
                }
                Set set = Collections.EMPTY_SET;
                Relation<GeneratedPluralSamples, SupplementalDataInfo.PluralInfo> samplesToPlurals = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
                for (Map.Entry entry : sorted) {
                    GeneratedPluralSamples samples;
                    SupplementalDataInfo.PluralInfo pluralInfo = (SupplementalDataInfo.PluralInfo)entry.getKey();
                    Set equivalentLocales = (Set)entry.getValue();
                    CHECK_VALUE = equivalentLocales.contains("pt");
                    String representative = (String)equivalentLocales.iterator().next();
                    PluralRules pluralRules = pluralInfo.getPluralRules();
                    Set<String> keywords = pluralRules.getKeywords();
                    if (fileFormat) {
                        void var16_18;
                        if (!keywords.equals(var16_18)) {
                            out.println("\n        <!-- " + keywords.size() + ": " + Joiner.on(",").join(keywords) + " -->\n");
                            Set<String> set2 = keywords;
                        }
                        out.println(WritePluralRules.formatPluralRuleHeader(equivalentLocales));
                        System.out.println((Object)((Object)type) + "\t" + equivalentLocales);
                    }
                    try {
                        samples = new GeneratedPluralSamples(pluralInfo, type, equivalentLocales);
                    }
                    catch (Exception e) {
                        out.dontReplaceFile();
                        throw e;
                    }
                    samplesToPlurals.put(samples, pluralInfo);
                    for (String keyword : keywords) {
                        DataSamples data;
                        int atPos;
                        SupplementalDataInfo.PluralInfo.Count count = SupplementalDataInfo.PluralInfo.Count.valueOf(keyword);
                        String rule = pluralInfo.getRule(count);
                        if (rule != null && (atPos = rule.indexOf(64)) >= 0) {
                            rule = rule.substring(0, atPos).trim();
                        }
                        if (rule == null && count != SupplementalDataInfo.PluralInfo.Count.other) {
                            pluralInfo.getRule(count);
                            throw new IllegalArgumentException("No rule for " + (Object)((Object)count));
                        }
                        if (!fileFormat) {
                            System.out.print((Object)((Object)type) + "\t" + representative + "\t" + keyword + "\t" + (rule == null ? "" : rule));
                        }
                        if ((data = samples.getData(keyword)) == null) {
                            System.err.println("***Failure");
                            ++failureCount;
                            continue;
                        }
                        if (fileFormat) {
                            out.println(WritePluralRules.formatPluralRule(keyword, rule, data.toString(), multiline));
                            continue;
                        }
                        System.out.println(data.toString());
                    }
                    if (fileFormat) {
                        out.println(WritePluralRules.formatPluralRuleFooter());
                        continue;
                    }
                    System.out.println();
                }
                if (fileFormat) {
                    out.println(WritePluralRules.formatPluralFooter());
                } else {
                    for (Map.Entry entry : seenAlready.keyValuesSet()) {
                        if (((Set)entry.getValue()).size() == 1) continue;
                        LinkedHashSet remainder = new LinkedHashSet((Collection)entry.getValue());
                        String first = (String)remainder.iterator().next();
                        remainder.remove(first);
                        System.err.println((Object)((Object)type) + "\tEQUIV:\t\t" + first + "\t\u2263\t" + Joiner.on(SEQUENCE_SEPARATOR).join(remainder));
                    }
                    System.out.println();
                }
                for (Map.Entry entry : samplesToPlurals.keyValuesSet()) {
                    Set set3 = (Set)entry.getValue();
                    if (set3.size() == 1) continue;
                    System.err.println("***Failure: Duplicate results " + set3);
                    ++failureCount;
                }
                System.out.println("\n");
            }
        }
        if (failureCount > 0) {
            System.err.println("***Failures: " + failureCount);
        }
        INFO.print();
    }

    static class HackComparator
    implements Comparator<Map.Entry<SupplementalDataInfo.PluralInfo, Set<String>>> {
        final Map<String, Integer> order;

        HackComparator(Map<String, Integer> order) {
            this.order = order;
        }

        @Override
        public int compare(Map.Entry<SupplementalDataInfo.PluralInfo, Set<String>> o1, Map.Entry<SupplementalDataInfo.PluralInfo, Set<String>> o2) {
            Integer firstLocale1 = this.order.get(o1.getValue().iterator().next());
            Integer firstLocale2 = this.order.get(o2.getValue().iterator().next());
            if (firstLocale1 != null) {
                if (firstLocale2 != null) {
                    return firstLocale1 - firstLocale2;
                }
                return -1;
            }
            if (firstLocale2 != null) {
                return 1;
            }
            return o1.getKey().compareTo(o2.getKey());
        }
    }

    static enum MyOptions {
        output(".*", CLDRPaths.SUPPLEMENTAL_DIRECTORY, "output data directory"),
        filter(".*", null, "filter locales"),
        multiline(null, null, "multiple lines in file"),
        sortNew(null, null, "sort without backwards compatible hack");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }

    class DataSamples {
        private final String keyword;
        private final PluralRules rules;
        private final DataSample integers = new DataSample(PluralRules.SampleType.INTEGER);
        private final DataSample decimals = new DataSample(PluralRules.SampleType.DECIMAL);
        private boolean boundsComputed;

        DataSamples(String keyword, PluralRules rules) {
            this.keyword = keyword;
            this.rules = rules;
        }

        private void add(FixedDecimal ni) {
            if (this.boundsComputed) {
                throw new IllegalArgumentException("Can't call 'add' after 'toString'");
            }
            if (ni.getVisibleDecimalDigitCount() == 0) {
                this.integers.add(ni);
            } else {
                this.decimals.add(ni);
            }
        }

        public String toString() {
            String integersString = this.integers.toString();
            String decimalsString = GeneratedPluralSamples.this.type == SupplementalDataInfo.PluralType.ordinal ? "" : this.decimals.toString();
            return (integersString.isEmpty() ? "\t\t" : "\t@integer\t" + integersString) + (decimalsString.isEmpty() ? "" : "\t@decimal\t" + decimalsString);
        }

        public boolean equals(Object obj) {
            DataSamples other = (DataSamples)obj;
            return this.integers.equals(other.integers) && this.decimals.equals(other.decimals);
        }

        public void freeze() {
            this.integers.freeze(this.keyword, this.rules);
            if (GeneratedPluralSamples.this.type != SupplementalDataInfo.PluralType.ordinal) {
                this.decimals.freeze(this.keyword, this.rules);
            }
            this.boundsComputed = true;
        }
    }

    static class DataSample {
        int count;
        int countNoTrailing = -1;
        final Set<Double> noTrailing = new TreeSet<Double>();
        final Ranges samples = new Ranges();
        final FixedDecimal[] digitToSample = new FixedDecimal[20];
        final PluralRules.SampleType sampleType;
        final Set<FixedDecimal> exponentSamples = new TreeSet<FixedDecimal>();
        private boolean isBounded;

        public DataSample(PluralRules.SampleType sampleType) {
            this.sampleType = sampleType;
        }

        public String toString() {
            Ranges samples2 = new Ranges(this.samples);
            for (FixedDecimal ni : this.digitToSample) {
                if (ni == null) continue;
                samples2.add(ni);
            }
            return this.format(samples2) + (this.isBounded ? "" : ", \u2026");
        }

        private String format(Ranges samples2) {
            StringBuilder builder = new StringBuilder().append(samples2);
            int max = 5;
            for (FixedDecimal exponentSample : this.exponentSamples) {
                if (builder.length() != 0) {
                    builder.append(GeneratedPluralSamples.SEQUENCE_SEPARATOR);
                }
                builder.append(exponentSample);
                if (--max >= 0) continue;
                break;
            }
            return builder.toString();
        }

        private void add(FixedDecimal ni) {
            int digit;
            if (ni.getPluralOperand(PluralRules.Operand.e) != 0.0) {
                this.exponentSamples.add(ni);
                return;
            }
            ++this.count;
            if (this.samples.size() < 16) {
                this.samples.add(ni);
            }
            if (this.noTrailing.size() <= 40) {
                this.noTrailing.add(ni.getSource());
            }
            if (this.digitToSample[digit = GeneratedPluralSamples.getDigit(ni)] == null) {
                this.digitToSample[digit] = ni;
            }
        }

        public boolean equals(Object obj) {
            DataSample other = (DataSample)obj;
            return this.count == other.count && this.samples.equals(other.samples) && this.digitToSample.equals(other.digitToSample) && this.exponentSamples.equals(other.exponentSamples);
        }

        public int hashCode() {
            return this.count ^ this.samples.hashCode() ^ Arrays.asList(this.digitToSample).hashCode() ^ this.exponentSamples.hashCode();
        }

        public void freeze(String keyword, PluralRules rule) {
            this.countNoTrailing = this.noTrailing.size() + this.exponentSamples.size();
            this.isBounded = this.computeBoundedWithSize(keyword, rule);
            if (this.countNoTrailing > 0) {
                this.noTrailing.clear();
            }
            if (!this.isBounded) {
                this.samples.trim(8);
            }
        }

        public boolean computeBoundedWithSize(String keyword, PluralRules rule) {
            boolean bounded;
            if (keyword.equals("other")) {
                bounded = this.noTrailing.size() == 0;
            } else {
                boolean isKnownBounded;
                bounded = isKnownBounded = rule.computeLimited(keyword, this.sampleType);
                if (this.countNoTrailing < 20) {
                    bounded = true;
                    if (keyword.equals("many") && this.countNoTrailing == 1 && this.noTrailing.contains(CELTIC_SPECIAL)) {
                        bounded = false;
                    }
                }
                if (bounded != isKnownBounded) {
                    Info.Type infoType = Info.Type.Error;
                    INFO.add(infoType, this.sampleType.toString().toLowerCase(Locale.ENGLISH) + " computation from rule \u2260 from items; keyword: " + keyword + "; count: " + this.noTrailing + "; rule:\n\t" + rule.toString().replace(";", ";\n\t"));
                }
            }
            return bounded;
        }
    }

    static class Info {
        Set<String> bounds = new TreeSet<String>();

        Info() {
        }

        public void add(Type type, String string) {
            if (string != null && !string.isEmpty()) {
                if (type == Type.Error) {
                    throw new IllegalArgumentException(string);
                }
                this.bounds.add((Object)((Object)type) + ": " + string);
            }
        }

        public void print() {
            for (String infoItem : this.bounds) {
                System.err.println(infoItem);
            }
        }

        static enum Type {
            Warning,
            Error;

        }
    }

    static class Ranges {
        Set<Range>[] data = new Set[10];
        int size = 0;

        public Ranges(Ranges other) {
            int i;
            for (i = 0; i < this.data.length; ++i) {
                this.data[i] = new TreeSet<Range>();
            }
            for (i = 0; i < this.data.length; ++i) {
                for (Range range : other.data[i]) {
                    this.data[i].add(new Range(range));
                }
            }
        }

        public Ranges() {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = new TreeSet<Range>();
            }
        }

        void add(FixedDecimal ni) {
            Set<Range> set = this.data[ni.getVisibleDecimalDigitCount()];
            for (Range item : set) {
                switch (item.getStatus(ni)) {
                    case inside: {
                        return;
                    }
                    case rightBefore: {
                        ++this.size;
                        return;
                    }
                }
            }
            set.add(new Range(ni, ni));
            ++this.size;
        }

        public int size() {
            return this.size;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (Set<Range> datum : this.data) {
                for (Range range : datum) {
                    if (b.length() != 0) {
                        b.append(GeneratedPluralSamples.SEQUENCE_SEPARATOR);
                    }
                    range.format(b);
                }
            }
            return b.toString();
        }

        public void trim(int sampleLimit) {
            for (int i = 0; i < this.data.length; ++i) {
                if (sampleLimit < 2) {
                    sampleLimit = 2;
                }
                Iterator<Range> it = this.data[i].iterator();
                while (it.hasNext()) {
                    it.next();
                    if (--sampleLimit >= 0) continue;
                    it.remove();
                }
            }
        }
    }

    static class Range
    implements Comparable<Range> {
        private final long startValue;
        private long endValue;
        final long offset;
        final long visibleFractionDigitCount;

        public Range(FixedDecimal start, FixedDecimal end) {
            int temp = 1;
            for (long i = (long)start.getVisibleDecimalDigitCount(); i > 0L; --i) {
                temp *= 10;
            }
            this.offset = temp;
            this.visibleFractionDigitCount = start.getVisibleDecimalDigitCount();
            this.startValue = start.getIntegerValue() * this.offset + start.getDecimalDigits();
            this.endValue = end.getIntegerValue() * this.offset + end.getDecimalDigits();
            if (this.startValue < 0L || this.endValue < 0L) {
                throw new IllegalArgumentException("Must not be negative");
            }
        }

        public Range(Range other) {
            this.startValue = other.startValue;
            this.endValue = other.endValue;
            this.offset = other.offset;
            this.visibleFractionDigitCount = other.visibleFractionDigitCount;
        }

        @Override
        public int compareTo(Range o) {
            int diff;
            int n = this.startValue == o.startValue ? 0 : (diff = this.startValue < o.startValue ? -1 : 1);
            if (diff != 0) {
                return diff;
            }
            return this.endValue == o.endValue ? 0 : (this.endValue < o.endValue ? -1 : 1);
        }

        Status getStatus(FixedDecimal ni) {
            Status status;
            long newValue = ni.getIntegerValue() * this.offset + ni.getDecimalDigits();
            if (newValue < 0L) {
                throw new IllegalArgumentException("Must not be negative");
            }
            Status status2 = this.startValue <= newValue && newValue <= this.endValue ? Status.inside : (status = this.endValue + 1L == newValue ? Status.rightBefore : Status.other);
            if (status == Status.rightBefore) {
                this.endValue = newValue;
            }
            return status;
        }

        public StringBuilder format(StringBuilder b) {
            if (this.visibleFractionDigitCount == 0L) {
                b.append(this.startValue);
                if (this.startValue != this.endValue) {
                    b.append(this.startValue + 1L == this.endValue ? GeneratedPluralSamples.SEQUENCE_SEPARATOR : GeneratedPluralSamples.RANGE_SEPARATOR).append(this.endValue);
                }
            } else {
                GeneratedPluralSamples.append(b, this.startValue, this.visibleFractionDigitCount);
                if (this.startValue != this.endValue) {
                    b.append(this.startValue + 1L == this.endValue ? GeneratedPluralSamples.SEQUENCE_SEPARATOR : GeneratedPluralSamples.RANGE_SEPARATOR);
                    GeneratedPluralSamples.append(b, this.endValue, this.visibleFractionDigitCount);
                }
            }
            return b;
        }

        public String toString() {
            return this.format(new StringBuilder()).toString();
        }

        static enum Status {
            inside,
            rightBefore,
            other;

        }
    }
}

