/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Row;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.SupplementalDataInfo;

public class LikelySubtags {
    static final boolean DEBUG = true;
    static final String TAG_SEPARATOR = "_";
    private Map<String, String> toMaximized;
    private boolean favorRegion = false;
    private static SupplementalDataInfo supplementalDataInfo;
    private static Map<String, String> currencyToLikelyTerritory;
    private static final Object SYNC;
    static final Map<String, String> EXTRA_SCRIPTS;

    public LikelySubtags(Map<String, String> toMaximized) {
        LikelySubtags.loadStaticVariables();
        this.toMaximized = this.toMaximized == null ? supplementalDataInfo.getLikelySubtags() : toMaximized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadStaticVariables() {
        if (supplementalDataInfo != null && currencyToLikelyTerritory != null) {
            return;
        }
        Object object = SYNC;
        synchronized (object) {
            supplementalDataInfo = SupplementalDataInfo.getInstance();
            currencyToLikelyTerritory = new HashMap<String, String>();
            Date now = new Date();
            TreeSet<Row.R2<Double, String>> sorted = new TreeSet<Row.R2<Double, String>>();
            for (String string : supplementalDataInfo.getTerritoriesWithPopulationData()) {
                SupplementalDataInfo.PopulationData pop = supplementalDataInfo.getPopulationDataForTerritory(string);
                double population = pop.getPopulation();
                sorted.add(Row.of(-population, string));
            }
            for (Row.R2 r2 : sorted) {
                String territory = (String)r2.get1();
                Set<SupplementalDataInfo.CurrencyDateInfo> targetCurrencyInfo = supplementalDataInfo.getCurrencyDateInfo(territory);
                if (targetCurrencyInfo == null) continue;
                for (SupplementalDataInfo.CurrencyDateInfo cdi : targetCurrencyInfo) {
                    String currency = cdi.getCurrency();
                    if (currencyToLikelyTerritory.containsKey(currency) || !cdi.getStart().before(now) || !cdi.getEnd().after(now) || !cdi.isLegalTender()) continue;
                    currencyToLikelyTerritory.put(currency, territory);
                }
            }
        }
    }

    public LikelySubtags() {
        this(null);
    }

    public boolean isFavorRegion() {
        return this.favorRegion;
    }

    public LikelySubtags setFavorRegion(boolean favorRegion) {
        this.favorRegion = favorRegion;
        return this;
    }

    public Map<String, String> getToMaximized() {
        return this.toMaximized;
    }

    public LikelySubtags setToMaximized(Map<String, String> toMaximized) {
        this.toMaximized = toMaximized;
        return this;
    }

    public static String maximize(String languageTag, Map<String, String> toMaximized) {
        return new LikelySubtags(toMaximized).maximize(languageTag);
    }

    public static String minimize(String input, Map<String, String> toMaximized, boolean favorRegion) {
        return new LikelySubtags(toMaximized).setFavorRegion(favorRegion).minimize(input);
    }

    public synchronized String maximize(String languageTag) {
        if (languageTag == null) {
            return null;
        }
        LanguageTagParser ltp = new LanguageTagParser();
        if (languageTag.equals("es_Hans_CN")) {
            System.out.print("");
        }
        ltp.set(languageTag);
        return this.maximize(ltp);
    }

    private String maximize(LanguageTagParser ltp) {
        String result;
        String language = ltp.getLanguage();
        String region = ltp.getRegion();
        String script = ltp.getScript();
        List<String> variants = ltp.getVariants();
        Map<String, String> extensions = ltp.getExtensions();
        Map<String, String> localeExtensions = ltp.getLocaleExtensions();
        if (language.equals("")) {
            language = "und";
            ltp.setLanguage("und");
        }
        if (script.equals("Zzzz")) {
            script = "";
            ltp.setScript("");
        }
        if (region.equals("ZZ")) {
            region = "";
            ltp.setRegion("");
        }
        if (variants.size() != 0) {
            ltp.setVariants(Collections.emptySet());
        }
        if (extensions.size() != 0) {
            ltp.setExtensions(Collections.emptyMap());
        }
        if (localeExtensions.size() != 0) {
            ltp.setExtensions(Collections.emptyMap());
        }
        if ((result = this.toMaximized.get(ltp.toString())) != null) {
            return ltp.set(result).setVariants(variants).setExtensions(extensions).setLocaleExtensions(localeExtensions).toString();
        }
        boolean noLanguage = language.equals("und");
        boolean noScript = script.isEmpty();
        boolean noRegion = region.isEmpty();
        for (String region2 : noRegion ? Arrays.asList(region) : Arrays.asList(region, "")) {
            ltp.setRegion(region2);
            for (String script2 : noScript ? Arrays.asList(script) : Arrays.asList(script, "")) {
                ltp.setScript(script2);
                result = this.toMaximized.get(ltp.toString());
                if (result == null) continue;
                ltp.set(result);
                if (!noLanguage) {
                    ltp.setLanguage(language);
                }
                if (!noScript) {
                    ltp.setScript(script);
                }
                if (!noRegion) {
                    ltp.setRegion(region);
                }
                return ltp.setVariants(variants).setExtensions(extensions).setLocaleExtensions(localeExtensions).toString();
            }
        }
        if (!noScript) {
            ltp.setLanguage("und");
            ltp.setScript(script);
            result = this.toMaximized.get(ltp.toString());
            if (result != null) {
                ltp.set(result);
                if (!noLanguage) {
                    ltp.setLanguage(language);
                }
                if (!noScript) {
                    ltp.setScript(script);
                }
                if (!noRegion) {
                    ltp.setRegion(region);
                }
                return ltp.setVariants(variants).setExtensions(extensions).setLocaleExtensions(localeExtensions).toString();
            }
        }
        return null;
    }

    public String minimize(String input) {
        return this.minimize(input, LanguageTagParser.OutputOption.ICU_LCVARIANT);
    }

    public synchronized String minimize(String input, LanguageTagParser.OutputOption oo) {
        String[] trials;
        String maximized = LikelySubtags.maximize(input, this.toMaximized);
        if (maximized == null) {
            return null;
        }
        if (maximized.equals("sr_Latn_RS")) {
            System.out.print("");
        }
        LanguageTagParser ltp = new LanguageTagParser().set(maximized);
        String language = ltp.getLanguage();
        String region = ltp.getRegion();
        String script = ltp.getScript();
        List<String> variants = ltp.getVariants();
        Map<String, String> extensions = ltp.getExtensions();
        Map<String, String> localeExtensions = ltp.getLocaleExtensions();
        String maximizedCheck = maximized;
        if (!(variants.isEmpty() && extensions.isEmpty() && localeExtensions.isEmpty())) {
            maximizedCheck = ltp.toLSR();
        }
        for (String trial : trials = new String[]{language, language + TAG_SEPARATOR + (this.favorRegion ? region : script), language + TAG_SEPARATOR + (!this.favorRegion ? region : script)}) {
            String newMaximized = LikelySubtags.maximize(trial, this.toMaximized);
            if (!maximizedCheck.equals(newMaximized)) continue;
            if (variants.isEmpty() && extensions.isEmpty() && localeExtensions.isEmpty()) {
                return trial;
            }
            return ltp.set(trial).setVariants(variants).setExtensions(extensions).setLocaleExtensions(extensions).toString(oo);
        }
        return maximized;
    }

    public String getLikelyScript(String code) {
        String max = this.maximize(code);
        String script = null;
        if (max != null) {
            script = new LanguageTagParser().set(max).getScript();
        } else {
            Map<SupplementalDataInfo.BasicLanguageData.Type, SupplementalDataInfo.BasicLanguageData> data = supplementalDataInfo.getBasicLanguageDataMap(code);
            if (data != null) {
                for (SupplementalDataInfo.BasicLanguageData item : data.values()) {
                    Set<String> scripts = item.getScripts();
                    if (scripts == null || scripts.size() == 0) continue;
                    script = scripts.iterator().next();
                    SupplementalDataInfo.BasicLanguageData.Type type = item.getType();
                    if (type != SupplementalDataInfo.BasicLanguageData.Type.primary) continue;
                    break;
                }
            }
            if (script == null && (script = EXTRA_SCRIPTS.get(code)) == null) {
                script = "Zzzz";
            }
        }
        return script;
    }

    public String getLikelyTerritoryFromCurrency(String code) {
        return currencyToLikelyTerritory.get(code);
    }

    static {
        SYNC = new Object();
        EXTRA_SCRIPTS = Builder.with(new HashMap()).on("crs", "pcm", "tlh").put("Latn").freeze();
    }
}

