/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.util.Output;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.FileProcessor;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.IsoRegionData;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class LocaleReplacements {
    public static final Pattern WHITESPACE;
    static Map<String, Map<String, Row.R2<Set<String>, String>>> type2item2replacementAndReason;
    static Map<String, Relation<String, Row.R2<String, Set<String>>>> type2reason2itemAndreplacement;
    static Relation<String, String> fixed;

    public String get(String old, Output<String> reason) {
        reason.value = null;
        return old;
    }

    private static void addType2item2reasonNreplacement(String line) {
        String[] parts = WHITESPACE.split(line);
        if (parts.length < 4) {
            LocaleReplacements.addType2item2reasonNreplacement(parts[0], parts[2], parts[1], "", true);
            return;
        }
        for (int i = 3; i < parts.length; ++i) {
            LocaleReplacements.addType2item2reasonNreplacement(parts[0], parts[2], parts[i], parts[1], true);
        }
    }

    private static void addType2item2reasonNreplacement(String type, String key, String preferredValue, String reason, boolean ignoreDuplicates) {
        Row.R2<Set<String>, String> oldReplacementAndReason;
        Map<String, Row.R2<Set<String>, String>> item2replacementAndReason;
        if (key == null) {
            return;
        }
        if (type.equals("legacy") || type.equals("redundant")) {
            type = "language";
        }
        key = key.replace('-', '_');
        if (type.equals("variant")) {
            key = key.toUpperCase(Locale.US);
            preferredValue = preferredValue.toUpperCase(Locale.US);
        }
        if ((item2replacementAndReason = type2item2replacementAndReason.get(type)) == null) {
            item2replacementAndReason = new HashMap<String, Row.R2<Set<String>, String>>();
            type2item2replacementAndReason.put(type, item2replacementAndReason);
        }
        if ((oldReplacementAndReason = item2replacementAndReason.get(key)) != null) {
            String message = "duplicateReplacement\t" + type + "\t" + key + "\told: " + oldReplacementAndReason + "\tnew:" + preferredValue + ", " + reason;
            if (!ignoreDuplicates) {
                throw new IllegalArgumentException(message);
            }
            fixed.put(key, message);
            Set list = (Set)oldReplacementAndReason.get0();
            list.add(preferredValue);
            return;
        }
        LinkedHashSet<String> list = new LinkedHashSet<String>(1);
        if (!preferredValue.isEmpty()) {
            list.add(preferredValue);
        }
        item2replacementAndReason.put(key, Row.of(list, reason));
    }

    public static void main(String[] args) {
        Row.R2<String, Set<String>> replacementAndReason;
        String type;
        Map<String, Map<String, Row.R2<List<String>, String>>> localeAliasInfo = SupplementalDataInfo.getInstance().getLocaleAliasInfo();
        TreeSet<String> newStuff = new TreeSet<String>();
        TreeSet<String> oldStuff = new TreeSet<String>();
        for (Map.Entry<String, Relation<String, Row.R2<String, Set<String>>>> entry : type2reason2itemAndreplacement.entrySet()) {
            type = entry.getKey();
            for (Map.Entry<String, Row.R2<String, Set<String>>> entry2 : entry.getValue().entrySet()) {
                String string = entry2.getKey();
                replacementAndReason = entry2.getValue();
                String key = (String)replacementAndReason.get0();
                Set replacements = (Set)replacementAndReason.get1();
                String message = type + "\t" + string + "\t" + key + "\t" + Joiner.on(" ").join(replacements);
                newStuff.add(message);
            }
        }
        for (Map.Entry<String, Object> entry : fixed.entrySet()) {
            System.out.println(entry.getKey() + "\t" + (String)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : localeAliasInfo.entrySet()) {
            type = entry.getKey();
            for (Map.Entry<String, Row.R2<String, Set<String>>> entry3 : ((Map)entry.getValue()).entrySet()) {
                String string = entry3.getKey();
                replacementAndReason = entry3.getValue();
                List replacements = (List)replacementAndReason.get0();
                String reason = (String)replacementAndReason.get1();
                oldStuff.add(type + "\t" + reason + "\t" + string + "\t" + (replacements == null ? "" : Joiner.on(" ").join(replacements)));
            }
        }
        TreeSet<Row.R2<String, String>> merged = new TreeSet<Row.R2<String, String>>();
        Set set = Builder.with(new TreeSet(oldStuff)).removeAll(newStuff).get();
        Set newNotOld = Builder.with(new TreeSet(newStuff)).removeAll(oldStuff).get();
        for (String string : set) {
            merged.add(Row.of(string, "\tOLD"));
        }
        for (String string : newNotOld) {
            merged.add(Row.of(string, "\tNEW"));
        }
        int i = 0;
        for (Row.R2 r2 : merged) {
            System.out.println(++i + "\t" + (String)r2.get1() + "\t" + (String)r2.get0());
        }
        System.out.println("DONE");
    }

    static {
        Set replacements;
        Row.R2<Set<String>, String> replacementAndReason;
        String item;
        String alpha3;
        WHITESPACE = PatternCache.get("\\s+");
        type2item2replacementAndReason = new HashMap<String, Map<String, Row.R2<Set<String>, String>>>();
        type2reason2itemAndreplacement = new TreeMap<String, Relation<String, Row.R2<String, Set<String>>>>();
        fixed = Relation.of(new TreeMap(), LinkedHashSet.class);
        Map<String, Map<String, Map<String, String>>> lstreg = StandardCodes.getLStreg();
        for (Map.Entry<String, Map<String, Map<String, String>>> entry : lstreg.entrySet()) {
            String type = entry.getKey();
            Map<String, Map<String, String>> subtype2data = entry.getValue();
            for (Map.Entry<String, Map<String, String>> itemAndData : subtype2data.entrySet()) {
                Map<String, String> value = itemAndData.getValue();
                String deprecated = value.get("Deprecated");
                if (deprecated == null) continue;
                String preferredValue = value.get("Preferred-Value");
                if (preferredValue == null) {
                    preferredValue = "";
                }
                String key = itemAndData.getKey();
                String type2 = type.equals("region") ? "territory" : type;
                LocaleReplacements.addType2item2reasonNreplacement(type2, key, preferredValue, "deprecated", false);
            }
        }
        for (String lang : Iso639Data.getAvailable()) {
            if (lang.length() != 2) continue;
            alpha3 = Iso639Data.toAlpha3(lang);
            LocaleReplacements.addType2item2reasonNreplacement("language", alpha3, lang, "overlong", false);
        }
        for (String region : IsoRegionData.getAvailable()) {
            alpha3 = IsoRegionData.get_alpha3(region);
            LocaleReplacements.addType2item2reasonNreplacement("territory", alpha3, region, "overlong", false);
            String numeric = IsoRegionData.getNumeric(region);
            LocaleReplacements.addType2item2reasonNreplacement("territory", numeric, region, "overlong", false);
        }
        FileProcessor myReader = new FileProcessor(){

            @Override
            protected boolean handleLine(int lineCount, String line) {
                LocaleReplacements.addType2item2reasonNreplacement(line);
                return true;
            }
        };
        myReader.process(CldrUtility.class, "data/localeReplacements.txt");
        for (Map.Entry<String, Map<String, Row.R2<Set<String>, String>>> entry : type2item2replacementAndReason.entrySet()) {
            boolean keepGoing;
            Map<String, Row.R2<Set<String>, String>> item2replacementAndReason = entry.getValue();
            do {
                keepGoing = false;
                for (Map.Entry<String, Row.R2<Set<String>, String>> entry2 : item2replacementAndReason.entrySet()) {
                    item = entry2.getKey();
                    replacementAndReason = entry2.getValue();
                    replacements = (Set)replacementAndReason.get0();
                    LinkedHashSet<String> newReplacements = new LinkedHashSet<String>(replacements.size());
                    boolean gotChange = false;
                    for (String oldRep : replacements) {
                        Row.R2<Set<String>, String> newRepAndReason = item2replacementAndReason.get(oldRep);
                        if (newRepAndReason != null) {
                            fixed.put(item, oldRep + "\t-->\t" + newRepAndReason);
                            newReplacements.addAll((Collection)newRepAndReason.get0());
                            gotChange = true;
                            continue;
                        }
                        newReplacements.add(oldRep);
                    }
                    if (!gotChange) continue;
                    replacementAndReason.set0(newReplacements);
                    keepGoing = true;
                }
            } while (keepGoing);
        }
        for (Map.Entry<String, Map<String, Row.R2<Set<String>, String>>> entry : type2item2replacementAndReason.entrySet()) {
            String type = entry.getKey();
            Map<String, Row.R2<Set<String>, String>> item2replacementAndReason = entry.getValue();
            for (Map.Entry<String, Row.R2<Set<String>, String>> entry2 : item2replacementAndReason.entrySet()) {
                item = entry2.getKey();
                replacementAndReason = entry2.getValue();
                replacements = (Set)replacementAndReason.get0();
                String reason = (String)replacementAndReason.get1();
                Relation<String, Row.R2<String, Set<String>>> reason2item2replacement = type2reason2itemAndreplacement.get(type);
                if (reason2item2replacement == null) {
                    reason2item2replacement = Relation.of(new TreeMap(), TreeSet.class);
                    type2reason2itemAndreplacement.put(type, reason2item2replacement);
                }
                reason2item2replacement.put(reason, Row.of(item, replacements));
            }
        }
    }
}

