/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.util.HashMap;
import java.util.Map;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ScriptPopulations {
    static SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
    static Map<String, String> likelySubtags = supplementalDataInfo.getLikelySubtags();
    static Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
    static CLDRFile english = cldrFactory.make("en", true);

    public static void main(String[] args) {
        SupplementalDataInfo info = supplementalDataInfo;
        LanguageTagParser languageTagParser = new LanguageTagParser();
        Counter<String> langScriptLitPop = new Counter<String>();
        Counter<String> scriptLitPop = new Counter<String>();
        HashMap<String, SupplementalDataInfo.OfficialStatus> bestStatus = new HashMap<String, SupplementalDataInfo.OfficialStatus>();
        for (String territory : info.getTerritoriesWithPopulationData()) {
            for (String language : info.getLanguagesForTerritoryWithPopulationData(territory)) {
                SupplementalDataInfo.PopulationData languageInfo = info.getLanguageAndTerritoryPopulationData(language, territory);
                SupplementalDataInfo.OfficialStatus officialStatus = languageInfo.getOfficialStatus();
                String baseLanguage = languageTagParser.set(language).getLanguage();
                String script = languageTagParser.getScript();
                if (script.length() == 0) {
                    String maxFrom = LikelySubtags.maximize(language, likelySubtags);
                    script = maxFrom != null ? languageTagParser.set(maxFrom).getScript() : "Zzzz";
                }
                String lang = baseLanguage + "_" + script;
                long population = (long)languageInfo.getLiteratePopulation();
                langScriptLitPop.add(lang, population);
                scriptLitPop.add(script, population);
                SupplementalDataInfo.OfficialStatus oldStatus = (SupplementalDataInfo.OfficialStatus)((Object)bestStatus.get(lang));
                if (oldStatus != null && oldStatus.compareTo(officialStatus) >= 0) continue;
                bestStatus.put(lang, officialStatus);
            }
        }
        for (String lang : langScriptLitPop.getKeysetSortedByCount(false)) {
            String baseLanguage = languageTagParser.set(lang).getLanguage();
            String script = languageTagParser.getScript();
            SupplementalDataInfo.OfficialStatus officialStatus = (SupplementalDataInfo.OfficialStatus)((Object)bestStatus.get(lang));
            System.out.println(baseLanguage + "\t" + script + "\t" + langScriptLitPop.getCount(lang) + "\t" + english.getName(baseLanguage) + "\t" + english.getName(1, script) + "\t" + (Object)((Object)officialStatus) + "\t" + officialStatus.ordinal() + "\t" + scriptLitPop.getCount(script));
        }
    }
}

