/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.StringId;

public abstract class CLDRURLS {
    public static final String CLDR_REPO_BASE = "https://github.com/unicode-org/cldr";
    public static final String DEFAULT_COMMIT_BASE = "https://github.com/unicode-org/cldr/commit/";
    public static final String DEFAULT_HOST = "st.unicode.org";
    public static final String DEFAULT_PATH = "/cldr-apps";
    public static final String DEFAULT_BASE = "https://st.unicode.org/cldr-apps";
    public static final String CLDR_NEWTICKET_URL = "http://cldr.unicode.org/index/bug-reports#TOC-Filing-a-Ticket";
    public static final String CLDR_REPO_ROOT = "https://github.com/unicode-org/cldr";
    public static final String CLDR_HOMEPAGE = "http://cldr.unicode.org";
    public static final String UNICODE_CONSORTIUM = "The Unicode Consortium";
    public static final String UNICODE_SPDX = "Unicode-DFS-2016";
    public static final String CLDR_SURVEY_BASE = "CLDR_SURVEY_BASE";
    public static final String CLDR_SURVEY_PATH = "CLDR_SURVEY_PATH";
    public static final String TOOLSURL = "http://cldr.unicode.org/tools/";
    protected static String VPATH = "/v#";
    public static final String UNKNOWN_REVISION = "(unknown)";

    public abstract String base();

    public String forXpath(String locale, String xpath) {
        return this.forXpath(CLDRLocale.getInstance(locale), xpath);
    }

    public final String forXpath(CLDRLocale locale, String xpath) {
        this.assertIsXpath(xpath);
        String hexid = xpath == null ? null : StringId.getHexId(xpath);
        return this.forXpathHexId(locale, hexid);
    }

    public final String forXpathHexId(String locale, String hexid) {
        return this.forXpathHexId(CLDRLocale.getInstance(locale), hexid);
    }

    public final String forXpathHexId(CLDRLocale locale, String hexid) {
        this.assertIsHexId(hexid);
        return this.forSpecial(Special.Survey, locale, (String)null, hexid);
    }

    public final String forXpathHexId(String locale, PathHeader.PageId page, String hexid) {
        return this.forXpathHexId(CLDRLocale.getInstance(locale), page, hexid);
    }

    public final String forXpathHexId(CLDRLocale locale, PathHeader.PageId page, String hexid) {
        this.assertIsHexId(hexid);
        return this.forSpecial(Special.Survey, locale, page, hexid);
    }

    public final String forPage(String locale, PathHeader.PageId page) {
        return this.forPage(CLDRLocale.getInstance(locale), page);
    }

    public final String forPage(CLDRLocale locale, PathHeader.PageId page) {
        return this.forSpecial(Special.Survey, locale, page.name(), null);
    }

    public final String forLocale(CLDRLocale locale) {
        return this.forXpath(locale, null);
    }

    public final String forSpecial(Special special, CLDRLocale locale, PathHeader.PageId page, String hexid) {
        return this.forSpecial(special, locale, page.name(), hexid);
    }

    public final String forSpecial(Special special) {
        return this.forSpecial(special, (CLDRLocale)null, (String)null, null);
    }

    public final String forSpecial(Special special, CLDRLocale locale) {
        return this.forSpecial(special, locale, (String)null, null);
    }

    public String forSpecial(Special special, CLDRLocale locale, String page, String hexid) {
        StringBuilder sb = new StringBuilder(this.base());
        sb.append(VPATH);
        if (special != null) {
            sb.append(special.id);
        }
        sb.append('/');
        if (locale != null) {
            sb.append(locale.getBaseName());
        }
        sb.append('/');
        if (page != null) {
            sb.append(page);
        }
        sb.append('/');
        if (hexid != null) {
            sb.append(hexid);
        }
        return sb.toString();
    }

    public final void assertIsHexId(String hexid) throws IllegalArgumentException {
        if (hexid != null && hexid.startsWith("/")) {
            throw new IllegalArgumentException("This function takes a hex StringID: perhaps you meant to use forXpath() instead.");
        }
    }

    public final void assertIsXpath(String xpath) throws IllegalArgumentException {
        if (xpath != null && !xpath.startsWith("/")) {
            throw new IllegalArgumentException("This function takes an XPath: perhaps you meant to use forXpathHexId() instead.");
        }
    }

    public final String forSpecial(Special special, String localeID) {
        return this.forSpecial(special, CLDRLocale.getInstance(localeID));
    }

    public final String forPathHeader(String locale, PathHeader pathHeader) {
        return this.forPathHeader(CLDRLocale.getInstance(locale), pathHeader);
    }

    public final String forPathHeader(CLDRLocale locale, PathHeader pathHeader) {
        return this.forSpecial(Special.Survey, locale, pathHeader.getPageId(), StringId.getHexId(pathHeader.getOriginalPath()));
    }

    public static String gitHashToLink(String hash) {
        if (!CLDRURLS.isKnownHash(hash)) {
            return "<span class=\"githashLink\">" + hash + "</span>";
        }
        return "<a class=\"githashLink\" href=\"" + CldrUtility.getProperty("CLDR_COMMIT_BASE", DEFAULT_COMMIT_BASE) + hash + "\">" + hash.substring(0, 8) + "</a>";
    }

    public static boolean isKnownHash(String hash) {
        return !hash.equals(UNKNOWN_REVISION);
    }

    public static final String toHTML(String url) {
        return "<a href=\"" + url + "\">" + url + "</a>";
    }

    public static enum Special {
        Survey(""),
        Locales,
        Vetting("r_vetting_json"),
        Forum;

        private final String id;

        private Special(String s2) {
            this.id = s2;
        }

        private Special() {
            this.id = this.name().toLowerCase();
        }
    }
}

