/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.text.Transform;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.RegexLookup;

public class PatternPlaceholders {
    public static final ImmutableSet<CheckCLDR.CheckStatus.Subtype> PLACEHOLDER_SUBTYPES = ImmutableSet.of(CheckCLDR.CheckStatus.Subtype.gapsInPlaceholderNumbers, CheckCLDR.CheckStatus.Subtype.duplicatePlaceholders, CheckCLDR.CheckStatus.Subtype.missingPlaceholders, CheckCLDR.CheckStatus.Subtype.extraPlaceholders);
    private final RegexLookup<PlaceholderData> patternPlaceholders = RegexLookup.of(new MapTransform()).setValueMerger(new MyMerger()).loadFromFile(PatternPlaceholders.class, "data/Placeholders.txt");

    private PatternPlaceholders() {
    }

    public static PatternPlaceholders getInstance() {
        return PatternPlaceholdersHelper.SINGLETON;
    }

    public Map<String, PlaceholderInfo> get(String path) {
        PlaceholderData map = this.patternPlaceholders.get(path);
        return map == null ? ImmutableMap.of() : Collections.unmodifiableMap(map.data);
    }

    public PlaceholderStatus getStatus(String path) {
        PlaceholderData map = this.patternPlaceholders.get(path);
        return map == null ? PlaceholderStatus.DISALLOWED : map.status;
    }

    private static final class PatternPlaceholdersHelper {
        static final PatternPlaceholders SINGLETON = new PatternPlaceholders();

        private PatternPlaceholdersHelper() {
        }
    }

    private static final class MapTransform
    implements Transform<String, PlaceholderData> {
        private MapTransform() {
        }

        @Override
        public PlaceholderData transform(String source) {
            PlaceholderData result = new PlaceholderData();
            try {
                String[] parts;
                String[] object = parts = source.split("\\s*;\\s+");
                int n = object.length;
                block10: for (int i = 0; i < n; ++i) {
                    String part;
                    switch (part = object[i]) {
                        case "locale": {
                            result.status = PlaceholderStatus.LOCALE_DEPENDENT;
                            continue block10;
                        }
                        case "multiple": {
                            result.status = PlaceholderStatus.MULTIPLE;
                            continue block10;
                        }
                        default: {
                            String example;
                            int equalsPos = part.indexOf(61);
                            String id = part.substring(0, equalsPos).trim();
                            String name = part.substring(equalsPos + 1).trim();
                            int spacePos = name.indexOf(32);
                            if (spacePos >= 0) {
                                example = name.substring(spacePos + 1).trim();
                                name = name.substring(0, spacePos).trim();
                            } else {
                                example = "";
                            }
                            PlaceholderInfo old = result.data.get(id);
                            if (old != null) {
                                throw new IllegalArgumentException("Key occurs twice: " + id + "=" + old + "!=" + name);
                            }
                            result.add(id, name, example);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse " + source, e);
            }
            for (Map.Entry<String, PlaceholderInfo> entry : result.data.entrySet()) {
            }
            return result;
        }
    }

    private static final class MyMerger
    implements RegexLookup.Merger<PlaceholderData> {
        private MyMerger() {
        }

        @Override
        public PlaceholderData merge(PlaceholderData a, PlaceholderData into) {
            for (String key : a.data.keySet()) {
                if (!into.data.containsKey(key)) continue;
                throw new IllegalArgumentException("Duplicate placeholder: " + key);
            }
            into.data.putAll(a.data);
            if (into.status != a.status) {
                throw new IllegalArgumentException("Different optional status");
            }
            return into;
        }
    }

    public static class PlaceholderInfo {
        public String name;
        public String example;

        private PlaceholderInfo(String name, String example) {
            this.name = name;
            this.example = example;
        }

        public String toString() {
            return "{" + this.name + "}, e.g. \u201c" + this.example + "\u201d";
        }
    }

    private static class PlaceholderData {
        PlaceholderStatus status = PlaceholderStatus.REQUIRED;
        Map<String, PlaceholderInfo> data = new LinkedHashMap<String, PlaceholderInfo>();

        private PlaceholderData() {
        }

        public void add(String id, String name, String example) {
            PlaceholderInfo row = new PlaceholderInfo(name, example);
            this.data.put(id, row);
        }
    }

    public static enum PlaceholderStatus {
        DISALLOWED("No placeholders allowed."),
        REQUIRED("Specific number of placeholders allowed."),
        LOCALE_DEPENDENT("Some placeholders may be omitted in certain locales"),
        MULTIPLE("May have multiple instances of the same placeholder, eg \u201c{0} cats and {0} dogs\u201d.");

        private final String message;

        private PlaceholderStatus(String message) {
            this.message = message;
        }

        public String toString() {
            return this.name() + ": " + this.message;
        }
    }
}

