/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.unicode.cldr.util.Quoter;

public abstract class Pick {
    private static boolean DEBUG = false;
    protected String name;

    public Pick replace(String toReplace, Pick replacement) {
        Replacer visitor = new Replacer(toReplace, replacement);
        return this.visit(visitor);
    }

    public Pick name(String nameStr) {
        this.name = nameStr;
        return this;
    }

    public static Sequence makeSequence() {
        return new Sequence();
    }

    public static Alternation makeAlternation() {
        return new Alternation();
    }

    public static Pick repeat(int minCount, int maxCount, int[] itemWeights, Pick item) {
        return new Repeat(minCount, maxCount, itemWeights, item);
    }

    public static Pick codePoint(UnicodeSet source) {
        return new CodePoint(source);
    }

    public static Pick string(String source) {
        return new Literal(source);
    }

    public abstract String getInternal(int var1, Set var2);

    protected abstract void addTo(Target var1);

    public abstract boolean match(String var1, Position var2);

    String checkName(String nameStr, Set alreadySeen) {
        if (nameStr == null) {
            return "";
        }
        if (alreadySeen.contains(nameStr)) {
            return nameStr;
        }
        alreadySeen.add(nameStr);
        return "{" + nameStr + "=}";
    }

    private static String indent(int depth) {
        String result = "\r\n";
        for (int i = 0; i < depth; ++i) {
            result = result + " ";
        }
        return result;
    }

    static int getChar(String newValue, int newIndex, StringBuffer mergeBuffer, boolean copy) {
        if (newIndex >= newValue.length()) {
            return newIndex;
        }
        int cp = UTF16.charAt(newValue, newIndex);
        if (copy) {
            UTF16.append(mergeBuffer, cp);
        }
        return newIndex + UTF16.getCharCount(cp);
    }

    protected abstract Pick visit(Visitor var1);

    public static int pick(Random random, int start, int end) {
        return start + (int)(random.nextDouble() * (double)(end + 1 - start));
    }

    public static double pick(Random random, double start, double end) {
        return start + random.nextDouble() * (end + 1.0 - start);
    }

    public static boolean pick(Random random, double percent) {
        return random.nextDouble() <= percent;
    }

    public static int pick(Random random, UnicodeSet s2) {
        return s2.charAt(Pick.pick(random, 0, s2.size() - 1));
    }

    public static String pick(Random random, String[] source) {
        return source[Pick.pick(random, 0, source.length - 1)];
    }

    public static double[] realloc(double[] source, int newSize) {
        double[] temp = new double[newSize];
        if (newSize > source.length) {
            newSize = source.length;
        }
        if (newSize != 0) {
            System.arraycopy(source, 0, temp, 0, newSize);
        }
        return temp;
    }

    public static int[] realloc(int[] source, int newSize) {
        int[] temp = new int[newSize];
        if (newSize > source.length) {
            newSize = source.length;
        }
        if (newSize != 0) {
            System.arraycopy(source, 0, temp, 0, newSize);
        }
        return temp;
    }

    public static Pick[] realloc(Pick[] source, int newSize) {
        Pick[] temp = new Pick[newSize];
        if (newSize > source.length) {
            newSize = source.length;
        }
        if (newSize != 0) {
            System.arraycopy(source, 0, temp, 0, newSize);
        }
        return temp;
    }

    public static class WeightedIndex {
        private int[] weights = new int[0];
        private int minCount = 0;
        private double total;

        public WeightedIndex(int minCount) {
            this.minCount = minCount;
        }

        public WeightedIndex add(int count, int itemWeights) {
            if (count > 0) {
                int[] newWeights = new int[count];
                if (itemWeights < 1) {
                    itemWeights = 1;
                }
                Arrays.fill(newWeights, 0, count, itemWeights);
                this.add(1, newWeights);
            }
            return this;
        }

        public WeightedIndex add(int[] newWeights) {
            return this.add(newWeights.length, newWeights);
        }

        public WeightedIndex add(int maxCount, int[] newWeights) {
            int i;
            if (newWeights == null) {
                newWeights = new int[]{1};
            }
            int oldLen = this.weights.length;
            if (maxCount < newWeights.length) {
                maxCount = newWeights.length;
            }
            this.weights = Pick.realloc(this.weights, this.weights.length + maxCount);
            System.arraycopy(newWeights, 0, this.weights, oldLen, newWeights.length);
            int lastWeight = this.weights[oldLen + newWeights.length - 1];
            for (i = oldLen + newWeights.length; i < maxCount; ++i) {
                this.weights[i] = lastWeight;
            }
            this.total = 0.0;
            for (i = 0; i < this.weights.length; ++i) {
                if (this.weights[i] < 0) {
                    throw new RuntimeException("only positive weights: " + i);
                }
                this.total += (double)this.weights[i];
            }
            return this;
        }

        public int toIndex(double zeroToOne) {
            int i;
            double weight = zeroToOne * this.total;
            for (i = 0; i < this.weights.length && !((weight -= (double)this.weights[i]) <= 0.0); ++i) {
            }
            return i + this.minCount;
        }

        public String toString() {
            int i;
            String result = "";
            for (i = 0; i < this.minCount; ++i) {
                if (result.length() != 0) {
                    result = result + ",";
                }
                result = result + "0";
            }
            for (i = 0; i < this.weights.length; ++i) {
                if (result.length() != 0) {
                    result = result + ",";
                }
                result = result + this.weights[i];
            }
            return result;
        }
    }

    private static abstract class ListPick
    extends Pick {
        protected Pick[] items = new Pick[0];

        private ListPick() {
        }

        Pick simplify() {
            if (this.items.length > 1) {
                return this;
            }
            if (this.items.length == 1) {
                return this.items[0];
            }
            return null;
        }

        int size() {
            return this.items.length;
        }

        Pick getLast() {
            return this.items[this.items.length - 1];
        }

        void setLast(Pick newOne) {
            this.items[this.items.length - 1] = newOne;
        }

        protected void addInternal(Pick[] objs) {
            int lastLen = this.items.length;
            this.items = ListPick.realloc(this.items, this.items.length + objs.length);
            for (int i = 0; i < objs.length; ++i) {
                this.items[lastLen + i] = objs[i];
            }
        }

        @Override
        public Pick visit(Visitor visitor) {
            Pick result = visitor.handle(this);
            if (visitor.alreadyEntered(this)) {
                return result;
            }
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i] = this.items[i].visit(visitor);
            }
            return result;
        }
    }

    private static abstract class ItemPick
    extends Pick {
        protected Pick item;

        ItemPick(Pick item) {
            this.item = item;
        }

        @Override
        public Pick visit(Visitor visitor) {
            Pick result = visitor.handle(this);
            if (visitor.alreadyEntered(this)) {
                return result;
            }
            if (this.item != null) {
                this.item = this.item.visit(visitor);
            }
            return result;
        }
    }

    private static abstract class FinalPick
    extends Pick {
        private FinalPick() {
        }

        @Override
        public Pick visit(Visitor visitor) {
            return visitor.handle(this);
        }
    }

    static class Replacer
    extends Visitor {
        String toReplace;
        Pick replacement;

        Replacer(String toReplace, Pick replacement) {
            this.toReplace = toReplace;
            this.replacement = replacement;
        }

        @Override
        public Pick handle(Pick a) {
            if (this.toReplace.equals(a.name)) {
                a = this.replacement;
            }
            return a;
        }
    }

    static abstract class Visitor {
        Set already = new HashSet();

        Visitor() {
        }

        abstract Pick handle(Pick var1);

        boolean alreadyEntered(Pick item) {
            boolean result = this.already.contains(item);
            this.already.add(item);
            return result;
        }

        void reset() {
            this.already.clear();
        }
    }

    public static class Position {
        public ArrayList failures = new ArrayList();
        public int index;
        public int maxInt;
        public String maxType;

        public void setMax(String type) {
            if (this.index >= this.maxInt) {
                this.maxType = type;
            }
        }

        public String toString() {
            return "index; " + this.index + ", maxInt:" + this.maxInt + ", maxType: " + this.maxType;
        }

        public boolean isFailure(Pick pick, int item) {
            ArrayList val = (ArrayList)this.failures.get(this.index);
            if (val == null) {
                return false;
            }
            Set set = (Set)val.get(item);
            if (set == null) {
                return false;
            }
            return !set.contains(pick);
        }

        public void setFailure(Pick pick, int item) {
            HashSet<Pick> set;
            ArrayList<HashSet<Pick>> val = (ArrayList<HashSet<Pick>>)this.failures.get(this.index);
            if (val == null) {
                val = new ArrayList<HashSet<Pick>>();
                this.failures.set(this.index, val);
            }
            if ((set = (HashSet<Pick>)val.get(item)) == null) {
                set = new HashSet<Pick>();
                val.set(item, set);
            }
            set.add(pick);
        }
    }

    private static class Literal
    extends FinalPick {
        public String toString() {
            return this.name;
        }

        private Literal(String source) {
            this.name = source;
        }

        @Override
        protected void addTo(Target target) {
            target.append(this.name);
        }

        @Override
        public boolean match(String input, Position p) {
            int len = this.name.length();
            if (input.regionMatches(p.index, this.name, 0, len)) {
                p.index += len;
                return true;
            }
            p.setMax("literal");
            return false;
        }

        @Override
        public String getInternal(int depth, Set alreadySeen) {
            return "'" + this.name + "'";
        }
    }

    static class Quote
    extends ItemPick {
        Quote(Pick item) {
            super(item);
        }

        @Override
        protected void addTo(Target target) {
            target.quoter.setQuoting(true);
            this.item.addTo(target);
            target.quoter.setQuoting(false);
        }

        @Override
        public boolean match(String s2, Position p) {
            return false;
        }

        @Override
        public String getInternal(int depth, Set alreadySeen) {
            String result = this.checkName(this.name, alreadySeen);
            if (result.startsWith("$")) {
                return result;
            }
            return Pick.indent(depth) + result + "QUOTE(" + this.item.getInternal(depth + 1, alreadySeen) + ")";
        }
    }

    static class Morph
    extends ItemPick {
        private String lastValue = null;
        private Target addBuffer = Target.make(this, null, new Quoter.RuleQuoter());
        private StringBuffer mergeBuffer = new StringBuffer();
        private static final int COPY_NEW = 0;
        private static final int COPY_BOTH = 1;
        private static final int COPY_LAST = 3;
        private static final int SKIP = 4;
        private static final int LEAST_SKIP = 4;
        private static final WeightedIndex choice = new WeightedIndex(0).add(new int[]{10, 10, 100, 10});

        Morph(Pick item) {
            super(item);
        }

        @Override
        protected void addTo(Target target) {
            this.addBuffer.copyState(target);
            this.addBuffer.clear();
            this.item.addTo(this.addBuffer);
            String newValue = this.addBuffer.get();
            if (DEBUG) {
                System.out.println("Old: " + this.lastValue + ", New:" + newValue);
            }
            if (this.lastValue != null) {
                this.mergeBuffer.setLength(0);
                int lastIndex = 0;
                int newIndex = 0;
                int newLenLimit = Morph.pick(target.random, this.lastValue.length(), newValue.length());
                while (this.mergeBuffer.length() < newLenLimit && newIndex < newValue.length() && lastIndex < this.lastValue.length()) {
                    int c = choice.toIndex(target.nextDouble());
                    if (c == 0 || c == 1 || c == 4) {
                        newIndex = Morph.getChar(newValue, newIndex, this.mergeBuffer, c < 4);
                        if (this.mergeBuffer.length() >= newLenLimit) break;
                    }
                    if (c != 3 && c != 1 && c != 4) continue;
                    lastIndex = Morph.getChar(this.lastValue, lastIndex, this.mergeBuffer, c < 4);
                }
                newValue = this.mergeBuffer.toString();
            }
            this.lastValue = newValue;
            target.append(newValue);
            if (DEBUG) {
                System.out.println("Result: " + newValue);
            }
        }

        @Override
        public String getInternal(int depth, Set alreadySeen) {
            String result = this.checkName(this.name, alreadySeen);
            if (result.startsWith("$")) {
                return result;
            }
            return Pick.indent(depth) + result + "MORPH(" + this.item.getInternal(depth + 1, alreadySeen) + ")";
        }

        @Override
        public boolean match(String input, Position p) {
            return false;
        }
    }

    private static class CodePoint
    extends FinalPick {
        private UnicodeSet source;

        private CodePoint(UnicodeSet source) {
            this.source = source;
        }

        @Override
        protected void addTo(Target target) {
            target.append(this.source.charAt(CodePoint.pick(target.random, 0, this.source.size() - 1)));
        }

        @Override
        public boolean match(String s2, Position p) {
            int cp = UTF16.charAt(s2, p.index);
            if (this.source.contains(cp)) {
                p.index += UTF16.getCharCount(cp);
                return true;
            }
            p.setMax("codePoint");
            return false;
        }

        @Override
        public String getInternal(int depth, Set alreadySeen) {
            String result = this.checkName(this.name, alreadySeen);
            if (result.startsWith("$")) {
                return result;
            }
            return this.source.toString();
        }
    }

    private static class Repeat
    extends ItemPick {
        WeightedIndex weightedIndex;
        int minCount = 0;

        private Repeat(int minCount, int maxCount, int[] itemWeights, Pick item) {
            super(item);
            this.weightedIndex = new WeightedIndex(minCount).add(maxCount - minCount + 1, itemWeights);
        }

        @Override
        protected void addTo(Target target) {
            int count;
            for (int i = count = this.weightedIndex.toIndex(target.nextDouble()); i > 0; --i) {
                this.item.addTo(target);
            }
        }

        @Override
        public String getInternal(int depth, Set alreadySeen) {
            String result = this.checkName(this.name, alreadySeen);
            if (result.startsWith("$")) {
                return result;
            }
            result = Pick.indent(depth) + result + "REPEAT(" + this.weightedIndex + "; " + this.item.getInternal(depth + 1, alreadySeen) + ")";
            return result;
        }

        @Override
        public boolean match(String input, Position p) {
            int count = 0;
            for (int i = 0; i < this.weightedIndex.weights.length && !p.isFailure(this, i); ++i) {
                if (!this.item.match(input, p)) {
                    p.setFailure(this, i);
                    break;
                }
                ++count;
            }
            return count >= this.minCount;
        }
    }

    public static class Alternation
    extends ListPick {
        private WeightedIndex weightedIndex = new WeightedIndex(0);

        public Alternation or2(Pick[] newItems) {
            return this.or2(1, newItems);
        }

        public Alternation or2(int itemWeight, Pick item) {
            return this.or2(itemWeight, new Pick[]{item});
        }

        public Alternation or2(int itemWeight, Pick[] newItems) {
            int[] itemWeights = new int[newItems.length];
            Arrays.fill(itemWeights, itemWeight);
            return this.or2(itemWeights, newItems);
        }

        public Alternation or2(int[] itemWeights, Pick[] newItems) {
            if (newItems.length != itemWeights.length) {
                throw new ArrayIndexOutOfBoundsException("or lengths must be equal: " + newItems.length + " != " + itemWeights.length);
            }
            this.addInternal(newItems);
            this.weightedIndex.add(itemWeights);
            return this;
        }

        @Override
        protected void addTo(Target target) {
            int index = this.weightedIndex.toIndex(target.nextDouble());
            int last = index - 1;
            if (last < this.weightedIndex.minCount) {
                last -= this.weightedIndex.minCount;
                last += this.weightedIndex.weights.length;
            }
            int i = index;
            while (true) {
                try {
                    target.enterStack(this);
                    this.items[index].addTo(target);
                    target.exitStack(this);
                    return;
                }
                catch (DepthExceededException e) {
                    target.exitStack(this);
                    if (i == last) {
                        throw e;
                    }
                    if (++i < this.weightedIndex.weights.length) continue;
                    i -= this.weightedIndex.weights.length - this.weightedIndex.minCount;
                    continue;
                }
                break;
            }
        }

        @Override
        public String getInternal(int depth, Set alreadySeen) {
            String result = this.checkName(this.name, alreadySeen);
            if (result.startsWith("$")) {
                return result;
            }
            result = Pick.indent(depth) + result + "OR(";
            for (int i = 0; i < this.items.length; ++i) {
                if (i != 0) {
                    result = result + ", ";
                }
                result = result + this.items[i].getInternal(depth + 1, alreadySeen) + "/" + this.weightedIndex.weights[i];
            }
            return result + ")";
        }

        private Alternation() {
        }

        @Override
        public boolean match(String input, Position p) {
            for (int i = 0; i < this.weightedIndex.weights.length; ++i) {
                if (p.isFailure(this, i)) continue;
                if (this.items[i].match(input, p)) {
                    return true;
                }
                p.setFailure(this, i);
            }
            return false;
        }
    }

    public static class Sequence
    extends ListPick {
        public Sequence and2(Pick item) {
            this.addInternal(new Pick[]{item});
            return this;
        }

        public Sequence and2(Pick[] itemArray) {
            this.addInternal(itemArray);
            return this;
        }

        @Override
        protected void addTo(Target target) {
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i].addTo(target);
            }
        }

        @Override
        public String getInternal(int depth, Set alreadySeen) {
            String result = this.checkName(this.name, alreadySeen);
            if (result.startsWith("$")) {
                return result;
            }
            result = Pick.indent(depth) + result + "SEQ(";
            for (int i = 0; i < this.items.length; ++i) {
                if (i != 0) {
                    result = result + ", ";
                }
                result = result + this.items[i].getInternal(depth + 1, alreadySeen);
            }
            result = result + ")";
            return result;
        }

        private Sequence() {
        }

        @Override
        public boolean match(String input, Position p) {
            int originalIndex = p.index;
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i].match(input, p)) continue;
                p.index = originalIndex;
                return false;
            }
            return true;
        }
    }

    static class DepthExceededException
    extends RuntimeException {
        private static final long serialVersionUID = -2478735802169169979L;
        private final Target target;
        private final Pick pick;

        public DepthExceededException(Target target, Pick pick) {
            this.target = target;
            this.pick = pick;
        }
    }

    static class Target {
        static int MAX_COUNT = 5;
        private Pick pick;
        private Random random;
        private Quoter quoter;
        private Multiset<Pick> stack = LinkedHashMultiset.create();

        Target() {
        }

        public static Target make(Pick pick, Random random, Quoter quoter) {
            Target result = new Target();
            result.pick = pick;
            result.random = random;
            result.quoter = quoter;
            return result;
        }

        public String next() {
            this.quoter.clear();
            this.stack.clear();
            while (true) {
                try {
                    this.pick.addTo(this);
                    return this.get();
                }
                catch (DepthExceededException e) {
                    for (Pick pick : ((DepthExceededException)e).target.stack.elementSet()) {
                        System.out.println(pick.name + ": " + ((DepthExceededException)e).target.stack.count(pick));
                    }
                    boolean bl = false;
                    continue;
                }
                break;
            }
        }

        public String get() {
            return this.quoter.toString();
        }

        private void copyState(Target other) {
            this.random = other.random;
        }

        private void clear() {
            this.quoter.clear();
        }

        private Target append(int codepoint) {
            if (codepoint == 45) {
                boolean bl = false;
            }
            this.quoter.append(codepoint);
            return this;
        }

        private Target append(String s2) {
            if (s2.contains("-")) {
                boolean bl = false;
            }
            this.quoter.append(s2);
            return this;
        }

        private double nextDouble() {
            return this.random.nextDouble();
        }

        public void exitStack(Pick pick) {
            this.stack.remove(pick);
        }

        public void enterStack(Pick pick) {
            int count = this.stack.count(pick);
            if (count > MAX_COUNT) {
                throw new DepthExceededException(this, pick);
            }
            this.stack.add(pick);
        }
    }
}

