/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.Notation;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.number.UnlocalizedNumberFormatter;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.Output;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public final class Rational
implements Comparable<Rational> {
    private static final Pattern INT_POWER_10 = Pattern.compile("10*");
    public final BigInteger numerator;
    public final BigInteger denominator;
    public static final Rational ZERO = Rational.of(0L);
    public static final Rational ONE = Rational.of(1L);
    public static final Rational NEGATIVE_ONE = ONE.negate();
    public static final Rational INFINITY = Rational.of(1L, 0L);
    public static final Rational NEGATIVE_INFINITY = INFINITY.negate();
    public static final Rational NaN = Rational.of(0L, 0L);
    public static final Rational TEN = Rational.of(10L, 1L);
    public static final Rational TENTH = TEN.reciprocal();
    public static final char REPTEND_MARKER = '\u02d9';
    static final LocalizedNumberFormatter nf = ((UnlocalizedNumberFormatter)NumberFormatter.with().precision(Precision.unlimited())).locale(Locale.ENGLISH);
    static final LocalizedNumberFormatter snf = ((UnlocalizedNumberFormatter)((UnlocalizedNumberFormatter)NumberFormatter.with().precision(Precision.unlimited())).notation(Notation.engineering())).locale(Locale.ENGLISH);
    static final BigInteger BI_TWO = BigInteger.valueOf(2L);
    static final BigInteger BI_FIVE = BigInteger.valueOf(5L);
    static final BigInteger BI_MINUS_ONE = BigInteger.valueOf(-1L);
    static final BigDecimal BD_TWO = BigDecimal.valueOf(2L);
    static final BigDecimal BD_FIVE = BigDecimal.valueOf(5L);

    public static Rational of(long numerator, long denominator) {
        return new Rational(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    public static Rational of(long numerator) {
        return new Rational(BigInteger.valueOf(numerator), BigInteger.ONE);
    }

    public static Rational of(BigInteger numerator, BigInteger denominator) {
        return new Rational(numerator, denominator);
    }

    public static Rational of(BigInteger numerator) {
        return new Rational(numerator, BigInteger.ONE);
    }

    public static Rational of(String simple) {
        return RationalParser.BASIC.parse(simple);
    }

    private Rational(BigInteger numerator, BigInteger denominator) {
        BigInteger gcd;
        if (denominator.compareTo(BigInteger.ZERO) < 0) {
            numerator = numerator.negate();
            denominator = denominator.negate();
        }
        if ((gcd = numerator.gcd(denominator)).compareTo(BigInteger.ONE) > 0) {
            numerator = numerator.divide(gcd);
            denominator = denominator.divide(gcd);
        }
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public Rational add(Rational other) {
        BigInteger gcd_den = this.denominator.gcd(other.denominator);
        return new Rational(this.numerator.multiply(other.denominator).divide(gcd_den).add(other.numerator.multiply(this.denominator).divide(gcd_den)), this.denominator.multiply(other.denominator).divide(gcd_den));
    }

    public Rational subtract(Rational other) {
        BigInteger gcd_den = this.denominator.gcd(other.denominator);
        return new Rational(this.numerator.multiply(other.denominator).divide(gcd_den).subtract(other.numerator.multiply(this.denominator).divide(gcd_den)), this.denominator.multiply(other.denominator).divide(gcd_den));
    }

    public Rational multiply(Rational other) {
        BigInteger gcd_num_oden = this.numerator.gcd(other.denominator);
        boolean isZero = gcd_num_oden.equals(BigInteger.ZERO);
        BigInteger smallNum = isZero ? this.numerator : this.numerator.divide(gcd_num_oden);
        BigInteger smallODen = isZero ? other.denominator : other.denominator.divide(gcd_num_oden);
        BigInteger gcd_den_onum = this.denominator.gcd(other.numerator);
        isZero = gcd_den_onum.equals(BigInteger.ZERO);
        BigInteger smallONum = isZero ? other.numerator : other.numerator.divide(gcd_den_onum);
        BigInteger smallDen = isZero ? this.denominator : this.denominator.divide(gcd_den_onum);
        return new Rational(smallNum.multiply(smallONum), smallDen.multiply(smallODen));
    }

    public Rational pow(int i) {
        return new Rational(this.numerator.pow(i), this.denominator.pow(i));
    }

    public static Rational pow10(int i) {
        return i > 0 ? TEN.pow(i) : TENTH.pow(-i);
    }

    public Rational divide(Rational other) {
        return this.multiply(other.reciprocal());
    }

    public Rational reciprocal() {
        return new Rational(this.denominator, this.numerator);
    }

    public Rational negate() {
        return new Rational(this.numerator.negate(), this.denominator);
    }

    public BigDecimal toBigDecimal(MathContext mathContext) {
        try {
            return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), mathContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Wrong math context for divide: " + this + ", " + mathContext);
        }
    }

    public double doubleValue() {
        if (this.denominator.equals(BigInteger.ZERO) && this.numerator.equals(BigInteger.ZERO)) {
            return Double.NaN;
        }
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), MathContext.DECIMAL64).doubleValue();
    }

    public BigDecimal toBigDecimal() {
        return this.toBigDecimal(MathContext.UNLIMITED);
    }

    public static Rational of(BigDecimal bigDecimal) {
        int scale = bigDecimal.scale();
        BigInteger unscaled = bigDecimal.unscaledValue();
        if (scale == 0) {
            return new Rational(unscaled, BigInteger.ONE);
        }
        if (scale >= 0) {
            return new Rational(unscaled, BigDecimal.ONE.movePointRight(scale).toBigInteger());
        }
        return new Rational(unscaled.multiply(BigDecimal.ONE.movePointLeft(scale).toBigInteger()), BigInteger.ONE);
    }

    public String toString() {
        return this.toString(FormatStyle.plain);
    }

    public String toString(FormatStyle style) {
        switch (style) {
            case plain: {
                return this.numerator + (this.denominator.equals(BigInteger.ONE) ? "" : " / " + this.denominator);
            }
        }
        Output<BigDecimal> newNumerator = new Output<BigDecimal>(new BigDecimal(this.numerator));
        BigInteger newDenominator = Rational.minimalDenominator(newNumerator, this.denominator);
        String numStr = Rational.format((BigDecimal)newNumerator.value);
        String denStr = nf.format(newDenominator).toString();
        boolean denIsOne = newDenominator.equals(BigInteger.ONE);
        switch (style) {
            case repeating: {
                String result = this.toRepeating(30);
                if (result != null) {
                    return result;
                }
            }
            case simple: {
                return denIsOne ? numStr : numStr + "/" + denStr;
            }
            case html: {
                return denIsOne ? numStr : "<sup>" + numStr + "</sup>/<sub>" + denStr + "<sub>";
            }
        }
        throw new UnsupportedOperationException();
    }

    static String format(BigDecimal value) {
        return nf.format(value).toString();
    }

    @Override
    public int compareTo(Rational other) {
        return this.numerator.multiply(other.denominator).compareTo(other.numerator.multiply(this.denominator));
    }

    public boolean equals(Object that) {
        return this.equals((Rational)that);
    }

    public boolean equals(Rational that) {
        return this.numerator.equals(that.numerator) && this.denominator.equals(that.denominator);
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator);
    }

    public Rational abs() {
        return this.numerator.signum() >= 0 ? this : this.negate();
    }

    public static BigInteger minimalDenominator(Output<BigDecimal> outNumerator, BigInteger denominator) {
        if (denominator.equals(BigInteger.ONE) || denominator.equals(BigInteger.ZERO)) {
            return denominator;
        }
        BigInteger newDenominator = denominator;
        while (newDenominator.mod(BI_TWO).equals(BigInteger.ZERO)) {
            newDenominator = newDenominator.divide(BI_TWO);
            outNumerator.value = ((BigDecimal)outNumerator.value).divide(BD_TWO);
        }
        BigInteger outDenominator = newDenominator;
        while (newDenominator.mod(BI_FIVE).equals(BigInteger.ZERO)) {
            newDenominator = newDenominator.divide(BI_FIVE);
            outNumerator.value = ((BigDecimal)outNumerator.value).divide(BD_FIVE);
        }
        return newDenominator;
    }

    public BigInteger floor() {
        return this.numerator.divide(this.denominator);
    }

    public Rational symmetricDiff(Rational b) {
        return this.subtract(b).divide(this.abs().add(b.abs())).multiply(Rational.of(2L));
    }

    private String toRepeating(int stringLimit) {
        int pToq;
        BigInteger p = this.numerator;
        BigInteger q = this.denominator;
        StringBuilder s2 = new StringBuilder();
        int pTo0 = p.compareTo(BigInteger.ZERO);
        if (q.compareTo(BigInteger.ZERO) == 0) {
            return pTo0 == 0 ? "NaN" : (pTo0 > 0 ? "INF" : "-INF");
        }
        if (pTo0 == 0) {
            return "0";
        }
        if (pTo0 < 0) {
            p = p.negate();
            s2.append('-');
        }
        if ((pToq = p.compareTo(q)) == 0) {
            s2.append('1');
            return s2.toString();
        }
        if (pToq > 0) {
            BigInteger intPart = p.divide(q);
            s2.append(nf.format(intPart));
            p = p.remainder(q);
            if (p.compareTo(BigInteger.ZERO) == 0) {
                return s2.toString();
            }
        } else {
            s2.append('0');
        }
        s2.append(".");
        int pos = -1;
        HashMap<BigInteger, Integer> occurs = new HashMap<BigInteger, Integer>();
        while (!occurs.containsKey(p)) {
            occurs.put(p, pos);
            BigInteger p10 = p.multiply(BigInteger.TEN);
            BigInteger z = p10.divide(q);
            p = p10.subtract(z.multiply(q));
            s2 = s2.append((char)(48 + z.intValue()));
            if (p.equals(BigInteger.ZERO)) {
                return s2.toString();
            }
            if (s2.length() > stringLimit) {
                return null;
            }
            --pos;
        }
        int L = (Integer)occurs.get(p) - pos;
        s2.insert(s2.length() - L, '\u02d9');
        return s2.toString();
    }

    public boolean isPowerOfTen() {
        Output<BigDecimal> newNumerator = new Output<BigDecimal>(new BigDecimal(this.numerator));
        BigInteger newDenominator = Rational.minimalDenominator(newNumerator, this.denominator);
        if (!newDenominator.equals(BigInteger.ONE)) {
            return false;
        }
        String str = ((BigDecimal)newNumerator.value).unscaledValue().toString();
        return INT_POWER_10.matcher(str).matches();
    }

    public String getIntPowerOfTen() {
        int sign;
        BigInteger value;
        if (this.numerator.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Prefix label must be positive: " + this);
        }
        if (!this.numerator.equals(BigInteger.ONE) && !this.denominator.equals(BigInteger.ONE)) {
            throw new IllegalArgumentException("Prefix label must be power of 10: " + this);
        }
        if (this.numerator.equals(BigInteger.ONE)) {
            value = this.denominator;
            sign = -1;
        } else {
            value = this.numerator;
            sign = 1;
        }
        String str = value.toString();
        if (!INT_POWER_10.matcher(str).matches()) {
            throw new IllegalArgumentException("Prefix label must be power of 10: " + this);
        }
        int result = str.length() - 1;
        return String.valueOf(result * sign);
    }

    public static class ContinuedFraction {
        public final List<BigInteger> sequence;

        public ContinuedFraction(Rational source) {
            ArrayList<BigInteger> _sequence = new ArrayList<BigInteger>();
            while (true) {
                BigInteger floor;
                if ((floor = source.floor()).compareTo(BigInteger.ZERO) < 0) {
                    floor = floor.subtract(BigInteger.ONE);
                }
                Rational remainder = source.subtract(Rational.of(floor, BigInteger.ONE));
                _sequence.add(floor);
                if (remainder.equals(ZERO)) break;
                source = remainder.reciprocal();
            }
            this.sequence = ImmutableList.copyOf(_sequence);
        }

        public ContinuedFraction(long ... items) {
            ArrayList<BigInteger> _sequence = new ArrayList<BigInteger>();
            int count = 0;
            for (long item : items) {
                if (count != 0 && item < 0L) {
                    throw new IllegalArgumentException("Only first item can be negative");
                }
                _sequence.add(BigInteger.valueOf(item));
                ++count;
            }
            this.sequence = ImmutableList.copyOf(_sequence);
        }

        public Rational toRational(List<Rational> intermediates) {
            if (intermediates != null) {
                intermediates.clear();
            }
            BigInteger h0 = BigInteger.ZERO;
            BigInteger h1 = BigInteger.ONE;
            BigInteger k0 = BigInteger.ONE;
            BigInteger k1 = BigInteger.ZERO;
            for (BigInteger item : this.sequence) {
                BigInteger h2 = item.multiply(h1).add(h0);
                BigInteger k2 = item.multiply(k1).add(k0);
                if (intermediates != null) {
                    intermediates.add(Rational.of(h2, k2));
                }
                h0 = h1;
                h1 = h2;
                k0 = k1;
                k1 = k2;
            }
            if (intermediates != null) {
                Rational last = intermediates.get(intermediates.size() - 1);
                intermediates.remove(intermediates.size() - 1);
                return last;
            }
            return Rational.of(h1, k1);
        }

        public String toString() {
            return this.sequence.toString();
        }

        public boolean equals(Object obj) {
            return this.sequence.equals(((ContinuedFraction)obj).sequence);
        }

        public int hashCode() {
            return this.sequence.hashCode();
        }
    }

    public static class MutableLong {
        public long value;

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FormatStyle {
        plain,
        simple,
        repeating,
        html;

    }

    public static class RationalParser
    implements Freezable<RationalParser> {
        public static RationalParser BASIC = new RationalParser().freeze();
        private static Splitter slashSplitter = Splitter.on('/').trimResults();
        private static Splitter starSplitter = Splitter.on('*').trimResults();
        private Map<String, Rational> constants = new LinkedHashMap<String, Rational>();
        private Map<String, String> constantStatus = new LinkedHashMap<String, String>();
        static final UnicodeSet ALLOWED_CHARS = new UnicodeSet("[-A-Za-z0-9_]").add(729).freeze();
        boolean frozen = false;

        public RationalParser addConstant(String id, String value, String status) {
            if (this.constants.put(id, this.parse(value)) != null) {
                throw new IllegalArgumentException("Can't reset constant " + id + " = " + value);
            }
            if (status != null) {
                this.constantStatus.put(id, status);
            }
            return this;
        }

        public Rational parse(String input) {
            switch (input) {
                case "NaN": {
                    return NaN;
                }
                case "INF": {
                    return INFINITY;
                }
                case "-INF": {
                    return NEGATIVE_INFINITY;
                }
            }
            List<String> comps = slashSplitter.splitToList(input.replace(",", ""));
            try {
                switch (comps.size()) {
                    case 1: {
                        return this.process(comps.get(0));
                    }
                    case 2: {
                        return this.process(comps.get(0)).divide(this.process(comps.get(1)));
                    }
                }
                throw new IllegalArgumentException("too many slashes in " + input);
            }
            catch (Exception e) {
                throw new ICUException("bad input: " + input, e);
            }
        }

        private Rational process(String string) {
            Rational result = null;
            for (String comp : starSplitter.split(string)) {
                Rational ratComp = this.process2(comp);
                result = result == null ? ratComp : result.multiply(ratComp);
            }
            return result;
        }

        private Rational process2(String input) {
            char firstChar = input.charAt(0);
            if (firstChar == '-' || firstChar >= '0' && firstChar <= '9') {
                int pos = input.indexOf(729);
                if (pos < 0) {
                    return Rational.of(new BigDecimal(input));
                }
                String reptend = input.substring(pos + 1);
                int rlen = reptend.length();
                input = input.substring(0, pos) + reptend;
                BigDecimal rf = new BigDecimal(input);
                BigDecimal rfPow = new BigDecimal(input + reptend).scaleByPowerOfTen(rlen);
                BigDecimal num = rfPow.subtract(rf);
                Rational result = Rational.of(num);
                Rational den = Rational.of(BigDecimal.ONE.scaleByPowerOfTen(rlen).subtract(BigDecimal.ONE));
                return result.divide(den);
            }
            if (!ALLOWED_CHARS.containsAll(input)) {
                throw new IllegalArgumentException("Bad characters in: " + input);
            }
            Rational result = this.constants.get(input);
            if (result == null) {
                throw new IllegalArgumentException("Constant not defined: " + input);
            }
            return result;
        }

        @Override
        public boolean isFrozen() {
            return this.frozen;
        }

        @Override
        public RationalParser freeze() {
            if (!this.frozen) {
                this.frozen = true;
                this.constants = ImmutableMap.copyOf(this.constants);
                this.constantStatus = ImmutableMap.copyOf(this.constantStatus);
            }
            return this;
        }

        @Override
        public RationalParser cloneAsThawed() {
            throw new UnsupportedOperationException();
        }

        public Map<String, Rational> getConstants() {
            return this.constants;
        }
    }
}

