/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.IOException;
import java.io.Reader;

public class SimpleHtmlParser {
    private Reader input;
    private State state;
    private Type bufferedReturn;
    private int lineCount;

    public SimpleHtmlParser setReader(Reader input) {
        this.input = input;
        this.state = State.IN_CONTENT;
        this.bufferedReturn = null;
        this.lineCount = 0;
        return this;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public Type next(StringBuilder result) throws IOException {
        result.setLength(0);
        if (this.bufferedReturn != null) {
            if (this.bufferedReturn == Type.DONE) {
                return Type.DONE;
            }
            Type temp = this.bufferedReturn;
            this.bufferedReturn = null;
            return temp;
        }
        block11: while (true) {
            char ch;
            int chi;
            if ((chi = this.input.read()) < 0) {
                this.bufferedReturn = Type.DONE;
                chi = 0;
            }
            if ((ch = (char)chi) == '\n') {
                ++this.lineCount;
            }
            switch (this.state) {
                case BASE: {
                    if (ch == '\ufeff') continue block11;
                }
                case IN_CONTENT: {
                    if (ch == '<') {
                        this.state = State.IN_ELEMENT;
                        this.bufferedReturn = Type.ELEMENT_START;
                        return Type.ELEMENT_CONTENT;
                    }
                    if (ch == '\u0000') {
                        return Type.ELEMENT_CONTENT;
                    }
                    result.append(ch);
                    break;
                }
                case IN_ELEMENT: {
                    if (ch <= ' ') {
                        if (SimpleHtmlParser.equals(result, "!--")) {
                            this.state = State.IN_QUOTE;
                            result.setLength(0);
                            break;
                        }
                        this.state = State.AFTER_ELEMENT;
                        return Type.ELEMENT;
                    }
                    if (ch == '>') {
                        this.state = State.IN_CONTENT;
                        this.bufferedReturn = Type.ELEMENT_END;
                        return Type.ELEMENT;
                    }
                    if (ch == '/') {
                        return Type.ELEMENT_POP;
                    }
                    result.append(ch);
                    break;
                }
                case AFTER_ELEMENT: {
                    if (ch <= ' ') continue block11;
                    if (ch == '>') {
                        this.state = State.IN_CONTENT;
                        return Type.ELEMENT_END;
                    }
                    result.append(ch);
                    this.state = State.IN_ATTRIBUTE;
                    break;
                }
                case IN_ATTRIBUTE: {
                    if (ch <= ' ') {
                        this.state = State.AFTER_ELEMENT;
                        return Type.ATTRIBUTE;
                    }
                    if (ch == '>') {
                        this.state = State.IN_CONTENT;
                        this.bufferedReturn = Type.ELEMENT_END;
                        return Type.ATTRIBUTE;
                    }
                    if (ch == '=') {
                        this.state = State.IN_ATTRIBUTE_CONTENT;
                        return Type.ATTRIBUTE;
                    }
                    result.append(ch);
                    break;
                }
                case IN_ATTRIBUTE_CONTENT: {
                    if (ch <= ' ') continue block11;
                    if (ch == '>') {
                        this.state = State.IN_CONTENT;
                        this.bufferedReturn = Type.ELEMENT_END;
                        return Type.ATTRIBUTE_CONTENT;
                    }
                    if (ch == '\'') {
                        this.state = State.IN_ATTRIBUTE_CONTENT1;
                        break;
                    }
                    if (ch == '\"') {
                        this.state = State.IN_ATTRIBUTE_CONTENT2;
                        break;
                    }
                    result.append(ch);
                    break;
                }
                case IN_ATTRIBUTE_CONTENT1: {
                    if (ch == '\u0000' || ch == '\'') {
                        this.state = State.AFTER_ELEMENT;
                        return Type.ATTRIBUTE_CONTENT;
                    }
                    result.append(ch);
                    break;
                }
                case IN_ATTRIBUTE_CONTENT2: {
                    if (ch == '\u0000' || ch == '\"') {
                        this.state = State.AFTER_ELEMENT;
                        return Type.ATTRIBUTE_CONTENT;
                    }
                    result.append(ch);
                    break;
                }
                case IN_QUOTE: {
                    if (ch == '\u0000') {
                        this.state = State.IN_CONTENT;
                        return Type.QUOTE;
                    }
                    if (ch == '>' && SimpleHtmlParser.endsWith(result, "--")) {
                        result.setLength(result.length() - 2);
                        this.state = State.IN_CONTENT;
                        return Type.QUOTE;
                    }
                    result.append(ch);
                    break;
                }
            }
        }
    }

    public static final boolean endsWith(CharSequence a, CharSequence b) {
        int aStart = a.length() - b.length();
        if (aStart < 0) {
            return false;
        }
        return SimpleHtmlParser.regionEquals(a, aStart, b, 0, b.length());
    }

    public static final boolean equals(CharSequence a, CharSequence b) {
        int len = a.length();
        if (len != b.length()) {
            return false;
        }
        return SimpleHtmlParser.regionEquals(a, 0, b, 0, len);
    }

    public static boolean regionEquals(CharSequence a, int i, CharSequence b, int j, int len) {
        while (--len >= 0) {
            if (a.charAt(i) != b.charAt(j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static void writeResult(Type type, StringBuilder result, Appendable writer) throws IOException {
        switch (type) {
            case ELEMENT: {
                writer.append(result);
                break;
            }
            case ELEMENT_START: {
                writer.append('<');
                break;
            }
            case ELEMENT_END: {
                writer.append('>');
                break;
            }
            case ATTRIBUTE: {
                writer.append(' ').append(result);
                break;
            }
            case ATTRIBUTE_CONTENT: {
                writer.append("=\"").append(result).append('\"');
                break;
            }
            case ELEMENT_CONTENT: {
                writer.append(result);
                break;
            }
            case ELEMENT_POP: {
                writer.append('/');
                break;
            }
            case QUOTE: {
                writer.append(result);
                break;
            }
            case DONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Missing case: " + (Object)((Object)type));
            }
        }
    }

    private static enum State {
        BASE,
        IN_ELEMENT,
        AFTER_ELEMENT,
        IN_CONTENT,
        IN_ATTRIBUTE,
        IN_ATTRIBUTE_CONTENT,
        IN_ATTRIBUTE_CONTENT1,
        IN_ATTRIBUTE_CONTENT2,
        ELEMENT_STOP,
        IN_QUOTE;

    }

    public static enum Type {
        DONE,
        ELEMENT_START,
        ELEMENT,
        ATTRIBUTE,
        ATTRIBUTE_CONTENT,
        ELEMENT_END,
        ELEMENT_POP,
        QUOTE,
        ELEMENT_CONTENT;

    }
}

