/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.unicode.cldr.util.CLDRTool;

@CLDRTool(alias="test.stacktracker", description="Test for StackTracker", hidden="test")
public class StackTracker
implements Iterable<Object> {
    private Hashtable<Object, String> stacks = new Hashtable();

    public void add(Object o) {
        String stack = StackTracker.currentStack();
        this.stacks.put(o, stack);
    }

    public void remove(Object o) {
        this.stacks.remove(o);
    }

    public static String stackToString(StackTraceElement[] stackTrace, int skip) {
        StringBuffer sb = new StringBuffer();
        for (int i = skip; i < stackTrace.length; ++i) {
            sb.append(stackTrace[i].toString() + "\n");
        }
        return sb.toString();
    }

    public String toString() {
        if (this.stacks.isEmpty()) {
            return "{StackTracker: empty}";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{StackTracker:\n");
        int n = 0;
        for (Map.Entry<Object, String> e : this.stacks.entrySet()) {
            sb.append("Held Obj #" + ++n + "/" + this.stacks.size() + ": " + e.getKey() + "\n");
            sb.append(e.getValue() + "\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public void clear() {
        this.stacks.clear();
    }

    public static String currentStack() {
        return StackTracker.stackToString(Thread.currentThread().getStackTrace(), 2);
    }

    public static StackTraceElement currentElement(int skip) {
        return Thread.currentThread().getStackTrace()[3 + skip];
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.stacks.keySet().iterator();
    }

    public static void main(String[] args) {
        StackTracker tracker = new StackTracker();
        System.out.println("At first: " + tracker);
        tracker.add("Now");
        tracker.add("is");
        tracker.add("the");
        tracker.add("time");
        tracker.add("for");
        tracker.add("time");
        tracker.remove("Now");
        tracker.remove("for");
        tracker.remove("time");
        System.out.println("At end: " + tracker);
    }
}

