/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.BasicTimeZone;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.TimeZoneTransition;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class TimezoneFormatter
extends UFormat {
    private static final long serialVersionUID = -506645087792499122L;
    private static final long TIME = new Date().getTime();
    public static boolean SHOW_DRAFT = false;
    private static SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
    private transient SimpleDateFormat hourFormatPlus = new SimpleDateFormat();
    private transient SimpleDateFormat hourFormatMinus = new SimpleDateFormat();
    private transient MessageFormat gmtFormat;
    private transient MessageFormat regionFormat;
    private transient MessageFormat regionFormatStandard;
    private transient MessageFormat regionFormatDaylight;
    private transient MessageFormat fallbackFormat;
    private transient Set<String> singleCountriesSet;
    private transient Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private transient SimpleDateFormat rfc822Plus = new SimpleDateFormat("+HHmm");
    private transient SimpleDateFormat rfc822Minus = new SimpleDateFormat("-HHmm");
    private CLDRFile desiredLocaleFile;
    private String inputLocaleID;
    private boolean skipDraft;
    private static final int WALL_LIMIT = 2;
    private static final int STANDARD_LIMIT = 4;
    private static final String[] zoneTypes = new String[]{"\"]/long/generic", "\"]/short/generic", "\"]/long/standard", "\"]/short/standard", "\"]/long/daylight", "\"]/short/daylight"};
    private transient Matcher m;
    private transient boolean parseInfoBuilt;
    private final transient Map<String, String> localizedCountry_countryCode;
    private final transient Map<String, String> exemplar_zone;
    private final transient Map<Object, Object> localizedExplicit_zone;
    private final transient Map<String, String> country_zone;
    public static final List<String> LENGTH = Arrays.asList(Length.SHORT.toString(), Length.LONG.toString());
    public static final int LENGTH_LIMIT = LENGTH.size();
    public static final int TYPE_LIMIT = Type.values().length;

    public TimezoneFormatter(Factory cldrFactory, String localeID, boolean includeDraft) {
        this(cldrFactory.make(localeID, true, includeDraft));
    }

    public TimezoneFormatter(Factory cldrFactory, String localeID, CLDRFile.DraftStatus minimalDraftStatus) {
        this(cldrFactory.make(localeID, true, minimalDraftStatus));
    }

    public TimezoneFormatter(CLDRFile resolvedLocaleFile) {
        XPathParts xpp;
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        this.rfc822Plus.setTimeZone(gmt);
        this.rfc822Minus.setTimeZone(gmt);
        this.m = PatternCache.get("([-+])([0-9][0-9])([0-9][0-9])").matcher("");
        this.localizedCountry_countryCode = new HashMap<String, String>();
        this.exemplar_zone = new HashMap<String, String>();
        this.localizedExplicit_zone = new HashMap<Object, Object>();
        this.country_zone = new HashMap<String, String>();
        this.desiredLocaleFile = resolvedLocaleFile;
        this.inputLocaleID = this.desiredLocaleFile.getLocaleID();
        String hourFormatString = this.getStringValue("//ldml/dates/timeZoneNames/hourFormat");
        String[] hourFormatStrings = CldrUtility.splitArray(hourFormatString, ';');
        ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder().setCldrFile(this.desiredLocaleFile);
        this.hourFormatPlus = icuServiceBuilder.getDateFormat("gregorian", 0, 1);
        this.hourFormatPlus.applyPattern(hourFormatStrings[0]);
        this.hourFormatMinus = icuServiceBuilder.getDateFormat("gregorian", 0, 1);
        this.hourFormatMinus.applyPattern(hourFormatStrings[1]);
        this.gmtFormat = new MessageFormat(this.getStringValue("//ldml/dates/timeZoneNames/gmtFormat"));
        this.regionFormat = new MessageFormat(this.getStringValue("//ldml/dates/timeZoneNames/regionFormat"));
        this.regionFormatStandard = new MessageFormat(this.getStringValue("//ldml/dates/timeZoneNames/regionFormat[@type=\"standard\"]"));
        this.regionFormatDaylight = new MessageFormat(this.getStringValue("//ldml/dates/timeZoneNames/regionFormat[@type=\"daylight\"]"));
        this.fallbackFormat = new MessageFormat(this.getStringValue("//ldml/dates/timeZoneNames/fallbackFormat"));
        this.checkForDraft("//ldml/dates/timeZoneNames/singleCountries");
        String singleCountriesList = "Africa/Bamako America/Godthab America/Santiago America/Guayaquil Asia/Shanghai Asia/Tashkent Asia/Kuala_Lumpur Europe/Madrid Europe/Lisbon Europe/London Pacific/Auckland Pacific/Tahiti";
        String temp = this.desiredLocaleFile.getFullXPath("//ldml/dates/timeZoneNames/singleCountries");
        if (temp != null && (temp = (xpp = XPathParts.getFrozenInstance(temp)).findAttributeValue("singleCountries", "list")) != null) {
            singleCountriesList = temp;
        }
        this.singleCountriesSet = new TreeSet<String>(CldrUtility.splitList(singleCountriesList, ' '));
    }

    private String getStringValue(String cleanPath) {
        this.checkForDraft(cleanPath);
        return this.desiredLocaleFile.getWinningValue(cleanPath);
    }

    private String getName(int territory_name, String country, boolean skipDraft2) {
        this.checkForDraft(CLDRFile.getKey(territory_name, country));
        return this.desiredLocaleFile.getName(territory_name, country);
    }

    private void checkForDraft(String cleanPath) {
        String xpath = this.desiredLocaleFile.getFullXPath(cleanPath);
        if (SHOW_DRAFT && xpath != null && xpath.indexOf("[@draft=\"true\"]") >= 0) {
            System.out.println("Draft in " + this.inputLocaleID + ":\t" + cleanPath);
        }
    }

    public String getFormattedZone(String zoneid, String pattern, long date) {
        Format format = Format.valueOf(pattern);
        return this.getFormattedZone(zoneid, format.location, format.type, format.length, date);
    }

    public String getFormattedZone(String inputZoneid, Location location, Type type, Length length, long date) {
        String zoneid = TimeZone.getCanonicalID(inputZoneid);
        BasicTimeZone timeZone = (BasicTimeZone)TimeZone.getTimeZone(zoneid);
        int gmtOffset1 = timeZone.getOffset(date);
        SupplementalDataInfo.MetaZoneRange metaZoneRange = sdi.getMetaZoneRange(zoneid, date);
        String metazone = metaZoneRange == null ? "?" : metaZoneRange.metazone;
        boolean noTimezoneChangeWithin184Days = this.noTimezoneChangeWithin184Days(timeZone, date);
        boolean daylight = gmtOffset1 != timeZone.getRawOffset();
        return this.getFormattedZone(inputZoneid, location, type, length, daylight, gmtOffset1, metazone, noTimezoneChangeWithin184Days);
    }

    public String getFormattedZone(String inputZoneid, Location location, Type type, Length length, boolean daylight, int gmtOffset1, String metazone, boolean noTimezoneChangeWithin184Days) {
        String formatted = this.getFormattedZoneInternal(inputZoneid, location, type, length, daylight, gmtOffset1, metazone, noTimezoneChangeWithin184Days);
        if (formatted != null) {
            return formatted;
        }
        if (type == Type.GENERIC && location == Location.NON_LOCATION && (formatted = this.getFormattedZone(inputZoneid, Location.LOCATION, type, length, daylight, gmtOffset1, metazone, noTimezoneChangeWithin184Days)) != null) {
            return formatted;
        }
        return this.getFormattedZone(inputZoneid, Location.GMT, null, Length.LONG, daylight, gmtOffset1, metazone, noTimezoneChangeWithin184Days);
    }

    private String getFormattedZoneInternal(String inputZoneid, Location location, Type type, Length length, boolean daylight, int gmtOffset1, String metazone, boolean noTimezoneChangeWithin184Days) {
        String zoneid = TimeZone.getCanonicalID(inputZoneid);
        switch (location) {
            default: {
                throw new IllegalArgumentException("Bad enum value for location: " + (Object)((Object)location));
            }
            case GMT: {
                if (length == Length.SHORT) {
                    return gmtOffset1 < 0 ? this.rfc822Minus.format(new Date(-gmtOffset1)) : this.rfc822Plus.format(new Date(gmtOffset1));
                }
                SimpleDateFormat format = gmtOffset1 < 0 ? this.hourFormatMinus : this.hourFormatPlus;
                this.calendar.setTimeInMillis(Math.abs(gmtOffset1));
                String result = format.format(this.calendar);
                return this.gmtFormat.format(new Object[]{result});
            }
            case NON_LOCATION: {
                String metaZoneName;
                String formatValue = this.getLocalizedExplicitTzid(zoneid, type, length, daylight);
                if (formatValue != null) {
                    return formatValue;
                }
                if (metazone == null) {
                    metazone = TimezoneFormatter.sdi.getMetaZoneRange((String)zoneid, (long)TimezoneFormatter.TIME).metazone;
                }
                if ((metaZoneName = this.getLocalizedMetazone(metazone, type, length, daylight)) == null && noTimezoneChangeWithin184Days) {
                    metaZoneName = this.getLocalizedMetazone(metazone, Type.SPECIFIC, length, false);
                }
                if (metaZoneName != null) {
                    String localeMax;
                    LanguageTagParser languageTagParser = new LanguageTagParser();
                    String localeId = this.desiredLocaleFile.getLocaleID();
                    String defaultRegion = languageTagParser.set(localeId).getRegion();
                    if (defaultRegion.isEmpty() && (defaultRegion = languageTagParser.set(localeMax = LikelySubtags.maximize(localeId, sdi.getLikelySubtags())).getRegion()).isEmpty()) {
                        return "001";
                    }
                    Map<String, String> regionToZone = sdi.getMetazoneToRegionToZone().get(metazone);
                    String preferredLocalesZone = regionToZone.get(defaultRegion);
                    if (preferredLocalesZone == null) {
                        preferredLocalesZone = regionToZone.get("001");
                    }
                    if (zoneid.equals(preferredLocalesZone)) {
                        return metaZoneName;
                    }
                    String zoneIdsCountry = TimeZone.getRegion(zoneid);
                    String preferredZonesCountrysZone = regionToZone.get(zoneIdsCountry);
                    if (preferredZonesCountrysZone == null) {
                        preferredZonesCountrysZone = regionToZone.get("001");
                    }
                    if (zoneid.equals(preferredZonesCountrysZone)) {
                        String countryName = this.getLocalizedCountryName(zoneIdsCountry);
                        return this.fallbackFormat.format(new Object[]{countryName, metaZoneName});
                    }
                    String cityName = this.getLocalizedExemplarCity(zoneid);
                    return this.fallbackFormat.format(new Object[]{cityName, metaZoneName});
                }
                if (length == Length.LONG) {
                    return this.getRegionFallback(zoneid, type == Type.GENERIC || noTimezoneChangeWithin184Days ? this.regionFormat : (daylight ? this.regionFormatDaylight : this.regionFormatStandard));
                }
                return null;
            }
            case LOCATION: 
        }
        return this.getRegionFallback(zoneid, this.regionFormat);
    }

    private String getRegionFallback(String zoneid, MessageFormat regionFallbackFormat) {
        String[] zonesInRegion;
        String zoneIdsCountry = TimeZone.getRegion(zoneid);
        if (zoneIdsCountry != null && ((zonesInRegion = TimeZone.getAvailableIDs(zoneIdsCountry)) != null && zonesInRegion.length == 1 || this.singleCountriesSet.contains(zoneid))) {
            String countryName = this.getLocalizedCountryName(zoneIdsCountry);
            return regionFallbackFormat.format(new Object[]{countryName});
        }
        String cityName = this.getLocalizedExemplarCity(zoneid);
        return regionFallbackFormat.format(new Object[]{cityName});
    }

    public boolean noTimezoneChangeWithin184Days(BasicTimeZone timeZone, long date) {
        TimeZoneTransition startTransition = timeZone.getPreviousTransition(date, true);
        if (startTransition == null) {
            return true;
        }
        if (!this.atLeast184Days(startTransition.getTime(), date)) {
            return false;
        }
        TimeZoneTransition nextTransition = timeZone.getNextTransition(date, false);
        return nextTransition == null || this.atLeast184Days(date, nextTransition.getTime());
    }

    private boolean atLeast184Days(long start, long end) {
        long transitionDays = (end - start) / 86400000L;
        return transitionDays >= 184L;
    }

    private String getLocalizedExplicitTzid(String zoneid, Type type, Length length, boolean daylight) {
        String formatValue = this.desiredLocaleFile.getWinningValue("//ldml/dates/timeZoneNames/zone[@type=\"" + zoneid + "\"]/" + length.toString() + "/" + type.toString(daylight));
        return formatValue;
    }

    public String getLocalizedMetazone(String metazone, Type type, Length length, boolean daylight) {
        if (metazone == null) {
            return null;
        }
        String name = this.desiredLocaleFile.getWinningValue("//ldml/dates/timeZoneNames/metazone[@type=\"" + metazone + "\"]/" + length.toString() + "/" + type.toString(daylight));
        return name;
    }

    private String getLocalizedCountryName(String zoneIdsCountry) {
        String countryName = this.desiredLocaleFile.getName(2, zoneIdsCountry);
        if (countryName == null) {
            countryName = zoneIdsCountry;
        }
        return countryName;
    }

    public String getLocalizedExemplarCity(String timezoneString) {
        String exemplarCity = this.desiredLocaleFile.getWinningValue("//ldml/dates/timeZoneNames/zone[@type=\"" + timezoneString + "\"]/exemplarCity");
        if (exemplarCity == null) {
            exemplarCity = timezoneString.substring(timezoneString.lastIndexOf(47) + 1).replace('_', ' ');
        }
        return exemplarCity;
    }

    public String parse(String inputText, ParsePosition parsePosition) {
        long[] offsetMillisOutput = new long[1];
        String result = this.parse(inputText, parsePosition, offsetMillisOutput);
        if (result == null || result.length() != 0) {
            return result;
        }
        long offsetMillis = offsetMillisOutput[0];
        String sign = "Etc/GMT-";
        if (offsetMillis < 0L) {
            offsetMillis = -offsetMillis;
            sign = "Etc/GMT+";
        }
        long minutes = (offsetMillis + 30000L) / 60000L;
        long hours = minutes / 60L;
        result = sign + String.valueOf(hours);
        if ((minutes %= 60L) != 0L) {
            result = result + ":" + String.valueOf(100L + minutes).substring(1, 3);
        }
        return result;
    }

    public String parse(String inputText, ParsePosition parsePosition, long[] offsetMillis) {
        if (!this.parseInfoBuilt) {
            this.buildParsingInfo();
        }
        int startOffset = parsePosition.getIndex();
        Object result = this.localizedExplicit_zone.get(inputText);
        if (result != null) {
            if (result instanceof String) {
                return (String)result;
            }
            offsetMillis[0] = (Long)result;
            return "";
        }
        if (this.m.reset(inputText).matches()) {
            int hours = Integer.parseInt(this.m.group(2));
            int minutes = Integer.parseInt(this.m.group(3));
            int millis = hours * 60 * 60 * 1000 + minutes * 60 * 1000;
            if (this.m.group(1).equals("-")) {
                millis = -millis;
            }
            offsetMillis[0] = millis;
            return "";
        }
        Object[] results = this.gmtFormat.parse(inputText, parsePosition);
        if (results != null) {
            if (results.length == 0) {
                results = this.gmtFormat.parse(inputText, parsePosition);
            }
            String hours = (String)results[0];
            parsePosition.setIndex(0);
            Date date = this.hourFormatPlus.parse(hours, parsePosition);
            if (date != null) {
                offsetMillis[0] = date.getTime();
                return "";
            }
            parsePosition.setIndex(0);
            date = this.hourFormatMinus.parse(hours, parsePosition);
            if (date != null) {
                offsetMillis[0] = -date.getTime();
                return "";
            }
        }
        parsePosition.setIndex(startOffset);
        Object[] x = this.regionFormat.parse(inputText, parsePosition);
        if (x != null) {
            inputText = (String)x[0];
        }
        String city = null;
        String country = null;
        parsePosition.setIndex(startOffset);
        x = this.fallbackFormat.parse(inputText, parsePosition);
        if (x != null) {
            city = (String)x[0];
            country = (String)x[1];
            return this.exemplar_zone.get(city);
        }
        String countryCode = this.localizedCountry_countryCode.get(inputText);
        if (countryCode == null) {
            countryCode = country;
        }
        return this.country_zone.get(countryCode);
    }

    private void buildParsingInfo() {
        for (String zoneid : TimeZone.getAvailableIDs()) {
            this.exemplar_zone.put(TimezoneFormatter.getFallbackName(zoneid), zoneid);
        }
        String prefix = "//ldml/dates/timeZoneNames/zone[@type=\"";
        String countryPrefix = "//ldml/localeDisplayNames/territories/territory[@type=\"";
        HashMap<String, Object> localizedNonWall = new HashMap<String, Object>();
        HashSet<String> skipDuplicates = new HashSet<String>();
        for (String path : this.desiredLocaleFile) {
            String name;
            if (path.startsWith(prefix)) {
                String name2;
                String zoneId = this.matchesPart(path, prefix, "\"]/exemplarCity");
                if (zoneId != null && (name2 = this.desiredLocaleFile.getWinningValue(path)) != null) {
                    this.exemplar_zone.put(name2, zoneId);
                }
                for (int i = 0; i < zoneTypes.length; ++i) {
                    String name3;
                    zoneId = this.matchesPart(path, prefix, zoneTypes[i]);
                    if (zoneId == null || (name3 = this.desiredLocaleFile.getWinningValue(path)) == null) continue;
                    if (i < 2) {
                        this.localizedExplicit_zone.put(name3, zoneId);
                        continue;
                    }
                    Object dup = localizedNonWall.get(name3);
                    if (dup != null) {
                        skipDuplicates.add(name3);
                        TimeZone tz = TimeZone.getTimeZone(zoneId);
                        int offset = tz.getRawOffset();
                        if (i >= 4) {
                            offset += tz.getDSTSavings();
                        }
                        localizedNonWall.put(name3, new Long(offset));
                        continue;
                    }
                    localizedNonWall.put(name3, zoneId);
                }
                continue;
            }
            String countryCode = this.matchesPart(path, countryPrefix, "\"]");
            if (countryCode == null || (name = this.desiredLocaleFile.getStringValue(path)) == null) continue;
            this.localizedCountry_countryCode.put(name, countryCode);
        }
        for (String key : localizedNonWall.keySet()) {
            Object value = localizedNonWall.get(key);
            this.localizedExplicit_zone.put(key, value);
        }
        for (String key : StandardCodes.make().getGoodAvailableCodes("territory")) {
            String[] tzids = TimeZone.getAvailableIDs(key);
            if (tzids == null || tzids.length == 0) continue;
            if (tzids.length == 1) {
                this.country_zone.put(key, tzids[0]);
                continue;
            }
            LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(tzids));
            set.retainAll(this.singleCountriesSet);
            if (set.size() != 1) continue;
            this.country_zone.put(key, (String)set.iterator().next());
        }
        this.parseInfoBuilt = true;
    }

    private String matchesPart(String input, String prefix, String suffix) {
        if (!input.startsWith(prefix)) {
            return null;
        }
        if (!input.endsWith(suffix)) {
            return null;
        }
        return input.substring(prefix.length(), input.length() - suffix.length());
    }

    public static String getFallbackName(String zoneid) {
        int pos = zoneid.lastIndexOf(47);
        String result = pos < 0 ? zoneid : zoneid.substring(pos + 1);
        result = result.replace('_', ' ');
        return result;
    }

    public boolean isSkipDraft() {
        return this.skipDraft;
    }

    public TimezoneFormatter setSkipDraft(boolean skipDraft) {
        this.skipDraft = skipDraft;
        return this;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return null;
    }

    public String getFormattedZone(String zoneId, String pattern, boolean daylight, int offset, boolean b) {
        Format format = Format.valueOf(pattern);
        return this.getFormattedZone(zoneId, format.location, format.type, format.length, daylight, offset, null, false);
    }

    public String getFormattedZone(String zoneId, int length, int type, int offset, boolean b) {
        return this.getFormattedZone(zoneId, Location.LOCATION, Type.values()[type], Length.values()[length], false, offset, null, true);
    }

    public String getFormattedZone(String zoneId, String pattern, long time, boolean b) {
        return this.getFormattedZone(zoneId, pattern, time);
    }

    public static enum Format {
        VVVV(Type.GENERIC, Location.LOCATION, Length.OTHER),
        vvvv(Type.GENERIC, Location.NON_LOCATION, Length.LONG),
        v(Type.GENERIC, Location.NON_LOCATION, Length.SHORT),
        zzzz(Type.SPECIFIC, Location.NON_LOCATION, Length.LONG),
        z(Type.SPECIFIC, Location.NON_LOCATION, Length.SHORT),
        ZZZZ(Type.GENERIC, Location.GMT, Length.LONG),
        Z(Type.GENERIC, Location.GMT, Length.SHORT),
        ZZZZZ(Type.GENERIC, Location.GMT, Length.OTHER);

        final Type type;
        final Location location;
        final Length length;

        private Format(Type type, Location location, Length length) {
            this.type = type;
            this.location = location;
            this.length = length;
        }
    }

    public static enum Length {
        SHORT,
        LONG,
        OTHER;


        public String toString() {
            return this == SHORT ? "short" : (this == LONG ? "long" : "other");
        }
    }

    public static enum Type {
        GENERIC,
        SPECIFIC;


        public String toString(boolean daylight) {
            return this == GENERIC ? "generic" : (daylight ? "daylight" : "standard");
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum Location {
        GMT,
        LOCATION,
        NON_LOCATION;


        public String toString() {
            return this == GMT ? "gmt" : (this == LOCATION ? "location" : "non-location");
        }
    }
}

