/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.GrammarDerivation;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.LocaleStringProvider;
import org.unicode.cldr.util.MapComparator;
import org.unicode.cldr.util.Rational;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnitPathType;
import org.unicode.cldr.util.Units;
import org.unicode.cldr.util.Validity;

public class UnitConverter
implements Freezable<UnitConverter> {
    public static boolean DEBUG = false;
    public static final Integer INTEGER_ONE = 1;
    static final Splitter BAR_SPLITTER = Splitter.on('-');
    static final Splitter SPACE_SPLITTER = Splitter.on(' ').trimResults().omitEmptyStrings();
    public static final Set<String> HACK_SKIP_UNIT_NAMES = ImmutableSet.of("dot-per-centimeter", "dot-per-inch", "liter-per-100-kilometer", "millimeter-ofhg", "inch-ofhg");
    final Rational.RationalParser rationalParser;
    private Map<String, String> baseUnitToQuantity = new LinkedHashMap<String, String>();
    private Map<String, String> baseUnitToStatus = new LinkedHashMap<String, String>();
    private Map<String, TargetInfo> sourceToTargetInfo = new LinkedHashMap<String, TargetInfo>();
    private Map<String, String> sourceToStandard;
    private Multimap<String, String> quantityToSimpleUnits = LinkedHashMultimap.create();
    private Multimap<String, String> sourceToSystems = LinkedHashMultimap.create();
    private Set<String> baseUnits;
    private Multimap<String, Continuation> continuations = TreeMultimap.create();
    private Comparator<String> quantityComparator;
    private Map<String, String> fixDenormalized;
    private ImmutableMap<String, UnitId> idToUnitId;
    public final BiMap<String, String> SHORT_TO_LONG_ID = Units.LONG_TO_SHORT.inverse();
    private boolean frozen = false;
    public TargetInfoComparator targetInfoComparator;
    public static final Set<String> BASE_UNITS = ImmutableSet.of("candela", "kilogram", "meter", "second", "ampere", "kelvin", new String[]{"year", "bit", "item", "pixel", "em", "revolution", "portion"});
    public static final Set<String> BASE_UNIT_PARTS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("per")).add("square")).add("cubic")).addAll(BASE_UNITS)).build();
    public static final Pattern PLACEHOLDER = Pattern.compile("[ \\u00A0\\u200E\\u200F\\u202F]*\\{0\\}[ \\u00A0\\u200E\\u200F\\u202F]*");
    public static final boolean HACK = true;
    Comparator<String> UNIT_COMPARATOR = new UnitComparator();
    private ConcurrentHashMap<String, UnitId> UNIT_ID = new ConcurrentHashMap();
    public static final ImmutableMap<String, Integer> PREFIX_POWERS = ImmutableMap.builder().put("yocto", -24).put("zepto", -21).put("atto", -18).put("femto", -15).put("pico", -12).put("nano", -9).put("micro", -6).put("milli", -3).put("centi", -2).put("deci", -1).put("deka", 1).put("hecto", 2).put("kilo", 3).put("mega", 6).put("giga", 9).put("tera", 12).put("peta", 15).put("exa", 18).put("zetta", 21).put("yotta", 24).build();
    public static final ImmutableMap<String, Rational> PREFIXES;
    static final Set<String> SKIP_PREFIX;
    static final Rational RATIONAL1000;
    private ConcurrentHashMap<String, UnitComplexity> COMPLEXITY = new ConcurrentHashMap();

    public void addQuantityInfo(String baseUnit, String quantity, String status) {
        if (this.baseUnitToQuantity.containsKey(baseUnit)) {
            throw new IllegalArgumentException();
        }
        this.baseUnitToQuantity.put(baseUnit, quantity);
        if (status != null) {
            this.baseUnitToStatus.put(baseUnit, status);
        }
        this.quantityToSimpleUnits.put(quantity, baseUnit);
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public UnitConverter freeze() {
        if (!this.frozen) {
            this.frozen = true;
            this.rationalParser.freeze();
            this.sourceToTargetInfo = ImmutableMap.copyOf(this.sourceToTargetInfo);
            this.sourceToStandard = this.buildSourceToStandard();
            this.quantityToSimpleUnits = ImmutableMultimap.copyOf(this.quantityToSimpleUnits);
            this.quantityComparator = this.getQuantityComparator(this.baseUnitToQuantity, this.baseUnitToStatus);
            this.sourceToSystems = ImmutableMultimap.copyOf(this.sourceToSystems);
            ImmutableCollection.Builder builder = ImmutableSet.builder().addAll(BASE_UNITS);
            for (TargetInfo s2 : this.sourceToTargetInfo.values()) {
                ((ImmutableSet.Builder)builder).add(s2.target);
            }
            this.baseUnits = ((ImmutableSet.Builder)builder).build();
            this.continuations = ImmutableMultimap.copyOf(this.continuations);
            this.targetInfoComparator = new TargetInfoComparator();
            TreeMap<String, UnitId> _idToUnitId = new TreeMap<String, UnitId>();
            for (Map.Entry shortAndLongId : this.SHORT_TO_LONG_ID.entrySet()) {
                String unitPart;
                String shortId = (String)shortAndLongId.getKey();
                String longId = (String)shortAndLongId.getKey();
                UnitId uid = this.createUnitId(shortId).freeze();
                boolean doTest = false;
                Output<Rational> deprefix = new Output<Rational>();
                for (Map.Entry<String, Integer> entry : uid.numUnitsToPowers.entrySet()) {
                    unitPart = entry.getKey();
                    UnitConverter.stripPrefix(unitPart, deprefix);
                    if (((Rational)deprefix.value).equals(Rational.ONE) && entry.getValue().equals(INTEGER_ONE)) continue;
                    doTest = true;
                    break;
                }
                if (!doTest) {
                    for (Map.Entry<String, Integer> entry : uid.denUnitsToPowers.entrySet()) {
                        unitPart = entry.getKey();
                        UnitConverter.stripPrefix(unitPart, deprefix);
                        if (((Rational)deprefix.value).equals(Rational.ONE)) continue;
                        doTest = true;
                        break;
                    }
                }
                if (!doTest) continue;
                _idToUnitId.put(shortId, uid);
                _idToUnitId.put(longId, uid);
            }
            this.idToUnitId = ImmutableMap.copyOf(_idToUnitId);
        }
        return this;
    }

    private Map<String, String> buildSourceToStandard() {
        TreeMap<String, String> unitToStandard = new TreeMap<String, String>();
        for (Map.Entry<String, TargetInfo> entry : this.sourceToTargetInfo.entrySet()) {
            String source = entry.getKey();
            TargetInfo targetInfo = entry.getValue();
            if (!targetInfo.unitInfo.factor.equals(Rational.ONE) || !targetInfo.unitInfo.offset.equals(Rational.ZERO)) continue;
            String target = targetInfo.target;
            String old = (String)unitToStandard.get(target);
            if (old == null) {
                unitToStandard.put(target, source);
                if (!DEBUG) continue;
                System.out.println(target + " \u27f9 " + source);
                continue;
            }
            if (old.length() > source.length()) {
                unitToStandard.put(target, source);
                if (!DEBUG) continue;
                System.out.println("TWO STANDARDS: " + target + " \u27f9 " + source + "; was " + old);
                continue;
            }
            if (!DEBUG) continue;
            System.out.println("TWO STANDARDS: " + target + " \u27f9 " + old + ", was " + source);
        }
        return ImmutableMap.copyOf(unitToStandard);
    }

    @Override
    public UnitConverter cloneAsThawed() {
        throw new UnsupportedOperationException();
    }

    public UnitConverter(Rational.RationalParser rationalParser, Validity validity) {
        this.rationalParser = rationalParser;
    }

    public void addRaw(String source, String target, String factor, String offset, String systems) {
        ConversionInfo info = new ConversionInfo(factor == null ? Rational.ONE : this.rationalParser.parse(factor), offset == null ? Rational.ZERO : this.rationalParser.parse(offset));
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        if (factor != null) {
            args.put("factor", factor);
        }
        if (offset != null) {
            args.put("offset", offset);
        }
        this.addToSourceToTarget(source, target, info, args, systems);
        Continuation.addIfNeeded(source, this.continuations);
    }

    private void addToSourceToTarget(String source, String target, ConversionInfo info, Map<String, String> inputParameters, String systems) {
        if (this.sourceToTargetInfo.isEmpty()) {
            this.baseUnitToQuantity = ImmutableBiMap.copyOf(this.baseUnitToQuantity);
            this.baseUnitToStatus = ImmutableMap.copyOf(this.baseUnitToStatus);
        } else if (this.sourceToTargetInfo.containsKey(source)) {
            throw new IllegalArgumentException("Duplicate source: " + source + ", " + target);
        }
        this.sourceToTargetInfo.put(source, new TargetInfo(target, info, inputParameters));
        String targetQuantity = this.baseUnitToQuantity.get(target);
        if (targetQuantity == null) {
            throw new IllegalArgumentException("No quantity for baseUnit: " + target);
        }
        this.quantityToSimpleUnits.put(targetQuantity, source);
        if (systems != null) {
            this.sourceToSystems.putAll(source, SPACE_SPLITTER.split(systems));
        }
    }

    private Comparator<String> getQuantityComparator(Map<String, String> baseUnitToQuantity2, Map<String, String> baseUnitToStatus2) {
        Collection<String> values = baseUnitToQuantity2.values();
        if (DEBUG) {
            System.out.println(values);
        }
        return new MapComparator<String>(values).freeze();
    }

    public Set<String> canConvertBetween(String unit) {
        TargetInfo targetInfo = this.sourceToTargetInfo.get(unit);
        if (targetInfo == null) {
            return Collections.emptySet();
        }
        String quantity = this.baseUnitToQuantity.get(targetInfo.target);
        return ImmutableSet.copyOf(this.quantityToSimpleUnits.get(quantity));
    }

    public Set<String> canConvert() {
        return this.sourceToTargetInfo.keySet();
    }

    public Rational convertDirect(Rational source, String sourceUnit, String targetUnit) {
        if (sourceUnit.equals(targetUnit)) {
            return source;
        }
        TargetInfo toPivotInfo = this.sourceToTargetInfo.get(sourceUnit);
        if (toPivotInfo == null) {
            return Rational.NaN;
        }
        TargetInfo fromPivotInfo = this.sourceToTargetInfo.get(targetUnit);
        if (fromPivotInfo == null) {
            return Rational.NaN;
        }
        if (!toPivotInfo.target.equals(fromPivotInfo.target)) {
            return Rational.NaN;
        }
        Rational toPivot = toPivotInfo.unitInfo.convert(source);
        Rational fromPivot = fromPivotInfo.unitInfo.convertBackwards(toPivot);
        return fromPivot;
    }

    public ConversionInfo getUnitInfo(String sourceUnit, Output<String> baseUnit) {
        if (this.isBaseUnit(sourceUnit)) {
            baseUnit.value = sourceUnit;
            return ConversionInfo.IDENTITY;
        }
        TargetInfo targetToInfo = this.sourceToTargetInfo.get(sourceUnit);
        if (targetToInfo == null) {
            return null;
        }
        baseUnit.value = targetToInfo.target;
        return targetToInfo.unitInfo;
    }

    public String getBaseUnit(String simpleUnit) {
        TargetInfo targetToInfo = this.sourceToTargetInfo.get(simpleUnit);
        if (targetToInfo == null) {
            return null;
        }
        return targetToInfo.target;
    }

    public String getStandardUnit(String unit) {
        Output<String> metricUnit = new Output<String>();
        this.parseUnitId(unit, metricUnit, false);
        String result = this.sourceToStandard.get(metricUnit.value);
        if (result == null) {
            UnitId mUnit = this.createUnitId((String)metricUnit.value);
            mUnit = mUnit.resolve();
            result = this.sourceToStandard.get(mUnit.toString());
        }
        return result == null ? (String)metricUnit.value : result;
    }

    public String getSpecialBaseUnit(String quantity, Set<UnitSystem> unitSystem) {
        if (unitSystem.contains((Object)UnitSystem.ussystem) || unitSystem.contains((Object)UnitSystem.uksystem)) {
            switch (quantity) {
                case "volume": {
                    return unitSystem.contains((Object)UnitSystem.uksystem) ? "gallon-imperial" : "gallon";
                }
                case "mass": {
                    return "pound";
                }
                case "length": {
                    return "foot";
                }
                case "area": {
                    return "square-foot";
                }
            }
        }
        return null;
    }

    public ConversionInfo parseUnitId(String derivedUnit, Output<String> metricUnit, boolean showYourWork) {
        metricUnit.value = null;
        UnitId outputUnit = new UnitId(this.UNIT_COMPARATOR);
        Rational numerator = Rational.ONE;
        Rational denominator = Rational.ONE;
        boolean inNumerator = true;
        int power = 1;
        Output<Rational> deprefix = new Output<Rational>();
        Rational offset = Rational.ZERO;
        int countUnits = 0;
        Continuation.UnitIterator it = Continuation.split(derivedUnit, this.continuations).iterator();
        while (it.hasNext()) {
            String unit = (String)it.next();
            ++countUnits;
            if (unit.equals("square")) {
                if (power != 1) {
                    throw new IllegalArgumentException("Can't have power of " + unit);
                }
                power = 2;
                if (!showYourWork) continue;
                System.out.println(this.showRational("\t " + unit + ": ", Rational.of(power), "power"));
                continue;
            }
            if (unit.equals("cubic")) {
                if (power != 1) {
                    throw new IllegalArgumentException("Can't have power of " + unit);
                }
                power = 3;
                if (!showYourWork) continue;
                System.out.println(this.showRational("\t " + unit + ": ", Rational.of(power), "power"));
                continue;
            }
            if (unit.startsWith("pow")) {
                if (power != 1) {
                    throw new IllegalArgumentException("Can't have power of " + unit);
                }
                power = Integer.parseInt(unit.substring(3));
                if (!showYourWork) continue;
                System.out.println(this.showRational("\t " + unit + ": ", Rational.of(power), "power"));
                continue;
            }
            if (unit.equals("per")) {
                if (power != 1) {
                    throw new IllegalArgumentException("Can't have power of per");
                }
                if (showYourWork && inNumerator) {
                    System.out.println("\tper");
                }
                inNumerator = false;
                continue;
            }
            unit = UnitConverter.stripPrefix(unit, deprefix);
            if (showYourWork) {
                if (!((Rational)deprefix.value).equals(Rational.ONE)) {
                    System.out.println(this.showRational("\tprefix: ", (Rational)deprefix.value, unit));
                } else {
                    System.out.println("\t" + unit);
                }
            }
            Rational value = (Rational)deprefix.value;
            if (!this.isSimpleBaseUnit(unit)) {
                TargetInfo info = this.sourceToTargetInfo.get(unit);
                if (info == null) {
                    if (showYourWork) {
                        System.out.println("\t\u27f9 no conversion for: " + unit);
                    }
                    return null;
                }
                String baseUnit = info.target;
                value = info.unitInfo.factor.multiply(value);
                if (countUnits == 1 && !it.hasNext()) {
                    offset = info.unitInfo.offset;
                    if (showYourWork && !info.unitInfo.offset.equals(Rational.ZERO)) {
                        System.out.println(this.showRational("\toffset: ", info.unitInfo.offset, baseUnit));
                    }
                }
                unit = baseUnit;
            }
            for (int p = 1; p <= power; ++p) {
                String title = "";
                if (value.equals(Rational.ONE)) {
                    if (!showYourWork) continue;
                    System.out.println("\t(already base unit)");
                    continue;
                }
                if (inNumerator) {
                    numerator = numerator.multiply(value);
                    title = "\t\u00d7 ";
                } else {
                    denominator = denominator.multiply(value);
                    title = "\t\u00f7 ";
                }
                if (!showYourWork) continue;
                System.out.println(this.showRational("\t\u00d7 ", value, " \u27f9 " + unit) + "\t" + numerator.divide(denominator) + "\t" + numerator.divide(denominator).doubleValue());
            }
            outputUnit.add(this.continuations, unit, inNumerator, power);
            power = 1;
        }
        metricUnit.value = outputUnit.toString();
        return new ConversionInfo(numerator.divide(denominator), offset);
    }

    public static String addPlaceholder(String result, String placeholderPattern, PlaceholderLocation placeholderPosition) {
        return placeholderPattern == null ? result : (placeholderPosition == PlaceholderLocation.before ? placeholderPattern + result : result + placeholderPattern);
    }

    public static PlaceholderLocation extractUnit(Matcher placeholderMatcher, String unitPattern, Output<String> unitPatternOut) {
        if (placeholderMatcher.reset(unitPattern).find()) {
            if (placeholderMatcher.start() == 0) {
                unitPatternOut.value = unitPattern.substring(placeholderMatcher.end());
                return PlaceholderLocation.before;
            }
            if (placeholderMatcher.end() == unitPattern.length()) {
                unitPatternOut.value = unitPattern.substring(0, placeholderMatcher.start());
                return PlaceholderLocation.after;
            }
            unitPatternOut.value = unitPattern;
            return PlaceholderLocation.middle;
        }
        unitPatternOut.value = unitPattern;
        return PlaceholderLocation.missing;
    }

    public static String combineLowercasing(ULocale locale, String width, String prefixPattern, String unitPattern) {
        if (width.equals("long") && !prefixPattern.contains(" {") && !prefixPattern.contains("\u00a0{")) {
            unitPattern = UCharacter.toLowerCase(locale, unitPattern);
        }
        unitPattern = MessageFormat.format(prefixPattern, unitPattern);
        return unitPattern;
    }

    public static <K extends Comparable<K>, V extends Comparable<V>, T extends Map.Entry<K, V>> int compareEntrySets(Collection<T> o1, Collection<T> o2, Comparator<T> comparator) {
        Map.Entry item2;
        Map.Entry item1;
        int diff;
        Iterator<T> iterator1 = o1.iterator();
        Iterator<T> iterator2 = o2.iterator();
        do {
            if (!iterator1.hasNext()) {
                return iterator2.hasNext() ? -1 : 0;
            }
            if (iterator2.hasNext()) continue;
            return 1;
        } while ((diff = comparator.compare(item1 = (Map.Entry)iterator1.next(), item2 = (Map.Entry)iterator2.next())) == 0);
        return diff;
    }

    public final UnitId createUnitId(String unit) {
        UnitId result = this.UNIT_ID.get(unit);
        if (result == null) {
            result = new UnitId(this.UNIT_COMPARATOR).add(this.continuations, unit, true, 1).freeze();
            this.UNIT_ID.put(unit, result);
        }
        return result;
    }

    public boolean isBaseUnit(String unit) {
        return this.baseUnits.contains(unit);
    }

    public boolean isSimpleBaseUnit(String unit) {
        return BASE_UNITS.contains(unit);
    }

    public Set<String> baseUnits() {
        return this.baseUnits;
    }

    private static <V> String stripPrefixCommon(String unit, Output<V> deprefix, Map<String, V> unitMap) {
        if (SKIP_PREFIX.contains(unit)) {
            return unit;
        }
        for (Map.Entry<String, V> entry : unitMap.entrySet()) {
            boolean isGramHack;
            String prefix = entry.getKey();
            if (!unit.startsWith(prefix)) continue;
            String result = unit.substring(prefix.length());
            boolean isRational = deprefix != null && deprefix.value instanceof Rational;
            boolean bl = isGramHack = isRational && result.equals("gram");
            if (isGramHack) {
                result = "kilogram";
            }
            if (deprefix != null) {
                deprefix.value = entry.getValue();
                if (isGramHack) {
                    Rational ratValue = (Rational)deprefix.value;
                    deprefix.value = ratValue.divide(RATIONAL1000);
                }
            }
            return result;
        }
        return unit;
    }

    public static String stripPrefix(String unit, Output<Rational> deprefix) {
        if (deprefix != null) {
            deprefix.value = Rational.ONE;
        }
        return UnitConverter.stripPrefixCommon(unit, deprefix, PREFIXES);
    }

    public static String stripPrefixPower(String unit, Output<Integer> deprefix) {
        if (deprefix != null) {
            deprefix.value = 1;
        }
        return UnitConverter.stripPrefixCommon(unit, deprefix, PREFIX_POWERS);
    }

    public BiMap<String, String> getBaseUnitToQuantity() {
        return (BiMap)this.baseUnitToQuantity;
    }

    public String getQuantityFromUnit(String unit, boolean showYourWork) {
        Output<String> metricUnit = new Output<String>();
        unit = this.fixDenormalized(unit);
        ConversionInfo unitInfo = this.parseUnitId(unit, metricUnit, showYourWork);
        return metricUnit.value == null ? null : this.getQuantityFromBaseUnit((String)metricUnit.value);
    }

    public String getQuantityFromBaseUnit(String baseUnit) {
        if (baseUnit == null) {
            throw new NullPointerException("baseUnit");
        }
        String result = this.getQuantityFromBaseUnit2(baseUnit);
        if (result != null) {
            return result;
        }
        result = this.getQuantityFromBaseUnit2(this.reciprocalOf(baseUnit));
        if (result != null) {
            result = result + "-inverse";
        }
        return result;
    }

    private String getQuantityFromBaseUnit2(String baseUnit) {
        String result = this.baseUnitToQuantity.get(baseUnit);
        if (result != null) {
            return result;
        }
        UnitId unitId = this.createUnitId(baseUnit);
        UnitId resolved = unitId.resolve();
        return this.baseUnitToQuantity.get(resolved.toString());
    }

    public Set<String> getSimpleUnits() {
        return this.sourceToTargetInfo.keySet();
    }

    public void addAliases(Map<String, Row.R2<List<String>, String>> tagToReplacement) {
        this.fixDenormalized = new TreeMap<String, String>();
        for (Map.Entry<String, Row.R2<List<String>, String>> entry : tagToReplacement.entrySet()) {
            String badCode = entry.getKey();
            List replacements = (List)entry.getValue().get0();
            this.fixDenormalized.put(badCode, (String)replacements.iterator().next());
        }
        this.fixDenormalized = ImmutableMap.copyOf(this.fixDenormalized);
    }

    public Map<String, TargetInfo> getInternalConversionData() {
        return this.sourceToTargetInfo;
    }

    public Multimap<String, String> getSourceToSystems() {
        return this.sourceToSystems;
    }

    public Set<String> getSystems(String unit) {
        return UnitSystem.toStringSet(this.getSystemsEnum(unit));
    }

    public Set<UnitSystem> getSystemsEnum(String unit) {
        Set<UnitSystem> result = null;
        UnitId id = this.createUnitId(unit);
        block0: for (Map unitsToPowers : Arrays.asList(id.denUnitsToPowers, id.numUnitsToPowers)) {
            for (String subunit : unitsToPowers.keySet()) {
                subunit = UnitConverter.stripPrefix(subunit, null);
                Set<UnitSystem> systems = UnitSystem.fromStringCollection(this.sourceToSystems.get(subunit));
                if (result == null) {
                    result = systems;
                } else {
                    result.retainAll(systems);
                }
                if (!result.isEmpty()) continue;
                break block0;
            }
        }
        return result == null || result.isEmpty() ? ImmutableSet.of(UnitSystem.other) : ImmutableSet.copyOf(EnumSet.copyOf(result));
    }

    private void addSystems(Set<String> result, String subunit) {
        Collection<String> systems = this.sourceToSystems.get(subunit);
        if (!systems.isEmpty()) {
            result.addAll(systems);
        }
    }

    public String reciprocalOf(String value) {
        int index = value.indexOf("-per-");
        if (index < 0) {
            return null;
        }
        return value.substring(index + 5) + "-per-" + value.substring(0, index);
    }

    public Rational parseRational(String source) {
        return this.rationalParser.parse(source);
    }

    public String showRational(String title, Rational rational, String unit) {
        String doubleString = this.showRational2(rational, " = ", " \u2245 ");
        String endResult = title + rational + doubleString + (unit != null ? " " + unit : "");
        return endResult;
    }

    public String showRational(Rational rational, String approximatePrefix) {
        String doubleString = this.showRational2(rational, "", approximatePrefix);
        return doubleString.isEmpty() ? rational.numerator.toString() : doubleString;
    }

    public String showRational2(Rational rational, String equalPrefix, String approximatePrefix) {
        String doubleString = "";
        if (!rational.denominator.equals(BigInteger.ONE)) {
            String doubleValue = String.valueOf(rational.toBigDecimal(MathContext.DECIMAL32).doubleValue());
            Rational reverse = this.parseRational(doubleValue);
            doubleString = (reverse.equals(rational) ? equalPrefix : approximatePrefix) + doubleValue;
        }
        return doubleString;
    }

    public Rational convert(Rational sourceValue, String sourceUnit, String targetUnit, boolean showYourWork) {
        String targetBaseFixed;
        String sourceBaseFixed;
        ConversionInfo targetConversionInfo;
        if (showYourWork) {
            System.out.println(this.showRational("\nconvert:\t", sourceValue, sourceUnit) + " \u27f9 " + targetUnit);
        }
        sourceUnit = this.fixDenormalized(sourceUnit);
        Output<String> sourceBase = new Output<String>();
        Output<String> targetBase = new Output<String>();
        ConversionInfo sourceConversionInfo = this.parseUnitId(sourceUnit, sourceBase, showYourWork);
        if (sourceConversionInfo == null) {
            if (showYourWork) {
                System.out.println("! unknown unit: " + sourceUnit);
            }
            return Rational.NaN;
        }
        Rational intermediateResult = sourceConversionInfo.convert(sourceValue);
        if (showYourWork) {
            System.out.println(this.showRational("intermediate:\t", intermediateResult, (String)sourceBase.value));
        }
        if (showYourWork) {
            System.out.println("invert:\t" + targetUnit);
        }
        if ((targetConversionInfo = this.parseUnitId(targetUnit, targetBase, showYourWork)) == null) {
            if (showYourWork) {
                System.out.println("! unknown unit: " + targetUnit);
            }
            return Rational.NaN;
        }
        if (!((String)sourceBase.value).equals(targetBase.value) && !(sourceBaseFixed = this.createUnitId((String)sourceBase.value).resolve().toString()).equals(targetBaseFixed = this.createUnitId((String)targetBase.value).resolve().toString())) {
            String reciprocalUnit = this.reciprocalOf((String)sourceBase.value);
            if (reciprocalUnit == null || !((String)targetBase.value).equals(reciprocalUnit)) {
                if (showYourWork) {
                    System.out.println("! incomparable units: " + sourceUnit + " and " + targetUnit);
                }
                return Rational.NaN;
            }
            intermediateResult = intermediateResult.reciprocal();
            if (showYourWork) {
                System.out.println(this.showRational(" \u27f9 1/intermediate:\t", intermediateResult, reciprocalUnit));
            }
        }
        Rational result = targetConversionInfo.convertBackwards(intermediateResult);
        if (showYourWork) {
            System.out.println(this.showRational("target:\t", result, targetUnit));
        }
        return result;
    }

    public String fixDenormalized(String unit) {
        String fixed = this.fixDenormalized.get(unit);
        return fixed == null ? unit : fixed;
    }

    public Map<String, Rational> getConstants() {
        return this.rationalParser.getConstants();
    }

    public String getBaseUnitFromQuantity(String unitQuantity) {
        String bu;
        boolean invert = false;
        if (unitQuantity.endsWith("-inverse")) {
            invert = true;
            unitQuantity = unitQuantity.substring(0, unitQuantity.length() - 8);
        }
        if ((bu = (String)((BiMap)this.baseUnitToQuantity).inverse().get(unitQuantity)) == null) {
            return null;
        }
        return invert ? this.reciprocalOf(bu) : bu;
    }

    public Set<String> getQuantities() {
        return this.getBaseUnitToQuantity().inverse().keySet();
    }

    public UnitComplexity getComplexity(String longOrShortId) {
        UnitComplexity result = this.COMPLEXITY.get(longOrShortId);
        if (result == null) {
            String shortId;
            String longId = this.getLongId(longOrShortId);
            if (longId == null) {
                longId = longOrShortId;
                shortId = (String)this.SHORT_TO_LONG_ID.inverse().get(longId);
            } else {
                shortId = longOrShortId;
            }
            UnitId uid = this.createUnitId(shortId);
            result = UnitComplexity.simple;
            if (uid.numUnitsToPowers.size() != 1 || !uid.denUnitsToPowers.isEmpty()) {
                result = UnitComplexity.non_simple;
            } else {
                String unitPart;
                Output<Rational> deprefix = new Output<Rational>();
                for (Map.Entry<String, Integer> entry : uid.numUnitsToPowers.entrySet()) {
                    unitPart = entry.getKey();
                    UnitConverter.stripPrefix(unitPart, deprefix);
                    if (((Rational)deprefix.value).equals(Rational.ONE) && entry.getValue().equals(INTEGER_ONE)) continue;
                    result = UnitComplexity.non_simple;
                    break;
                }
                if (result == UnitComplexity.simple) {
                    for (Map.Entry<String, Integer> entry : uid.denUnitsToPowers.entrySet()) {
                        unitPart = entry.getKey();
                        UnitConverter.stripPrefix(unitPart, deprefix);
                        if (((Rational)deprefix.value).equals(Rational.ONE)) continue;
                        result = UnitComplexity.non_simple;
                        break;
                    }
                }
            }
            this.COMPLEXITY.put(shortId, result);
            this.COMPLEXITY.put(longId, result);
        }
        return result;
    }

    public boolean isSimple(String x) {
        return this.getComplexity(x) == UnitComplexity.simple;
    }

    public String getLongId(String shortUnitId) {
        return CldrUtility.ifNull(this.SHORT_TO_LONG_ID.get(shortUnitId), shortUnitId);
    }

    public String getShortId(String longUnitId) {
        return CldrUtility.ifNull(this.SHORT_TO_LONG_ID.inverse().get(longUnitId), longUnitId);
    }

    public Multimap<String, Continuation> getContinuations() {
        return this.continuations;
    }

    public Map<String, String> getBaseUnitToStatus() {
        return this.baseUnitToStatus;
    }

    static {
        LinkedHashMap temp = new LinkedHashMap();
        for (Map.Entry entry : PREFIX_POWERS.entrySet()) {
            temp.put(entry.getKey(), Rational.pow10((Integer)entry.getValue()));
        }
        PREFIXES = ImmutableMap.copyOf(temp);
        SKIP_PREFIX = ImmutableSet.of("millimeter-ofhg", "kilogram");
        RATIONAL1000 = Rational.of(1000L);
    }

    public static enum UnitComplexity {
        simple,
        non_simple;

    }

    public static enum UnitSystem {
        si,
        metric,
        ussystem,
        uksystem,
        other;


        public static Set<UnitSystem> fromStringCollection(Collection<String> stringUnitSystems) {
            return stringUnitSystems.stream().map(x -> UnitSystem.valueOf(x)).collect(Collectors.toSet());
        }

        public static Set<String> toStringSet(Collection<UnitSystem> stringUnitSystems) {
            return stringUnitSystems.stream().map(x -> x.toString()).collect(Collectors.toSet());
        }
    }

    public static class EntrySetComparator<K extends Comparable<K>, V>
    implements Comparator<Map.Entry<K, V>> {
        Comparator<K> kComparator;
        Comparator<V> vComparator;

        public EntrySetComparator(Comparator<K> kComparator, Comparator<V> vComparator) {
            this.kComparator = kComparator;
            this.vComparator = vComparator;
        }

        @Override
        public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
            int diff = this.kComparator.compare(o1.getKey(), o2.getKey());
            if (diff != 0) {
                return diff;
            }
            diff = this.vComparator.compare(o1.getValue(), o2.getValue());
            if (diff != 0) {
                return diff;
            }
            return ((Comparable)o1.getKey()).compareTo(o2.getKey());
        }
    }

    public static enum PlaceholderLocation {
        before,
        middle,
        after,
        missing;

    }

    public class UnitId
    implements Freezable<UnitId>,
    Comparable<UnitId> {
        public Map<String, Integer> numUnitsToPowers;
        public Map<String, Integer> denUnitsToPowers;
        public EntrySetComparator<String, Integer> entrySetComparator;
        private boolean frozen = false;

        private UnitId(Comparator<String> comparator) {
            this.numUnitsToPowers = new TreeMap<String, Integer>(comparator);
            this.denUnitsToPowers = new TreeMap<String, Integer>(comparator);
            this.entrySetComparator = new EntrySetComparator(comparator, Comparator.naturalOrder());
        }

        private UnitId add(Multimap<String, Continuation> continuations, String compoundUnit, boolean groupInNumerator, int groupPower) {
            if (this.frozen) {
                throw new UnsupportedOperationException("Object is frozen.");
            }
            boolean inNumerator = true;
            int power = 1;
            Continuation.UnitIterator unitIterator = Continuation.split(compoundUnit, continuations).iterator();
            block10: while (unitIterator.hasNext()) {
                String unitPart;
                switch (unitPart = (String)unitIterator.next()) {
                    case "square": {
                        power = 2;
                        continue block10;
                    }
                    case "cubic": {
                        power = 3;
                        continue block10;
                    }
                    case "per": {
                        inNumerator = false;
                        continue block10;
                    }
                }
                if (unitPart.startsWith("pow")) {
                    power = Integer.parseInt(unitPart.substring(3));
                    continue;
                }
                Map<String, Integer> target = inNumerator == groupInNumerator ? this.numUnitsToPowers : this.denUnitsToPowers;
                Integer oldPower = target.get(unitPart);
                int newPower = groupPower * power + (oldPower == null ? 0 : oldPower);
                target.put(unitPart, newPower);
                power = 1;
            }
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            boolean firstDenominator = true;
            for (int i = 1; i >= 0; --i) {
                boolean positivePass = i > 0;
                Map<String, Integer> target = positivePass ? this.numUnitsToPowers : this.denUnitsToPowers;
                for (Map.Entry<String, Integer> entry : target.entrySet()) {
                    String unit = entry.getKey();
                    int power = entry.getValue();
                    if (builder.length() != 0) {
                        builder.append('-');
                    }
                    if (!positivePass && firstDenominator) {
                        firstDenominator = false;
                        builder.append("per-");
                    }
                    switch (power) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            builder.append("square-");
                            break;
                        }
                        case 3: {
                            builder.append("cubic-");
                            break;
                        }
                        default: {
                            if (power > 3) {
                                builder.append("pow" + power + "-");
                                break;
                            }
                            throw new IllegalArgumentException("Unhandled power: " + power);
                        }
                    }
                    builder.append(unit);
                }
            }
            return builder.toString();
        }

        public String toString(LocaleStringProvider resolvedFile, String width, String _pluralCategory, String caseVariant, Multimap<UnitPathType, String> partsUsed, boolean maximal) {
            if (partsUsed != null) {
                partsUsed.clear();
            }
            String result = null;
            String numerator = null;
            String timesPattern = null;
            String placeholderPattern = null;
            Output<Integer> deprefix = new Output<Integer>();
            PlaceholderLocation placeholderPosition = PlaceholderLocation.missing;
            Matcher placeholderMatcher = PLACEHOLDER.matcher("");
            Output<String> unitPatternOut = new Output<String>();
            SupplementalDataInfo.PluralInfo pluralInfo = CLDRConfig.getInstance().getSupplementalDataInfo().getPlurals(resolvedFile.getLocaleID());
            PluralRules pluralRules = pluralInfo.getPluralRules();
            String singularPluralCategory = pluralRules.select(1.0);
            ULocale locale = new ULocale(resolvedFile.getLocaleID());
            String fullPerPattern = null;
            int negCount = 0;
            for (int i = 1; i >= 0; --i) {
                boolean positivePass;
                boolean bl = positivePass = i > 0;
                if (!positivePass) {
                    switch (locale.toString()) {
                        case "de": {
                            caseVariant = "accusative";
                        }
                    }
                    numerator = result;
                    result = null;
                }
                Map<String, Integer> target = positivePass ? this.numUnitsToPowers : this.denUnitsToPowers;
                int unitsLeft = target.size();
                for (Map.Entry<String, Integer> entry : target.entrySet()) {
                    String unitPattern;
                    String pluralCategory;
                    String possiblyPrefixedUnit = entry.getKey();
                    String unit = UnitConverter.stripPrefixPower(possiblyPrefixedUnit, deprefix);
                    String genderVariant = UnitPathType.gender.getTrans(resolvedFile, "long", unit, null, null, null, partsUsed);
                    int power = entry.getValue();
                    String string = pluralCategory = --unitsLeft == 0 && positivePass ? _pluralCategory : singularPluralCategory;
                    if (!positivePass && maximal && 0 == negCount++) {
                        throw new UnsupportedOperationException("not yet implemented fully");
                    }
                    String prefixPattern = null;
                    if ((Integer)deprefix.value != 1) {
                        prefixPattern = UnitPathType.prefix.getTrans(resolvedFile, width, "10p" + deprefix.value, _pluralCategory, caseVariant, genderVariant, partsUsed);
                    }
                    if ((unitPattern = UnitPathType.unit.getTrans(resolvedFile, width, unit, pluralCategory, caseVariant, genderVariant, partsUsed)) == null) {
                        return null;
                    }
                    placeholderPosition = UnitConverter.extractUnit(placeholderMatcher, unitPattern, unitPatternOut);
                    if (placeholderPosition == PlaceholderLocation.middle) {
                        return null;
                    }
                    if (placeholderPosition != PlaceholderLocation.missing) {
                        unitPattern = (String)unitPatternOut.value;
                        placeholderPattern = placeholderMatcher.group();
                    }
                    if (prefixPattern != null) {
                        unitPattern = UnitConverter.combineLowercasing(locale, width, prefixPattern, unitPattern);
                    }
                    String powerPattern = null;
                    switch (power) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            powerPattern = UnitPathType.power.getTrans(resolvedFile, width, "power2", pluralCategory, caseVariant, genderVariant, partsUsed);
                            break;
                        }
                        case 3: {
                            powerPattern = UnitPathType.power.getTrans(resolvedFile, width, "power3", pluralCategory, caseVariant, genderVariant, partsUsed);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("No power pattern > 3: " + this);
                        }
                    }
                    if (powerPattern != null) {
                        unitPattern = UnitConverter.combineLowercasing(locale, width, powerPattern, unitPattern);
                    }
                    if (result != null) {
                        if (timesPattern == null) {
                            timesPattern = this.getTimesPattern(resolvedFile, width);
                        }
                        result = MessageFormat.format(timesPattern, result, unitPattern);
                        continue;
                    }
                    result = unitPattern;
                }
            }
            if (fullPerPattern != null) {
                if (numerator != null) {
                    numerator = MessageFormat.format(fullPerPattern, numerator);
                } else {
                    numerator = fullPerPattern;
                    placeholderPattern = null;
                }
                if (result != null) {
                    if (timesPattern == null) {
                        timesPattern = this.getTimesPattern(resolvedFile, width);
                    }
                    numerator = MessageFormat.format(timesPattern, numerator, result);
                }
                result = numerator;
            } else if (result == null) {
                result = numerator;
            } else {
                String perPattern = UnitPathType.per.getTrans(resolvedFile, width, null, _pluralCategory, caseVariant, null, partsUsed);
                result = numerator == null ? MessageFormat.format(perPattern, "", result).trim() : MessageFormat.format(perPattern, numerator, result);
            }
            return UnitConverter.addPlaceholder(result, placeholderPattern, placeholderPosition);
        }

        public String getTimesPattern(LocaleStringProvider resolvedFile, String width) {
            if ("en".equals(resolvedFile.getLocaleID())) {
                return "{0}-{1}";
            }
            String timesPatternPath = "//ldml/units/unitLength[@type=\"" + width + "\"]/compoundUnit[@type=\"times\"]/compoundUnitPattern";
            return resolvedFile.getStringValue(timesPatternPath);
        }

        public boolean equals(Object obj) {
            UnitId other = (UnitId)obj;
            return this.numUnitsToPowers.equals(other.numUnitsToPowers) && this.denUnitsToPowers.equals(other.denUnitsToPowers);
        }

        public int hashCode() {
            return Objects.hash(this.numUnitsToPowers, this.denUnitsToPowers);
        }

        @Override
        public boolean isFrozen() {
            return this.frozen;
        }

        @Override
        public UnitId freeze() {
            this.frozen = true;
            this.numUnitsToPowers = ImmutableMap.copyOf(this.numUnitsToPowers);
            this.denUnitsToPowers = ImmutableMap.copyOf(this.denUnitsToPowers);
            return this;
        }

        @Override
        public UnitId cloneAsThawed() {
            throw new UnsupportedOperationException();
        }

        public UnitId resolve() {
            UnitId result = new UnitId(UnitConverter.this.UNIT_COMPARATOR);
            result.numUnitsToPowers.putAll(this.numUnitsToPowers);
            result.denUnitsToPowers.putAll(this.denUnitsToPowers);
            for (Map.Entry<String, Integer> entry : this.numUnitsToPowers.entrySet()) {
                String key = entry.getKey();
                Integer denPower = this.denUnitsToPowers.get(key);
                if (denPower == null) continue;
                int power = entry.getValue() - denPower;
                if (power > 0) {
                    result.numUnitsToPowers.put(key, power);
                    result.denUnitsToPowers.remove(key);
                    continue;
                }
                if (power < 0) {
                    result.numUnitsToPowers.remove(key);
                    result.denUnitsToPowers.put(key, -power);
                    continue;
                }
                result.numUnitsToPowers.remove(key);
                result.denUnitsToPowers.remove(key);
            }
            return result.freeze();
        }

        @Override
        public int compareTo(UnitId o) {
            int diff = UnitConverter.compareEntrySets(this.numUnitsToPowers.entrySet(), o.numUnitsToPowers.entrySet(), this.entrySetComparator);
            if (diff != 0) {
                return diff;
            }
            return UnitConverter.compareEntrySets(this.denUnitsToPowers.entrySet(), o.denUnitsToPowers.entrySet(), this.entrySetComparator);
        }

        public String getGender(CLDRFile resolvedFile, Output<String> source, Multimap<UnitPathType, String> partsUsed) {
            Map.Entry<String, Integer> bestMeasure;
            Map<String, Integer> determiner;
            GrammarDerivation gd = null;
            if (this.numUnitsToPowers.isEmpty()) {
                determiner = this.denUnitsToPowers;
            } else if (this.denUnitsToPowers.isEmpty()) {
                determiner = this.numUnitsToPowers;
            } else {
                if (gd == null) {
                    gd = SupplementalDataInfo.getInstance().getGrammarDerivation(resolvedFile.getLocaleID());
                }
                GrammarDerivation.Values per = gd.get(GrammarInfo.GrammaticalFeature.grammaticalGender, GrammarDerivation.CompoundUnitStructure.per);
                boolean useFirst = per.value0.equals("0");
                Map<String, Integer> map = determiner = useFirst ? this.numUnitsToPowers : this.denUnitsToPowers;
            }
            if (determiner.size() == 1) {
                bestMeasure = determiner.entrySet().iterator().next();
            } else {
                if (gd == null) {
                    gd = SupplementalDataInfo.getInstance().getGrammarDerivation(resolvedFile.getLocaleID());
                }
                GrammarDerivation.Values times = gd.get(GrammarInfo.GrammaticalFeature.grammaticalGender, GrammarDerivation.CompoundUnitStructure.times);
                boolean useFirst = times.value0.equals("0");
                if (useFirst) {
                    bestMeasure = determiner.entrySet().iterator().next();
                } else {
                    bestMeasure = null;
                    for (Map.Entry<String, Integer> entry : determiner.entrySet()) {
                        bestMeasure = entry;
                    }
                }
            }
            String strippedUnit = UnitConverter.stripPrefix(bestMeasure.getKey(), null);
            String gender = UnitPathType.gender.getTrans(resolvedFile, "long", strippedUnit, null, null, null, partsUsed);
            if (gender != null && source != null) {
                source.value = strippedUnit;
            }
            return gender;
        }
    }

    private class UnitComparator
    implements Comparator<String> {
        private UnitComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            Rational factor2;
            if (o1.equals(o2)) {
                return 0;
            }
            Output<Rational> deprefix1 = new Output<Rational>();
            o1 = UnitConverter.stripPrefix(o1, deprefix1);
            TargetInfo targetAndInfo1 = (TargetInfo)UnitConverter.this.sourceToTargetInfo.get(o1);
            String quantity1 = (String)UnitConverter.this.baseUnitToQuantity.get(targetAndInfo1.target);
            Output<Rational> deprefix2 = new Output<Rational>();
            o2 = UnitConverter.stripPrefix(o2, deprefix2);
            TargetInfo targetAndInfo2 = (TargetInfo)UnitConverter.this.sourceToTargetInfo.get(o2);
            String quantity2 = (String)UnitConverter.this.baseUnitToQuantity.get(targetAndInfo2.target);
            int diff = UnitConverter.this.quantityComparator.compare(quantity1, quantity2);
            if (0 != diff) {
                return diff;
            }
            Rational factor1 = targetAndInfo1.unitInfo.factor.multiply((Rational)deprefix1.value);
            diff = factor1.compareTo(factor2 = targetAndInfo2.unitInfo.factor.multiply((Rational)deprefix2.value));
            if (0 != diff) {
                return diff;
            }
            return o1.compareTo(o2);
        }
    }

    public class TargetInfoComparator
    implements Comparator<TargetInfo> {
        @Override
        public int compare(TargetInfo o1, TargetInfo o2) {
            String quality1 = (String)UnitConverter.this.baseUnitToQuantity.get(o1.target);
            String quality2 = (String)UnitConverter.this.baseUnitToQuantity.get(o2.target);
            int diff = UnitConverter.this.quantityComparator.compare(quality1, quality2);
            if (0 != diff) {
                return diff;
            }
            diff = o1.unitInfo.compareTo(o2.unitInfo);
            if (0 != diff) {
                return diff;
            }
            return o1.target.compareTo(o2.target);
        }
    }

    public static class TargetInfo {
        public final String target;
        public final ConversionInfo unitInfo;
        public final Map<String, String> inputParameters;

        public TargetInfo(String target, ConversionInfo unitInfo, Map<String, String> inputParameters) {
            this.target = target;
            this.unitInfo = unitInfo;
            this.inputParameters = ImmutableMap.copyOf(inputParameters);
        }

        public String toString() {
            return this.unitInfo + " (" + this.target + ")";
        }

        public String formatOriginalSource(String source) {
            StringBuilder result = new StringBuilder().append("<convertUnit source='").append(source).append("' baseUnit='").append(this.target).append("'");
            for (Map.Entry<String, String> entry : this.inputParameters.entrySet()) {
                if (entry.getValue() == null) continue;
                result.append(" " + entry.getKey() + "='" + entry.getValue() + "'");
            }
            result.append("/>");
            return result.toString();
        }
    }

    public static class Continuation
    implements Comparable<Continuation> {
        public final List<String> remainder;
        public final String result;

        public static void addIfNeeded(String source, Multimap<String, Continuation> data) {
            List<String> sourceParts = BAR_SPLITTER.splitToList(source);
            if (sourceParts.size() > 1) {
                Continuation continuation = new Continuation(ImmutableList.copyOf(sourceParts.subList(1, sourceParts.size())), source);
                data.put(sourceParts.get(0), continuation);
            }
        }

        public Continuation(List<String> remainder, String source) {
            this.remainder = remainder;
            this.result = source;
        }

        @Override
        public int compareTo(Continuation other) {
            int diff = other.remainder.size() - this.remainder.size();
            if (diff != 0) {
                return diff;
            }
            return this.result.compareTo(other.result);
        }

        public boolean match(List<String> parts, int startIndex) {
            if (this.remainder.size() > parts.size() - startIndex) {
                return false;
            }
            int i = startIndex;
            for (String unitPart : this.remainder) {
                if (unitPart.equals(parts.get(i++))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.remainder + " \ud83e\udca3 " + this.result;
        }

        public static UnitIterator split(String derivedUnit, Multimap<String, Continuation> continuations) {
            return new UnitIterator(derivedUnit, continuations);
        }

        public static class UnitIterator
        implements Iterable<String>,
        Iterator<String> {
            final List<String> parts;
            final Multimap<String, Continuation> continuations;
            int nextIndex = 0;

            public UnitIterator(String derivedUnit, Multimap<String, Continuation> continuations) {
                this.parts = BAR_SPLITTER.splitToList(derivedUnit);
                this.continuations = continuations;
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex < this.parts.size();
            }

            public String peek() {
                return this.parts.size() <= this.nextIndex ? null : this.parts.get(this.nextIndex);
            }

            @Override
            public String next() {
                String result = this.parts.get(this.nextIndex++);
                Collection<Continuation> continuationOptions = this.continuations.get(result);
                for (Continuation option : continuationOptions) {
                    if (!option.match(this.parts, this.nextIndex)) continue;
                    this.nextIndex += option.remainder.size();
                    return option.result;
                }
                return result;
            }

            public UnitIterator iterator() {
                return this;
            }
        }
    }

    public static final class ConversionInfo
    implements Comparable<ConversionInfo> {
        public final Rational factor;
        public final Rational offset;
        static final ConversionInfo IDENTITY = new ConversionInfo(Rational.ONE, Rational.ZERO);

        public ConversionInfo(Rational factor, Rational offset) {
            this.factor = factor;
            this.offset = offset;
        }

        public Rational convert(Rational source) {
            return source.multiply(this.factor).add(this.offset);
        }

        public Rational convertBackwards(Rational source) {
            return source.subtract(this.offset).divide(this.factor);
        }

        public ConversionInfo invert() {
            Rational factor2 = this.factor.reciprocal();
            Rational offset2 = this.offset.equals(Rational.ZERO) ? Rational.ZERO : this.offset.divide(this.factor).negate();
            return new ConversionInfo(factor2, offset2);
        }

        public String toString() {
            return this.toString("x");
        }

        public String toString(String unit) {
            return this.factor.toString(Rational.FormatStyle.simple) + " * " + unit + (this.offset.equals(Rational.ZERO) ? "" : (this.offset.compareTo(Rational.ZERO) < 0 ? " - " : " - ") + this.offset.abs().toString(Rational.FormatStyle.simple));
        }

        public String toDecimal() {
            return this.toDecimal("x");
        }

        public String toDecimal(String unit) {
            return this.factor.toBigDecimal(MathContext.DECIMAL64) + " * " + unit + (this.offset.equals(Rational.ZERO) ? "" : (this.offset.compareTo(Rational.ZERO) < 0 ? " - " : " - ") + this.offset.toBigDecimal(MathContext.DECIMAL64).abs());
        }

        @Override
        public int compareTo(ConversionInfo o) {
            int diff = this.factor.compareTo(o.factor);
            if (0 != diff) {
                return diff;
            }
            return this.offset.compareTo(o.offset);
        }

        public boolean equals(Object obj) {
            return 0 == this.compareTo((ConversionInfo)obj);
        }

        public int hashCode() {
            return Objects.hash(this.factor, this.offset);
        }
    }
}

