/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Transform;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Output;
import java.util.List;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ValuePathStatus {
    public static final UnicodeSet LATIN = new UnicodeSet("[:sc=Latn:]").freeze();
    public static Transform<String, MissingOK> MISSING_STATUS_TRANSFORM = new Transform<String, MissingOK>(){

        @Override
        public MissingOK transform(String source) {
            return MissingOK.valueOf(source);
        }
    };
    static final RegexLookup<MissingOK> missingOk = new RegexLookup().setPatternTransform(RegexLookup.RegexFinderTransformPath).setValueTransform(MISSING_STATUS_TRANSFORM).loadFromFile(ValuePathStatus.class, "data/paths/missingOk.txt");

    public static boolean isLatinScriptLocale(CLDRFile sourceFile) {
        UnicodeSet main = sourceFile.getExemplarSet("", CLDRFile.WinningChoice.WINNING);
        return LATIN.containsSome(main);
    }

    static int countZeros(String otherValue) {
        int result = 0;
        for (int i = 0; i < otherValue.length(); ++i) {
            if (otherValue.charAt(i) != '0') continue;
            ++result;
        }
        return result;
    }

    public static boolean isMissingOk(CLDRFile sourceFile, String path, boolean latin, boolean aliased) {
        Output<String[]> arguments = new Output<String[]>();
        List<String> failures = null;
        MissingOK value = missingOk.get(path, null, arguments, null, failures);
        if (value == null) {
            return false;
        }
        switch (value) {
            case ok: {
                return true;
            }
            case latin: {
                return latin;
            }
            case alias: {
                return aliased;
            }
            case compact: {
                if (path.contains("[@count=\"other\"]")) {
                    return false;
                }
                String otherPath = "//ldml/numbers/decimalFormats[@numberSystem=\"" + ((String[])arguments.value)[1] + "\"]/decimalFormatLength[@type=\"" + ((String[])arguments.value)[2] + "\"]/decimalFormat[@type=\"standard\"]/pattern[@type=\"" + ((String[])arguments.value)[3] + "\"][@count=\"other\"]";
                String otherValue = sourceFile.getWinningValue(otherPath);
                if (otherValue == null) {
                    return false;
                }
                int digits = ValuePathStatus.countZeros(otherValue);
                if (digits > 4) {
                    return false;
                }
                SupplementalDataInfo.PluralInfo.Count c = SupplementalDataInfo.PluralInfo.Count.valueOf(((String[])arguments.value)[4]);
                SupplementalDataInfo supplementalDataInfo2 = CLDRConfig.getInstance().getSupplementalDataInfo();
                SupplementalDataInfo.PluralInfo plurals = supplementalDataInfo2.getPlurals(sourceFile.getLocaleID());
                return plurals == null || !plurals.hasSamples(c, digits);
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum MissingOK {
        ok,
        latin,
        alias,
        compact;

    }
}

