/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.PathUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@CLDRTool(alias="validate", description="Check XML files for validity")
public class XMLValidator {
    public boolean quiet = false;
    public boolean parseonly = false;
    public boolean justCheckBom = false;

    public XMLValidator(boolean quiet, boolean parseonly, boolean justCheckBom) {
        this.quiet = quiet;
        this.parseonly = parseonly;
        this.justCheckBom = justCheckBom;
    }

    public static void main(String[] args) throws IOException {
        int failCount;
        boolean quiet = false;
        boolean parseonly = false;
        boolean justCheckBom = false;
        if (args.length == 0) {
            System.out.println("No files specified. Validation failed. Use --help for help.");
            return;
        }
        ArrayList<File> toCheck = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-q") || args[i].equals("--quiet")) {
                quiet = true;
                continue;
            }
            if (args[i].equals("--help")) {
                XMLValidator.usage();
                return;
            }
            if (args[i].equals("--parseonly")) {
                parseonly = true;
                continue;
            }
            if (args[i].equals("--justCheckBom")) {
                justCheckBom = true;
                continue;
            }
            File f = new File(args[i]);
            if (f.isDirectory()) {
                XMLValidator.addDirectory(f, toCheck);
                continue;
            }
            if (f.canRead()) {
                toCheck.add(f);
                continue;
            }
            throw new IllegalArgumentException("Not a regular file: " + f.getAbsolutePath());
        }
        if (parseonly) {
            System.err.println("# DTD Validation is disabled. Will only check for well-formed XML.");
        }
        if (toCheck.isEmpty()) {
            throw new IllegalArgumentException("No files specified to check.");
        }
        if (!quiet) {
            System.err.println("# " + toCheck.size() + " file(s) to check");
        }
        if ((failCount = new XMLValidator(quiet, parseonly, justCheckBom).check(toCheck)) != 0) {
            System.err.println("# FAIL: " + failCount + " of " + toCheck.size() + " file(s) had errors.");
            System.exit(1);
        } else if (!quiet) {
            System.err.println("# " + toCheck.size() + " file(s) OK");
        }
    }

    private static void addDirectory(File f, final List<File> toCheck) throws IOException {
        for (File s2 : f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                if (arg1.startsWith(".")) {
                    return false;
                }
                File n = new File(arg0, arg1);
                if (n.isDirectory()) {
                    try {
                        XMLValidator.addDirectory(n, toCheck);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.err.println("Error " + e.toString() + " parsing " + arg0.getPath());
                    }
                    return false;
                }
                return arg1.endsWith(".xml");
            }
        })) {
            toCheck.add(s2);
        }
    }

    public int check(List<File> toCheck) {
        return toCheck.parallelStream().mapToInt(f -> this.parse((File)f)).sum();
    }

    private static void usage() {
        System.err.println("usage:  " + XMLValidator.class.getName() + " [ -q ] [ --help ] [ --parseonly ] [ --justCheckBom ] file ...");
        System.err.println("usage:  " + XMLValidator.class.getName() + " [ -q ] [ --help ] [ --parseonly ] [ --justCheckBom ] directory ...");
    }

    public static String filenameToURL(String filename) throws MalformedURLException {
        if (null == filename) {
            return null;
        }
        if (filename.startsWith("file:") || filename.startsWith("http:") || filename.startsWith("ftp:") || filename.startsWith("gopher:") || filename.startsWith("mailto:") || filename.startsWith("news:") || filename.startsWith("telnet:")) {
            return filename;
        }
        File f = new File(filename);
        return f.toURI().toURL().toString();
    }

    public int parse(File f) {
        if (XMLValidator.checkForBOM(f)) {
            return 1;
        }
        if (this.justCheckBom) {
            return 0;
        }
        String filename = PathUtilities.getNormalizedPathString(f);
        try {
            String docURI = XMLValidator.filenameToURL(filename);
            this.parse(new InputSource(docURI), filename);
            return 0;
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println(f.getPath() + " - fail - " + t);
            return 1;
        }
    }

    Document parse(InputSource docSrc, String filename) {
        Document doc;
        block10: {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            if (!this.parseonly) {
                dfactory.setNamespaceAware(true);
                dfactory.setValidating(true);
            }
            final String filename2 = filename;
            ErrorHandler nullHandler = new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    System.err.println(filename2 + ": Warning: " + e.getMessage());
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    int col = e.getColumnNumber();
                    System.err.println(filename2 + ":" + e.getLineNumber() + (col >= 0 ? ":" + col : "") + ": ERROR: Element " + e.getPublicId() + " is not valid because " + e.getMessage());
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    System.err.println(filename2 + ": ERROR ");
                    throw e;
                }
            };
            doc = null;
            try {
                DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
                docBuilder.setErrorHandler(nullHandler);
                doc = docBuilder.parse(docSrc);
            }
            catch (Throwable se) {
                if (se instanceof SAXParseException) {
                    SAXParseException pe = (SAXParseException)se;
                    int col = pe.getColumnNumber();
                    System.err.println(filename + ":" + pe.getLineNumber() + (col >= 0 ? ":" + col : "") + ": ERROR:" + se.toString());
                } else {
                    System.err.println(filename + ": ERROR:" + se.toString());
                }
                try {
                    throw new RuntimeException(filename + ": XMLComparator not HTML parser!");
                }
                catch (Exception e) {
                    if (filename == null) break block10;
                    try {
                        String tmp;
                        FileReader fr = new FileReader(filename);
                        BufferedReader br = new BufferedReader(fr);
                        StringBuffer buffer = new StringBuffer();
                        while ((tmp = br.readLine()) != null) {
                            buffer.append(tmp);
                            buffer.append("\n");
                        }
                        br.close();
                        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
                        doc = docBuilder.newDocument();
                        Element outElem = doc.createElement("out");
                        Text textNode = doc.createTextNode(buffer.toString());
                        outElem.appendChild(textNode);
                        doc.appendChild(outElem);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkForBOM(File f) {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(f);
            byte[] bytes = new byte[3];
            if (fis.read(bytes) != 3) return false;
            if (bytes[0] != -17) return false;
            if (bytes[1] != -69) return false;
            if (bytes[2] != -65) return false;
            System.err.println(f.getPath() + ": ERROR: contains UTF-8 BOM (shouldn't happen in CLDR XML files)");
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

