/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.ibm.icu.util.ULocale;
import org.unicode.cldr.draft.keyboard.KeyboardSettings;

public final class KeyboardId {
    private final ULocale locale;
    private final Platform platform;
    private final ImmutableList<String> attributes;
    private static final Joiner DASH_JOINER = Joiner.on("-");

    private KeyboardId(ULocale locale, Platform platform, ImmutableList<String> attributes) {
        this.locale = Preconditions.checkNotNull(locale);
        this.platform = Preconditions.checkNotNull(platform);
        this.attributes = Preconditions.checkNotNull(attributes);
    }

    public static KeyboardId of(ULocale locale, Platform platform, ImmutableList<String> attributes) {
        return new KeyboardId(locale, platform, attributes);
    }

    public static KeyboardId fromString(String keyboardLocale) {
        int tExtensionLocation = keyboardLocale.indexOf("-t-k0-");
        Preconditions.checkArgument(tExtensionLocation != -1, keyboardLocale);
        String localeString = keyboardLocale.substring(0, tExtensionLocation);
        ULocale locale = ULocale.forLanguageTag(localeString);
        String[] attributeStrings = keyboardLocale.substring(tExtensionLocation + 6).split("-");
        Preconditions.checkArgument(attributeStrings.length > 0, keyboardLocale);
        Platform platform = Platform.fromString(attributeStrings[0]);
        ImmutableList<String> attributes = attributeStrings.length > 1 ? ImmutableList.copyOf(attributeStrings).subList(1, attributeStrings.length) : ImmutableList.of();
        return new KeyboardId(locale, platform, attributes);
    }

    public ULocale locale() {
        return this.locale;
    }

    public Platform platform() {
        return this.platform;
    }

    public ImmutableList<String> attributes() {
        return this.attributes;
    }

    public String toString() {
        ImmutableList.Builder components = ImmutableList.builder();
        components.add(this.locale.toString().replace("_", "-"));
        components.add("t-k0");
        components.add(this.platform.toString());
        components.addAll(FluentIterable.from(this.attributes).transform(Functions.toStringFunction()));
        return DASH_JOINER.join(components.build());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KeyboardId) {
            KeyboardId other = (KeyboardId)o;
            return Objects.equal(this.locale, other.locale) && Objects.equal((Object)this.platform, (Object)other.platform) && Objects.equal(this.attributes, other.attributes);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.locale, this.platform, this.attributes});
    }

    public static enum Platform {
        ANDROID(4.4f, KeyboardSettings.of(KeyboardSettings.FallbackSetting.NONE, KeyboardSettings.TransformFailureSetting.NONE, KeyboardSettings.TransformPartialSetting.NONE)),
        CHROMEOS(33.0f, KeyboardSettings.of(KeyboardSettings.FallbackSetting.BASE, KeyboardSettings.TransformFailureSetting.OMIT, KeyboardSettings.TransformPartialSetting.HIDE)),
        OSX(10.9f, KeyboardSettings.of(KeyboardSettings.FallbackSetting.BASE, KeyboardSettings.TransformFailureSetting.EMIT, KeyboardSettings.TransformPartialSetting.SHOW)),
        WINDOWS(10.0f, KeyboardSettings.of(KeyboardSettings.FallbackSetting.OMIT, KeyboardSettings.TransformFailureSetting.EMIT, KeyboardSettings.TransformPartialSetting.HIDE));

        private final float version;
        private final KeyboardSettings settings;

        private Platform(float version, KeyboardSettings settings) {
            this.version = version;
            this.settings = Preconditions.checkNotNull(settings);
            Preconditions.checkArgument(version >= 0.0f);
        }

        public double version() {
            return this.version;
        }

        public KeyboardSettings settings() {
            return this.settings;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        private static Platform fromString(String platform) {
            Platform value = Platform.valueOf(platform.toUpperCase());
            Preconditions.checkArgument(platform != null, platform);
            return value;
        }
    }
}

