/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.time.Instant;
import java.util.Arrays;
import org.unicode.cldr.draft.keyboard.Keyboard;
import org.unicode.cldr.draft.keyboard.KeyboardId;
import org.unicode.cldr.draft.keyboard.out.KeyboardToXml;
import org.unicode.cldr.draft.keyboard.out.KeycodeMapToXml;
import org.unicode.cldr.draft.keyboard.windows.KlcParser;

public final class KeyboardTool {
    public static void main(String[] args) throws IOException {
        System.out.println(Arrays.toString(args));
        long timestamp = Instant.now().getEpochSecond();
        String output = args[0] + "/" + timestamp;
        File outputFolder = new File(output);
        KeyboardTool.parseWindowsKeyboards(args[1], outputFolder);
    }

    private static void parseWindowsKeyboards(String inputFolder, File outputFolder) throws IOException {
        File windowsKeyboardsDirectory = new File(inputFolder);
        File windowsOutputFolder = new File(outputFolder + "/windows");
        windowsOutputFolder.mkdirs();
        for (File keyboardLayout : windowsKeyboardsDirectory.listFiles(KlcFilenameFilter.INSTANCE)) {
            System.out.println("Parsing " + keyboardLayout);
            String contents = Files.toString(keyboardLayout, Charsets.UTF_16);
            ImmutableList<Keyboard> keyboards = KlcParser.parseLayout(contents);
            for (Keyboard keyboard : keyboards) {
                String id = keyboard.keyboardId().toString();
                File outputFile = new File(windowsOutputFolder + "/" + id + ".xml");
                StringWriter keyboardStringWriter = new StringWriter();
                KeyboardToXml.writeToXml(keyboard, keyboardStringWriter);
                FileWriter keyboardFileWriter = new FileWriter(outputFile);
                keyboardFileWriter.write(KeyboardTool.doLastMinuteFixesToXml(keyboardStringWriter.toString()));
                keyboardFileWriter.close();
                System.out.println("   Writing to " + outputFile);
            }
        }
        System.out.println("Writing _platform.xml");
        FileWriter platformFileWriter = new FileWriter(windowsOutputFolder + "/_platform.xml");
        KeycodeMapToXml.writeToXml(KlcParser.KEYCODE_MAP, KeyboardId.Platform.WINDOWS, platformFileWriter);
        if (KlcParser.KEYBOARD_ID_MAP.unmatchedIds().size() != 0) {
            System.out.println("Found the following keyboards with no id (add them to windows-locales.csv file):");
            System.out.println(KlcParser.KEYBOARD_ID_MAP.unmatchedIds());
        }
    }

    private static String doLastMinuteFixesToXml(String ouputString) {
        String cleansedString = ouputString.replace("\"'\"", "\"&apos;\"");
        return cleansedString;
    }

    private static enum KlcFilenameFilter implements FilenameFilter
    {
        INSTANCE;


        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".klc");
        }
    }
}

