/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.keyboard.ModifierKey;
import org.unicode.cldr.draft.keyboard.ModifierKeyCombination;

public final class ModifierKeySimplifier {
    private static final ImmutableMap<String, String> INPUT_COMBINATION_TO_INTERNAL = ImmutableMap.builder().put("---", "0??").put("--1", "?01").put("--?", "?0?").put("-1-", "?10").put("-11", "?11").put("-1?", "?1?").put("-?-", "??0").put("-?1", "??1").put("-??", "???").put("1--", "1??").put("1-1", "??1").put("1-?", "1??").put("11-", "?1?").put("111", "?11").put("11?", "?1?").put("1?-", "1??").put("1?1", "??1").put("1??", "1??").put("?--", "???").put("?-1", "??1").put("?-?", "?0?").put("?1-", "?1?").put("?11", "?11").put("?1?", "?1?").put("??-", "??0").put("??1", "??1").put("???", "???").build();
    private static final ImmutableTable<String, String, String> COMBINATIONS_TO_SIMPLIFCATION = ImmutableTable.builder().put("1??", "0??", "???").put("?10", "0??", "??0").put("?1?", "0??", "%").put("??0", "0??", "??0").put("?11", "0??", "%").put("?01", "0??", "?0?").put("??1", "0??", "%").put("?0?", "0??", "?0?").put("???", "0??", "???").put("?10", "1??", "1??").put("?1?", "1??", "1??").put("??0", "1??", "???").put("?11", "1??", "1??").put("?01", "1??", "1??").put("??1", "1??", "1??").put("?0?", "1??", "???").put("???", "1??", "???").put("?1?", "?10", "?1?").put("??0", "?10", "??0").put("?11", "?10", "?1?").put("?01", "?10", "%").put("??1", "?10", "%").put("?0?", "?10", "%").put("???", "?10", "???").put("??0", "?1?", "%").put("?11", "?1?", "?1?").put("?01", "?1?", "%").put("??1", "?1?", "1??").put("?0?", "?1?", "???").put("???", "?1?", "???").put("?11", "??0", "%").put("?01", "??0", "%").put("??1", "??0", "???").put("?0?", "??0", "%").put("???", "??0", "???").put("?01", "?11", "??1").put("??1", "?11", "??1").put("?0?", "?11", "%").put("???", "?11", "???").put("??1", "?01", "??1").put("?0?", "?01", "?0?").put("???", "?01", "???").put("?0?", "??1", "%").put("???", "??1", "???").put("???", "?0?", "???").build();
    private static Joiner PLUS_JOINER = Joiner.on('+');

    public static ModifierKeyCombination simplifyInput(Set<ModifierKey> onKeys, Set<ModifierKey> dontCareKeys) {
        Preconditions.checkArgument(Sets.intersection(onKeys, dontCareKeys).size() == 0);
        ImmutableSet.Builder<ModifierKey> onKeysBuilder = ImmutableSet.builder();
        ImmutableSet.Builder<ModifierKey> offKeysBuilder = ImmutableSet.builder();
        for (ModifierKey parentKey : ModifierKey.parents()) {
            StringBuilder inputRepresentation = new StringBuilder();
            inputRepresentation.append(ModifierKeySimplifier.getInputKeyState(parentKey, onKeys, dontCareKeys));
            for (ModifierKey child : parentKey.children()) {
                inputRepresentation.append(ModifierKeySimplifier.getInputKeyState(child, onKeys, dontCareKeys));
            }
            String result = INPUT_COMBINATION_TO_INTERNAL.get(inputRepresentation.toString());
            Preconditions.checkNotNull(result, "No internal mapping for %s", (Object)inputRepresentation);
            ModifierKeySimplifier.addInternalRepresentationFromString(parentKey, result, onKeysBuilder, offKeysBuilder);
        }
        for (ModifierKey singleKey : ModifierKey.singles()) {
            if (onKeys.contains((Object)singleKey)) {
                onKeysBuilder.add((Object)singleKey);
                continue;
            }
            if (dontCareKeys.contains((Object)singleKey)) continue;
            offKeysBuilder.add((Object)singleKey);
        }
        return ModifierKeyCombination.of((ImmutableSet<ModifierKey>)onKeysBuilder.build(), (ImmutableSet<ModifierKey>)offKeysBuilder.build());
    }

    private static char getInputKeyState(ModifierKey modifierKey, Set<ModifierKey> onKeys, Set<ModifierKey> dontCareKeys) {
        return (char)(onKeys.contains((Object)modifierKey) ? 49 : (dontCareKeys.contains((Object)modifierKey) ? 63 : 45));
    }

    public static String simplifyToString(ModifierKeyCombination combination) {
        ImmutableSet<ModifierKey> onKeys = combination.onKeys();
        ImmutableSet<ModifierKey> offKeys = combination.offKeys();
        TreeSet<ModifierKey> onKeysForOutput = Sets.newTreeSet();
        TreeSet<ModifierKey> dontCareKeysForOutput = Sets.newTreeSet();
        for (ModifierKey parentKey : ModifierKey.parents()) {
            String result = ModifierKeySimplifier.getStringFromInternalRepresentation(parentKey, onKeys, offKeys);
            char parentState = result.charAt(0);
            char leftChildState = result.charAt(1);
            char rightChildState = result.charAt(2);
            if (leftChildState == '?' && rightChildState == '?') {
                if (parentState == '1') {
                    onKeysForOutput.add(parentKey);
                    continue;
                }
                if (parentState != '?') continue;
                dontCareKeysForOutput.add(parentKey);
                continue;
            }
            ImmutableList<ModifierKey> children = parentKey.children();
            if (leftChildState == '1') {
                onKeysForOutput.add((ModifierKey)((Object)children.get(0)));
            } else if (leftChildState == '?') {
                dontCareKeysForOutput.add((ModifierKey)((Object)children.get(0)));
            }
            if (rightChildState == '1') {
                onKeysForOutput.add((ModifierKey)((Object)children.get(1)));
                continue;
            }
            if (rightChildState != '?') continue;
            dontCareKeysForOutput.add((ModifierKey)((Object)children.get(1)));
        }
        for (ModifierKey singleKey : ModifierKey.singles()) {
            if (onKeys.contains((Object)singleKey)) {
                onKeysForOutput.add(singleKey);
                continue;
            }
            if (offKeys.contains((Object)singleKey)) continue;
            dontCareKeysForOutput.add(singleKey);
        }
        String onKeysString = PLUS_JOINER.join(onKeysForOutput);
        ArrayList<String> dontCareKeysList = Lists.newArrayList();
        for (ModifierKey dontCareKey : dontCareKeysForOutput) {
            dontCareKeysList.add(dontCareKey.toString() + "?");
        }
        String dontCareKeysString = PLUS_JOINER.join(dontCareKeysList);
        return dontCareKeysString.isEmpty() ? onKeysString : (onKeysString.isEmpty() ? dontCareKeysString : PLUS_JOINER.join(onKeysString, dontCareKeysString, new Object[0]));
    }

    private static char getInternalKeyState(ModifierKey modifierKey, Set<ModifierKey> onKeys, Set<ModifierKey> offKeys) {
        return (char)(onKeys.contains((Object)modifierKey) ? 49 : (offKeys.contains((Object)modifierKey) ? 48 : 63));
    }

    public static ImmutableSet<ModifierKeyCombination> simplifySet(Set<ModifierKeyCombination> combinations) {
        Set<ModifierKeyCombination> finalCombinations = Sets.newHashSet(combinations);
        int sizeChange = Integer.MAX_VALUE;
        while (sizeChange != 0) {
            int initialSize = finalCombinations.size();
            finalCombinations = ModifierKeySimplifier.simplifyCombinationsOnePass(finalCombinations);
            sizeChange = initialSize - finalCombinations.size();
        }
        return ImmutableSet.copyOf(finalCombinations);
    }

    private static Set<ModifierKeyCombination> simplifyCombinationsOnePass(Set<ModifierKeyCombination> combinations) {
        if (combinations.size() < 2) {
            return combinations;
        }
        Iterator<ModifierKeyCombination> iterator = Sets.newTreeSet(combinations).iterator();
        HashSet<ModifierKeyCombination> finalCombinations = Sets.newHashSet();
        ModifierKeyCombination combination1 = iterator.next();
        while (iterator.hasNext()) {
            ModifierKeyCombination combination2 = iterator.next();
            ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifyTwoCombinations(combination1, combination2);
            if (result.size() == 1) {
                combination1 = (ModifierKeyCombination)result.iterator().next();
                continue;
            }
            finalCombinations.add(combination1);
            combination1 = combination2;
        }
        finalCombinations.add(combination1);
        return finalCombinations;
    }

    private static ImmutableSet<ModifierKeyCombination> simplifyTwoCombinations(ModifierKeyCombination combination1, ModifierKeyCombination combination2) {
        String combination2States;
        Sets.SetView<ModifierKey> offKeyDifferences;
        if (combination1.equals(combination2)) {
            return ImmutableSet.of(combination1);
        }
        Sets.SetView<ModifierKey> onKeyDifferences = Sets.symmetricDifference(combination1.onKeys(), combination2.onKeys());
        if (!ModifierKeySimplifier.keysAreRelated(onKeyDifferences, offKeyDifferences = Sets.symmetricDifference(combination1.offKeys(), combination2.offKeys()))) {
            return ImmutableSet.of(combination1, combination2);
        }
        ModifierKey key = null;
        key = onKeyDifferences.size() > 0 ? (ModifierKey)((Object)onKeyDifferences.iterator().next()) : (ModifierKey)((Object)offKeyDifferences.iterator().next());
        ModifierKey parentKey = key.parent();
        Sets.SetView<ModifierKey> onKeysIntersect = Sets.intersection(combination1.onKeys(), combination2.onKeys());
        EnumSet<ModifierKey> onKeys = onKeysIntersect.isEmpty() ? EnumSet.noneOf(ModifierKey.class) : EnumSet.copyOf(onKeysIntersect);
        Sets.SetView<ModifierKey> offKeysIntersect = Sets.intersection(combination1.offKeys(), combination2.offKeys());
        EnumSet<ModifierKey> offKeys = offKeysIntersect.isEmpty() ? EnumSet.noneOf(ModifierKey.class) : EnumSet.copyOf(offKeysIntersect);
        String combination1States = ModifierKeySimplifier.getStringFromInternalRepresentation(parentKey, combination1.onKeys(), combination1.offKeys());
        String result = (String)COMBINATIONS_TO_SIMPLIFCATION.get(combination1States, combination2States = ModifierKeySimplifier.getStringFromInternalRepresentation(parentKey, combination2.onKeys(), combination2.offKeys()));
        if (result == null) {
            result = (String)COMBINATIONS_TO_SIMPLIFCATION.get(combination2States, combination1States);
        }
        Preconditions.checkNotNull(result, "Unknown combination %s", (Object)(combination1States + "," + combination2States));
        if (result.equals("%")) {
            return ImmutableSet.of(combination1, combination2);
        }
        ImmutableSet.Builder<ModifierKey> onKeysBuilder = ImmutableSet.builder();
        ImmutableSet.Builder<ModifierKey> offKeysBuilder = ImmutableSet.builder();
        ModifierKeySimplifier.addInternalRepresentationFromString(parentKey, result, onKeysBuilder, offKeysBuilder);
        onKeysBuilder.addAll(onKeys);
        offKeysBuilder.addAll(offKeys);
        return ImmutableSet.of(ModifierKeyCombination.of((ImmutableSet<ModifierKey>)onKeysBuilder.build(), (ImmutableSet<ModifierKey>)offKeysBuilder.build()));
    }

    private static boolean keysAreRelated(Set<ModifierKey> onKeys, Set<ModifierKey> offKeys) {
        EnumSet<ModifierKey> allKeys = EnumSet.noneOf(ModifierKey.class);
        allKeys.addAll(onKeys);
        allKeys.addAll(offKeys);
        ModifierKey testKey = (ModifierKey)((Object)allKeys.iterator().next());
        allKeys.remove((Object)testKey);
        allKeys.remove((Object)testKey.parent());
        allKeys.remove((Object)testKey.sibling());
        allKeys.removeAll(testKey.children());
        return allKeys.size() == 0;
    }

    private static String getStringFromInternalRepresentation(ModifierKey parentKey, Set<ModifierKey> onKeys, Set<ModifierKey> offKeys) {
        StringBuilder internalRepresentationBuilder = new StringBuilder();
        internalRepresentationBuilder.append(ModifierKeySimplifier.getInternalKeyState(parentKey, onKeys, offKeys));
        ImmutableList<ModifierKey> children = parentKey.children();
        if (children.size() == 0) {
            internalRepresentationBuilder.append("??");
        } else {
            internalRepresentationBuilder.append(ModifierKeySimplifier.getInternalKeyState((ModifierKey)((Object)children.get(0)), onKeys, offKeys));
            internalRepresentationBuilder.append(ModifierKeySimplifier.getInternalKeyState((ModifierKey)((Object)children.get(1)), onKeys, offKeys));
        }
        return internalRepresentationBuilder.toString();
    }

    private static void addInternalRepresentationFromString(ModifierKey parentKey, String modifierKeyState, ImmutableSet.Builder<ModifierKey> onKeysOut, ImmutableSet.Builder<ModifierKey> offKeysOut) {
        Preconditions.checkArgument(modifierKeyState.length() == 3, modifierKeyState);
        ImmutableList<ModifierKey> children = parentKey.children();
        ArrayList<ModifierKey> keys = children.isEmpty() ? Lists.newArrayList(parentKey, parentKey, parentKey) : Lists.newArrayList(parentKey, (ModifierKey)((Object)children.get(0)), (ModifierKey)((Object)children.get(1)));
        for (int i = 0; i < modifierKeyState.length(); ++i) {
            char state = modifierKeyState.charAt(i);
            ModifierKey key = (ModifierKey)((Object)keys.get(i));
            if (state == '1') {
                onKeysOut.add((Object)key);
                continue;
            }
            if (state != '0') continue;
            offKeysOut.add((Object)key);
        }
    }

    private ModifierKeySimplifier() {
    }
}

