/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard.test;

import com.ibm.icu.dev.test.TestFmwk;
import org.unicode.cldr.draft.keyboard.IsoLayoutPosition;

public class IsoLayoutPositionTest
extends TestFmwk {
    public void testForPosition() {
        IsoLayoutPosition position = IsoLayoutPosition.forPosition('C', 6);
        this.assertEquals("", (Object)IsoLayoutPosition.C06, (Object)position);
    }

    public void testForPositionWithInvalidRow() {
        try {
            IsoLayoutPosition.forPosition('F', 6);
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testForPositionWithInvalidColumn() {
        try {
            IsoLayoutPosition.forPosition('A', 14);
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testForPositionWithMissingEntry() {
        try {
            IsoLayoutPosition.forPosition('A', 9);
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToStringWithLeadingZero() {
        String string = IsoLayoutPosition.A02.toString();
        this.assertEquals("", "A02", string);
    }

    public void testIsoLayoutPosition() {
        IsoLayoutPosition position = IsoLayoutPosition.D01;
        this.assertEquals("", "Q", position.englishKeyName());
        this.assertEquals("", 68L, position.row());
        this.assertEquals("", 1L, position.column());
    }

    public void testIsoLayoutPositionForNonUsKey() {
        IsoLayoutPosition position = IsoLayoutPosition.B00;
        this.assertEquals("", "(key to left of Z)", position.englishKeyName());
        this.assertEquals("", 66L, position.row());
        this.assertEquals("", 0L, position.column());
    }
}

