/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard.test;

import com.google.common.collect.ImmutableList;
import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.util.ULocale;
import org.unicode.cldr.draft.keyboard.KeyboardId;

public class KeyboardIdTest
extends TestFmwk {
    public void testKeyboardId() {
        KeyboardId id = KeyboardId.fromString("de-CH-t-k0-windows-extended-var");
        this.assertEquals("", ULocale.forLanguageTag("de-CH"), id.locale());
        this.assertEquals("", (Object)KeyboardId.Platform.WINDOWS, (Object)id.platform());
        ImmutableList<String> attributes = ImmutableList.of("extended", "var");
        this.assertEquals("", attributes, id.attributes());
    }

    public void testFromStringForSimple() {
        KeyboardId keyboardLocale = KeyboardId.fromString("bn-t-k0-windows");
        this.assertEquals("", "bn-t-k0-windows", keyboardLocale.toString());
    }

    public void testFromStringForComplex() {
        KeyboardId keyboardLocale = KeyboardId.fromString("es-US-t-k0-android-768dpi.xml");
        this.assertEquals("", "es-US-t-k0-android-768dpi.xml", keyboardLocale.toString());
    }

    public void testFromStringForInvalid() {
        try {
            KeyboardId.fromString("en-US-android");
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEqualsTrue() {
        KeyboardId id1 = KeyboardId.fromString("de-CH-t-k0-windows-extended-var");
        KeyboardId id2 = KeyboardId.fromString("de-CH-t-k0-windows-extended-var");
        this.assertTrue("", id1.equals(id2));
        this.assertTrue("", id1.hashCode() == id2.hashCode());
    }

    public void testEqualsFalse() {
        KeyboardId id1 = KeyboardId.fromString("de-CH-t-k0-windows-extended-var");
        KeyboardId id2 = KeyboardId.fromString("es-US-t-k0-android-768dpi.xml");
        this.assertFalse("", id1.equals(id2));
    }
}

