/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard.test;

import com.google.common.collect.ImmutableSet;
import com.ibm.icu.dev.test.TestFmwk;
import java.util.EnumSet;
import org.unicode.cldr.draft.keyboard.ModifierKey;
import org.unicode.cldr.draft.keyboard.ModifierKeyCombination;
import org.unicode.cldr.draft.keyboard.ModifierKeySimplifier;

public class ModifierKeySimplifierTest
extends TestFmwk {
    private static ImmutableSet<ModifierKey> EMPTY_SET = ImmutableSet.of();

    public void testSimplifyInputWithOverlappingSets() {
        try {
            ModifierKeySimplifier.simplifyInput(ImmutableSet.of(ModifierKey.ALT_LEFT, ModifierKey.CAPSLOCK), ImmutableSet.of(ModifierKey.ALT_LEFT));
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSimplifyInputWithBase() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnKeys(EMPTY_SET);
        this.assertTrue("", combination.onKeys().isEmpty());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.ALT, ModifierKey.OPTION, ModifierKey.SHIFT, ModifierKey.COMMAND, ModifierKey.CAPSLOCK, new ModifierKey[0]);
        this.assertEquals("", offKeys, combination.offKeys());
    }

    public void testSimplifyInputWithParentOn() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.ALT, ModifierKey.CAPSLOCK));
        ImmutableSet<ModifierKey> onKeys = ImmutableSet.of(ModifierKey.ALT, ModifierKey.CAPSLOCK);
        this.assertEquals("", onKeys, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.OPTION, ModifierKey.SHIFT, ModifierKey.COMMAND);
        this.assertEquals("", offKeys, combination.offKeys());
    }

    public void testSimplifyInputWithChildOn() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.OPTION_LEFT, ModifierKey.COMMAND));
        ImmutableSet<ModifierKey> onKeys = ImmutableSet.of(ModifierKey.OPTION_LEFT, ModifierKey.COMMAND);
        this.assertEquals("", onKeys, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.ALT, ModifierKey.CONTROL, ModifierKey.OPTION_RIGHT, ModifierKey.SHIFT, ModifierKey.CAPSLOCK);
        this.assertEquals("", offKeys, combination.offKeys());
    }

    public void testSimplifyInputWithBothChildrenOn() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT_LEFT, ModifierKey.SHIFT_RIGHT));
        ImmutableSet<ModifierKey> onKeys = ImmutableSet.of(ModifierKey.SHIFT_LEFT, ModifierKey.SHIFT_RIGHT);
        this.assertEquals("", onKeys, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.ALT, ModifierKey.CONTROL, ModifierKey.OPTION, ModifierKey.CAPSLOCK, ModifierKey.COMMAND);
        this.assertEquals("", offKeys, combination.offKeys());
    }

    public void testSimplifyInputWithParentDontCare() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(EMPTY_SET, ImmutableSet.of(ModifierKey.SHIFT));
        this.assertEquals("", EMPTY_SET, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.ALT, ModifierKey.CONTROL, ModifierKey.OPTION, ModifierKey.CAPSLOCK, ModifierKey.COMMAND);
        this.assertEquals("", offKeys, combination.offKeys());
    }

    public void testSimplifyInputWithParentDontCareAndChildOn() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.ALT_LEFT), ImmutableSet.of(ModifierKey.ALT));
        ImmutableSet<ModifierKey> onKeys = ImmutableSet.of(ModifierKey.ALT_LEFT);
        this.assertEquals("", onKeys, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.CONTROL, ModifierKey.OPTION, ModifierKey.CAPSLOCK, ModifierKey.COMMAND);
        this.assertEquals("", offKeys, combination.offKeys());
    }

    public void testSimplifyInputWithChildDontCare() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(EMPTY_SET, ImmutableSet.of(ModifierKey.CONTROL_RIGHT));
        this.assertEquals("", EMPTY_SET, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.CONTROL_LEFT, ModifierKey.ALT, ModifierKey.OPTION, ModifierKey.CAPSLOCK, ModifierKey.COMMAND, new ModifierKey[0]);
        this.assertEquals("", offKeys, combination.offKeys());
    }

    public void testSimplifyInputWithAllThreeKeysPresent() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.CONTROL_LEFT), ImmutableSet.of(ModifierKey.CONTROL_RIGHT));
        ImmutableSet<ModifierKey> onKeys = ImmutableSet.of(ModifierKey.CONTROL_LEFT);
        this.assertEquals("", onKeys, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT, ModifierKey.OPTION, ModifierKey.CAPSLOCK, ModifierKey.COMMAND);
        this.assertEquals("", offKeys, combination.offKeys());
    }

    public void testSimplifyToStringWithBase() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnKeys(EMPTY_SET);
        this.assertEquals("", "", ModifierKeySimplifier.simplifyToString(combination));
    }

    public void testSimplifyToStringWithParentOn() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.ALT, ModifierKey.CAPSLOCK));
        this.assertEquals("", "alt+caps", ModifierKeySimplifier.simplifyToString(combination));
    }

    public void testSimplifyToStringWithChildOn() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.OPTION_LEFT, ModifierKey.COMMAND));
        this.assertEquals("", "cmd+optL", ModifierKeySimplifier.simplifyToString(combination));
    }

    public void testSimplifyToStringWithBothChildrenOn() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT_LEFT, ModifierKey.SHIFT_RIGHT));
        this.assertEquals("", "shiftL+shiftR", ModifierKeySimplifier.simplifyToString(combination));
    }

    public void testSimplifyToStringWithParentDontCare() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(EMPTY_SET, ImmutableSet.of(ModifierKey.SHIFT));
        this.assertEquals("", "shift?", ModifierKeySimplifier.simplifyToString(combination));
    }

    public void testSimplifyToStringWithChildDontCareAndOn() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.SHIFT_LEFT), ImmutableSet.of(ModifierKey.SHIFT_RIGHT));
        this.assertEquals("", "shiftL+shiftR?", ModifierKeySimplifier.simplifyToString(combination));
    }

    public void testSimplifyToStringWithChildDontCare() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(EMPTY_SET, ImmutableSet.of(ModifierKey.OPTION_RIGHT));
        this.assertEquals("", "optR?", ModifierKeySimplifier.simplifyToString(combination));
    }

    public void testSimplifyToStringWithComplexCombination() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.ALT_RIGHT, ModifierKey.COMMAND), ImmutableSet.of(ModifierKey.OPTION, ModifierKey.CAPSLOCK, ModifierKey.SHIFT_LEFT));
        this.assertEquals("", "cmd+ctrl+altR+opt?+caps?+shiftL?", ModifierKeySimplifier.simplifyToString(combination));
    }

    public void testSimplifySetWithIdentical() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.CAPSLOCK), ImmutableSet.of(ModifierKey.SHIFT_RIGHT));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.CAPSLOCK), ImmutableSet.of(ModifierKey.SHIFT_RIGHT));
        ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifySet(ImmutableSet.of(combination1, combination2));
        this.assertEquals("", 1L, result.size());
        this.assertEquals("", ImmutableSet.of(combination1), result);
    }

    public void testSimplifySetWithSingleOnKey() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT));
        ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifySet(ImmutableSet.of(combination1, combination2));
        ModifierKeyCombination resultCombination = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.CAPSLOCK));
        this.assertEquals("", ImmutableSet.of(resultCombination), result);
    }

    public void testSimplifySetWithParentOnKey() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CONTROL));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT));
        ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifySet(ImmutableSet.of(combination1, combination2));
        ModifierKeyCombination resultCombination = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.CONTROL));
        this.assertEquals("", ImmutableSet.of(resultCombination), result);
    }

    public void testSimplifySetWithSingleOffKey() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.COMMAND));
        ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifySet(ImmutableSet.of(combination1, combination2));
        ModifierKeyCombination resultCombination = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.COMMAND));
        this.assertEquals("", ImmutableSet.of(resultCombination), result);
    }

    public void testSimplifySetWithParentOffKey() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.OPTION));
        ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifySet(ImmutableSet.of(combination1, combination2));
        ModifierKeyCombination resultCombination = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.OPTION));
        this.assertEquals("", ImmutableSet.of(resultCombination), result);
    }

    public void testSimplifySetWithChildOnKey() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CONTROL_LEFT));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT));
        ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifySet(ImmutableSet.of(combination1, combination2));
        ModifierKeyCombination resultCombination = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.CONTROL_LEFT));
        this.assertEquals("", ImmutableSet.of(resultCombination), result);
    }

    public void testSimplifySetWithChildOffKey() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.CONTROL_LEFT));
        ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifySet(ImmutableSet.of(combination1, combination2));
        ModifierKeyCombination resultCombination = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.CONTROL_LEFT));
        this.assertEquals("", ImmutableSet.of(resultCombination), result);
    }

    public void testSimplifySetWithTwoDifferentChildrenDontCare() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.CONTROL_RIGHT));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.CONTROL_LEFT));
        ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifySet(ImmutableSet.of(combination1, combination2));
        this.assertEquals("", ImmutableSet.of(combination1, combination2), result);
    }

    public void testSimplifySetWithTwoDifferentChildrenOn() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CONTROL_RIGHT));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CONTROL_LEFT));
        ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifySet(ImmutableSet.of(combination1, combination2));
        this.assertEquals("", ImmutableSet.of(combination1, combination2), result);
    }

    public void testSimplifySetWithParentDontCareAndChildOn() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.OPTION));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.OPTION_RIGHT));
        ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifySet(ImmutableSet.of(combination1, combination2));
        ModifierKeyCombination resultCombination = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.OPTION));
        this.assertEquals("", ImmutableSet.of(resultCombination), result);
    }

    public void testSimplifySetWithParentDontCareAndChildDontCare() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.OPTION));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.OPTION_RIGHT));
        ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifySet(ImmutableSet.of(combination1, combination2));
        ModifierKeyCombination resultCombination = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.OPTION));
        this.assertTrue("", result.contains(resultCombination));
    }

    public void testSimplifySetWithNoSimplification() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.CONTROL, ModifierKey.SHIFT, ModifierKey.CAPSLOCK), EnumSet.of(ModifierKey.OPTION));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnAndDontCareKeys(EnumSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT), EnumSet.of(ModifierKey.COMMAND));
        ImmutableSet<ModifierKeyCombination> result = ModifierKeySimplifier.simplifySet(ImmutableSet.of(combination1, combination2));
        this.assertEquals("", ImmutableSet.of(combination1, combination2), result);
    }
}

