/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestCldr
extends TestFmwk {
    static boolean DEBUG = false;
    SAXParser SAX;
    static String MATCH;
    String directory;
    Set<String> allLocales = new TreeSet<String>();
    static Transliterator toUnicode;
    Map<String, Handler> RegisteredHandlers = new HashMap<String, Handler>();
    static TimeZone utc;
    static DateFormat iso;
    static int[] DateFormatValues;
    static String[] DateFormatNames;
    static String[] NumberNames;
    static UnicodeSet controlsAndSpace;
    DefaultHandler DEFAULT_HANDLER;

    public TestCldr() {
        iso.setTimeZone(utc);
        this.addHandler("collation", new Handler(){

            @Override
            public void handleResult(ULocale currentLocale, String value) {
                Collator col = Collator.getInstance(currentLocale);
                String lastLine = "";
                int count = 0;
                int pos = 0;
                while (pos < value.length()) {
                    int nextPos = value.indexOf(10, pos);
                    if (nextPos < 0) {
                        nextPos = value.length();
                    }
                    String line = value.substring(pos, nextPos);
                    if ((line = TestCldr.remove(line, controlsAndSpace)).trim().length() != 0) {
                        int comp = col.compare(lastLine, line);
                        if (comp > 0) {
                            ++this.failures;
                            TestCldr.this.errln("\tLine " + (count + 1) + "\tFailure: " + TestCldr.showString(lastLine) + " should be leq " + TestCldr.showString(line));
                        } else if (DEBUG) {
                            TestCldr.this.logln("OK: " + line);
                        }
                        lastLine = line;
                    }
                    pos = nextPos + 1;
                    ++count;
                }
            }
        });
        this.addHandler("number", new Handler(){
            String numberType = null;

            @Override
            public void handleResult(ULocale locale, String result) {
                NumberFormat nf = null;
                double v = Double.NaN;
                block12: for (AttributeName attributeName : this.settings.keySet()) {
                    String attributeValue = (String)this.settings.get((Object)attributeName);
                    switch (attributeName) {
                        case input: {
                            v = Double.parseDouble(attributeValue);
                            continue block12;
                        }
                        case draft: {
                            this.approved = attributeValue.contains("approved");
                            continue block12;
                        }
                        case numberType: {
                            this.numberType = attributeValue;
                            int index = this.lookupValue(attributeValue, NumberNames);
                            if (DEBUG) {
                                TestCldr.this.logln("Getting number format for " + locale);
                            }
                            switch (index) {
                                case 0: {
                                    nf = NumberFormat.getInstance(locale);
                                    continue block12;
                                }
                                case 1: {
                                    nf = NumberFormat.getIntegerInstance(locale);
                                    continue block12;
                                }
                                case 2: {
                                    nf = NumberFormat.getNumberInstance(locale);
                                    continue block12;
                                }
                                case 3: {
                                    nf = NumberFormat.getPercentInstance(locale);
                                    continue block12;
                                }
                                case 4: {
                                    nf = NumberFormat.getScientificInstance(locale);
                                    continue block12;
                                }
                            }
                            nf = NumberFormat.getCurrencyInstance(locale);
                            nf.setCurrency(Currency.getInstance(attributeValue));
                            continue block12;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected Attribute Name: " + (Object)((Object)attributeName));
                }
                if (!this.approved) {
                    return;
                }
                String temp = nf.format(v).trim();
                if (!temp.equals(result = result.trim())) {
                    TestCldr.this.errln("Number: Locale: " + locale + ",\tType: " + this.numberType + ",\tCLDR: <" + result + ">, ICU: <" + temp + ">");
                }
            }
        });
        this.addHandler("date", new Handler(){
            int dateFormat = 0;
            int timeFormat = 0;

            @Override
            public void handleResult(ULocale locale, String result) throws ParseException {
                Date date = new Date();
                block6: for (AttributeName attributeName : this.settings.keySet()) {
                    String attributeValue = (String)this.settings.get((Object)attributeName);
                    switch (attributeName) {
                        case input: {
                            date = iso.parse(attributeValue);
                            continue block6;
                        }
                        case dateType: {
                            this.dateFormat = this.lookupValue(attributeValue, DateFormatNames);
                            continue block6;
                        }
                        case timeType: {
                            this.timeFormat = this.lookupValue(attributeValue, DateFormatNames);
                            continue block6;
                        }
                        case draft: {
                            this.approved = attributeValue.contains("approved");
                            continue block6;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected Attribute Name: " + (Object)((Object)attributeName));
                }
                if (!this.approved) {
                    return;
                }
                SimpleDateFormat dt = this.getDateFormat(locale, this.dateFormat, this.timeFormat);
                dt.setTimeZone(utc);
                String temp = dt.format(date).trim();
                result = result.trim();
                if (!temp.equals(result)) {
                    TestCldr.this.errln("DateTime: Locale: " + locale + ",\tDate: " + DateFormatNames[this.dateFormat] + ",\tTime: " + DateFormatNames[this.timeFormat] + ",\tCLDR: <" + result + ">, ICU: <" + temp + ">");
                }
            }

            private SimpleDateFormat getDateFormat(ULocale locale, int dateFormat, int timeFormat) {
                DateFormat dt;
                if (DEBUG) {
                    TestCldr.this.logln("Getting date/time format for " + locale);
                }
                if (DEBUG && "ar_EG".equals(locale.toString())) {
                    System.out.println("debug here");
                }
                if (dateFormat == 0) {
                    dt = DateFormat.getTimeInstance(DateFormatValues[timeFormat], locale);
                    if (DEBUG) {
                        System.out.print("getTimeInstance");
                    }
                } else if (timeFormat == 0) {
                    dt = DateFormat.getDateInstance(DateFormatValues[dateFormat], locale);
                    if (DEBUG) {
                        System.out.print("getDateInstance");
                    }
                } else {
                    dt = DateFormat.getDateTimeInstance(DateFormatValues[dateFormat], DateFormatValues[timeFormat], locale);
                    if (DEBUG) {
                        System.out.print("getDateTimeInstance");
                    }
                }
                if (DEBUG) {
                    System.out.println("\tinput:\t" + dateFormat + ", " + timeFormat + " => " + ((SimpleDateFormat)dt).toPattern());
                }
                return (SimpleDateFormat)dt;
            }
        });
        this.addHandler("zoneFields", new Handler(){
            String date = "";
            String zone = "";
            String pattern = "";

            @Override
            public void handleResult(ULocale locale, String result) throws ParseException {
                for (AttributeName attributeName : this.settings.keySet()) {
                    String attributeValue = (String)this.settings.get((Object)attributeName);
                    switch (attributeName) {
                        case date: {
                            this.date = attributeValue;
                            break;
                        }
                        case field: {
                            this.pattern = attributeValue;
                            break;
                        }
                        case zone: {
                            this.zone = attributeValue;
                            break;
                        }
                        case parse: {
                            break;
                        }
                        case draft: {
                            this.approved = attributeValue.contains("approved");
                        }
                    }
                }
                if (!this.approved) {
                    return;
                }
                Date dateValue = iso.parse(this.date);
                SimpleDateFormat field = new SimpleDateFormat(this.pattern, locale);
                field.setTimeZone(TimeZone.getTimeZone(this.zone));
                String temp = field.format(dateValue).trim();
                result = result.trim();
                if (!temp.equals(result)) {
                    TestCldr.this.errln("Zone Format: Locale: " + locale + ", \tZone: " + this.zone + ", \tDate: " + this.date + ", \tField: " + this.pattern + ", \tCLDR: <" + result + ">, \tICU: <" + temp + ">");
                }
            }
        });
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            this.SAX = factory.newSAXParser();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't start");
        }
        this.DEFAULT_HANDLER = new DefaultHandler(){
            static final boolean DEBUG = false;
            StringBuffer lastChars = new StringBuffer();
            Handler handler;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                try {
                    if (!qName.equals("cldrTest")) {
                        if (qName.equals("result")) {
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                this.handler.set(AttributeName.valueOf(attributes.getQName(i)), attributes.getValue(i));
                            }
                        } else {
                            this.handler = TestCldr.this.getHandler(qName, attributes);
                        }
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                try {
                    if (qName.equals("result")) {
                        this.handler.checkResult(this.lastChars.toString());
                    } else if (qName.length() != 0) {
                        // empty if block
                    }
                    this.lastChars.setLength(0);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                try {
                    String value = new String(ch, start, length);
                    this.lastChars.append(value);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }

            @Override
            public void notationDecl(String name, String publicId, String systemId) throws SAXException {
                TestCldr.this.logln("notationDecl: " + name + ", " + publicId + ", " + systemId);
            }

            @Override
            public void processingInstruction(String target, String data) throws SAXException {
                TestCldr.this.logln("processingInstruction: " + target + ", " + data);
            }

            @Override
            public void skippedEntity(String name) throws SAXException {
                TestCldr.this.logln("skippedEntity: " + name);
            }

            @Override
            public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
                TestCldr.this.logln("unparsedEntityDecl: " + name + ", " + publicId + ", " + systemId + ", " + notationName);
            }
        };
    }

    public static void main(String[] args) throws Exception {
        MATCH = System.getProperty("XML_MATCH");
        if (MATCH == null) {
            MATCH = ".*";
        } else {
            System.out.println("Resetting MATCH:" + MATCH);
        }
        new TestCldr().run(args);
    }

    public void TestScripts() {
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, MATCH, CLDRFile.DraftStatus.contributed);
        ULocale[] locales = ULocale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            ULocale locale = locales[i];
            this.logln(locale.toString());
            int[] scriptNumbers = UScript.getCode(locale);
            TreeSet<String> ICUScripts = new TreeSet<String>();
            for (int j = 0; j < scriptNumbers.length; ++j) {
                ICUScripts.add(UScript.getShortName(scriptNumbers[j]));
            }
            CLDRFile cfile = cldrFactory.make(locale.toString(), true, true);
            UnicodeSet exemplars = this.getExemplarSet(cfile, "").addAll(this.getExemplarSet(cfile, "auxiliary"));
            Set<String> CLDRScripts = this.getScriptsFromUnicodeSet(exemplars);
            if (!CLDRScripts.equals(ICUScripts)) {
                this.errln(locale + "\tscripts not equals.\tCLDR: " + CLDRScripts + ",\tICU: " + ICUScripts);
                continue;
            }
            this.logln("\tCLDR:\t" + CLDRScripts + ",\tICU: " + ICUScripts);
        }
    }

    public Set<String> getScriptsFromUnicodeSet(UnicodeSet exemplars) {
        BitSet scriptBits = new BitSet();
        boolean show = false;
        UnicodeSetIterator it = new UnicodeSetIterator(exemplars);
        while (it.next()) {
            int cp;
            if (show) {
                System.out.println(Integer.toHexString(it.codepoint));
            }
            if (it.codepoint != -1) {
                scriptBits.set(UScript.getScript(it.codepoint));
                continue;
            }
            for (int i = 0; i < it.string.length(); i += UTF16.getCharCount(cp)) {
                cp = UTF16.charAt(it.string, i);
                scriptBits.set(UScript.getScript(cp));
            }
        }
        scriptBits.clear(0);
        scriptBits.clear(1);
        TreeSet<String> scripts = new TreeSet<String>();
        for (int j = 0; j < scriptBits.size(); ++j) {
            if (!scriptBits.get(j)) continue;
            scripts.add(UScript.getShortName(j));
        }
        return scripts;
    }

    public UnicodeSet getExemplarSet(CLDRFile cldrfile, String type) {
        String v;
        if (type.length() != 0) {
            type = "[@type=\"" + type + "\"]";
        }
        if ((v = cldrfile.getStringValue("//ldml/characters/exemplarCharacters" + type)) == null) {
            return new UnicodeSet();
        }
        return new UnicodeSet(v);
    }

    public void TestFiles() throws SAXException, IOException {
        this.directory = CLDRPaths.TEST_DIR;
        TreeSet<String> s2 = new TreeSet<String>();
        this.addLocales(NumberFormat.getAvailableULocales(), s2);
        this.addLocales(DateFormat.getAvailableULocales(), s2);
        this.addLocales(Collator.getAvailableULocales(), s2);
        Matcher m3 = PatternCache.get(MATCH).matcher("");
        for (String locale : s2) {
            if (!m3.reset(locale).matches()) continue;
            this._test(locale);
        }
    }

    public void addLocales(ULocale[] list, Collection<String> s2) {
        LanguageTagParser lsp = new LanguageTagParser();
        for (int i = 0; i < list.length; ++i) {
            this.allLocales.add(list[i].toString());
            String loc = list[i].toString();
            s2.add(lsp.set(loc).getLanguage());
        }
    }

    public void _test(String localeName) throws SAXException, IOException {
        File f = new File(this.directory, localeName + ".xml");
        this.logln("Testing " + PathUtilities.getNormalizedPathString(f));
        this.SAX.parse(f, this.DEFAULT_HANDLER);
    }

    public static String showString(String in) {
        return "\u00ab" + in + "\u00bb (" + toUnicode.transliterate(in) + ")";
    }

    public Handler getHandler(String name, Attributes attributes) {
        Handler result;
        if (DEBUG) {
            this.logln("Creating Handler: " + name);
        }
        if ((result = this.RegisteredHandlers.get(name)) == null) {
            this.logln("Unexpected test type: " + name);
        } else {
            result.setAttributes(attributes);
        }
        return result;
    }

    public void addHandler(String name, Handler handler) {
        handler.setName(name);
        this.RegisteredHandlers.put(name, handler);
    }

    static String remove(String in, UnicodeSet toRemove) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < in.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(in, i);
            if (toRemove.contains(cp)) continue;
            UTF16.append(result, cp);
        }
        return result.toString();
    }

    static {
        toUnicode = Transliterator.getInstance("any-hex");
        utc = TimeZone.getTimeZone("GMT");
        iso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        DateFormatValues = new int[]{-1, 3, 2, 1, 0};
        DateFormatNames = new String[]{"none", "short", "medium", "long", "full"};
        NumberNames = new String[]{"standard", "integer", "decimal", "percent", "scientific", "GBP"};
        controlsAndSpace = new UnicodeSet("[:cc:]");
    }

    public abstract class Handler {
        Map<AttributeName, String> settings = new TreeMap<AttributeName, String>();
        String name;
        List<ULocale> currentLocales = new ArrayList<ULocale>();
        int failures = 0;
        protected boolean approved = true;

        void setName(String name) {
            this.name = name;
        }

        void set(AttributeName attributeName, String attributeValue) {
            this.settings.put(attributeName, attributeValue);
        }

        void checkResult(String value) {
            ULocale ul = new ULocale("xx");
            try {
                for (int i = 0; i < this.currentLocales.size(); ++i) {
                    ul = this.currentLocales.get(i);
                    this.handleResult(ul, value);
                    if (this.failures == 0) continue;
                    TestCldr.this.errln("\tTotal Failures: " + this.failures + "\t" + ul + "(" + ul.getDisplayName(ULocale.ENGLISH) + ")");
                    this.failures = 0;
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                TestCldr.this.errln("Exception: Locale: " + ul + ",\tValue: <" + value + ">" + "\n" + sw.toString());
            }
        }

        public void loglnSAX(String message) {
            String temp = message + "\t[" + this.name;
            for (AttributeName attributeName : this.settings.keySet()) {
                String attributeValue = this.settings.get((Object)attributeName);
                temp = temp + " " + (Object)((Object)attributeName) + "=<" + attributeValue + ">";
            }
            TestCldr.this.logln(temp + "]");
        }

        int lookupValue(Object x, Object[] list) {
            for (int i = 0; i < list.length; ++i) {
                if (!x.equals(list[i])) continue;
                return i;
            }
            this.loglnSAX("Unknown String: " + x);
            return -1;
        }

        abstract void handleResult(ULocale var1, String var2) throws Exception;

        public void setAttributes(Attributes attributes) {
            String localeList = attributes.getValue("locales");
            String[] currentLocaleString = new String[50];
            Utility.split(localeList, ' ', currentLocaleString);
            this.currentLocales.clear();
            for (int i = 0; i < currentLocaleString.length; ++i) {
                if (currentLocaleString[i].length() == 0) continue;
                if (TestCldr.this.allLocales.contains("")) {
                    TestCldr.this.logln("Skipping locale, not in ICU4J: " + currentLocaleString[i]);
                    continue;
                }
                this.currentLocales.add(new ULocale(currentLocaleString[i]));
            }
            if (DEBUG) {
                TestCldr.this.logln("Setting locales: " + this.currentLocales);
            }
        }
    }

    static enum AttributeName {
        numberType,
        dateType,
        timeType,
        date,
        field,
        zone,
        parse,
        input,
        draft;

    }
}

