/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.json;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.FileProcessor;
import org.unicode.cldr.util.PatternCache;

class LdmlConvertRules {
    public static final ImmutableSet<String> IGNORE_FILE_SET = ImmutableSet.of("attributeValueValidity", "coverageLevels", "postalCodeData", "subdivisions");
    static final ImmutableSet<String> NAME_PART_DISTINGUISHING_ATTR_SET = ImmutableSet.of("monthWidth:month:yeartype", "characters:parseLenients:scope", "dateFormat:pattern:numbers", "characterLabelPatterns:characterLabelPattern:count", "currencyFormats:unitPattern:count", "currency:displayName:count", new String[]{"numbers:symbols:numberSystem", "numbers:decimalFormats:numberSystem", "numbers:currencyFormats:numberSystem", "numbers:percentFormats:numberSystem", "numbers:scientificFormats:numberSystem", "numbers:miscPatterns:numberSystem", "minimalPairs:pluralMinimalPairs:count", "territoryContainment:group:status", "decimalFormat:pattern:count", "currencyFormat:pattern:count", "unit:unitPattern:count", "compoundUnit:compoundUnitPattern1:count", "compoundUnit:compoundUnitPattern1:gender", "compoundUnit:compoundUnitPattern1:case", "field:relative:type", "field:relativeTime:type", "relativeTime:relativeTimePattern:count", "availableFormats:dateFormatItem:count", "listPatterns:listPattern:type", "timeZoneNames:regionFormat:type", "units:durationUnit:type", "weekData:minDays:territories", "weekData:firstDay:territories", "weekData:weekendStart:territories", "weekData:weekendEnd:territories", "supplemental:dayPeriodRuleSet:type", "unitPreferenceDataData:unitPreferences:category", "grammaticalData:grammaticalFeatures:targets", "grammaticalGenderData:grammaticalFeatures:targets", "grammaticalFeatures:grammaticalCase:scope", "grammaticalFeatures:grammaticalGender:scope", "grammaticalDerivations:deriveCompound:structure", "grammaticalDerivations:deriveCompound:feature", "grammaticalDerivations:deriveComponent:feature", "grammaticalDerivations:deriveComponent:structure", "measurementData:measurementSystem:category", "supplemental:plurals:type", "pluralRanges:pluralRange:start", "pluralRanges:pluralRange:end", "pluralRules:pluralRule:count", "languageMatches:languageMatch:desired", "styleNames:styleName:subtype", "styleNames:styleName:alt"});
    static final ImmutableSet<String> ATTR_AS_VALUE_SET = ImmutableSet.of("dayPeriodRules:dayPeriodRule:from", "likelySubtags:likelySubtag:to", "timezone:usesMetazone:mzone", "timezone:usesMetazone:to", "timezone:usesMetazone:from", "mapTimezones:mapZone:other", new String[]{"mapTimezones:mapZone:type", "mapTimezones:mapZone:territory", "numberingSystems:numberingSystem:type", "region:currency:from", "region:currency:to", "region:currency:tender", "calendar:calendarSystem:type", "codeMappings:territoryCodes:numeric", "codeMappings:territoryCodes:alpha3", "codeMappings:currencyCodes:numeric", "timeData:hours:allowed", "timeData:hours:preferred", "validity:variable:type", "deprecated:deprecatedItems:elements", "deprecated:deprecatedItems:attributes", "deprecated:deprecatedItems:type", "codesByTerritory:telephoneCountryCode:code", "mapTimezones:mapZone:other", "*:unitPreference:geq", "*:unitPreference:skeleton", "grammaticalDerivations:deriveComponent:value0", "grammaticalDerivations:deriveComponent:value1", "identity:language:type", "identity:script:type", "identity:territory:type", "identity:variant:type", "keyword:key:name"});
    static final ImmutableSet<String> COMPACTABLE_ATTR_AS_VALUE_SET = ImmutableSet.of("calendars:default:choice", "dateFormats:default:choice", "months:default:choice", "monthContext:default:choice", "days:default:choice", "dayContext:default:choice", new String[]{"timeFormats:default:choice", "dateTimeFormats:default:choice", "timeZoneNames:singleCountries:list", "ruleset:rbnfrule:value", "likelySubtags:likelySubtag:to", "calendar:calendarSystem:type", "calendarPreferenceData:calendarPreference:ordering", "codesByTerritory:telephoneCountryCode:code", "collations:default:choice", "pluralRanges:pluralRange:result", "identity:language:type", "identity:script:type", "identity:territory:type", "identity:variant:type", "grammaticalFeatures:grammaticalGender:values", "grammaticalFeatures:grammaticalDefiniteness:values", "grammaticalFeatures:grammaticalCase:values", "grammaticalDerivations:deriveCompound:value"});
    public static final String ANONYMOUS_KEY = "_";
    public static final ImmutableSet<String> IGNORABLE_NONDISTINGUISHING_ATTR_SET = ImmutableSet.of("draft", "references");
    public static final String[] ATTR_SUPPRESS_LIST = new String[]{"dateFormat", "standard", "type", "dateTimeFormat", "standard", "type", "timeFormat", "standard", "type", "decimalFormat", "standard", "type", "percentFormat", "standard", "type", "scientificFormat", "standard", "type", "pattern", "standard", "type"};
    private static final SplittableAttributeSpec[] SPLITTABLE_ATTRS = new SplittableAttributeSpec[]{new SplittableAttributeSpec("calendarPreference", "territories", null), new SplittableAttributeSpec("pluralRanges", "locales", null), new SplittableAttributeSpec("pluralRules", "locales", null), new SplittableAttributeSpec("minDays", "territories", "count"), new SplittableAttributeSpec("firstDay", "territories", "day"), new SplittableAttributeSpec("weekendStart", "territories", "day"), new SplittableAttributeSpec("weekendEnd", "territories", "day"), new SplittableAttributeSpec("weekOfPreference", "locales", "ordering"), new SplittableAttributeSpec("measurementSystem", "territories", "type"), new SplittableAttributeSpec("measurementSystem-category-temperature", "territories", "type"), new SplittableAttributeSpec("paperSize", "territories", "type"), new SplittableAttributeSpec("parentLocale", "locales", "parent"), new SplittableAttributeSpec("hours", "regions", null), new SplittableAttributeSpec("dayPeriodRules", "locales", null), new SplittableAttributeSpec("personList", "locales", "type"), new SplittableAttributeSpec("unitPreference", "regions", null), new SplittableAttributeSpec("grammaticalFeatures", "locales", null), new SplittableAttributeSpec("grammaticalDerivations", "locales", null)};
    public static final Set<String> TIMEZONE_ELEMENT_NAME_SET = Builder.with(new HashSet()).add("zone").add("timezone").add("zoneItem").add("typeMap").freeze();
    public static final Set<String> ATTRVALUE_AS_ARRAY_SET = Builder.with(new HashSet()).add("territories").add("scripts").add("contains").add("systems").freeze();
    public static final String[] ELEMENT_NEED_SORT = new String[]{"zone", "timezone", "zoneItem", "typeMap", "dayPeriodRule", "pluralRanges", "pluralRules", "personList", "calendarPreferenceData", "character-fallback", "types", "timeData", "minDays", "firstDay", "weekendStart", "weekendEnd", "measurementData", "measurementSystem"};
    public static final Pattern ARRAY_ITEM_PATTERN = PatternCache.get("(.*/collation[^/]*/rules[^/]*/|.*/character-fallback[^/]*/character[^/]*/|.*/rbnfrule[^/]*/|.*/ruleset[^/]*/|.*/languageMatching[^/]*/languageMatches[^/]*/|.*/unitPreferences/[^/]*/[^/]*/|.*/windowsZones[^/]*/mapTimezones[^/]*/|.*/metaZones[^/]*/mapTimezones[^/]*/|.*/segmentation[^/]*/variables[^/]*/|.*/segmentation[^/]*/suppressions[^/]*/|.*/transform[^/]*/tRules[^/]*/|.*/region/region[^/]*/|.*/keyword[^/]*/key[^/]*/|.*/telephoneCodeData[^/]*/codesByTerritory[^/]*/|.*/metazoneInfo[^/]*/timezone\\[[^\\]]*\\]/|.*/metadata[^/]*/validity[^/]*/|.*/metadata[^/]*/suppress[^/]*/|.*/metadata[^/]*/deprecated[^/]*/)(.*)");
    public static final Pattern VALUE_IS_SPACESEP_ARRAY = PatternCache.get("(grammaticalCase|grammaticalGender|grammaticalDefiniteness)");
    public static final Set<String> CHILD_VALUE_IS_SPACESEP_ARRAY = ImmutableSet.of("weekOfPreference", "calendarPreferenceData");
    public static final Pattern NO_NUMBERING_SYSTEM_PATTERN = Pattern.compile("//ldml/numbers/(symbols|(decimal|percent|scientific|currency)Formats)/.*");
    public static final Pattern NUMBERING_SYSTEM_PATTERN = Pattern.compile("//ldml/numbers/(symbols|miscPatterns|(decimal|percent|scientific|currency)Formats)\\[@numberSystem=\"([^\"]++)\"\\]/.*");
    public static final String[] ACTIVE_NUMBERING_SYSTEM_XPATHS = new String[]{"//ldml/numbers/defaultNumberingSystem", "//ldml/numbers/otherNumberingSystems/native", "//ldml/numbers/otherNumberingSystems/traditional", "//ldml/numbers/otherNumberingSystems/finance"};
    public static final Pattern ROOT_IDENTITY_PATTERN = Pattern.compile("//ldml/identity/language\\[@type=\"root\"\\]");
    static final Set<String> BOOLEAN_OMIT_FALSE = ImmutableSet.of("deprecated");

    LdmlConvertRules() {
    }

    public static boolean IsSuppresedAttr(String attr) {
        return attr.endsWith("_q") || attr.endsWith("-q");
    }

    public static final Iterable<PathTransformSpec> getPathTransformations() {
        return PathTransformSpecHelper.INSTANCE;
    }

    public static final void addVersionHandler(String version) {
        if (!"40".equals(version)) {
            PathTransformSpecHelper.INSTANCE.prependVersionTransforms(version);
        }
    }

    public static void main(String[] args) {
        PathTransformSpec.dumpAll();
    }

    public static final String getKeyStr(String name, String key) {
        String keyStr2 = "*:" + name + ":" + key;
        return keyStr2;
    }

    public static final String getKeyStr(String parent, String name, String key) {
        String keyStr = parent + ":" + name + ":" + key;
        return keyStr;
    }

    public static SplittableAttributeSpec[] getSplittableAttrs() {
        return SPLITTABLE_ATTRS;
    }

    public static final boolean valueIsSpacesepArray(String nodeName, String parent) {
        return VALUE_IS_SPACESEP_ARRAY.matcher(nodeName).matches() || parent != null && CHILD_VALUE_IS_SPACESEP_ARRAY.contains(parent);
    }

    public static final boolean attrIsBooleanOmitFalse(String fullPath, String nodeName, String parent, String key) {
        return fullPath != null && (fullPath.startsWith("//supplementalData/metaZones/metazoneIds") || fullPath.startsWith("//ldmlBCP47/keyword/key")) && BOOLEAN_OMIT_FALSE.contains(key);
    }

    public static final class PathTransformSpecHelper
    extends FileProcessor
    implements Iterable<PathTransformSpec> {
        static final PathTransformSpecHelper INSTANCE = PathTransformSpecHelper.make();
        private List<PathTransformSpec> data = new ArrayList<PathTransformSpec>();
        private String lastComment = "";
        private String lastPattern = null;
        private String lastReplacement = null;

        static final PathTransformSpecHelper make() {
            PathTransformSpecHelper helper = new PathTransformSpecHelper();
            helper.process(PathTransformSpecHelper.class, "pathTransforms.txt");
            return helper;
        }

        private PathTransformSpecHelper() {
        }

        @Override
        protected void handleStart() {
            String version = "40";
            this.prependVersionTransforms(version);
        }

        public void prependVersionTransforms(String version) {
            this.data.add(0, new PathTransformSpec("(.+)/identity/version\\[@number=\"([^\"]*)\"\\]", "$1/identity/version\\[@cldrVersion=\"" + version + "\"\\]", "added by code"));
            this.data.add(0, new PathTransformSpec("(.+)/version\\[@number=\"([^\"]*)\"\\]\\[@unicodeVersion=\"([^\"]*\")(\\])", "$1/version\\[@cldrVersion=\"" + version + "\"\\]\\[@unicodeVersion=\"$3\\]", "added by code"));
        }

        @Override
        protected boolean handleLine(int lineCount, String line) {
            if (line.isEmpty()) {
                return true;
            }
            if (line.startsWith("<")) {
                this.lastReplacement = null;
                if (this.lastPattern != null) {
                    throw new IllegalArgumentException("line " + lineCount + ": two <'s in a row");
                }
                this.lastPattern = line.substring(1).trim();
                if (this.lastPattern.isEmpty()) {
                    throw new IllegalArgumentException("line " + lineCount + ": empty < pattern");
                }
            } else if (line.startsWith(">")) {
                if (this.lastPattern == null) {
                    throw new IllegalArgumentException("line " + lineCount + ": need < line before > line");
                }
                this.lastReplacement = line.substring(1).trim();
                this.data.add(new PathTransformSpec(this.lastPattern, this.lastReplacement, this.lastComment));
                this.reset();
            }
            return true;
        }

        @Override
        protected void handleEnd() {
            if (this.lastPattern != null) {
                throw new IllegalArgumentException("ended with a < but no >");
            }
        }

        private void reset() {
            this.lastComment = "";
            this.lastPattern = null;
            this.lastReplacement = null;
        }

        @Override
        public void handleComment(String line, int commentCharPosition) {
            this.lastComment = line.substring(commentCharPosition + 1).trim();
        }

        @Override
        public Iterator<PathTransformSpec> iterator() {
            return this.data.iterator();
        }
    }

    public static class PathTransformSpec {
        private final boolean DEBUG_TRANSFORMS = false;
        public Pattern pattern;
        public String replacement;
        public String patternStr;
        public String comment = "";
        private AtomicInteger use = new AtomicInteger();

        PathTransformSpec(String patternStr, String replacement, String comment) {
            this.patternStr = patternStr;
            this.pattern = PatternCache.get(patternStr);
            this.replacement = replacement;
            this.comment = comment;
            if (this.comment == null) {
                this.comment = "";
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('\n').append("# ").append(this.comment.replace('\n', ' ')).append('\n').append("< ").append(this.patternStr).append('\n').append("> ").append(this.replacement).append('\n');
            return sb.toString();
        }

        public String apply(String result) {
            Matcher m3 = this.pattern.matcher(result);
            if (m3.matches()) {
                String newResult = m3.replaceFirst(this.replacement);
                int count = this.use.incrementAndGet();
                return newResult;
            }
            return null;
        }

        public static void dumpAll() {
            System.out.println("# Path Transformations");
            for (PathTransformSpec ts : LdmlConvertRules.getPathTransformations()) {
                System.out.append(ts.toString());
            }
            System.out.println();
        }

        public static final String applyAll(String result) {
            for (PathTransformSpec ts : LdmlConvertRules.getPathTransformations()) {
                String changed = ts.apply(result);
                if (changed == null) continue;
                result = changed;
                break;
            }
            return result;
        }
    }

    public static class SplittableAttributeSpec {
        public String element;
        public String attribute;
        public String attrAsValueAfterSplit;

        SplittableAttributeSpec(String el, String attr, String av) {
            this.element = el;
            this.attribute = attr;
            this.attrAsValueAfterSplit = av;
        }
    }
}

