/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.posix;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.CollationElementIterator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.posix.POSIXUtilities;
import org.unicode.cldr.posix.POSIXVariant;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.SortedBag;

public class POSIX_LCCollate {
    public RuleBasedCollator col;
    UnicodeSet chars;
    SortedBag allItems;
    SortedBag contractions;
    CLDRFile collrules;
    int longest_char;
    Set<Weights> nonUniqueWeights = new HashSet<Weights>();
    Set<Weights> allWeights = new HashSet<Weights>();
    Map<String, Weights> stringToWeights = new HashMap<String, Weights>();

    public POSIX_LCCollate(CLDRFile doc, UnicodeSet repertoire, CLDRFile collrules, UnicodeSet CollateSet, String codeset, POSIXVariant variant) throws Exception {
        UnicodeSet tailored;
        String rules = "";
        String collationType = "standard";
        boolean UsingDefaultCollateSet = false;
        if (CollateSet.isEmpty()) {
            CollateSet.addAll(repertoire);
            UsingDefaultCollateSet = true;
        }
        this.chars = new UnicodeSet(repertoire).retainAll(CollateSet);
        this.collrules = collrules;
        if (collrules != null) {
            String path;
            if (variant.collation_type == "default") {
                path = "//ldml/collations/defaultCollation";
                collationType = collrules.getWinningValue(path);
            } else {
                collationType = variant.collation_type;
            }
            path = "//ldml/collations/collation[@type=\"" + collationType + "\"]/cr";
            rules = collrules.getStringValue(path);
        }
        this.col = rules != null && rules.length() > 0 ? new RuleBasedCollator(rules) : (RuleBasedCollator)RuleBasedCollator.getInstance();
        if (codeset.equals("UTF-8") && UsingDefaultCollateSet) {
            tailored = this.col.getTailoredSet();
            UnicodeSetIterator it = new UnicodeSetIterator(tailored);
            while (it.next()) {
                if (it.codepoint == -1 || !UCharacter.isBMP(it.codepoint) || UCharacter.isLowSurrogate((char)it.codepoint) || UCharacter.isHighSurrogate((char)it.codepoint)) continue;
                this.chars.add(it.codepoint);
            }
        }
        this.col.setStrength(15);
        this.allItems = new SortedBag(this.col);
        this.contractions = new SortedBag(this.col);
        this.longest_char = 0;
        UnicodeSetIterator it = new UnicodeSetIterator(this.chars);
        while (it.next()) {
            this.allItems.add(it.getString());
            int CharNameLength = POSIXUtilities.POSIXCharName(it.getString()).length();
            if (CharNameLength <= this.longest_char) continue;
            this.longest_char = CharNameLength;
        }
        tailored = this.col.getTailoredSet();
        this.getFilteredSet(this.chars, tailored);
        UnicodeSet uca_contractions = new UnicodeSet("[{\u0406\u0308}{\u0410\u0306}{\u0410\u0308}{\u0413\u0301}{\u0413\u0341}{\u0415\u0306}{\u0416\u0308}{\u0417\u0308}{\u0418\u0306}{\u0418\u0308}{\u041a\u0301}{\u041a\u0341}{\u041e\u0308}{\u0423\u0306}{\u0423\u0308}{\u0423\u030b}{\u0427\u0308}{\u042b\u0308}{\u042d\u0308}{\u0430\u0306}{\u0430\u0308}{\u0433\u0301}{\u0433\u0341}{\u0435\u0306}{\u0436\u0308}{\u0437\u0308}{\u0438\u0306}{\u0438\u0308}{\u043a\u0301}{\u043a\u0341}{\u043e\u0308}{\u0443\u0306}{\u0443\u0308}{\u0443\u030b}{\u0447\u0308}{\u044b\u0308}{\u044d\u0308}{\u0456\u0308}{\u0474\u030f}{\u0475\u030f}{\u04d8\u0308}{\u04d9\u0308}{\u04e8\u0308}{\u04e9\u0308}{\u0627\u0653}{\u0627\u0654}{\u0627\u0655}{\u0648\u0654}{\u064a\u0654}{\u09c7\u09be}{\u09c7\u09d7}{\u0b47\u0b3e}{\u0b47\u0b56}{\u0b47\u0b57}{\u0b92\u0bd7}{\u0bc6\u0bbe}{\u0bc6\u0bd7}{\u0bc7\u0bbe}{\u0c46\u0c56}{\u0cbf\u0cd5}{\u0cc6\u0cc2}{\u0cc6\u0cc2\u0cd5}{\u0cc6\u0cd5}{\u0cc6\u0cd6}{\u0cca\u0cd5}{\u0d46\u0d3e}{\u0d46\u0d57}{\u0d47\u0d3e}{\u0dd9\u0dca}{\u0dd9\u0dcf}{\u0dd9\u0dcf\u0dca}{\u0dd9\u0ddf}{\u0ddc\u0dca}{\u0e4d\u0e32}{\u0ecd\u0eb2}{\u0f71\u0f72}{\u0f71\u0f74}{\u0f71\u0f80}{\u0fb2\u0f71}{\u0fb2\u0f71\u0f80}{\u0fb2\u0f80}{\u0fb2\u0f81}{\u0fb3\u0f71}{\u0fb3\u0f71\u0f80}{\u0fb3\u0f80}{\u0fb3\u0f81}{\u1025\u102e}]");
        this.getFilteredSet(uca_contractions, tailored);
    }

    private void getFilteredSet(UnicodeSet chars, UnicodeSet tailored) {
        UnicodeSetIterator it = new UnicodeSetIterator(tailored);
        while (it.next()) {
            if (it.codepoint != -1) continue;
            String s2 = it.getString();
            if (!UTF16.hasMoreCodePointsThan(s2 = Normalizer.compose(s2, false), 1) || !chars.containsAll(s2)) continue;
            this.contractions.add(s2);
            this.allItems.add(s2);
        }
    }

    public void write(PrintWriter out) {
        out.println("*************");
        out.println("LC_COLLATE");
        out.println("*************");
        out.println();
        this.writeDefinitions(out);
        out.println();
        this.writeList(out);
        out.println();
        out.println("* assignment of characters to weights");
        out.println();
        for (Object o : this.allItems) {
            String currentChar = (String)o;
            out.println(this.showLine(this.col, currentChar));
        }
        out.print("UNDEFINED");
        for (int i = this.longest_char - 9; i > 0; --i) {
            out.print(" ");
        }
        out.print(" ");
        out.println("IGNORE;IGNORE;IGNORE;...");
        out.println();
        out.println("order_end");
        out.println();
        out.println("END LC_COLLATE");
    }

    private void writeDefinitions(PrintWriter out) {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.contractions.iterator();
        while (it.hasNext()) {
            Object o;
            try {
                o = it.next();
            }
            catch (NullPointerException ex) {
                continue;
            }
            buffer.setLength(0);
            String s2 = (String)o;
            buffer.append("collating-element ").append(POSIXUtilities.POSIXContraction(s2)).append(" from \"").append(POSIXUtilities.POSIXCharName(s2)).append("\"");
            out.println(buffer.toString());
        }
    }

    private void writeList(PrintWriter out) {
        int i;
        BitSet needToWrite = new BitSet();
        needToWrite.set(1);
        for (Object o : this.allItems) {
            String string = (String)o;
            Weights w = new Weights(this.col.getCollationElementIterator(string));
            w.primaries.setBits(needToWrite);
            w.secondaries.setBits(needToWrite);
            w.tertiaries.setBits(needToWrite);
            if (this.allWeights.contains(w)) {
                this.nonUniqueWeights.add(w);
            }
            this.allWeights.add(w);
            this.stringToWeights.put(string, w);
        }
        out.println("");
        out.println("* Define collation weights as symbols");
        out.println("");
        for (i = 0; i < needToWrite.size(); ++i) {
            if (!needToWrite.get(i)) continue;
            out.print("collating-symbol ");
            out.println(POSIX_LCCollate.getID('X', i));
        }
        out.println("");
        out.println("order_start forward;" + (this.col.isFrenchCollation() ? "backward" : "forward") + ";forward;forward");
        out.println("");
        out.println("");
        out.println("* collation weights in order");
        out.println("");
        for (i = 0; i < needToWrite.size(); ++i) {
            if (!needToWrite.get(i)) continue;
            out.println(POSIX_LCCollate.getID('X', i));
        }
    }

    private String showLine(RuleBasedCollator col, String string) {
        String prefix = "";
        StringBuffer result = new StringBuffer();
        String ThisChar = POSIXUtilities.POSIXContraction(string);
        result.append(ThisChar);
        for (int i = this.longest_char - ThisChar.length(); i > 0; --i) {
            result.append(" ");
        }
        result.append(" ");
        Weights w = this.stringToWeights.get(string);
        result.append(w.primaries).append(";").append(w.secondaries).append(";").append(w.tertiaries).append(";");
        if (this.nonUniqueWeights.contains(w)) {
            String decomposed = Normalizer.decompose(string, false);
            if (decomposed.length() > 1) {
                result.append("\"");
                result.append(POSIXUtilities.POSIXCharName(decomposed));
                result.append("\"");
            } else {
                result.append(ThisChar);
            }
        } else {
            result.append(ThisChar);
        }
        if (prefix.length() != 0) {
            result.insert(0, prefix);
        }
        return result.toString();
    }

    private static String getID(char leadChar, int i) {
        int length = i < 256 ? 2 : 4;
        return "<" + leadChar + Utility.hex(i, length) + ">";
    }

    private class Weights {
        WeightList primaries;
        WeightList secondaries;
        WeightList tertiaries;

        public Weights(CollationElementIterator it) {
            int ce;
            this.primaries = new WeightList();
            this.secondaries = new WeightList();
            this.tertiaries = new WeightList();
            while ((ce = it.next()) != -1) {
                int p = CollationElementIterator.primaryOrder(ce);
                this.primaries.append(p);
                this.secondaries.append(CollationElementIterator.secondaryOrder(ce));
                this.tertiaries.append(CollationElementIterator.tertiaryOrder(ce));
            }
        }

        public boolean equals(Object other) {
            Weights that = (Weights)other;
            return this.primaries.equals(that.primaries) && this.secondaries.equals(that.secondaries) && this.tertiaries.equals(that.tertiaries);
        }

        public int hashCode() {
            return (this.primaries.hashCode() * 37 + this.secondaries.hashCode()) * 37 + this.tertiaries.hashCode();
        }
    }

    private class WeightList {
        char[] weights = new char[100];
        int count = 0;

        private WeightList() {
        }

        public void append(int i) {
            for (int j = 16; j >= 0; j -= 16) {
                char b = (char)(i >>> j);
                if (b == '\u0000') continue;
                this.weights[this.count++] = b;
            }
        }

        public void setBits(BitSet s2) {
            for (int j = 0; j < this.count; ++j) {
                s2.set(this.weights[j]);
            }
        }

        public String toString() {
            if (this.count == 0) {
                return "IGNORE";
            }
            if (this.count == 1) {
                return POSIX_LCCollate.getID('X', this.weights[0]);
            }
            String result = "\"";
            for (int i = 0; i < this.count; ++i) {
                result = result + POSIX_LCCollate.getID('X', this.weights[i]);
            }
            return result + "\"";
        }

        public boolean equals(Object other) {
            WeightList that = (WeightList)other;
            for (int j = 0; j < this.count; ++j) {
                if (this.weights[j] == that.weights[j]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.count;
            for (int j = 0; j < this.count; ++j) {
                result = result * 37 + this.weights[j];
            }
            return result;
        }
    }
}

