/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUException;
import java.util.List;
import java.util.Map;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.InternalCldrException;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.XPathParts;

public class CheckForCopy
extends FactoryCheckCLDR {
    private static final boolean DEBUG = CldrUtility.getProperty("DEBUG", false);
    private static final RegexLookup<Boolean> skip = new RegexLookup<Boolean>().add("/(availableFormats|exponential|nan|availableFormats|intervalFormatItem|exemplarCharacters\\[@type=\"(currencySymbol|index)\"]|scientificFormat|timeZoneNames/(hourFormat|gmtFormat|gmtZeroFormat)|dayPeriod|(monthWidth|dayWidth|quarterWidth)\\[@type=\"(narrow|abbreviated)\"]|exemplarCity|currency\\[@type=\"[A-Z]+\"]/symbol|pattern|field\\[@type=\"dayperiod\"]|defaultNumberingSystem|otherNumberingSystems|exemplarCharacters|durationUnitPattern|coordinateUnitPattern|unitLength\\[@type=\"(short|narrow)\"\\]/unit\\[@type=\"[^\"]++\"\\]/unitPattern\\[@count=\"[^\"]++\"\\]|unitLength\\[@type=\"(short|narrow)\"\\]/unit\\[@type=\"[^\"]++\"\\]/perUnitPattern)", Boolean.valueOf(true)).add("^//ldml/dates/calendars/calendar\\[@type=\"gregorian\"]", (Boolean)false).add("^//ldml/dates/calendars/calendar", (Boolean)true);
    private static final RegexLookup<Boolean> SKIP_CODE_CHECK = new RegexLookup<Boolean>().add("^//ldml/characterLabels/characterLabel", Boolean.valueOf(true)).add("^//ldml/dates/fields/field\\[@type=\"(era|week|minute|quarter|second)\"]/displayName", (Boolean)true).add("^//ldml/localeDisplayNames/scripts/script\\[@type=\"(Jamo|Thai|Ahom|Loma|Moon|Newa|Arab|Lisu|Bali|Cham|Modi|Toto)\"]", (Boolean)true).add("^//ldml/localeDisplayNames/languages/language\\[@type=\"(fon|gan|luo|tiv|yao|vai)\"]", (Boolean)true).add("^//ldml/dates/timeZoneNames/metazone\\[@type=\"GMT\"]", (Boolean)true).add("^//ldml/localeDisplayNames/territories/territory\\[@type=\"[^\"]*+\"]\\[@alt=\"short\"]", (Boolean)true).add("^//ldml/localeDisplayNames/measurementSystemNames/measurementSystemName", (Boolean)true).add("^//ldml/localeDisplayNames/types/type\\[@key=\"collation\"]\\[@type=\"standard\"]", (Boolean)true);
    static UnicodeSet ASCII_LETTER = new UnicodeSet("[a-zA-Z]").freeze();

    public CheckForCopy(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (fullPath == null || path == null || value == null) {
            return this;
        }
        Failure failure = CheckForCopy.sameAsCodeOrEnglish(value, path, this.getCldrFileToCheck(), false);
        this.addFailure(result, failure);
        return this;
    }

    public static boolean sameAsCode(String value, String path, CLDRFile cldrFile) {
        return CheckForCopy.sameAsCodeOrEnglish(value, path, cldrFile, true) == Failure.same_as_code;
    }

    private static Failure sameAsCodeOrEnglish(String value, String path, CLDRFile cldrFile, boolean contextIsVoteSubmission) {
        CLDRFile.Status status = new CLDRFile.Status();
        String topStringValue = cldrFile.getUnresolved().getStringValue(path);
        boolean isExplicitBailey = CldrUtility.INHERITANCE_MARKER.equals(topStringValue);
        String loc = cldrFile.getSourceLocaleID(path, status);
        if (!(contextIsVoteSubmission || isExplicitBailey || cldrFile.getLocaleID().equals(loc) && path.equals(status.pathWhereFound))) {
            return Failure.ok;
        }
        if (Boolean.TRUE == skip.get(path)) {
            return Failure.ok;
        }
        Failure failure = Failure.ok;
        CLDRFile di = CheckForCopy.getDisplayInformation();
        if (di == null) {
            throw new InternalCldrException("CheckForCopy.sameAsCodeOrEnglish error: getDisplayInformation is null");
        }
        String english = di.getStringValue(path);
        if (value.equals(english) && ASCII_LETTER.containsSome(english)) {
            failure = Failure.same_as_english;
        }
        if (Boolean.TRUE == SKIP_CODE_CHECK.get(path)) {
            return Failure.ok;
        }
        if (CldrUtility.INHERITANCE_MARKER.equals(value) && (value = cldrFile.getConstructedBaileyValue(path, null, null)) == null) {
            return Failure.ok;
        }
        if (CheckForCopy.sameAsEnglishOK(loc, path, value)) {
            return Failure.ok;
        }
        String value2 = value;
        if (isExplicitBailey && (value2 = cldrFile.getConstructedValue(path)) == null) {
            value2 = value;
        }
        XPathParts parts = XPathParts.getFrozenInstance(path);
        int elementCount = parts.size();
        block2: for (int i = 2; i < elementCount; ++i) {
            Map<String, String> attributes = parts.getAttributes(i);
            for (Map.Entry<String, String> attributeEntry : attributes.entrySet()) {
                String attributeValue = attributeEntry.getValue();
                try {
                    if (!value2.equals(attributeValue)) continue;
                    failure = Failure.same_as_code;
                    continue block2;
                }
                catch (NullPointerException e) {
                    throw new ICUException("Value: " + value + "\nattributeValue: " + attributeValue + "\nPath: " + path, e);
                }
            }
        }
        return failure;
    }

    private static boolean sameAsEnglishOK(String loc, String path, String value) {
        if (path.startsWith("//ldml/units/unitLength") || path.startsWith("//ldml/characters/parseLenients")) {
            return true;
        }
        return !(!"en".equals(loc) && !loc.startsWith("en_") || !"year".equals(value) && !"month".equals(value) && !"day".equals(value) && !"hour".equals(value));
    }

    private void addFailure(List<CheckCLDR.CheckStatus> result, Failure failure) {
        switch (failure) {
            case same_as_english: {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.sameAsEnglish).setCheckOnSubmit(false).setMessage("The value is the same as in English: see <a target='CLDR-ST-DOCS' href='http://cldr.org/translation/fixing-errors'>Fixing Errors and Warnings</a>.", new Object[0]));
                break;
            }
            case same_as_code: {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.sameAsCode).setCheckOnSubmit(false).setMessage("The value is the same as the 'code': see <a target='CLDR-ST-DOCS' href='http://cldr.org/translation/fixing-errors'>Fixing Errors and Warnings</a>.", new Object[0]));
                break;
            }
        }
    }

    @Override
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        String localeID = cldrFileToCheck.getLocaleID();
        LanguageTagParser ltp = new LanguageTagParser().set(localeID);
        String lang = ltp.getLanguage();
        this.setSkipTest(false);
        if (lang.equals("en") || localeID.equals("root")) {
            this.setSkipTest(true);
            if (DEBUG) {
                System.out.println("# CheckForCopy: Skipping: " + localeID);
            }
            return this;
        }
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        return this;
    }

    static enum Failure {
        ok,
        same_as_english,
        same_as_code;

    }
}

