/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.dev.util.ElapsedTimer;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CheckForExemplars;
import org.unicode.cldr.test.ExampleGenerator;
import org.unicode.cldr.test.FlexibleDateFromCLDR;
import org.unicode.cldr.test.HelpMessages;
import org.unicode.cldr.test.XPathToMenu;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ShowData;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathDescription;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.StringId;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnicodeSetPrettyPrinter;
import org.unicode.cldr.util.VoteResolver;
import org.unicode.cldr.util.XMLSource;

@CLDRTool(alias="check", description="Run CheckCLDR against CLDR data")
public class ConsoleCheckCLDR {
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    private static final PathHeader.Factory PATH_HEADER_FACTORY = PathHeader.getFactory();
    public static boolean showStackTrace = false;
    public static boolean errorsOnly = false;
    static boolean SHOW_LOCALE = true;
    static boolean SHOW_EXAMPLES = false;
    private static boolean CLDR_GITHUB_ANNOTATIONS = Boolean.parseBoolean(System.getProperty("CLDR_GITHUB_ANNOTATIONS", "false"));
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int COVERAGE = 2;
    private static final int EXAMPLES = 3;
    private static final int FILE_FILTER = 4;
    private static final int TEST_FILTER = 5;
    private static final int DATE_FORMATS = 6;
    private static final int ORGANIZATION = 7;
    private static final int SHOWALL = 8;
    private static final int PATH_FILTER = 9;
    private static final int ERRORS_ONLY = 10;
    private static final int CHECK_ON_SUBMIT = 11;
    private static final int NO_ALIASES = 12;
    private static final int SOURCE_DIRECTORY = 13;
    private static final int USER = 14;
    private static final int PHASE = 15;
    private static final int GENERATE_HTML = 16;
    private static final int VOTE_RESOLVE = 17;
    private static final int ID_VIEW = 18;
    private static final int SUBTYPE_FILTER = 19;
    private static final int SOURCE_ALL = 20;
    private static final int BAILEY = 21;
    static final String SOURCE_DIRS = CLDRPaths.MAIN_DIRECTORY + "," + CLDRPaths.ANNOTATIONS_DIRECTORY + "," + CLDRPaths.SEED_DIRECTORY;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.create("coverage", 'c', 1), UOption.create("examples", 'x', 0), UOption.create("file_filter", 'f', 1).setDefault(".*"), UOption.create("test_filter", 't', 1).setDefault(".*"), UOption.create("date_formats", 'd', 0), UOption.create("organization", 'o', 1), UOption.create("showall", 'a', 0), UOption.create("path_filter", 'p', 1).setDefault(".*"), UOption.create("errors_only", 'e', 0), UOption.create("check-on-submit", 'k', 0), UOption.create("noaliases", 'n', 0), UOption.create("source_directory", 's', 1).setDefault(SOURCE_DIRS), UOption.create("user", 'u', 1), UOption.create("phase", 'z', 1), UOption.create("generate_html", 'g', 2).setDefault(CLDRPaths.CHART_DIRECTORY + "/errors/"), UOption.create("vote resolution", 'v', 0), UOption.create("id view", 'i', 0), UOption.create("subtype_filter", 'y', 1), UOption.create("source_all", 'S', 2).setDefault("common,seed,exemplars"), UOption.create("bailey", 'b', 0), UOption.create("exemplarError", 'E', 0)};
    private static final Comparator<String> baseFirstCollator = new Comparator<String>(){
        LanguageTagParser languageTagParser1 = new LanguageTagParser();
        LanguageTagParser languageTagParser2 = new LanguageTagParser();

        @Override
        public int compare(String o1, String o2) {
            String ls2;
            String ls1 = this.languageTagParser1.set(o1).getLanguageScript();
            int result = ls1.compareTo(ls2 = this.languageTagParser2.set(o2).getLanguageScript());
            if (result != 0) {
                return result;
            }
            return o1.compareTo(o2);
        }
    };
    private static final boolean PATH_IN_COUNT = false;
    private static String[] HelpMessage = new String[]{"-h \t This message", "-s \t Source directory, default = " + SOURCE_DIRS, "-S common,seed\t Use common AND seed directories. ( Set CLDR_DIR, don't use this with -s. )\n", "-fxxx \t Pick the locales (files) to check: xxx is a regular expression, eg -f fr, or -f fr.*, or -f (fr|en-.*)", "-pxxx \t Pick the paths to check, eg -p(.*languages.*)", "-cxxx \t Set the coverage: eg -c comprehensive or -c modern or -c moderate or -c basic", "-txxx \t Filter the Checks: xxx is a regular expression, eg -t.*number.*. To check all BUT a given test, use the style -t ((?!.*CheckZones).*)", "-oxxx \t Organization: ibm, google, ....; filters locales and uses Locales.txt for coverage tests", "-x \t Turn on examples (actually a summary of the demo).", "-d \t Turn on special date format checks", "-a \t Show all paths", "-e \t Show errors only (with -ef, only final processing errors)", "-n \t No aliases", "-u \t User, eg -uu148", "-y \t error/warning subtype filter, eg unexpectedOrderOfEraYear", "-b \t check bailey values (" + CldrUtility.INHERITANCE_MARKER + ")"};
    static Counter<ErrorType> subtotalCount = new Counter(true);
    static Counter<ErrorType> totalCount = new Counter(true);
    static Matcher draftStatusMatcher = PatternCache.get("\\[@draft=\"(provisional|unconfirmed)\"]").matcher("");
    private static ExampleGenerator englishExampleGenerator;
    static Matcher coverageMatcher;
    private static PathDescription pathDescription;
    static String lastHtmlLocaleID;
    private static VoteResolver<String> voteResolver;
    private static String resolveVotesDirectory;
    private static boolean idView;
    private static SupplementalDataInfo supplementalDataInfo;
    private static CLDRFile english;
    static final ConcurrentHashMap<Pair<String, String>, String> localeXpathToFilePath;

    public static void main(String[] args) throws IOException {
        long errorCount;
        CheckCLDR.Phase phase;
        Set<Organization> organizations;
        Organization organization;
        MyOptions.parse(args, true);
        ElapsedTimer totalTimer = new ElapsedTimer();
        UOption.parseArgs(args, options);
        String factoryFilter = ConsoleCheckCLDR.options[4].value;
        if (factoryFilter.equals("key")) {
            factoryFilter = "(en|ru|nl|fr|de|it|pl|es|tr|th|ja|zh|ko|ar|bg|sr|uk|ca|hr|cs|da|fil|fi|hu|id|lv|lt|no|pt|ro|sk|sl|sv|vi|el|he|fa|hi|am|af|et|is|ms|sw|zu|bn|mr|ta|eu|gl|ur|gu|kn|ml|te|zh_Hant|pt_PT|en_GB)";
        }
        String checkFilter = ConsoleCheckCLDR.options[5].value;
        String subtypeFilterString = ConsoleCheckCLDR.options[19].value;
        EnumSet<CheckCLDR.CheckStatus.Subtype> subtypeFilter = null;
        if (subtypeFilterString != null) {
            subtypeFilter = EnumSet.noneOf(CheckCLDR.CheckStatus.Subtype.class);
            Matcher m3 = PatternCache.get(subtypeFilterString).matcher("");
            for (CheckCLDR.CheckStatus.Subtype value : CheckCLDR.CheckStatus.Subtype.values()) {
                if (!m3.reset(value.toString()).find() && !m3.reset(value.name()).find()) continue;
                subtypeFilter.add(value);
            }
            if (subtypeFilter.size() == 0) {
                System.err.println("No subtype match for " + subtypeFilterString);
                return;
            }
        }
        errorsOnly = ConsoleCheckCLDR.options[10].doesOccur;
        SHOW_EXAMPLES = ConsoleCheckCLDR.options[3].doesOccur;
        boolean showAll = ConsoleCheckCLDR.options[8].doesOccur;
        boolean checkFlexibleDates = ConsoleCheckCLDR.options[6].doesOccur;
        String pathFilterString = ConsoleCheckCLDR.options[9].value;
        Matcher pathFilter = null;
        if (!pathFilterString.equals(".*")) {
            pathFilter = PatternCache.get(pathFilterString).matcher("");
        }
        boolean checkOnSubmit = ConsoleCheckCLDR.options[11].doesOccur;
        boolean noaliases = ConsoleCheckCLDR.options[12].doesOccur;
        Level coverageLevel = null;
        String coverageLevelInput = ConsoleCheckCLDR.options[2].value;
        if (coverageLevelInput != null && (coverageLevel = Level.get(coverageLevelInput)) == Level.UNDETERMINED) {
            throw new IllegalArgumentException("-c" + coverageLevelInput + "\t is invalid: must be one of: basic,moderate,...");
        }
        Organization organization2 = organization = ConsoleCheckCLDR.options[7].value == null ? null : Organization.fromString(ConsoleCheckCLDR.options[7].value);
        if (organization != null && !(organizations = StandardCodes.make().getLocaleCoverageOrganizations()).contains((Object)organization)) {
            throw new IllegalArgumentException("-o" + (Object)((Object)organization) + "\t is invalid: must be one of: " + organizations);
        }
        CLDRConfig cldrConf = CLDR_CONFIG;
        cldrConf.setEnvironment(CLDRConfig.Environment.UNITTEST);
        if (ConsoleCheckCLDR.options[15].doesOccur) {
            String phaseVal = ConsoleCheckCLDR.options[15].value;
            try {
                phase = CheckCLDR.Phase.forString(phaseVal);
            }
            catch (IllegalArgumentException e) {
                StringBuilder sb = new StringBuilder("Incorrect Phase value");
                if (phaseVal != null && !phaseVal.isEmpty()) {
                    sb.append(" '");
                    sb.append(phaseVal);
                    sb.append("'");
                }
                sb.append(": should be one of ");
                for (CheckCLDR.Phase curPhase : CheckCLDR.Phase.values()) {
                    sb.append((Object)curPhase);
                    sb.append(", ");
                }
                int lastIdx = sb.lastIndexOf(",");
                if (lastIdx > -1) {
                    String tmpBuf = sb.substring(0, lastIdx);
                    sb.setLength(0);
                    sb.append(tmpBuf);
                }
                sb.append(".");
                throw new IllegalArgumentException(sb.toString(), e);
            }
        } else {
            phase = cldrConf.getPhase();
        }
        boolean baileyTest = ConsoleCheckCLDR.options[21].doesOccur;
        File[] sourceDirectories = null;
        if (MyOptions.source_all.option.doesOccur()) {
            if (MyOptions.source_directory.option.doesOccur()) {
                throw new IllegalArgumentException("Don't use -s and -S together.");
            }
            sourceDirectories = cldrConf.addStandardSubdirectories(cldrConf.getCLDRDataDirectories(MyOptions.source_all.option.getValue()));
        } else {
            String[] sdirs = ConsoleCheckCLDR.options[13].value.split(",\\s*");
            sourceDirectories = new File[sdirs.length];
            for (int i = 0; i < sdirs.length; ++i) {
                sourceDirectories[i] = new File(CldrUtility.checkValidDirectory(sdirs[i], "Fix with -s. Use -h for help."));
            }
        }
        if (ConsoleCheckCLDR.options[16].doesOccur) {
            coverageLevel = Level.MODERN;
            ErrorFile.generated_html_directory = ConsoleCheckCLDR.options[16].value;
            ErrorFile.generated_html_count = FileUtilities.openUTF8Writer(ErrorFile.generated_html_directory, "count.txt");
        }
        idView = ConsoleCheckCLDR.options[18].doesOccur;
        if (ConsoleCheckCLDR.options[17].doesOccur) {
            resolveVotesDirectory = CldrUtility.checkValidFile(CLDRPaths.BASE_DIRECTORY + "incoming/vetted/votes/", true, null);
            VoteResolver.setVoterToInfo(CldrUtility.checkValidFile(CLDRPaths.BASE_DIRECTORY + "incoming/vetted/usersa/usersa.xml", false, null));
            voteResolver = new VoteResolver();
        }
        String user = ConsoleCheckCLDR.options[14].value;
        System.out.println("Source directories:\n");
        for (File f : sourceDirectories) {
            System.out.println("    " + f.getPath() + "\t(" + PathUtilities.getNormalizedPathString(f) + ")");
        }
        Factory cldrFactory = SimpleFactory.make(sourceDirectories, factoryFilter).setSupplementalDirectory(new File(CLDRPaths.SUPPLEMENTAL_DIRECTORY));
        CheckCLDR.CompoundCheckCLDR checkCldr = CheckCLDR.getCheckAll(cldrFactory, checkFilter);
        if (checkCldr.getFilteredTestList().size() == 0) {
            throw new IllegalArgumentException("The filter doesn't match any tests.");
        }
        System.out.println("filtered tests: " + checkCldr.getFilteredTests());
        Factory backCldrFactory = CLDRConfig.getInstance().getMainAndAnnotationsFactory();
        english = backCldrFactory.make("en", true);
        CheckCLDR.setDisplayInformation(english);
        checkCldr.setEnglishFile(english);
        ConsoleCheckCLDR.setExampleGenerator(new ExampleGenerator(english, english, CLDRPaths.SUPPLEMENTAL_DIRECTORY));
        PathShower pathShower = new PathShower();
        TreeSet<String> locales = new TreeSet<String>(baseFirstCollator);
        locales.addAll(cldrFactory.getAvailable());
        ArrayList<CheckCLDR.CheckStatus> result = new ArrayList<CheckCLDR.CheckStatus>();
        TreeSet<PathHeader> paths = new TreeSet<PathHeader>();
        TreeMap<String, String> m4 = new TreeMap<String, String>();
        HashMap<String, String> options = new HashMap<String, String>();
        FlexibleDateFromCLDR fset = new FlexibleDateFromCLDR();
        Set<String> englishPaths = null;
        TreeSet<String> fatalErrors = new TreeSet<String>();
        ConsoleCheckCLDR.showHeaderLine();
        supplementalDataInfo = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
        LocaleIDParser localeIDParser = new LocaleIDParser();
        String lastBaseLanguage = "";
        PathHeader.Factory pathHeaderFactory = PathHeader.getFactory(english);
        ArrayList<String> specialPurposeLocales = new ArrayList<String>(Arrays.asList("en_US_POSIX", "en_ZZ"));
        for (String localeID : locales) {
            Collator col;
            String example;
            String fullPath;
            String path;
            String baseLanguage;
            CLDRFile file;
            ElapsedTimer timer;
            CLDRFile parent;
            CLDRFile englishFile;
            Level level;
            boolean isLanguageLocale;
            block74: {
                if (CLDRFile.isSupplementalName(localeID)) continue;
                if (supplementalDataInfo.getDefaultContentLocales().contains(localeID)) {
                    System.out.println("# Skipping default content locale: " + localeID);
                    continue;
                }
                if (specialPurposeLocales.contains(localeID)) {
                    System.out.println("# Skipping special purpose locale: " + localeID);
                    continue;
                }
                isLanguageLocale = localeID.equals(localeIDParser.set(localeID).getLanguageScript());
                options.clear();
                if (MyOptions.exemplarError.option.doesOccur()) {
                    options.put(CheckCLDR.Options.Option.exemplarErrors.toString(), "true");
                }
                if ((level = coverageLevel) == null) {
                    level = Level.BASIC;
                }
                if (organization != null) {
                    Map<String, Level> locale_status = StandardCodes.make().getLocaleToLevel(organization);
                    if (locale_status == null || (level = locale_status.get(localeID)) == null || level.compareTo(Level.BASIC) <= 0) {
                        continue;
                    }
                } else if (!isLanguageLocale) {
                    options.put(CheckCLDR.Options.Option.CheckCoverage_skip.getKey(), "true");
                }
                if (organization != null) {
                    options.put(CheckCLDR.Options.Option.CoverageLevel_localeType.getKey(), organization.toString());
                }
                options.put(CheckCLDR.Options.Option.phase.getKey(), phase.toString());
                if (SHOW_LOCALE) {
                    System.out.println();
                }
                englishFile = english;
                parent = null;
                timer = new ElapsedTimer();
                try {
                    String parentID;
                    file = cldrFactory.make(localeID, true);
                    if (ErrorFile.voteFactory != null) {
                        ErrorFile.voteFile = ErrorFile.voteFactory.make(localeID, true);
                    }
                    if ((parentID = LocaleIDParser.getParent(localeID)) == null) break block74;
                    parent = cldrFactory.make(parentID, true);
                }
                catch (RuntimeException e) {
                    fatalErrors.add(localeID);
                    System.out.println("FATAL ERROR: " + localeID);
                    e.printStackTrace(System.out);
                    continue;
                }
            }
            if (ErrorFile.generated_html_directory != null && !(baseLanguage = localeIDParser.set(localeID).getLanguageScript()).equals(lastBaseLanguage)) {
                lastBaseLanguage = baseLanguage;
                ErrorFile.openErrorFile(localeID, baseLanguage);
            }
            if (user != null) {
                file = new CLDRFile.TestUser(file, user, isLanguageLocale);
                if (parent != null) {
                    parent = new CLDRFile.TestUser(parent, user, isLanguageLocale);
                }
            }
            checkCldr.setCldrFileToCheck(file, options, result);
            subtotalCount.clear();
            for (CheckCLDR.CheckStatus checkStatus : result) {
                String statusString = checkStatus.toString();
                CheckCLDR.CheckStatus.Type statusType = checkStatus.getType();
                if (errorsOnly && !statusType.equals((Object)CheckCLDR.CheckStatus.errorType) || subtypeFilter != null && !subtypeFilter.contains((Object)checkStatus.getSubtype()) || checkOnSubmit && (!checkStatus.isCheckOnSubmit() || !statusType.equals((Object)CheckCLDR.CheckStatus.errorType))) continue;
                ConsoleCheckCLDR.showValue(file, null, localeID, null, null, null, null, statusString, checkStatus.getSubtype());
            }
            paths.clear();
            CoverageInfo covInfo = cldrConf.getCoverageInfo();
            for (String path2 : file.fullIterable()) {
                Level currentLevel;
                if (pathFilter != null && !pathFilter.reset(path2).find() || coverageLevel != null && (currentLevel = covInfo.getCoverageLevel(path2, localeID)).compareTo(coverageLevel) > 0) continue;
                paths.add(pathHeaderFactory.fromPath(path2));
            }
            if (englishPaths == null) {
                englishPaths = new HashSet<String>();
                CLDRFile cLDRFile = CheckCLDR.getDisplayInformation();
                ConsoleCheckCLDR.addPrettyPaths(cLDRFile, pathFilter, pathHeaderFactory, noaliases, true, englishPaths);
                ConsoleCheckCLDR.addPrettyPaths(cLDRFile, cLDRFile.getExtraPaths(), pathFilter, pathHeaderFactory, noaliases, true, englishPaths);
                englishPaths = Collections.unmodifiableSet(englishPaths);
            }
            UnicodeSet unicodeSet = new UnicodeSet();
            UnicodeSet missingCurrencyExemplars = new UnicodeSet();
            if (checkFlexibleDates) {
                fset.set(file);
            }
            pathShower.set(localeID);
            ExampleGenerator exampleGenerator = SHOW_EXAMPLES ? new ExampleGenerator(file, englishFile, CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY) : null;
            int pathCount = 0;
            CLDRFile.Status otherPath = new CLDRFile.Status();
            for (PathHeader pathHeader : paths) {
                String sourceLocaleID;
                ++pathCount;
                path = pathHeader.getOriginalPath();
                String prettyPath = pathHeader.toString().replace('\t', '|').replace(' ', '_');
                if (!showAll && !file.isWinningPath(path) || !isLanguageLocale && !baileyTest && (!localeID.equals(sourceLocaleID = file.getSourceLocaleID(path, otherPath)) || !path.equals(otherPath.pathWhereFound)) || path.contains("@alt") && path.contains("proposed")) continue;
                String value = file.getStringValue(path);
                if (baileyTest) {
                    value = CldrUtility.INHERITANCE_MARKER;
                }
                fullPath = file.getFullXPath(path);
                example = "";
                if (SHOW_EXAMPLES) {
                    example = ExampleGenerator.simplify(exampleGenerator.getExampleHtml(path, value));
                    ConsoleCheckCLDR.showExamples(checkCldr, prettyPath, localeID, path, value, fullPath, example);
                }
                if (checkFlexibleDates) {
                    fset.checkFlexibles(path, value, fullPath);
                }
                if (path.contains("duration-century")) {
                    boolean bl = false;
                }
                int limit = 1;
                for (int jj = 0; jj < limit; ++jj) {
                    if (jj == 0) {
                        checkCldr.check(path, fullPath, value, new CheckCLDR.Options(options), result);
                    } else {
                        checkCldr.getExamples(path, fullPath, value, new CheckCLDR.Options(options), result);
                    }
                    boolean showedOne = false;
                    for (CheckCLDR.CheckStatus status3 : result) {
                        String statusString = status3.toString();
                        CheckCLDR.CheckStatus.Type statusType = status3.getType();
                        Object[] parameters = status3.getParameters();
                        if (parameters != null && parameters.length >= 1 && status3.getCause().getClass() == CheckForExemplars.class) {
                            try {
                                UnicodeSet set = new UnicodeSet(parameters[0].toString());
                                if (status3.getMessage().contains("currency")) {
                                    missingCurrencyExemplars.addAll(set);
                                } else {
                                    unicodeSet.addAll(set);
                                }
                            }
                            catch (RuntimeException set) {
                                // empty catch block
                            }
                        }
                        if (errorsOnly && !statusType.equals((Object)CheckCLDR.CheckStatus.errorType) || subtypeFilter != null && !subtypeFilter.contains((Object)status3.getSubtype()) || checkOnSubmit && (!status3.isCheckOnSubmit() || !statusType.equals((Object)CheckCLDR.CheckStatus.errorType))) continue;
                        if (statusType.equals((Object)CheckCLDR.CheckStatus.demoType)) {
                            CheckCLDR.SimpleDemo d = status3.getDemo();
                            if (d == null || !(d instanceof CheckCLDR.FormatDemo)) continue;
                            CheckCLDR.FormatDemo fd = (CheckCLDR.FormatDemo)d;
                            m4.clear();
                            if (!d.processPost(m4)) continue;
                            System.out.println("\tDemo:\t" + fd.getPlainText(m4));
                            continue;
                        }
                        if (parameters != null) {
                            for (int i = 0; i < parameters.length; ++i) {
                                if (!showStackTrace || !(parameters[i] instanceof Throwable)) continue;
                                ((Throwable)parameters[i]).printStackTrace();
                            }
                        }
                        ConsoleCheckCLDR.showValue(file, prettyPath, localeID, example, path, value, fullPath, statusString, status3.getSubtype());
                        showedOne = true;
                    }
                    if (showedOne || phase == CheckCLDR.Phase.FINAL_TESTING || showedOne || !showAll) continue;
                    ConsoleCheckCLDR.showValue(file, prettyPath, localeID, example, path, value, fullPath, "ok", CheckCLDR.CheckStatus.Subtype.none);
                    showedOne = true;
                }
            }
            if (resolveVotesDirectory != null) {
                LocaleVotingData.resolveErrors(localeID);
            }
            ConsoleCheckCLDR.showSummary(localeID, level, "Items (including inherited):\t" + pathCount);
            if (unicodeSet.size() != 0) {
                unicodeSet.removeAll(new UnicodeSet("[[:Uppercase:]-[\u0130]]"));
                if (unicodeSet.size() != 0) {
                    col = Collator.getInstance(new ULocale(localeID));
                    ConsoleCheckCLDR.showSummary(localeID, level, "Total missing from general exemplars:\t" + unicodeSet.size() + "\t" + new UnicodeSetPrettyPrinter().setOrdering(col != null ? col : Collator.getInstance(ULocale.ROOT)).setSpaceComparator(col != null ? col : Collator.getInstance(ULocale.ROOT).setStrength2(0)).setCompressRanges(false).format(unicodeSet));
                }
            }
            if (missingCurrencyExemplars.size() != 0) {
                col = Collator.getInstance(new ULocale(localeID));
                ConsoleCheckCLDR.showSummary(localeID, level, "Total missing from currency exemplars:\t" + new UnicodeSetPrettyPrinter().setOrdering(col != null ? col : Collator.getInstance(ULocale.ROOT)).setSpaceComparator(col != null ? col : Collator.getInstance(ULocale.ROOT).setStrength2(0)).setCompressRanges(true).format(missingCurrencyExemplars));
            }
            for (ErrorType type : subtotalCount.keySet()) {
                ConsoleCheckCLDR.showSummary(localeID, level, "Subtotal " + (Object)((Object)type) + ":\t" + subtotalCount.getCount(type));
            }
            if (checkFlexibleDates) {
                fset.showFlexibles();
            }
            if (SHOW_EXAMPLES) {
                for (String zone : StandardCodes.make().getGoodAvailableCodes("tzid")) {
                    path = "//ldml/dates/timeZoneNames/zone[@type=\"" + zone + "\"]/exemplarCity";
                    PathHeader pathHeader = pathHeaderFactory.fromPath(path);
                    String prettyPath = pathHeader.toString().replace('\t', '|').replace(' ', '_');
                    if (pathFilter != null && !pathFilter.reset(path).matches() || (fullPath = file.getStringValue(path)) != null) continue;
                    example = ExampleGenerator.simplify(exampleGenerator.getExampleHtml(path, null));
                    ConsoleCheckCLDR.showExamples(checkCldr, prettyPath, localeID, path, null, fullPath, example);
                }
            }
            System.out.println("# Elapsed time: " + timer);
            System.out.flush();
        }
        if (ErrorFile.errorFileWriter != null) {
            ErrorFile.closeErrorFile();
        }
        if (ErrorFile.generated_html_directory != null) {
            ErrorFile.writeErrorCountsText();
            ErrorFile.writeErrorFileIndex();
        }
        System.out.println();
        for (ErrorType type : totalCount.keySet()) {
            System.out.println("# Total " + (Object)((Object)type) + ":\t" + totalCount.getCount(type));
        }
        System.out.println();
        System.out.println("# Total elapsed time: " + totalTimer);
        if (fatalErrors.size() != 0) {
            System.out.println("# FATAL ERRORS:");
        }
        if ((errorCount = totalCount.getCount(ErrorType.error) + (long)fatalErrors.size()) != 0L) {
            System.out.println();
            System.out.println("<< FAILURE - Error count is " + errorCount + " . >>");
            System.exit(-1);
        } else {
            System.out.println();
            System.out.println("<< SUCCESS - No errors found. >>");
        }
        checkCldr.handleFinish();
    }

    private static String getValue(int item) {
        return String.valueOf(item);
    }

    private static void showSummary(String localeID, Level level, String value) {
        String line = "# " + ConsoleCheckCLDR.getLocaleAndName(localeID) + "\tSummary\t" + (Object)((Object)level) + "\t" + value;
        System.out.println(line);
    }

    private static void showExamples(CheckCLDR checkCldr, String prettyPath, String localeID, String path, String value, String fullPath, String example) {
        if (example != null) {
            ConsoleCheckCLDR.showValue(checkCldr.getCldrFileToCheck(), prettyPath, localeID, example, path, value, fullPath, "ok", CheckCLDR.CheckStatus.Subtype.none);
        }
    }

    private static void addPrettyPaths(CLDRFile file, Matcher pathFilter, PathHeader.Factory pathHeaderFactory, boolean noaliases, boolean filterDraft, Collection<String> target) {
        Iterator<String> pit = file.iterator(pathFilter);
        while (pit.hasNext()) {
            String path = pit.next();
            ConsoleCheckCLDR.addPrettyPath(file, pathHeaderFactory, noaliases, filterDraft, target, path);
        }
    }

    private static void addPrettyPaths(CLDRFile file, Collection<String> paths, Matcher pathFilter, PathHeader.Factory pathHeaderFactory, boolean noaliases, boolean filterDraft, Collection<String> target) {
        for (String path : paths) {
            if (pathFilter != null && !pathFilter.reset(path).matches()) continue;
            ConsoleCheckCLDR.addPrettyPath(file, pathHeaderFactory, noaliases, filterDraft, target, path);
        }
    }

    private static void addPrettyPath(CLDRFile file, PathHeader.Factory pathHeaderFactory, boolean noaliases, boolean filterDraft, Collection<String> target, String path) {
        String value;
        String newPath;
        if (noaliases && XMLSource.Alias.isAliasPath(path)) {
            return;
        }
        if (filterDraft && !(newPath = CLDRFile.getNondraftNonaltXPath(path)).equals(path) && (value = file.getStringValue(newPath)) != null) {
            return;
        }
        String prettyPath = pathHeaderFactory.fromPath(path).toString();
        target.add(prettyPath);
    }

    public static synchronized void setDisplayInformation(CLDRFile inputDisplayInformation, ExampleGenerator inputExampleGenerator) {
        CheckCLDR.setDisplayInformation(inputDisplayInformation);
        englishExampleGenerator = inputExampleGenerator;
    }

    public static synchronized void setExampleGenerator(ExampleGenerator inputExampleGenerator) {
        englishExampleGenerator = inputExampleGenerator;
    }

    public static synchronized ExampleGenerator getExampleGenerator() {
        return englishExampleGenerator;
    }

    private static void showHeaderLine() {
        if (SHOW_LOCALE) {
            if (idView) {
                System.out.println("Locale\tID\tDesc.\t\u3008Eng.Value\u3009\t\u3010Eng.Ex.\u3011\t\u3008Loc.Value\u3009\t\u3010Loc.Ex\u3011\t\u2045error/warning type\u2046\t\u276eError/Warning Msg\u276f");
            } else {
                System.out.println("Locale\tStatus\t\u25b8PPath\u25c2\t\u3008Eng.Value\u3009\t\u3010Eng.Ex.\u3011\t\u3008Loc.Value\u3009\t\u00abfill-in\u00bb\t\u3010Loc.Ex\u3011\t\u2045error/warning type\u2046\t\u276eError/Warning Msg\u276f\tFull Path\tAliasedSource/Path?");
            }
        }
    }

    private static String getIdString(String path, String value) {
        if (pathDescription == null) {
            pathDescription = new PathDescription(supplementalDataInfo, english, null, null, PathDescription.ErrorHandling.CONTINUE);
        }
        String description = pathDescription.getDescription(path, value, null, null);
        return "\t" + StringId.getId(path) + "\t" + description + "";
    }

    private static void showValue(CLDRFile cldrFile, String prettyPath, String localeID, String example, String path, String value, String fullPath, String statusString, CheckCLDR.CheckStatus.Subtype subType) {
        ErrorType shortStatus = ErrorType.fromStatusString(statusString);
        subtotalCount.add(shortStatus, 1L);
        totalCount.add(shortStatus, 1L);
        if (subType == null) {
            subType = CheckCLDR.CheckStatus.Subtype.none;
        }
        if (ErrorFile.errorFileWriter == null) {
            String otherPath;
            String otherSource;
            String fillinValue;
            String englishPathValue;
            example = example == null ? "" : example;
            String englishExample = null;
            String string = englishPathValue = path == null ? null : ConsoleCheckCLDR.getEnglishPathValue(path);
            if (SHOW_EXAMPLES && path != null) {
                englishExample = ExampleGenerator.simplify(ConsoleCheckCLDR.getExampleGenerator().getExampleHtml(path, englishPathValue));
            }
            englishExample = englishExample == null ? "" : englishExample;
            String cleanPrettyPath = path == null ? null : prettyPath;
            CLDRFile.Status status = new CLDRFile.Status();
            String sourceLocaleID = path == null ? null : cldrFile.getSourceLocaleID(path, status);
            String string2 = fillinValue = path == null ? null : cldrFile.getFillInValue(path);
            fillinValue = fillinValue == null ? "" : (fillinValue.equals(value) ? "=" : fillinValue);
            String pathLink = CLDR_CONFIG.urls().forXpath(localeID, path);
            String string3 = path == null ? null : (otherSource = sourceLocaleID.equals(localeID) ? "" : "\t" + sourceLocaleID);
            String string4 = path == null ? null : (otherPath = status.pathWhereFound.equals(path) ? "" : "\t" + status.pathWhereFound);
            String idViewString = idView ? (path == null ? "\tNO_ID" : ConsoleCheckCLDR.getIdString(path, value)) : "";
            System.out.println(ConsoleCheckCLDR.getLocaleAndName(localeID) + (idViewString.isEmpty() ? "\t" + (Object)((Object)shortStatus) + "\t\u25b8" + cleanPrettyPath + "\u25c2\t\u3008" + englishPathValue + "\u3009\t\u3010" + englishExample + "\u3011\t\u3008" + value + "\u3009\t\u00ab" + fillinValue + "\u00bb\t\u3010" + example + "\u3011\t\u2045" + (Object)((Object)subType) + "\u2046\t\u276e" + statusString + "\u276f\t" + pathLink + otherSource + otherPath : idViewString + "\t\u3008" + englishPathValue + "\u3009\t\u3010" + englishExample + "\u3011\t" + value + "\u3009\t\u3010" + example + "\u3011\t\u2045" + (Object)((Object)subType) + "\u2046\t\u276e" + statusString + "\u276f"));
        } else if (ErrorFile.errorFileWriter != null) {
            if (shortStatus == ErrorType.contributed) {
                return;
            }
            if (shortStatus == ErrorType.posix) {
                shortStatus = ErrorType.minimal;
            }
            if (!localeID.equals(lastHtmlLocaleID)) {
                ErrorFile.writeErrorCountsText();
                lastHtmlLocaleID = localeID;
            }
            ConsoleCheckCLDR.addError(shortStatus);
            ErrorFile.addDataToErrorFile(localeID, path, shortStatus, subType);
        }
        if (CLDR_GITHUB_ANNOTATIONS) {
            String filePath = localeXpathToFilePath.computeIfAbsent(Pair.of(localeID, path), locPath -> ConsoleCheckCLDR.guessFilePath(locPath));
            if (shortStatus == ErrorType.error || shortStatus == ErrorType.warning) {
                String cleanPrettyPath = path == null ? "\u2014" : prettyPath;
                System.out.println("::" + (Object)((Object)shortStatus) + " file=" + filePath + ":: " + localeID + ": " + (Object)((Object)subType) + " @ " + cleanPrettyPath);
            }
        }
    }

    private static void addError(ErrorType shortStatus) {
        if (ErrorType.showInSummary.contains((Object)shortStatus)) {
            ErrorFile.htmlErrorsPerLocale.increment(shortStatus);
        }
    }

    private static void showValue(String path, String value, boolean showEnglish, String localeID) {
        System.out.println("\tValue:\t" + value + (showEnglish ? "\t" + ConsoleCheckCLDR.getEnglishPathValue(path) : "") + "\tLocale:\t" + localeID);
    }

    private static String getEnglishPathValue(String path) {
        String englishValue = CheckCLDR.getDisplayInformation().getWinningValue(path);
        if (englishValue == null) {
            String path2 = CLDRFile.getNondraftNonaltXPath(path);
            englishValue = CheckCLDR.getDisplayInformation().getWinningValue(path2);
        }
        return englishValue;
    }

    public static String getLocaleAndName(String locale) {
        String localizedName = CheckCLDR.getDisplayInformation().getName(locale);
        if (localizedName == null || localizedName.equals(locale)) {
            return locale;
        }
        return locale + " [" + localizedName + "]";
    }

    public static String getNameAndLocale(String locale, boolean linkToXml) {
        String localizedName = CheckCLDR.getDisplayInformation().getName(locale);
        if (localizedName == null || localizedName.equals(locale)) {
            return locale;
        }
        if (linkToXml) {
            locale = "<a href='http://unicode.org/cldr/data/common/main/" + locale + ".xml'>" + locale + "</a>";
        }
        return localizedName + " [" + locale + "]";
    }

    public static String getLocaleName(String locale) {
        String localizedName = CheckCLDR.getDisplayInformation().getName(locale);
        if (localizedName == null || localizedName.equals(locale)) {
            return locale;
        }
        return localizedName;
    }

    public static String getLinkedLocale(String locale) {
        return "<a href='http://unicode.org/cldr/apps/survey?_=" + locale + "'>" + locale + "</a>";
    }

    public static String guessFilePath(Pair<String, String> locPath) {
        File subFile;
        File subFile2;
        File base = new File(CLDRPaths.BASE_DIRECTORY);
        String loc = locPath.getFirst();
        String path = locPath.getSecond();
        String subdir = "main";
        if (path.startsWith("//ldml/annotations")) {
            subdir = "annotations";
        } else if (path.startsWith("//ldml/subdivisions")) {
            subdir = "subdivisions";
        }
        File inCommon = new File(base, "common");
        File subsub = new File(inCommon, subdir);
        if (subsub.isDirectory() && (subFile2 = new File(subsub, loc + ".xml")).canRead()) {
            return subFile2.getAbsolutePath().substring(base.getAbsolutePath().length() + 1);
        }
        File inSeed = new File(base, "seed");
        subsub = new File(inSeed, subdir);
        if (subsub.isDirectory() && (subFile = new File(subsub, loc + ".xml")).canRead()) {
            return subFile.getAbsolutePath().substring(base.getAbsolutePath().length() + 1);
        }
        return loc + ".xml";
    }

    static {
        coverageMatcher = PatternCache.get("meet ([a-z]*) coverage").matcher("");
        pathDescription = null;
        lastHtmlLocaleID = "";
        localeXpathToFilePath = new ConcurrentHashMap();
    }

    static enum MyOptions {
        coverage(new Option.Params().setHelp("Set the coverage: eg -c comprehensive").setMatch("comprehensive|modern|moderate|basic")),
        examples(new Option.Params().setHelp("Turn on examples (actually a summary of the demo)").setFlag('x')),
        file_filter(new Option.Params().setHelp("Pick the locales (files) to check: arg is a regular expression, eg -f fr, or -f fr.*, or -f (fr|en-.*)").setDefault(".*").setMatch(".*")),
        test_filter(new Option.Params().setHelp("Filter the Checks: arg is a regular expression, eg -t.*number.*. To check all BUT a given test, use the style -t ((?!.*CheckZones).*)").setDefault(".*").setMatch(".*")),
        date_formats(new Option.Params().setHelp("Turn on special date format checks")),
        organization(new Option.Params().setHelp("Organization: ibm, google, ....; Uses Locales.txt for to filter locales and set coverage levels").setDefault(".*").setMatch(".*")),
        showall(new Option.Params().setHelp("Show all paths, including aliased").setFlag('a')),
        path_filter(new Option.Params().setHelp("Pick the paths to check, eg -p.*languages.*").setDefault(".*").setMatch(".*")),
        errors_only(new Option.Params().setHelp("Show errors only (with -ef, only final processing errors)")),
        check_on_submit(new Option.Params().setHelp("").setFlag('k')),
        noaliases(new Option.Params().setHelp("No aliases")),
        source_directory(new Option.Params().setHelp("Fully qualified source directories. (Conflicts with -S.)").setDefault(SOURCE_DIRS).setMatch(".*")),
        user(new Option.Params().setHelp("User, eg -uu148").setMatch(".*")),
        phase(new Option.Params().setHelp("?").setMatch(CheckCLDR.Phase.class).setFlag('z')),
        generate_html(new Option.Params().setHelp("Generate HTML-style chart in directory.").setDefault(CLDRPaths.CHART_DIRECTORY + "/errors/").setMatch(".*")),
        vote_resolution(new Option.Params().setHelp("")),
        id_view(new Option.Params().setHelp("")),
        subtype_filter(new Option.Params().setHelp("error/warning subtype filter, eg unexpectedOrderOfEraYear").setDefault(".*").setMatch(".*").setFlag('y')),
        source_all(new Option.Params().setHelp("Partially qualified directories. Standard subdirectories added if not specified (/main, /annotations, /subdivisions). (Conflicts with -s.)").setMatch(".*").setFlag('S').setDefault("common,seed,exemplars")),
        bailey(new Option.Params().setHelp("check bailey values (" + CldrUtility.INHERITANCE_MARKER + ")")),
        exemplarError(new Option.Params().setFlag('E').setHelp("include to force strict Exemplar check"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args, boolean showArguments) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }

    static class ErrorFile {
        private static final boolean SHOW_VOTING_INFO = false;
        public static CLDRFile voteFile;
        public static Factory voteFactory;
        static TablePrinter errorFileTable;
        static Counter<Row.R4<String, String, ErrorType, CheckCLDR.CheckStatus.Subtype>> errorFileCounter;
        static Relation<Organization, String> orgToLocales;
        static Counter<ErrorType> htmlErrorsPerLocale;
        static PrintWriter generated_html_count;
        private static TreeMap<String, Pair<String, Counter<ErrorType>>> errorFileIndexData;
        static PrintWriter errorFileWriter;
        private static final String ERROR_CHART_HEADER;
        static String generated_html_directory;
        public static Counter<Row.R4<String, ErrorType, CheckCLDR.CheckStatus.Subtype, String>> sectionToProblemsToLocaleToCount;

        ErrorFile() {
        }

        private static void openErrorFile(String localeID, String baseLanguage) throws IOException {
            if (errorFileWriter != null) {
                ErrorFile.closeErrorFile();
            }
            errorFileWriter = FileUtilities.openUTF8Writer(generated_html_directory, baseLanguage + ".html");
            errorFileTable = new TablePrinter();
            errorFileCounter.clear();
            errorFileTable.setCaption("Problem Details").addColumn("Problem").setCellAttributes("align=\"left\" class=\"{0}\"").setSortPriority(0).setSpanRows(true).setBreakSpans(true).setRepeatHeader(true).setHeaderCell(true).addColumn("Subtype").setCellAttributes("align=\"left\" class=\"{1}\"").setSortPriority(1).setSpanRows(true).setBreakSpans(true).setRepeatHeader(true).setHeaderCell(true).addColumn("Locale").setCellAttributes("class=\"{1}\"").setCellPattern("<a href=\"http://unicode.org/cldr/apps/survey?_={0}\">{0}</a>").setSortPriority(2).setSpanRows(true).setBreakSpans(true).addColumn("Name").setCellAttributes("class=\"{1}\"").setSpanRows(true).setBreakSpans(true).addColumn("Section").setCellAttributes("class=\"{1}\"").setSortPriority(3).setCellPattern("<a href=\"http://unicode.org/cldr/apps/survey?_={3}&x={0}\">{0}</a>").setSpanRows(true).addColumn("Count").setCellAttributes("class=\"{1}\" align=\"right\"");
            ErrorFile.showIndexHead("", localeID, errorFileWriter);
        }

        private static void addDataToErrorFile(String localeID, String path, ErrorType shortStatus, CheckCLDR.CheckStatus.Subtype subType) {
            String section;
            String string = section = path == null ? null : XPathToMenu.xpathToMenu(path);
            if (section == null) {
                section = "general";
            }
            errorFileCounter.add(new Row.R4<String, String, ErrorType, CheckCLDR.CheckStatus.Subtype>(localeID, section, shortStatus, subType), 1L);
            sectionToProblemsToLocaleToCount.add(new Row.R4<String, ErrorType, CheckCLDR.CheckStatus.Subtype, String>(section, shortStatus, subType, localeID), 1L);
        }

        private static void closeErrorFile() {
            TreeSet<String> locales = new TreeSet<String>();
            for (Row.R4<String, String, ErrorType, CheckCLDR.CheckStatus.Subtype> item : errorFileCounter.keySet()) {
                String localeID = (String)item.get0();
                locales.add(localeID);
                String section = (String)item.get1();
                ErrorType shortStatus = (ErrorType)((Object)item.get2());
                CheckCLDR.CheckStatus.Subtype subtype = (CheckCLDR.CheckStatus.Subtype)((Object)item.get3());
                errorFileTable.addRow().addCell((Comparable)((Object)shortStatus)).addCell((Comparable)((Object)subtype)).addCell((Comparable)((Object)localeID)).addCell((Comparable)((Object)ConsoleCheckCLDR.getLocaleName(localeID))).addCell((Comparable)((Object)section)).addCell(Long.valueOf(errorFileCounter.getCount(item))).finishRow();
            }
            errorFileWriter.println(errorFileTable.toTable());
            errorFileWriter.println(ShowData.dateFooter());
            errorFileWriter.println("<script>\nvar gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");\ndocument.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));\n</script>\n<script>\ntry {\nvar pageTracker = _gat._getTracker(\"UA-7672775-1\");\npageTracker._trackPageview();\n} catch(err) {}</script>");
            errorFileWriter.println("</body></html>");
            errorFileWriter.close();
            errorFileTable = null;
        }

        static void showErrorFileIndex(PrintWriter generated_html_index) {
            Relation<Organization, String> orgToLocales = ErrorFile.getOrgToLocales();
            TablePrinter indexTablePrinter = new TablePrinter().setCaption("Problem Summary").setTableAttributes("border='1' style='border-collapse: collapse' bordercolor='blue'").addColumn("BASE").setHidden(true).addColumn("Locale").setCellPattern("<a name=\"{0}\" href=\"{1}.html\">{0}</a>").addColumn("Name");
            for (Organization org : orgToLocales.keySet()) {
                indexTablePrinter.addColumn(org.toString().substring(0, 2));
            }
            indexTablePrinter.addColumn("Disputed").setHeaderAttributes("class='disputed'").setCellAttributes("class='disputed'").addColumn("Conflicted").setHeaderAttributes("class='conflicted'").setCellAttributes("class='conflicted'");
            for (ErrorType type : ErrorType.showInSummary) {
                String columnTitle = UCharacter.toTitleCase(type.toString(), null);
                boolean coverage = ErrorType.coverage.contains((Object)type);
                if (coverage) {
                    columnTitle = "MC: " + columnTitle;
                } else if (ErrorType.unapproved.contains((Object)type)) {
                    columnTitle = "MV: " + columnTitle;
                }
                indexTablePrinter.addColumn(columnTitle).setHeaderAttributes("class='" + (Object)((Object)type) + "'").setCellAttributes("class='" + (Object)((Object)type) + "'");
            }
            LanguageTagParser ltp = new LanguageTagParser();
            for (String key : errorFileIndexData.keySet()) {
                Pair<String, Counter<ErrorType>> pair = errorFileIndexData.get(key);
                String htmlOpenedFileLanguage = pair.getFirst();
                Counter<ErrorType> counts = pair.getSecond();
                LocaleVotingData votingData = LocaleVotingData.get(htmlOpenedFileLanguage);
                if (counts.getTotal() == 0L) continue;
                String baseLanguage = ltp.set(htmlOpenedFileLanguage).getLanguage();
                indexTablePrinter.addRow().addCell((Comparable)((Object)baseLanguage)).addCell((Comparable)((Object)htmlOpenedFileLanguage)).addCell((Comparable)((Object)ConsoleCheckCLDR.getLocaleName(htmlOpenedFileLanguage)));
                for (Organization org : orgToLocales.keySet()) {
                    indexTablePrinter.addCell((Comparable)((Object)(orgToLocales.getAll((Object)org).contains(htmlOpenedFileLanguage) ? org.toString().substring(0, 2) : "")));
                }
                indexTablePrinter.addCell((Comparable)((Object)(votingData == null ? "" : ErrorFile.formatSkippingZero(votingData.getDisputedCount())))).addCell((Comparable)((Object)(votingData == null ? "" : votingData.getConflictedHTML())));
                for (ErrorType type : ErrorType.showInSummary) {
                    indexTablePrinter.addCell((Comparable)((Object)ErrorFile.formatSkippingZero(counts.getCount(type))));
                }
                indexTablePrinter.finishRow();
            }
            generated_html_index.println(indexTablePrinter.toTable());
            generated_html_index.println(ShowData.dateFooter());
            generated_html_index.println("<script>\nvar gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");\ndocument.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));\n</script>\n<script>\ntry {\nvar pageTracker = _gat._getTracker(\"UA-7672775-1\");\npageTracker._trackPageview();\n} catch(err) {}</script>");
            generated_html_index.println("</body></html>");
        }

        private static Relation<Organization, String> getOrgToLocales() {
            if (orgToLocales == null) {
                orgToLocales = Relation.of(new TreeMap(), TreeSet.class);
                StandardCodes sc = StandardCodes.make();
                for (Organization org : sc.getLocaleCoverageOrganizations()) {
                    for (String locale : sc.getLocaleCoverageLocales(org)) {
                        Level x = sc.getLocaleCoverageLevel(org, locale);
                        if (x.compareTo(Level.BASIC) <= 0) continue;
                        orgToLocales.put(org, locale);
                    }
                }
            }
            return orgToLocales;
        }

        static void showSections() throws IOException {
            Relation<Organization, String> orgToLocales = ErrorFile.getOrgToLocales();
            TablePrinter indexTablePrinter = new TablePrinter().setCaption("Problem Summary").setTableAttributes("border='1' style='border-collapse: collapse' bordercolor='blue'").addColumn("Section").setSpanRows(true).setBreakSpans(true).addColumn("Problems").setCellAttributes("style=\"text-align:left\" class=\"{2}\"").setSpanRows(true).addColumn("Subtype").setCellAttributes("style=\"text-align:left\" class=\"{2}\"").setSpanRows(true).addColumn("Locale").setCellAttributes("class=\"{2}\"").addColumn("Code").setCellAttributes("class=\"{2}\"").setCellPattern("<a href=\"http://unicode.org/cldr/apps/survey?_={0}&x={1}\">{0}</a>").addColumn("Count").setCellAttributes("class=\"{2}\"");
            for (Organization organization : orgToLocales.keySet()) {
                indexTablePrinter.addColumn(organization.toString().substring(0, 2));
            }
            for (Row.R4 r4 : sectionToProblemsToLocaleToCount.getKeysetSortedByKey()) {
                ErrorType problem = (ErrorType)((Object)r4.get1());
                CheckCLDR.CheckStatus.Subtype subtype = (CheckCLDR.CheckStatus.Subtype)((Object)r4.get2());
                if (!ErrorType.showInSummary.contains((Object)problem)) continue;
                String locale = (String)r4.get3();
                if (problem != ErrorType.error && problem != ErrorType.disputed && !orgToLocales.containsValue(locale)) continue;
                long count = sectionToProblemsToLocaleToCount.getCount(r4);
                String section = (String)r4.get0();
                indexTablePrinter.addRow().addCell((Comparable)((Object)section)).addCell((Comparable)((Object)problem)).addCell((Comparable)((Object)subtype)).addCell((Comparable)((Object)ConsoleCheckCLDR.getLocaleName(locale))).addCell((Comparable)((Object)locale)).addCell(Long.valueOf(count));
                for (Organization org : orgToLocales.keySet()) {
                    indexTablePrinter.addCell((Comparable)((Object)(orgToLocales.getAll((Object)org).contains(locale) ? org.toString().substring(0, 2) : "")));
                }
                indexTablePrinter.finishRow();
            }
            PrintWriter generated_html_index = FileUtilities.openUTF8Writer(generated_html_directory, "sections.html");
            ErrorFile.showIndexHead("Error Report Index by Section", "", generated_html_index);
            generated_html_index.println(indexTablePrinter.toTable());
            generated_html_index.println(ShowData.dateFooter());
            generated_html_index.println("<script>\nvar gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");\ndocument.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));\n</script>\n<script>\ntry {\nvar pageTracker = _gat._getTracker(\"UA-7672775-1\");\npageTracker._trackPageview();\n} catch(err) {}</script>");
            generated_html_index.println("</body></html>");
            generated_html_index.close();
        }

        static String formatSkippingZero(long count) {
            if (count == 0L) {
                return "";
            }
            return String.valueOf(count);
        }

        static void showIndexHead(String title, String localeID, PrintWriter generated_html_index) {
            boolean notLocaleSpecific;
            boolean bl = notLocaleSpecific = localeID.length() == 0;
            if (!notLocaleSpecific) {
                title = "Errors in " + ConsoleCheckCLDR.getNameAndLocale(localeID, false);
            }
            generated_html_index.println("<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>\n<title>" + title + "</title>" + "\n" + "<link rel='stylesheet' href='errors.css' type='text/css'>" + "\n" + "<base target='_blank'>" + "\n" + "</head><body>" + "\n" + "<h1>" + title + "</h1>" + "\n" + "<p><a href='index.html" + (notLocaleSpecific ? "" : "#" + localeID) + "'>Index</a> | <a href='sections.html" + (notLocaleSpecific ? "" : "#" + localeID) + "'>Index by Section</a> | <a href='http://unicode.org/cldr/data/docs/survey/vetting.html'><b style='background-color: yellow;'><i>Help: How to Vet</i></b></a></p><p>The following errors have been detected in the locale" + (notLocaleSpecific ? "s. " + HelpMessages.getChartMessages("error_index_header") : " " + ConsoleCheckCLDR.getNameAndLocale(localeID, false) + ". " + ERROR_CHART_HEADER));
        }

        private static void writeErrorFileIndex() throws IOException {
            PrintWriter generated_html_index = FileUtilities.openUTF8Writer(generated_html_directory, "index.html");
            ErrorFile.showIndexHead("Error Report Index", "", generated_html_index);
            ErrorFile.showErrorFileIndex(generated_html_index);
            generated_html_index.close();
            ErrorFile.showSections();
        }

        private static void writeErrorCountsText() {
            generated_html_count.print(lastHtmlLocaleID + ";\tcounts");
            for (ErrorType type : ErrorType.showInSummary) {
                generated_html_count.print(";\t" + (Object)((Object)type) + "=" + htmlErrorsPerLocale.getCount(type));
            }
            generated_html_count.println();
            generated_html_count.flush();
            errorFileIndexData.put(lastHtmlLocaleID, new Pair<String, Counter<ErrorType>>(lastHtmlLocaleID, htmlErrorsPerLocale));
            htmlErrorsPerLocale = new Counter();
        }

        static {
            errorFileTable = new TablePrinter();
            errorFileCounter = new Counter(true);
            htmlErrorsPerLocale = new Counter();
            generated_html_count = null;
            errorFileIndexData = new TreeMap();
            errorFileWriter = null;
            ERROR_CHART_HEADER = HelpMessages.getChartMessages("error_locale_header");
            generated_html_directory = null;
            sectionToProblemsToLocaleToCount = new Counter();
        }
    }

    public static class PathShower {
        String localeID;
        boolean newLocale = true;
        String lastPath;
        String[] lastSplitPath;
        boolean showEnglish;
        String splitChar = "/";
        static final String lead = "****************************************";

        public void set(String localeID) {
            this.localeID = localeID;
            this.newLocale = true;
            LocaleIDParser localeIDParser = new LocaleIDParser();
            this.showEnglish = !localeIDParser.set(localeID).getLanguageScript().equals("en");
            this.lastPath = null;
            this.lastSplitPath = null;
        }

        public String getSplitChar() {
            return this.splitChar;
        }

        public PathShower setSplitChar(String splitChar) {
            this.splitChar = splitChar;
            return this;
        }
    }

    static class LocaleVotingData {
        private int disputedCount = 0;
        Counter<Organization> missingOrganizationCounter = new Counter(true);
        Counter<Organization> goodOrganizationCounter = new Counter(true);
        Counter<Organization> conflictedOrganizations = new Counter(true);
        Counter<VoteResolver.Status> winningStatusCounter = new Counter(true);
        static Map<String, LocaleVotingData> localeToErrors = new HashMap<String, LocaleVotingData>();
        private static Map<Integer, String> idToPath;

        public static void resolveErrors(String locale) {
            localeToErrors.put(locale, new LocaleVotingData(locale));
        }

        public LocaleVotingData(String locale) {
            Map<Organization, VoteResolver.Level> orgToMaxVote = VoteResolver.getOrganizationToMaxVote(locale);
            Map<Integer, Map<Integer, VoteResolver.CandidateInfo>> info = VoteResolver.getBaseToAlternateToInfo(resolveVotesDirectory + locale + ".xml");
            HashMap<String, Integer> valueToItem = new HashMap<String, Integer>();
            for (int basePath : info.keySet()) {
                VoteResolver.Level maxVoteHere;
                VoteResolver.Level maxVote;
                VoteResolver.CandidateInfo candidateInfo;
                Map<Integer, VoteResolver.CandidateInfo> itemInfo = info.get(basePath);
                voteResolver.clear();
                valueToItem.clear();
                for (int item : itemInfo.keySet()) {
                    String itemValue = ConsoleCheckCLDR.getValue(item);
                    valueToItem.put(itemValue, item);
                    candidateInfo = itemInfo.get(item);
                    if (candidateInfo.oldStatus != null) {
                        voteResolver.setBaseline(itemValue, candidateInfo.oldStatus);
                    }
                    voteResolver.add(itemValue);
                    for (int voter : candidateInfo.voters) {
                        try {
                            voteResolver.add(itemValue, voter);
                        }
                        catch (VoteResolver.UnknownVoterException unknownVoterException) {}
                    }
                }
                EnumSet<Organization> basePathConflictedOrganizations = voteResolver.getConflictedOrganizations();
                this.conflictedOrganizations.addAll(basePathConflictedOrganizations, 1);
                VoteResolver.Status winningStatus = voteResolver.getWinningStatus();
                String winningValue = (String)voteResolver.getWinningValue();
                this.winningStatusCounter.add(winningStatus, 1L);
                if (winningStatus == VoteResolver.Status.approved) continue;
                candidateInfo = itemInfo.get(valueToItem.get(winningValue));
                Map<Organization, VoteResolver.Level> orgToMaxVoteHere = VoteResolver.getOrganizationToMaxVote(candidateInfo.voters);
                if (winningStatus.compareTo(VoteResolver.Status.contributed) < 0) {
                    for (Organization org : orgToMaxVote.keySet()) {
                        maxVote = orgToMaxVote.get((Object)org);
                        maxVoteHere = orgToMaxVoteHere.get((Object)org);
                        if (maxVoteHere != null && maxVoteHere.compareTo(maxVote) >= 0) continue;
                        this.missingOrganizationCounter.add(org, 1L);
                    }
                    if (!voteResolver.isDisputed()) continue;
                    ++this.disputedCount;
                    String path = LocaleVotingData.getIdToPath(basePath);
                    ErrorFile.addDataToErrorFile(locale, path, ErrorType.disputed, CheckCLDR.CheckStatus.Subtype.none);
                    continue;
                }
                for (Organization org : orgToMaxVote.keySet()) {
                    maxVote = orgToMaxVote.get((Object)org);
                    maxVoteHere = orgToMaxVoteHere.get((Object)org);
                    if (maxVoteHere == null || maxVoteHere.compareTo(maxVote) < 0) continue;
                    this.goodOrganizationCounter.add(org, 1L);
                }
            }
            System.out.println(ConsoleCheckCLDR.getLocaleAndName(locale) + "\tEnabled Organizations:\t" + orgToMaxVote);
            if (this.disputedCount != 0) {
                System.out.println(ConsoleCheckCLDR.getLocaleAndName(locale) + "\tDisputed Items:\t" + this.disputedCount);
            }
            if (this.missingOrganizationCounter.size() > 0) {
                System.out.println(ConsoleCheckCLDR.getLocaleAndName(locale) + "\tMIA organizations:\t" + this.missingOrganizationCounter);
                System.out.println(ConsoleCheckCLDR.getLocaleAndName(locale) + "\tConflicted organizations:\t" + this.conflictedOrganizations);
                System.out.println(ConsoleCheckCLDR.getLocaleAndName(locale) + "\tCool organizations!:\t" + this.goodOrganizationCounter);
            }
            System.out.println(ConsoleCheckCLDR.getLocaleAndName(locale) + "\tOptimal Status:\t" + this.winningStatusCounter);
        }

        private static String getIdToPath(int basePath) {
            if (idToPath == null) {
                idToPath = VoteResolver.getIdToPath(resolveVotesDirectory + "xpathTable.xml");
            }
            return idToPath.get(basePath);
        }

        public static LocaleVotingData get(String locale) {
            return localeToErrors.get(locale);
        }

        int getDisputedCount() {
            return this.disputedCount;
        }

        String getConflictedHTML() {
            String result = this.conflictedOrganizations.toString();
            if (result.length() == 0) {
                return "";
            }
            result = result.substring(1, result.length() - 1);
            result = result.replace(", ", "<br>");
            return result;
        }
    }

    static enum ErrorType {
        ok,
        error,
        disputed,
        warning,
        core,
        posix,
        minimal,
        basic,
        moderate,
        modern,
        comprehensive,
        optional,
        contributed,
        provisional,
        unconfirmed,
        unknown;

        static EnumSet<ErrorType> unapproved;
        static EnumSet<ErrorType> coverage;
        static EnumSet<ErrorType> showInSummary;

        static ErrorType fromStatusString(String statusString) {
            ErrorType shortStatus;
            ErrorType errorType = statusString.equals("ok") ? ok : (statusString.startsWith("Error") ? error : (statusString.equals("disputed") ? disputed : (statusString.startsWith("Warning") ? warning : (statusString.equals("contributed") ? contributed : (statusString.equals("provisional") ? provisional : (shortStatus = statusString.equals("unconfirmed") ? unconfirmed : unknown))))));
            if (shortStatus == unknown) {
                throw new IllegalArgumentException("Unknown error type: " + statusString);
            }
            if (shortStatus == warning && coverageMatcher.reset(statusString).find()) {
                shortStatus = ErrorType.valueOf(coverageMatcher.group(1));
            }
            return shortStatus;
        }

        static {
            unapproved = EnumSet.range(contributed, unconfirmed);
            coverage = EnumSet.range(posix, optional);
            showInSummary = EnumSet.of(error, warning, posix, minimal, basic);
        }
    }
}

