/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.test.ExampleDependencies;
import org.unicode.cldr.util.PathStarrer;

class ExampleCache {
    private static final boolean AVOID_CLEARING_CACHE = true;
    private static final String NONE = "\uffff";
    private final Map<String, Map<String, Map<String, String>>> cache = new ConcurrentHashMap<String, Map<String, Map<String, String>>>();
    private final PathStarrer pathStarrer = new PathStarrer().setSubstitutionPattern("*");
    private boolean cachingIsEnabled = true;
    private boolean cacheOnly = false;

    ExampleCache() {
    }

    void setCachingEnabled(boolean enabled) {
        this.cachingIsEnabled = enabled;
    }

    void setCacheOnly(boolean only) {
        this.cacheOnly = only;
    }

    void update(String xpath) {
        String starredA = this.pathStarrer.set(xpath);
        for (String starredB : ExampleDependencies.dependencies.get((Object)starredA)) {
            this.cache.remove(starredB);
        }
    }

    class ExampleCacheItem {
        private String xpath;
        private String value;
        private String starredPath = null;
        private Map<String, Map<String, String>> pathMap = null;
        private Map<String, String> valueMap = null;

        ExampleCacheItem(String xpath, String value) {
            this.xpath = xpath;
            this.value = value;
        }

        String getExample() {
            if (!ExampleCache.this.cachingIsEnabled) {
                return null;
            }
            String result = null;
            this.starredPath = ExampleCache.this.pathStarrer.set(this.xpath);
            this.pathMap = (Map)ExampleCache.this.cache.get(this.starredPath);
            if (this.pathMap != null) {
                this.valueMap = this.pathMap.get(this.xpath);
                if (this.valueMap != null) {
                    result = this.valueMap.get(this.value);
                }
            }
            if (ExampleCache.this.cacheOnly && result == ExampleCache.NONE) {
                throw new InternalError("getExampleHtml cacheOnly not found: " + this.xpath + ", " + this.value);
            }
            return result == ExampleCache.NONE ? null : result;
        }

        void putExample(String result) {
            if (ExampleCache.this.cachingIsEnabled) {
                if (this.pathMap == null) {
                    this.pathMap = new ConcurrentHashMap<String, Map<String, String>>();
                    ExampleCache.this.cache.put(this.starredPath, this.pathMap);
                }
                if (this.valueMap == null) {
                    this.valueMap = new ConcurrentHashMap<String, String>();
                    this.pathMap.put(this.xpath, this.valueMap);
                }
                this.valueMap.put(this.value, result == null ? ExampleCache.NONE : result);
            }
        }
    }
}

