/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.List;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathHeader;

abstract class FactoryCheckCLDR
extends CheckCLDR {
    private Factory factory;
    private CLDRFile resolvedCldrFileToCheck;
    private PathHeader.Factory pathHeaderFactory;

    @Override
    public synchronized CLDRFile getEnglishFile() {
        if (super.getEnglishFile() != null) {
            return super.getEnglishFile();
        }
        try {
            return this.getFactory().make("en", true);
        }
        catch (Exception e) {
            return CLDRConfig.getInstance().getEnglish();
        }
    }

    public synchronized PathHeader.Factory getPathHeaderFactory() {
        if (this.pathHeaderFactory == null) {
            this.pathHeaderFactory = PathHeader.getFactory(this.getEnglishFile() != null ? this.getEnglishFile() : this.getFactory().make("en", true));
        }
        return this.pathHeaderFactory;
    }

    public FactoryCheckCLDR(Factory factory) {
        this.factory = factory;
    }

    public CLDRFile getResolvedCldrFileToCheck() {
        if (this.resolvedCldrFileToCheck == null) {
            this.resolvedCldrFileToCheck = this.factory.make(this.getCldrFileToCheck().getLocaleID(), true);
        }
        return this.resolvedCldrFileToCheck;
    }

    @Override
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.resolvedCldrFileToCheck = null;
        return this;
    }

    public Factory getFactory() {
        return this.factory;
    }

    public String getPathReferenceForMessage(String path, boolean codeOnly) {
        PathHeader pathHeader = this.getPathHeaderFactory().fromPath(path);
        String code = codeOnly ? pathHeader.getCode() : pathHeader.getHeaderCode();
        String referenceToOther = this.getPhase() == CheckCLDR.Phase.FINAL_TESTING ? code : "<a href=\"" + CLDRConfig.getInstance().urls().forPathHeader(this.getCldrFileToCheck().getLocaleID(), pathHeader) + "\">" + code + "</a>";
        return referenceToOther;
    }
}

