/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.StandardCodes;

public final class SubmissionLocales {
    public static Set<String> NEW_CLDR_LOCALES = ImmutableSet.of("ceb", "mai", "mni", "sat", "kok", "sd_Deva", new String[]{"su", "pcm"});
    public static Set<String> HIGH_LEVEL_LOCALES = ImmutableSet.of("chr", "gd", "fo");
    public static Set<String> CLDR_LOCALES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(HIGH_LEVEL_LOCALES)).addAll(NEW_CLDR_LOCALES)).addAll(StandardCodes.make().getLocaleToLevel(Organization.cldr).keySet())).build();
    public static final Pattern ALLOWED_IN_LIMITED_PATHS = Pattern.compile("//ldml/annotations/annotation.*[\ud83e\udd35\ud83d\udc70\u2b06\u27a1\u2b07\u2b05\u267e\u2716\u2795\u2796\u2797]");
    private static final boolean DEBUG_REGEX = false;

    public static boolean allowEvenIfLimited(String localeString, String path, boolean isError, boolean isMissing) {
        if (NEW_CLDR_LOCALES.contains(localeString) || isError) {
            return true;
        }
        boolean bl = false;
        if (!CLDR_LOCALES.contains(localeString)) {
            return false;
        }
        bl = false;
        if (isMissing) {
            return true;
        }
        bl = false;
        if (SubmissionLocales.pathAllowedInLimitedSubmission(path)) {
            return true;
        }
        bl = false;
        return false;
    }

    public static boolean pathAllowedInLimitedSubmission(String path) {
        if (ALLOWED_IN_LIMITED_PATHS == null) {
            return false;
        }
        Matcher matcher = ALLOWED_IN_LIMITED_PATHS.matcher(path);
        boolean result = matcher.lookingAt();
        return result;
    }
}

