/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.impl.Relation;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class TestSupplementalData {
    static CLDRFile english;
    private static SupplementalDataInfo supplementalData;
    private static StandardCodes sc;
    static Matcher numericTerritory;
    private static CLDRFile root;

    public static void main(String[] args) throws IOException {
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        english = cldrFactory.make("en", true);
        root = cldrFactory.make("root", true);
        supplementalData = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
        sc = StandardCodes.make();
        TestSupplementalData.checkPlurals();
        System.out.println("Skipped Elements: " + supplementalData.getSkippedElements());
        TestSupplementalData.checkAgainstLanguageScript();
        TestSupplementalData.checkTerritoryMapping();
        TestSupplementalData.checkTelephoneCodeData();
    }

    private static void checkPlurals() {
        Relation<SupplementalDataInfo.PluralInfo, String> pluralsToLocale = Relation.of(new HashMap(), TreeSet.class);
        for (String locale : new TreeSet<String>(supplementalData.getPluralLocales())) {
            SupplementalDataInfo.PluralInfo pluralInfo = supplementalData.getPlurals(locale);
            System.out.println(locale + ":\t" + pluralInfo);
            pluralsToLocale.put(pluralInfo, locale);
        }
        String locale = "en_US";
        SupplementalDataInfo.PluralInfo pluralInfo = supplementalData.getPlurals(locale);
        System.out.println(locale + ":\t" + pluralInfo);
        for (SupplementalDataInfo.PluralInfo pluralInfo2 : pluralsToLocale.keySet()) {
            System.out.println("Locales: \t" + pluralsToLocale.getAll(pluralInfo2));
            Map<SupplementalDataInfo.PluralInfo.Count, String> typeToExamples = pluralInfo2.getCountToStringExamplesMap();
            for (SupplementalDataInfo.PluralInfo.Count type : typeToExamples.keySet()) {
                System.out.println("\tPlural Code: \t" + (Object)((Object)type) + " \t=>\t" + typeToExamples.get((Object)type));
            }
            System.out.println();
        }
    }

    private static void checkTelephoneCodeData() {
        System.out.println("==== territories for telephoneCodeData ====");
        System.out.println(supplementalData.getTerritoriesForTelephoneCodeInfo());
        System.out.println("==== telephone code data for 001 ====");
        System.out.println(supplementalData.getTelephoneCodeInfoForTerritory("001"));
        System.out.println("==== telephone code data for US ====");
        System.out.println(supplementalData.getTelephoneCodeInfoForTerritory("US"));
        System.out.println("==== all telephoneCodeData ====");
        System.out.println(supplementalData.getTerritoryToTelephoneCodeInfo());
    }

    private static void checkTerritoryMapping() {
        Relation<String, String> alpha3 = supplementalData.getAlpha3TerritoryMapping();
        TreeSet<String> temp = new TreeSet<String>(sc.getAvailableCodes("territory"));
        Iterator it = temp.iterator();
        while (it.hasNext()) {
            String code = (String)it.next();
            if (!numericTerritory.reset(code).matches()) continue;
            it.remove();
        }
        TestSupplementalData.showAnyDifferences("alpha3", alpha3.keySet(), "sc", temp);
    }

    private static void showAnyDifferences(String title, Set<String> set, String title2, Set<String> set2) {
        if (!set.equals(set2)) {
            TestSupplementalData.showFirstMinusSecond("Failure " + title + "-" + title2 + ": ", set, set2);
            TestSupplementalData.showFirstMinusSecond("Failure " + title2 + "-" + title + ": ", set2, set);
        }
    }

    private static void showFirstMinusSecond(String title, Set<String> name, Set<String> availableCodes) {
        Set<String> temp = TestSupplementalData.getFirstMinusSecond(name, availableCodes);
        if (!temp.isEmpty()) {
            System.out.println(title + TestSupplementalData.getFirstMinusSecond(name, availableCodes));
        }
    }

    private static Set<String> getFirstMinusSecond(Set<String> name, Set<String> availableCodes) {
        TreeSet<String> temp = new TreeSet<String>(name);
        temp.removeAll(availableCodes);
        return temp;
    }

    static void checkAgainstLanguageScript() {
        Relation<String, String> otherTerritoryToLanguages = Relation.of(new TreeMap(), TreeSet.class, null);
        for (String language : sc.getGoodAvailableCodes("language")) {
            Set<SupplementalDataInfo.BasicLanguageData> newLanguageData = supplementalData.getBasicLanguageData(language);
            if (newLanguageData == null) continue;
            for (SupplementalDataInfo.BasicLanguageData languageData : newLanguageData) {
                TreeSet<String> territories = new TreeSet<String>(languageData.getTerritories());
                territories.addAll(languageData.getTerritories());
                if (territories == null) continue;
                TreeSet<String> scripts = new TreeSet<String>(languageData.getScripts());
                scripts.addAll(languageData.getScripts());
                if (scripts == null || scripts.size() < 2) {
                    otherTerritoryToLanguages.putAll(territories, language);
                    continue;
                }
                for (String script : scripts) {
                    otherTerritoryToLanguages.putAll(territories, language + "_" + script);
                }
            }
        }
        for (String territory : sc.getGoodAvailableCodes("territory")) {
            Set<String> languages = supplementalData.getTerritoryToLanguages(territory);
            Set<Object> otherLanguages = otherTerritoryToLanguages.getAll(territory);
            if (otherLanguages == null) {
                otherLanguages = Collections.emptySet();
            }
            if (Objects.equals(languages, otherLanguages)) continue;
            TreeSet<String> languagesLeftover = new TreeSet<String>(languages);
            languagesLeftover.removeAll(otherLanguages);
            TreeSet otherLanguagesLeftover = new TreeSet(otherLanguages);
            otherLanguagesLeftover.removeAll(languages);
            String territoryString = english.getName(2, territory);
            if (otherLanguagesLeftover.size() == 0) continue;
            for (String other : otherLanguagesLeftover) {
                String name = english.getName(other);
                System.out.println(territoryString + "\t" + territory + "\t" + name + "\t" + other);
            }
        }
    }

    public static void genData() throws IOException {
        String line;
        BufferedReader codes = CldrUtility.getUTF8Data("territory_codes.txt");
        TreeSet<Pair<String, Pair<String, Pair<String, Pair<String, String>>>>> sorted = new TreeSet<Pair<String, Pair<String, Pair<String, Pair<String, String>>>>>();
        while ((line = codes.readLine()) != null) {
            if ((line = line.split("#")[0].trim()).length() == 0) continue;
            String[] stringArray = line.split("\\s+");
            String[] values = new String[5];
            for (int i = 0; i < values.length; ++i) {
                values[i] = i >= stringArray.length || stringArray[i].equals("-") ? null : stringArray[i];
            }
            String alpha2 = values[0];
            String numeric = values[1];
            String alpha3 = values[2];
            String internet = values[3];
            if (internet != null) {
                internet = internet.replace("/", " ");
            }
            if (internet != null) {
                internet = internet.toUpperCase();
            }
            String fips10 = values[4];
            Pair<String, Pair<String, Pair<String, Pair<String, String>>>> item = new Pair<String, Pair<String, Pair<String, Pair<String, String>>>>(alpha2, new Pair<String, Pair<String, Pair<String, String>>>(numeric, new Pair<String, Pair<String, String>>(alpha3, new Pair<String, String>(fips10, internet))));
            sorted.add(item);
        }
        for (Pair pair : sorted) {
            System.out.print("<territoryCodes");
            Object first = pair.getFirst();
            TestSupplementalData.showNonNull("type", first, null);
            Pair pair2 = (Pair)pair.getSecond();
            TestSupplementalData.showNonNull("numeric", pair2.getFirst(), null);
            Pair pair3 = (Pair)pair2.getSecond();
            TestSupplementalData.showNonNull("alpha3", pair3.getFirst(), null);
            Pair pair4 = (Pair)pair3.getSecond();
            TestSupplementalData.showNonNull("fips10", pair4.getFirst(), first);
            TestSupplementalData.showNonNull("internet", pair4.getSecond(), first);
            System.out.println("/>");
        }
        codes.close();
    }

    private static void showNonNull(String title, Object first, Object noDup) {
        if (first != null && !first.equals(noDup)) {
            System.out.print(" " + title + "=\"" + first + "\"");
        }
    }

    static {
        numericTerritory = PatternCache.get("[0-9]{3}").matcher("");
    }
}

