/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Row;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DayPeriodData;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.LanguageGroup;

public class ChartDayPeriods
extends Chart {
    public static void main(String[] args) {
        new ChartDayPeriods().writeChart(null);
    }

    @Override
    public String getDirectory() {
        return FormattedFileWriter.CHART_TARGET_DIR;
    }

    @Override
    public String getTitle() {
        return "Day Periods";
    }

    @Override
    public String getExplanation() {
        return "<p>Day Periods indicate roughly how the day is broken up in different languages. The following shows the ones that can be used as selectors in messages. The first column has a language group to collect languages together that are more likely to have similar day periods. For more information, see: <a href='https://unicode.org/reports/tr35/tr35-dates.html#Day_Period_Rule_Sets'>Day Period Rules</a>. The latest release data for this chart is in <a href='http://unicode.org/cldr/latest/common/supplemental/dayPeriods.xml'>dayPeriods.xml</a>.<p>";
    }

    @Override
    public void writeContents(FormattedFileWriter pw) throws IOException {
        TablePrinter tablePrinter = new TablePrinter().addColumn("Locale Group", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Locale Name", "class='source'", null, "class='source'", true).setSortPriority(1).addColumn("Code", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setSortPriority(2).setBreakSpans(true).addColumn("Start Time", "class='target'", null, "class='target'", true).addColumn("Day Period Code", "class='target'", null, "class='target'", true).addColumn("Example", "class='target'", null, "class='target'", true);
        DateFormat df = DateFormat.getPatternInstance("HH:mm", ULocale.ENGLISH);
        df.setTimeZone(TimeZone.GMT_ZONE);
        for (DayPeriodInfo.Type type : DayPeriodInfo.Type.values()) {
            if (type != DayPeriodInfo.Type.selection) continue;
            for (String locale : SDI.getDayPeriodLocales(type)) {
                if (locale.equals("root")) continue;
                LanguageGroup group = LanguageGroup.get(new ULocale(locale));
                DayPeriodInfo dayPeriodInfo = SDI.getDayPeriods(DayPeriodInfo.Type.selection, locale);
                for (int i = 0; i < dayPeriodInfo.getPeriodCount(); ++i) {
                    Row.R3<Integer, Boolean, DayPeriodInfo.DayPeriod> data = dayPeriodInfo.getPeriod(i);
                    Integer time = (Integer)data.get0();
                    String name = DayPeriodData.getName(locale, (DayPeriodInfo.DayPeriod)((Object)data.get2()));
                    if (name == null) {
                        name = "missing";
                    }
                    tablePrinter.addRow().addCell((Comparable)((Object)group)).addCell((Comparable)((Object)ENGLISH.getName(locale))).addCell((Comparable)((Object)locale)).addCell((Comparable)((Object)df.format(time))).addCell((Comparable)data.get2()).addCell((Comparable)((Object)name)).finishRow();
                }
            }
        }
        pw.write(tablePrinter.toTable());
    }
}

