/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Objects;
import com.ibm.icu.util.Output;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;

public class FindHardInheritance {
    static Output<String> localeWhereFound = new Output();
    static Output<String> pathWhereFound = new Output();

    public static void main(String[] args) {
        LinkedHashMap data = new LinkedHashMap();
        System.out.println("dir.\tlocale\tcount\tcps\tinher.\tcps\tredund.\tcps\tcover.\tcps");
        Output<Info> output = new Output<Info>();
        Iterator<String> iterator = DtdType.ldml.directories.iterator();
        block6: while (iterator.hasNext()) {
            String dir;
            switch (dir = iterator.next()) {
                default: {
                    break;
                }
                case "casing": {
                    continue block6;
                }
            }
            Factory factory = Factory.make(CLDRPaths.COMMON_DIRECTORY + dir, ".*");
            for (String localeId : factory.getAvailable()) {
                Info info = FindHardInheritance.getCounts(dir, factory, localeId, output);
                System.out.println(dir + "\t" + localeId + "\t" + info);
            }
        }
    }

    private static Info getCounts(String dir, Factory factory, String localeId, Output<Info> cpsInfo) {
        int redundantCount = 0;
        int regularCount = 0;
        int constructedCount = 0;
        int inheritedCount = 0;
        int coverageCount = 0;
        int redundantCountCps = 0;
        int regularCountCps = 0;
        int constructedCountCps = 0;
        int inheritedCountCps = 0;
        int coverageCountCps = 0;
        boolean allConstructed = "annotationsDerived".equals(dir);
        CoverageLevel2 coverage = CoverageLevel2.getInstance(localeId);
        CLDRFile cldrFile = factory.make(localeId, true, CLDRFile.DraftStatus.contributed);
        CLDRFile unresolvedCldrFile = factory.make(localeId, false, CLDRFile.DraftStatus.contributed);
        for (String path : cldrFile) {
            if (path.startsWith("//ldml/identity/")) continue;
            String value = cldrFile.getStringValue(path);
            int cps = value.codePointCount(0, value.length());
            Level level = coverage.getLevel(path);
            if (unresolvedCldrFile.getStringValue(path) == null) {
                ++inheritedCount;
                inheritedCountCps += cps;
                continue;
            }
            if (!Level.CORE_TO_MODERN.contains((Object)level)) {
                ++coverageCount;
                coverageCountCps += cps;
                continue;
            }
            String bailey = cldrFile.getBaileyValue(path, pathWhereFound, localeWhereFound);
            if (Objects.equal(value, bailey)) {
                ++redundantCount;
                redundantCountCps += cps;
                continue;
            }
            if (allConstructed) {
                ++constructedCount;
                constructedCountCps += cps;
                continue;
            }
            ++regularCount;
            regularCountCps += cps;
        }
        Info info = new Info(regularCount, inheritedCount, redundantCount, constructedCount, coverageCount, regularCountCps, inheritedCountCps, redundantCountCps, constructedCountCps, coverageCountCps);
        return info;
    }

    static final class Info {
        final int regularCount;
        final int inheritedCount;
        final int redundantCount;
        final int constructedCount;
        final int coverageCount;
        final int regularCountCps;
        final int inheritedCountCps;
        final int redundantCountCps;
        final int constructedCountCps;
        final int coverageCountCps;
        static final String HEADER = "count\tcps\tinher.\tcps\tredund.\tcps\tcover.\tcps";

        public Info(int regularCount, int inheritedCount, int redundantCount, int constructedCount, int coverageCount, int regularCountCps, int inheritedCountCps, int redundantCountCps, int constructedCountCps, int coverageCountCps) {
            this.regularCount = regularCount;
            this.inheritedCount = inheritedCount;
            this.redundantCount = redundantCount;
            this.constructedCount = constructedCount;
            this.coverageCount = coverageCount;
            this.regularCountCps = regularCountCps;
            this.inheritedCountCps = inheritedCountCps;
            this.redundantCountCps = redundantCountCps;
            this.constructedCountCps = constructedCountCps;
            this.coverageCountCps = coverageCountCps;
        }

        public String toString() {
            return this.regularCount + "\t" + this.regularCountCps + "\t" + this.inheritedCount + "\t" + this.inheritedCountCps + "\t" + this.redundantCount + "\t" + this.redundantCountCps + "\t" + this.coverageCount + "\t" + this.coverageCountCps;
        }
    }
}

