/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.SupplementalDataInfo;

public class FindPluralDifferences {
    public static void main(String[] args) {
        FindPluralDifferences.diff();
    }

    public static void diff() {
        BitSet x = new BitSet();
        x.set(3, 6);
        x.set(9);
        x.set(11, 13);
        TreeMap<String, BitSet> foo = new TreeMap<String, BitSet>();
        foo.put("x", x);
        FindPluralDifferences.show(foo);
        SupplementalDataInfo supplementalNew = null;
        String newVersion = null;
        ArrayList<String> items = new ArrayList<String>(ToolConstants.CLDR_VERSIONS);
        items.add("trunk");
        for (String version : items) {
            if (version.compareTo("28.0") < 0) continue;
            String oldVersion = newVersion;
            newVersion = version;
            SupplementalDataInfo supplementalOld = supplementalNew;
            if (supplementalNew == null) {
                try {
                    supplementalNew = SupplementalDataInfo.getInstance(CLDRPaths.ARCHIVE_DIRECTORY + "cldr-" + version + "/common/supplemental/");
                }
                catch (ICUUncheckedIOException e) {
                    System.out.println(e.getMessage());
                }
                continue;
            }
            supplementalNew = newVersion.equals("trunk") ? SupplementalDataInfo.getInstance() : SupplementalDataInfo.getInstance(CLDRPaths.ARCHIVE_DIRECTORY + "cldr-" + newVersion + "/common/supplemental/");
            System.out.println("# " + oldVersion + "\u279e" + newVersion);
            for (SupplementalDataInfo.PluralType pluralType : SupplementalDataInfo.PluralType.values()) {
                Set<String> oldLocales = supplementalOld.getPluralLocales(pluralType);
                Set<String> newLocales = supplementalNew.getPluralLocales(pluralType);
                TreeSet<String> justOldLocales = new TreeSet<String>(oldLocales);
                justOldLocales.removeAll(newLocales);
                if (!justOldLocales.isEmpty()) {
                    System.err.println("Old locales REMOVED:\t" + justOldLocales.size() + "\t" + justOldLocales);
                }
                TreeSet<String> justNewLocales = new TreeSet<String>(newLocales);
                justNewLocales.removeAll(oldLocales);
                System.out.println("\nNew locales for " + (Object)((Object)pluralType) + "s:\t" + justNewLocales.size() + "\t" + justNewLocales);
                System.out.println("Modifications:");
                for (String locale : oldLocales) {
                    TreeMap<String, BitSet> results = new TreeMap<String, BitSet>();
                    SupplementalDataInfo.PluralInfo oldPluralInfo = supplementalOld.getPlurals(pluralType, locale);
                    PluralRules oldRules = oldPluralInfo.getPluralRules();
                    SupplementalDataInfo.PluralInfo newPluralInfo = supplementalNew.getPlurals(pluralType, locale);
                    PluralRules newRules = newPluralInfo.getPluralRules();
                    for (int i = 0; i < 101; ++i) {
                        String newKeyword;
                        String oldKeyword = oldRules.select(i);
                        if (oldKeyword.equals(newKeyword = newRules.select(i))) continue;
                        String key = oldKeyword + "\u279e" + newKeyword;
                        BitSet diff = (BitSet)results.get(key);
                        if (diff == null) {
                            diff = new BitSet();
                            results.put(key, diff);
                        }
                        diff.set(i);
                    }
                    Set<String> oldKeywords = oldRules.getKeywords();
                    Set<String> newKeywords = newRules.getKeywords();
                    if (results.size() == 0 && oldKeywords.equals(newKeywords)) continue;
                    String type = null;
                    type = oldKeywords.equals(newKeywords) ? "EQUAL TO" : (oldKeywords.containsAll(newKeywords) ? "MERGED TO" : (newKeywords.containsAll(oldKeywords) ? "SPLIT TO" : "DISJOINT FROM"));
                    System.out.println((Object)((Object)pluralType) + "\t" + oldVersion + "\u279e" + newVersion + "\t" + ToolConfig.getToolInstance().getEnglish().getName(locale) + "\t" + locale + "\t" + oldKeywords + "\t" + type + "\t" + newKeywords + "\t" + FindPluralDifferences.show(results));
                }
            }
        }
        Set<String> pluralRangesLocales = supplementalNew.getPluralRangesLocales();
        System.out.println("\nLocales for plural ranges: " + pluralRangesLocales.size() + "\t" + new TreeSet<String>(pluralRangesLocales));
    }

    static String show(Map<String, BitSet> results) {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, BitSet>> iterator = results.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, BitSet> entry = iterator.next();
            String key = entry.getKey();
            BitSet value = entry.getValue();
            if (result.length() != 0) {
                result.append("; ");
            }
            result.append(key).append(" for {");
            int start = 0;
            boolean first = true;
            while ((start = value.nextSetBit(start)) >= 0) {
                int limit = value.nextClearBit(start);
                if (limit < 0) {
                    limit = value.size();
                }
                int end = limit - 1;
                if (first) {
                    first = false;
                } else {
                    result.append(",");
                }
                result.append(start);
                if (end != start) {
                    result.append("\u2013").append(end);
                }
                start = limit;
            }
            return result.append("}").toString();
        }
        return null;
    }
}

