/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.lang.CharSequences;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.VersionInfo;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.test.OutdatedPaths;
import org.unicode.cldr.tool.CldrVersion;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StringId;

public class GenerateBirth {
    private static boolean DEBUG = false;
    static CldrVersion[] VERSIONS;
    static Factory[] factories;
    static final Option.Options myOptions;

    public static void main(String[] args) throws IOException {
        System.out.println("Run TestOutdatedPaths.java -v to see a listing of changes.");
        myOptions.parse(args, true);
        DEBUG = myOptions.get("debug").doesOccur();
        try {
            CldrVersion.checkVersions();
        }
        catch (Exception e) {
            throw new ICUException("This tool can only be run if the archive of released versions matching CldrVersion is available.", e);
        }
        VersionInfo oldest = VersionInfo.getInstance(myOptions.get("oldest").getValue());
        ArrayList<CldrVersion> versions = new ArrayList<CldrVersion>();
        boolean foundStart = false;
        for (CldrVersion version : CldrVersion.CLDR_VERSIONS_DESCENDING) {
            versions.add(version);
            if (version.getVersionInfo() != oldest) continue;
            foundStart = true;
            break;
        }
        if (!foundStart) {
            throw new IllegalArgumentException("The last version is " + myOptions.get("oldest").getValue() + "; it must be in: " + Joiner.on(", ").join(CldrVersion.CLDR_VERSIONS_DESCENDING));
        }
        VERSIONS = versions.toArray(new CldrVersion[versions.size()]);
        factories = new Factory[VERSIONS.length];
        String filePattern = myOptions.get("file").getValue();
        ArrayList<Factory> list = new ArrayList<Factory>();
        for (CldrVersion version : VERSIONS) {
            if (version == CldrVersion.unknown) continue;
            List<File> paths = version.getPathsForFactory();
            System.out.println((Object)((Object)version) + ", " + paths);
            Factory aFactory = SimpleFactory.make(paths.toArray(new File[paths.size()]), filePattern);
            list.add(aFactory);
        }
        list.toArray(factories);
        String dataDirectory = myOptions.get("target").getValue();
        File dataDir = new File(dataDirectory);
        if (!dataDir.isDirectory()) {
            throw new IllegalArgumentException("-t value is not directory: " + dataDir);
        }
        String logDirectory = myOptions.get("log").getValue();
        System.out.println("en");
        Births english = new Births("en");
        english.writeBirth(logDirectory, "en", null);
        english.writeBirthValues(dataDirectory + "/" + "outdatedEnglish.data");
        HashMap<Long, Pair<CldrVersion, String>> pathToPrevious = new HashMap<Long, Pair<CldrVersion, String>>();
        OutdatedPaths.readBirthValues(dataDirectory, null, pathToPrevious);
        for (Map.Entry entry : english.pathToBirthCurrentPrevious.entrySet()) {
            Object previousRead;
            long id;
            Pair readValue;
            String path = (String)entry.getKey();
            String previous = (String)((Row.R3)entry.getValue()).get2();
            CldrVersion birth = (CldrVersion)((Object)((Row.R3)entry.getValue()).get0());
            if (previous == null) {
                previous = "\ufffd";
            }
            CldrVersion birthRead = (readValue = (Pair)pathToPrevious.get(id = StringId.getId(path))) == null ? null : (CldrVersion)((Object)readValue.getFirst());
            Object object = previousRead = readValue == null ? null : (String)readValue.getSecond();
            if (Objects.equal(previous, previousRead) && Objects.equal((Object)birth, (Object)birthRead)) continue;
            throw new IllegalArgumentException("path: " + path + "\tprevious: " + previous + "\tread: " + readValue + "\tbirth: " + (Object)((Object)birth) + "\tread: " + (Object)((Object)birthRead));
        }
        File file = new File(dataDirectory + "/" + "outdated.data");
        String string = PathUtilities.getNormalizedPathString(file);
        TreeMap<String, Set<String>> localeToNewer = new TreeMap<String, Set<String>>();
        System.out.println("Writing data: " + string);
        try (DataOutputStream dataOut = new DataOutputStream(new FileOutputStream(file));){
            dataOut.writeUTF(OutdatedPaths.FORMAT_KEY);
            LanguageTagParser ltp = new LanguageTagParser();
            for (String fileName : factories[0].getAvailable()) {
                if (fileName.equals("en") || !ltp.set(fileName).getRegion().isEmpty()) continue;
                System.out.println(fileName);
                Births other = new Births(fileName);
                Set<String> newer = other.writeBirth(logDirectory, fileName, english);
                dataOut.writeUTF(fileName);
                dataOut.writeInt(newer.size());
                for (String item : newer) {
                    long id = StringId.getId(item);
                    dataOut.writeLong(id);
                    if (!DEBUG) continue;
                    System.out.println(id + "\t" + item);
                }
                localeToNewer.put(fileName, newer);
            }
            dataOut.writeUTF("$END$");
        }
        OutdatedPaths outdatedPaths = new OutdatedPaths(dataDirectory);
        TreeSet<String> needPrevious = new TreeSet<String>();
        int errorCount = 0;
        for (Map.Entry localeAndNewer : localeToNewer.entrySet()) {
            String locale = (String)localeAndNewer.getKey();
            System.out.println("Checking " + locale);
            Set newer = (Set)localeAndNewer.getValue();
            if (newer.size() != outdatedPaths.countOutdated(locale)) {
                throw new IllegalArgumentException("broken: " + locale);
            }
            for (String xpath : newer) {
                String previous;
                boolean isOutdated = outdatedPaths.isRawOutdated(locale, xpath);
                if (!isOutdated) {
                    System.out.println("Error, broken locale: " + locale + "\t" + StringId.getId(xpath) + "\t" + xpath);
                    ++errorCount;
                }
                if (outdatedPaths.isSkipped(xpath) || (previous = outdatedPaths.getPreviousEnglish(xpath)).isEmpty() == english.emptyPrevious.contains(xpath)) continue;
                System.out.println("previous.isEmpty() != original " + locale + "\t" + StringId.getId(xpath) + "\t" + xpath);
                needPrevious.add(xpath);
                ++errorCount;
            }
        }
        if (errorCount != 0) {
            throw new IllegalArgumentException("Done, but " + errorCount + " errors");
        }
        System.out.println("Done, no errors");
    }

    static {
        myOptions = new Option.Options().add("target", (Object)".*", CLDRPaths.BIRTH_DATA_DIR, "The target directory for building the text files that show the results.").add("log", (Object)".*", CLDRPaths.STAGING_DIRECTORY + "births/" + CldrVersion.baseline.getVersionInfo().getVersionString(2, 4), "The target directory for building the text files that show the results.").add("file", (Object)".*", ".*", "Filter the information based on file name, using a regex argument. The '.xml' is removed from the file before filtering").add("previous", "Stop after writing the English previous data.").add("oldest", (Object)"\\d+(\\.\\d+)?", "36.0", "Oldest version to go back to, eg 36.1").add("debug", "Debug");
    }

    static class Births {
        private static final boolean USE_RESOLVED = false;
        final Relation<CldrVersion, String> birthToPaths;
        final Map<String, Row.R3<CldrVersion, String, String>> pathToBirthCurrentPrevious;
        final String locale;
        static final Pattern TYPE = PatternCache.get("\\[@type=\"([^\"]*)\"");
        final Matcher typeMatcher = TYPE.matcher("");
        Set<String> emptyPrevious = new HashSet<String>();

        Births(String file) {
            this.locale = file;
            CLDRFile[] files = new CLDRFile[factories.length];
            DisplayAndInputProcessor[] processors = new DisplayAndInputProcessor[factories.length];
            for (int i = 0; i < factories.length; ++i) {
                try {
                    files[i] = factories[i].make(file, false);
                    processors[i] = new DisplayAndInputProcessor(files[i], false);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Stopped at " + file + ", " + (Object)((Object)CldrVersion.CLDR_VERSIONS_DESCENDING.get(i)));
                    break;
                }
            }
            this.birthToPaths = Relation.of(new TreeMap(), TreeSet.class);
            this.pathToBirthCurrentPrevious = new HashMap<String, Row.R3<CldrVersion, String, String>>();
            for (String xpath : files[0]) {
                if ((xpath = xpath.intern()).contains("[@type=\"ar\"]")) {
                    boolean bl = false;
                }
                String base = this.getProcessedStringValue(0, xpath, files, processors);
                String previousValue = null;
                CLDRFile lastFile = files[0];
                for (int i = 1; i < files.length && files[i] != null; ++i) {
                    String previous = this.getProcessedStringValue(i, xpath, files, processors);
                    if (previous == null) {
                        previous = "\ufffd";
                    }
                    if (!CharSequences.equals(base, previous)) {
                        if (previous == null) break;
                        previousValue = previous;
                        break;
                    }
                    lastFile = files[i];
                }
                CldrVersion version = CldrVersion.from(lastFile.getDtdVersionInfo());
                this.birthToPaths.put(version, xpath);
                this.pathToBirthCurrentPrevious.put(xpath, Row.of(version, base, previousValue));
            }
        }

        public String getProcessedStringValue(int fileNumber, String xpath, CLDRFile[] files, DisplayAndInputProcessor[] processors) {
            String base = files[fileNumber].getStringValue(xpath);
            if (base != null) {
                base = processors[fileNumber].processInput(xpath, base, null);
            }
            return base;
        }

        private String fixNullPrevious(String xpath) {
            if (this.typeMatcher.reset(xpath).find()) {
                String type = this.typeMatcher.group(1);
                if (xpath.contains("metazone")) {
                    return type.replace("_", " ");
                }
                if (xpath.contains("zone")) {
                    String[] splits = type.split("/");
                    return splits[splits.length - 1].replace("_", " ");
                }
                return type;
            }
            return null;
        }

        public void writeBirthValues(String file) throws IOException {
            try (DataOutputStream dataOut = new DataOutputStream(new FileOutputStream(file));){
                dataOut.writeUTF(OutdatedPaths.FORMAT_KEY);
                System.out.println("Writing data: " + PathUtilities.getNormalizedPathString(file, new String[0]));
                dataOut.writeInt(this.pathToBirthCurrentPrevious.size());
                for (Map.Entry<String, Row.R3<CldrVersion, String, String>> entry : this.pathToBirthCurrentPrevious.entrySet()) {
                    String path = entry.getKey();
                    Row.R3<CldrVersion, String, String> birthCurrentPrevious = entry.getValue();
                    CldrVersion birth = (CldrVersion)((Object)birthCurrentPrevious.get0());
                    String current = (String)birthCurrentPrevious.get1();
                    String previous = (String)birthCurrentPrevious.get2();
                    long id = StringId.getId(path);
                    dataOut.writeLong(id);
                    String previousString = previous == null ? "\ufffd" : previous;
                    dataOut.writeUTF(previousString);
                    if (previous == null) {
                        this.emptyPrevious.add(path);
                    }
                    dataOut.writeUTF(birth.toString());
                    System.out.println(id + "\t" + (Object)((Object)birth) + "\t\u00ab" + current + "\u21d0" + previous + "\u00bb");
                }
                dataOut.writeUTF("$END$");
                this.emptyPrevious = Collections.unmodifiableSet(this.emptyPrevious);
            }
        }

        Set<String> writeBirth(PrintWriter out, Births onlyNewer) {
            out.println("Loc\tVersion\tValue\tPrevValue\tEVersion\tEValue\tEPrevValue\tPath");
            HashSet<String> newer = new HashSet<String>();
            HashMap<Long, String> sanityCheck = new HashMap<Long, String>();
            CldrVersion onlyNewerVersion = null;
            String otherValue = "n/a";
            String olderOtherValue = "n/a";
            for (Map.Entry<CldrVersion, Set<String>> entry2 : this.birthToPaths.keyValuesSet()) {
                CldrVersion version = entry2.getKey();
                for (String xpath : entry2.getValue()) {
                    long id = StringId.getId(xpath);
                    String old = (String)sanityCheck.get(id);
                    if (old != null) {
                        throw new IllegalArgumentException("Path Collision " + xpath + ", old:" + old + ", id: " + id);
                    }
                    sanityCheck.put(id, xpath);
                    Row.R3<CldrVersion, String, String> info = this.pathToBirthCurrentPrevious.get(xpath);
                    if (onlyNewer != null) {
                        Row.R3<CldrVersion, String, String> otherInfo = onlyNewer.pathToBirthCurrentPrevious.get(xpath);
                        if (otherInfo == null || !version.isOlderThan(onlyNewerVersion = (CldrVersion)((Object)otherInfo.get0()))) continue;
                        otherValue = this.fixNull((String)otherInfo.get1());
                        olderOtherValue = this.fixNull((String)otherInfo.get2());
                        newer.add(xpath);
                    }
                    String value = this.fixNull((String)info.get1());
                    String olderValue = this.fixNull((String)info.get2());
                    out.println(this.locale + "\t" + (Object)((Object)version) + "\t" + value + "\t" + olderValue + "\t" + CldrUtility.ifNull(onlyNewerVersion, "n/a") + "\t" + otherValue + "\t" + olderOtherValue + "\t" + xpath);
                }
            }
            return newer;
        }

        private String fixNull(String value) {
            if (value == null) {
                value = "\ufffd";
            }
            return value;
        }

        Set<String> writeBirth(String directory, String filename, Births onlyNewer) throws IOException {
            try (PrintWriter out = FileUtilities.openUTF8Writer(directory, filename + ".txt");){
                Set<String> newer;
                Set<String> set = newer = this.writeBirth(out, onlyNewer);
                return set;
            }
        }
    }
}

