/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TransliteratorUtilities;

public class GenerateKaraList {
    static CLDRFile english;
    static Factory cldrFactory;

    public static void main(String[] args) throws IOException {
        cldrFactory = Factory.make(CLDRPaths.COMMON_DIRECTORY, ".*");
        english = cldrFactory.make("en", true);
        PrintWriter log = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "main/", "karaList.xml");
        Set<String> locales = LanguageTagParser.getLanguageScript(cldrFactory.getAvailable());
        locales.remove("sr");
        locales.remove("zh");
        StandardCodes codes = StandardCodes.make();
        log.println("<root>");
        GenerateKaraList.printCodes(log, locales, codes.getAvailableCodes("language"), 0);
        GenerateKaraList.printCodes(log, locales, codes.getAvailableCodes("territory"), 2);
        GenerateKaraList.printCodes(log, locales, codes.getAvailableCodes("currency"), 4);
        log.println("</root>");
        log.close();
        System.out.println("Done");
    }

    private static void printCodes(PrintWriter log, Set<String> locales, Set<String> availableCodes, int choice) {
        boolean hasAbbreviation = choice == 4;
        HashSet<String> errors = new HashSet<String>();
        for (String id : availableCodes) {
            String aename;
            String ename = english.getName(choice, id);
            if (ename == null) {
                ename = "[untranslated: " + id + "]";
            }
            System.out.println(id + "\t" + ename);
            log.println("\t<entry>");
            log.println("\t\t<hdterm>" + TransliteratorUtilities.toXML.transliterate(ename) + "</hdterm>\t<!-- " + TransliteratorUtilities.toXML.transliterate(CLDRFile.getNameName(choice)) + ": " + id + " -->");
            log.println("\t\t<hom>");
            log.println("\t\t\t<epos>n</epos>");
            log.println("\t\t\t<sense>");
            if (hasAbbreviation && (aename = english.getName(5, id)) != null) {
                log.println("\t\t\t\t<eabbr>" + TransliteratorUtilities.toXML.transliterate(aename) + "</eabbr>");
            }
            for (String locale : locales) {
                try {
                    String aename2;
                    CLDRFile cldrfile = cldrFactory.make(locale, true);
                    String trans = cldrfile.getName(choice, id);
                    if (trans == null) continue;
                    log.println("\t\t\t\t<target>");
                    log.println("\t\t\t\t\t<tlanguage>" + locale + "</tlanguage>\t<!-- " + TransliteratorUtilities.toXML.transliterate(english.getName(locale)) + " -->");
                    log.println("\t\t\t\t\t<trans>" + TransliteratorUtilities.toXML.transliterate(trans) + "</trans>");
                    if (hasAbbreviation && (aename2 = cldrfile.getName(5, id)) != null && !aename2.equals(id)) {
                        log.println("\t\t\t\t\t<tabbr>" + TransliteratorUtilities.toXML.transliterate(aename2) + "</tabbr>");
                    }
                    log.println("\t\t\t\t</target>");
                }
                catch (RuntimeException e) {
                    String s2 = e.getMessage();
                    if (errors.contains(s2)) continue;
                    System.out.println(s2);
                    errors.add(s2);
                }
            }
            log.println("\t\t\t</sense>");
            log.println("\t\t</hom>");
            log.println("\t</entry>");
        }
    }
}

