/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.Files;
import com.ibm.icu.util.Output;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.LogicalGrouping;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class GenerateProductionData {
    static boolean DEBUG = false;
    static boolean VERBOSE = false;
    static Matcher FILE_MATCH = null;
    static String SOURCE_COMMON_DIR = null;
    static String DEST_COMMON_DIR = null;
    static boolean ADD_LOGICAL_GROUPS = false;
    static boolean ADD_DATETIME = false;
    static boolean ADD_SIDEWAYS = false;
    static boolean ADD_ROOT = false;
    static boolean INCLUDE_COMPREHENSIVE = false;
    static boolean CONSTRAINED_RESTORATION = false;
    static final Set<String> NON_XML = ImmutableSet.of("dtd", "properties", "testData", "uca");
    static final Set<String> COPY_ANYWAY = ImmutableSet.of("casing", "collation");
    static final SupplementalDataInfo SDI = CLDRConfig.getInstance().getSupplementalDataInfo();
    static final Multimap<String, Pair<String, String>> localeToSubdivisionsToMigrate = TreeMultimap.create();

    public static void main(String[] args) {
        MyOptions.parse(args, true);
        SOURCE_COMMON_DIR = MyOptions.sourceDirectory.option.getValue();
        DEST_COMMON_DIR = MyOptions.destinationDirectory.option.getValue();
        VERBOSE = MyOptions.verbose.option.doesOccur();
        DEBUG = MyOptions.Debug.option.doesOccur();
        String fileMatch = MyOptions.fileMatch.option.getValue();
        if (fileMatch != null) {
            FILE_MATCH = Pattern.compile(fileMatch).matcher("");
        }
        ADD_LOGICAL_GROUPS = "true".equalsIgnoreCase(MyOptions.logicalGroups.option.getValue());
        ADD_DATETIME = "true".equalsIgnoreCase(MyOptions.time.option.getValue());
        ADD_SIDEWAYS = "true".equalsIgnoreCase(MyOptions.Sideways.option.getValue());
        ADD_ROOT = "true".equalsIgnoreCase(MyOptions.root.option.getValue());
        INCLUDE_COMPREHENSIVE = "true".equalsIgnoreCase(MyOptions.includeComprehensive.option.getValue());
        CONSTRAINED_RESTORATION = "true".equalsIgnoreCase(MyOptions.constrainedRestoration.option.getValue());
        ((Stream)Arrays.asList(DtdType.values()).parallelStream().unordered()).forEach(type -> {
            boolean isLdmlDtdType = type == DtdType.ldml;
            Set<String> directories = type == DtdType.ldmlICU ? NON_XML : type.directories;
            for (String dir : directories) {
                File sourceDir = new File(SOURCE_COMMON_DIR, dir);
                File destinationDir = new File(DEST_COMMON_DIR, dir);
                Stats stats = new Stats();
                GenerateProductionData.copyFilesAndReturnIsEmpty(sourceDir, destinationDir, null, isLdmlDtdType, stats);
            }
        });
        if (!localeToSubdivisionsToMigrate.isEmpty()) {
            System.err.println("WARNING: Subdivision files not written");
            for (Map.Entry<String, Pair<String, String>> entry : localeToSubdivisionsToMigrate.entries()) {
                System.err.println(entry.getKey() + " \t" + entry.getValue());
            }
        }
    }

    private static boolean copyFilesAndReturnIsEmpty(File sourceFile, File destinationFile, Factory factory, boolean isLdmlDtdType, Stats stats) {
        if (sourceFile.isDirectory()) {
            Set<String> childless;
            System.out.println(sourceFile + " => " + destinationFile);
            if (!destinationFile.mkdirs()) {
                Arrays.stream(destinationFile.listFiles()).forEach(File::delete);
            }
            TreeSet<String> sorted = new TreeSet<String>();
            sorted.addAll(Arrays.asList(sourceFile.list()));
            if (COPY_ANYWAY.contains(sourceFile.getName())) {
                isLdmlDtdType = false;
            }
            factory = null;
            if (isLdmlDtdType) {
                factory = Factory.make(sourceFile.toString(), ".*");
            }
            boolean isMainDir = factory != null && sourceFile.getName().contentEquals("main");
            boolean isRbnfDir = factory != null && sourceFile.getName().contentEquals("rbnf");
            HashSet<String> emptyLocales = new HashSet<String>();
            Stats stats2 = new Stats();
            Factory theFactory = factory;
            boolean isLdmlDtdType2 = isLdmlDtdType;
            sorted.parallelStream().forEach(file -> {
                boolean isEmpty;
                File sourceFile2 = new File(sourceFile, (String)file);
                File destinationFile2 = new File(destinationFile, (String)file);
                if (VERBOSE) {
                    System.out.println("\t" + file);
                }
                Factory currFactory = theFactory;
                if (isMainDir) {
                    if (file.equals("root.xml")) {
                        currFactory = null;
                    }
                } else if (isRbnfDir) {
                    currFactory = null;
                }
                if (isEmpty = GenerateProductionData.copyFilesAndReturnIsEmpty(sourceFile2, destinationFile2, currFactory, isLdmlDtdType2, stats2)) {
                    emptyLocales.add(file.substring(0, file.length() - 4));
                }
            });
            stats2.showNonZero("\tTOTAL:\t");
            if (!(emptyLocales.isEmpty() || sourceFile.getName().equals("main") || (childless = GenerateProductionData.getChildless(emptyLocales, factory.getAvailable())).isEmpty())) {
                if (VERBOSE) {
                    System.out.println("\t" + destinationFile + "\tRemoving empty locales:" + childless);
                }
                childless.stream().forEach(locale -> new File(destinationFile, locale + ".xml").delete());
            }
            return false;
        }
        if (factory != null) {
            String file2 = sourceFile.getName();
            if (!file2.endsWith(".xml")) {
                return false;
            }
            String localeId = file2.substring(0, file2.length() - 4);
            if (FILE_MATCH != null && !FILE_MATCH.reset(localeId).matches()) {
                return false;
            }
            boolean isRoot = localeId.equals("root");
            String directoryName = sourceFile.getParentFile().getName();
            boolean isSubdivisionDirectory = "subdivisions".equals(directoryName);
            CLDRFile cldrFileUnresolved = factory.make(localeId, false);
            CLDRFile cldrFileResolved = factory.make(localeId, true);
            boolean gotOne = false;
            TreeSet<String> toRemove = new TreeSet<String>();
            TreeSet<String> toRetain = new TreeSet<String>();
            Output<String> pathWhereFound = new Output<String>();
            Output<String> localeWhereFound = new Output<String>();
            boolean isArabicSpecial = localeId.equals("ar") || localeId.startsWith("ar_");
            Object debugPath = null;
            String debugLocale = "af";
            for (String xpath : cldrFileUnresolved) {
                Set<String> set;
                Level level;
                Object bailey;
                String value;
                if (xpath.startsWith("//ldml/identity")) continue;
                if (debugPath != null && localeId.equals(debugLocale) && xpath.equals(debugPath)) {
                    boolean bl = false;
                }
                if ((value = cldrFileUnresolved.getStringValue(xpath)) == null || CldrUtility.INHERITANCE_MARKER.equals(value)) {
                    toRemove.add(xpath);
                    continue;
                }
                if (isRoot && xpath.startsWith("//ldml/annotations/annotation")) {
                    toRemove.add(xpath);
                    continue;
                }
                if (isArabicSpecial && xpath.contains("/defaultNumberingSystem")) {
                    toRetain.add(xpath);
                }
                if (!(!value.equals(bailey = cldrFileResolved.getConstructedBaileyValue(xpath, pathWhereFound, localeWhereFound)) || ADD_SIDEWAYS && !GenerateProductionData.pathEqualsOrIsAltVariantOf(xpath, (String)pathWhereFound.value) || ADD_ROOT && (Objects.equals("root", localeWhereFound.value) || Objects.equals("code-fallback", localeWhereFound.value)))) {
                    toRemove.add(xpath);
                    continue;
                }
                if (!isSubdivisionDirectory && xpath.startsWith("//ldml/localeDisplayNames/subdivisions/subdivision")) {
                    localeToSubdivisionsToMigrate.put(localeId, Pair.of(xpath, value));
                    toRemove.add(xpath);
                    continue;
                }
                if (!INCLUDE_COMPREHENSIVE && (level = SDI.getCoverageLevel(xpath, localeId)) == Level.COMPREHENSIVE) {
                    toRemove.add(xpath);
                    continue;
                }
                if (ADD_LOGICAL_GROUPS && !LogicalGrouping.isOptional(cldrFileResolved, xpath) && (set = LogicalGrouping.getPaths(cldrFileResolved, xpath)) != null && set.size() > 1) {
                    for (String possiblePath : set) {
                        if (LogicalGrouping.isOptional(cldrFileResolved, possiblePath)) continue;
                        toRetain.add(possiblePath);
                    }
                }
                if (ADD_DATETIME && GenerateProductionData.isDateTimePath(xpath)) {
                    toRetain.addAll(GenerateProductionData.dateTimePaths(xpath));
                }
                gotOne = true;
            }
            try (PrintWriter pw = new PrintWriter(destinationFile);){
                Collection<Pair<String, String>> path_values;
                CLDRFile outCldrFile = cldrFileUnresolved.cloneAsThawed();
                if (isSubdivisionDirectory && (path_values = localeToSubdivisionsToMigrate.get(localeId)) != null) {
                    for (Pair<String, String> pair : path_values) {
                        outCldrFile.add(pair.getFirst(), pair.getSecond());
                    }
                    localeToSubdivisionsToMigrate.removeAll(localeId);
                }
                if (DEBUG) {
                    GenerateProductionData.showIfNonZero(localeId, "removing", toRemove);
                    GenerateProductionData.showIfNonZero(localeId, "retaining", toRetain);
                }
                if (CONSTRAINED_RESTORATION) {
                    toRetain.retainAll(toRemove);
                    if (DEBUG) {
                        GenerateProductionData.showIfNonZero(localeId, "constrained retaining", toRetain);
                    }
                }
                boolean changed0 = toRemove.removeAll(toRetain);
                if (DEBUG && changed0) {
                    GenerateProductionData.showIfNonZero(localeId, "final removing", toRemove);
                }
                boolean changed = toRetain.removeAll(toRemove);
                if (DEBUG && changed) {
                    GenerateProductionData.showIfNonZero(localeId, "final retaining", toRetain);
                }
                outCldrFile.removeAll(toRemove, false);
                if (DEBUG) {
                    for (String xpath : toRemove) {
                        System.out.println(localeId + ": removing: \u00ab" + cldrFileUnresolved.getStringValue(xpath) + "\u00bb, " + xpath);
                    }
                }
                for (String xpath : toRetain) {
                    String value;
                    if (debugPath != null && localeId.equals(debugLocale) && xpath.equals(debugPath)) {
                        boolean possiblePath = false;
                    }
                    if ((value = cldrFileResolved.getStringValue(xpath)) == null || value.equals(CldrUtility.INHERITANCE_MARKER)) {
                        throw new IllegalArgumentException(localeId + ": " + value + " in value for " + xpath);
                    }
                    if (DEBUG) {
                        String oldValue = cldrFileUnresolved.getStringValue(xpath);
                        System.out.println("Restoring: \u00ab" + oldValue + "\u00bb \u21d2 \u00ab" + value + "\u00bb\t" + xpath);
                    }
                    outCldrFile.add(xpath, value);
                }
                int n = 0;
                for (String xpath : outCldrFile) {
                    String value;
                    if (debugPath != null && localeId.equals(debugLocale) && xpath.equals(debugPath)) {
                        boolean oldValue = false;
                    }
                    if ((value = outCldrFile.getStringValue(xpath)) != null && !value.equals(CldrUtility.INHERITANCE_MARKER)) continue;
                    throw new IllegalArgumentException(localeId + ": " + value + " in value for " + xpath);
                }
                outCldrFile.write(pw);
                ++stats.files;
                stats.removed += (long)toRemove.size();
                stats.retained += (long)toRetain.size();
                stats.remaining += (long)n;
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException("Can't copy " + sourceFile + " to " + destinationFile + " \u2014 ", e);
            }
            return !gotOne;
        }
        if (FILE_MATCH != null) {
            String baseName;
            String file3 = sourceFile.getName();
            int dotPos = file3.lastIndexOf(46);
            String string = baseName = dotPos >= 0 ? file3.substring(0, file3.length() - dotPos) : file3;
            if (!FILE_MATCH.reset(baseName).matches()) {
                return false;
            }
        }
        ++stats.files;
        GenerateProductionData.copyFiles(sourceFile, destinationFile);
        return false;
    }

    private static void showIfNonZero(String localeId, String title, Set<String> toRemove) {
        if (toRemove.size() != 0) {
            System.out.println(localeId + ": " + title + ": " + toRemove.size());
        }
    }

    private static boolean pathEqualsOrIsAltVariantOf(String desiredPath, String foundPath) {
        if (desiredPath.equals(foundPath)) {
            return true;
        }
        if (desiredPath.contains("type=\"en_GB\"") && desiredPath.contains("alt=")) {
            boolean bl = false;
        }
        if (foundPath == null) {
            return true;
        }
        XPathParts desiredPathParts = XPathParts.getFrozenInstance(desiredPath);
        XPathParts foundPathParts = XPathParts.getFrozenInstance(foundPath);
        if (desiredPathParts.size() != foundPathParts.size()) {
            return false;
        }
        for (int e = 0; e < desiredPathParts.size(); ++e) {
            Map<String, String> attr2;
            String element2;
            String element1 = desiredPathParts.getElement(e);
            if (!element1.equals(element2 = foundPathParts.getElement(e))) {
                return false;
            }
            Map<String, String> attr1 = desiredPathParts.getAttributes(e);
            if (attr1.equals(attr2 = foundPathParts.getAttributes(e))) continue;
            Set<String> keys1 = attr1.keySet();
            Set<String> keys2 = attr2.keySet();
            for (String attr : Sets.union(keys1, keys2)) {
                if (attr.equals("alt") || Objects.equals(attr1.get(attr), attr2.get(attr))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isDateTimePath(String xpath) {
        return xpath.startsWith("//ldml/dates/calendars/calendar") && xpath.contains("FormatLength[@type=");
    }

    private static Set<String> dateTimePaths(String xpath) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String prefix = xpath.substring(0, xpath.indexOf(93) + 2);
        for (String type : Arrays.asList("date", "time", "dateTime")) {
            String pattern = prefix + "$XFormats/$XFormatLength[@type=\"$Y\"]/$XFormat[@type=\"standard\"]/pattern[@type=\"standard\"]".replace("$X", type);
            for (String width : Arrays.asList("full", "long", "medium", "short")) {
                result.add(pattern.replace("$Y", width));
            }
        }
        return result;
    }

    private static Set<String> getChildless(Set<String> emptyLocales, Set<String> available) {
        HashMultimap<String, String> parent2child = HashMultimap.create();
        for (String locale : available) {
            String parent = LocaleIDParser.getParent(locale);
            if (parent == null) continue;
            parent2child.put(parent, locale);
        }
        HashSet<String> result = new HashSet<String>();
        for (String empty : emptyLocales) {
            if (!GenerateProductionData.allChildrenAreEmpty(empty, emptyLocales, parent2child)) continue;
            result.add(empty);
        }
        return result;
    }

    private static boolean allChildrenAreEmpty(String locale, Set<String> emptyLocales, Multimap<String, String> parent2child) {
        Collection<String> children = parent2child.get(locale);
        for (String child : children) {
            if (!emptyLocales.contains(child)) {
                return false;
            }
            if (GenerateProductionData.allChildrenAreEmpty(child, emptyLocales, parent2child)) continue;
            return false;
        }
        return true;
    }

    private static void copyFiles(File sourceFile, File destinationFile) {
        try {
            Files.copy(sourceFile, destinationFile);
        }
        catch (IOException e) {
            System.err.println("Can't copy " + sourceFile + " to " + destinationFile + " \u2014 " + e);
        }
    }

    static enum MyOptions {
        sourceDirectory(new Option.Params().setHelp("source common directory").setDefault(CLDRPaths.COMMON_DIRECTORY).setMatch(".*")),
        destinationDirectory(new Option.Params().setHelp("destination common directory").setDefault(CLDRPaths.STAGING_DIRECTORY + "production/common").setMatch(".*")),
        logicalGroups(new Option.Params().setHelp("add path/values for logical groups").setDefault("true").setMatch("true|false")),
        time(new Option.Params().setHelp("add path/values for stock date/time/datetime").setDefault("true").setMatch("true|false")),
        Sideways(new Option.Params().setHelp("add path/values for sideways inheritance").setDefault("true").setMatch("true|false")),
        root(new Option.Params().setHelp("add path/values for root and code-fallback").setDefault("true").setMatch("true|false")),
        constrainedRestoration(new Option.Params().setHelp("only add inherited paths that were in original file").setDefault("true").setMatch("true|false")),
        includeComprehensive(new Option.Params().setHelp("exclude comprehensive paths \u2014 otherwise just to modern level").setDefault("true").setMatch("true|false")),
        verbose(new Option.Params().setHelp("verbose debugging messages")),
        Debug(new Option.Params().setHelp("debug")),
        fileMatch(new Option.Params().setHelp("regex to match patterns").setMatch(".*"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args, boolean showArguments) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }

    private static class Stats {
        long files;
        long removed;
        long retained;
        long remaining;

        private Stats() {
        }

        Stats clear() {
            this.remaining = 0L;
            this.retained = 0L;
            this.removed = 0L;
            this.files = 0L;
            return this;
        }

        public String toString() {
            return "files=" + this.files + (this.removed + this.retained + this.remaining == 0L ? "" : "; removed=" + this.removed + "; retained=" + this.retained + "; remaining=" + this.remaining);
        }

        public void showNonZero(String label) {
            if (this.removed + this.retained + this.remaining != 0L) {
                System.out.println(label + this.toString());
            }
        }
    }
}

