/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.lang.CharSequences;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.CheckExemplars;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.test.QuickCheck;
import org.unicode.cldr.tool.LanguageCodeConverter;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ReadXMB;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.PathDescription;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PatternPlaceholders;
import org.unicode.cldr.util.PrettyPath;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.RegexUtilities;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.StringId;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class GenerateXMB {
    private static final String DEBUG_PATH = "[@type=\"day\"]/unitPattern[@count=\"1\"]";
    static StandardCodes sc = StandardCodes.make();
    static final String DATE;
    static final String stock = "en|ar|de|es|fr|it|ja|ko|nl|pl|ru|th|tr|pt|zh|zh_Hant|bg|ca|cs|da|el|fa|fi|fil|hi|hr|hu|id|lt|lv|ro|sk|sl|sr|sv|uk|vi|he|no|et|ms|am|bn|gu|is|kn|ml|mr|sw|ta|te|ur|eu|gl|af|zu|en_GB|es_419|pt_PT|fr_CA|zh_Hant_HK";
    private static final HashSet<String> REGION_LOCALES;
    static final Option.Options myOptions;
    static final SupplementalDataInfo supplementalDataInfo;
    static Matcher pathMatcher;
    static RegexLookup<String> pathFindRemover;
    static PrettyPath prettyPath;
    static int errors;
    static Relation<String, String> path2errors;
    static final Matcher datePatternMatcher;
    public static final boolean DEBUG = false;
    private static final HashSet<String> SKIP_LOCALES;
    public static String DTD_VERSION;
    private static String projectId;
    static Output<String[]> matches;
    static List<String> failures;
    static Output<RegexLookup.Finder> matcherFound;
    static final Pattern COUNT_OR_ALT_ATTRIBUTE;
    static final Pattern PLURAL_XPATH;
    static final Pattern SKIP_EXEMPLAR_TEST;
    static final Matcher skipExemplarTest;
    static final UnicodeSet ASCII_LATIN;
    static final UnicodeSet LATIN;
    static final Matcher keepFromRoot;
    static final Matcher currencyDisplayName;
    static final Pattern COUNT_ATTRIBUTE;
    static final Pattern PLURAL_NUMBER;
    static final String[] PLURAL_KEYS;
    static final String[] EXTRA_PLURAL_KEYS;
    static final long START_TIME;
    static final long END_TIME;
    static final long DELTA_TIME = 900000L;
    static final long MIN_DAYLIGHT_PERIOD = 7776000000L;
    static final Set<String> HAS_DAYLIGHT;
    static final Set<String> SINGULAR_COUNTRIES;
    private static PrintWriter countFile;
    static final Map<String, String> PLURAL_TAGS;
    private static String compareDirectory;

    public static void main(String[] args) throws Exception {
        myOptions.parse(args, true);
        Option option = myOptions.get("zone");
        if (option.doesOccur()) {
            GenerateXMB.showMetazoneInfo();
            return;
        }
        option = myOptions.get("file");
        String fileMatcherString = option.getValue();
        option = myOptions.get("content");
        Matcher contentMatcher = option.doesOccur() ? PatternCache.get(option.getValue()).matcher("") : null;
        option = myOptions.get("path");
        pathMatcher = option.doesOccur() ? PatternCache.get(option.getValue()).matcher("") : null;
        String targetDir = myOptions.get("target").getValue();
        countFile = FileUtilities.openUTF8Writer(targetDir + "/log/", "counts.txt");
        Factory cldrFactory1 = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        CLDRFile english = cldrFactory1.make("en", true);
        CLDRFile englishTop = cldrFactory1.make("en", false);
        DTD_VERSION = englishTop.getDtdVersion();
        CLDRFile root = cldrFactory1.make("en", true);
        GenerateXMB.showDefaultContents(targetDir, english);
        EnglishInfo englishInfo = new EnglishInfo(targetDir, english, root);
        option = myOptions.get("kompare");
        if (option.doesOccur()) {
            compareDirectory = option.getValue();
            GenerateXMB.compareFiles(fileMatcherString, contentMatcher, targetDir, cldrFactory1, english, englishInfo);
            return;
        }
        if (myOptions.get("wsb").doesOccur()) {
            GenerateXMB.displayWsb(myOptions.get("wsb").getValue(), englishInfo);
            return;
        }
        projectId = myOptions.get("project_name").getValue();
        GenerateXMB.writeFile(targetDir, "en", englishInfo, english, true, false);
        GenerateXMB.writeFile(targetDir + "/filtered/", "en", englishInfo, english, true, true);
        Factory cldrFactory2 = Factory.make(CLDRPaths.MAIN_DIRECTORY, fileMatcherString);
        LanguageTagParser ltp = new LanguageTagParser();
        for (String file : cldrFactory2.getAvailable()) {
            if (SKIP_LOCALES.contains(file) || ltp.set(file).getRegion().length() != 0 && !REGION_LOCALES.contains(file)) continue;
            SupplementalDataInfo.PluralInfo plurals = supplementalDataInfo.getPlurals(file, false);
            if (plurals == null) {
                System.out.println("Skipping " + file + ", no plural rules");
                continue;
            }
            CLDRFile cldrFile = cldrFactory2.make(file, true);
            GenerateXMB.writeFile(targetDir + "/wsb/", file, englishInfo, cldrFile, false, false);
            GenerateXMB.writeFile(targetDir + "/wsb/filtered/", file, englishInfo, cldrFile, false, true);
            countFile.flush();
        }
        countFile.close();
        PrintWriter errorFile = FileUtilities.openUTF8Writer(targetDir + "/log/", "errors.txt");
        for (Map.Entry<String, Set<String>> entry : path2errors.keyValuesSet()) {
            errorFile.println(entry);
        }
        errorFile.close();
        System.out.println("Errors: " + (errors + path2errors.size()));
    }

    private static void compareFiles(String fileMatcherString, Matcher contentMatcher, String targetDir, Factory cldrFactory1, CLDRFile english, EnglishInfo englishInfo) throws IOException {
        SubmittedPathFixer fixer = new SubmittedPathFixer();
        Factory cldrFactory2 = Factory.make(compareDirectory, fileMatcherString);
        PrintWriter output = null;
        PrintWriter log = FileUtilities.openUTF8Writer(targetDir + "/log/", "skipped.txt");
        for (String file : cldrFactory2.getAvailable()) {
            CLDRFile submitted = cldrFactory2.make(file, false);
            CLDRFile trunk = cldrFactory1.make(file, true);
            for (String path : With.in(submitted.iterator(null, submitted.getComparator()))) {
                String trunkPath;
                String trunkValue;
                PathStatus pathStatus;
                if (pathMatcher != null && !pathMatcher.reset(path).matches()) continue;
                String submittedValue = submitted.getStringValue(path);
                if (contentMatcher != null && !contentMatcher.reset(submittedValue).matches() || (pathStatus = GenerateXMB.shouldSkipPath(path, submittedValue)) == PathStatus.SKIP || CharSequences.equals(submittedValue, trunkValue = trunk.getStringValue(trunkPath = fixer.fix(path, false)))) continue;
                if (output == null) {
                    output = FileUtilities.openUTF8Writer(targetDir, file + ".txt");
                    output.println("ID\tEnglish\tSource\tRelease\tDescription");
                }
                String englishValue = english.getStringValue(trunkPath);
                PathInfo pathInfo = englishInfo.getPathInfo(trunkPath);
                if (pathInfo == null) {
                    log.println(file + "\tDescription unavailable for " + trunkPath);
                    ++errors;
                    String temp = fixer.fix(path, true);
                    englishInfo.getPathInfo(trunkPath);
                    continue;
                }
                String description = pathInfo.getDescription();
                long id = StringId.getId(trunkPath);
                if (englishValue == null) {
                    log.println(file + "\tEmpty English for " + trunkPath);
                    ++errors;
                    continue;
                }
                output.println(id + "\t" + GenerateXMB.ssquote(englishValue, false) + "\t" + GenerateXMB.ssquote(submittedValue, false) + "\t" + GenerateXMB.ssquote(trunkValue, true) + "\t" + description);
            }
            if (output != null) {
                output.close();
                output = null;
            }
            log.flush();
        }
        log.close();
    }

    public static PathStatus shouldSkipPath(String path, String value) {
        List<String> myFailures = null;
        String skipPath = pathFindRemover.get(path, null, matches, matcherFound, myFailures);
        if (myFailures != null && failures.size() != 0) {
            System.out.println("Failures\n\t" + Joiner.on("\n\t").join(failures));
            failures.clear();
        }
        if (skipPath == null || skipPath.equals("MAYBE")) {
            return PathStatus.MAYBE;
        }
        if (skipPath.equals("VALUE")) {
            return value.equals(((String[])GenerateXMB.matches.value)[1]) ? PathStatus.SKIP : PathStatus.MAYBE;
        }
        if (skipPath.equals("SKIP")) {
            return PathStatus.SKIP;
        }
        if (skipPath.equals("KEEP")) {
            return PathStatus.KEEP;
        }
        throw new IllegalArgumentException("Unexpected xmbSkip.txt value: " + skipPath);
    }

    private static String ssquote(String englishValue, boolean showRemoved) {
        if (englishValue == null) {
            return showRemoved ? "[removed]" : "[empty]";
        }
        englishValue = englishValue.replace("\"", "&quot;");
        return englishValue;
    }

    /*
     * WARNING - void declaration
     */
    private static void showDefaultContents(String targetDir, CLDRFile english) throws IOException {
        String locale;
        void var7_9;
        PrintWriter out = FileUtilities.openUTF8Writer(targetDir + "/log/", "locales.txt");
        String[] locales = stock.split("\\|");
        TreeSet<Row.R2<String, String>> sorted = new TreeSet<Row.R2<String, String>>();
        String[] stringArray = locales;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            locale = stringArray[var7_9];
            if (!locale.isEmpty()) {
                String name = english.getName(locale);
                Row.R2<String, String> row = Row.of(name, locale);
                sorted.add(row);
            }
            ++var7_9;
        }
        Set<String> defaultContents = supplementalDataInfo.getDefaultContentLocales();
        for (Row.R2 r2 : sorted) {
            locale = (String)r2.get1();
            String dlocale = GenerateXMB.getDefaultContentLocale(locale, defaultContents);
            out.println((String)r2.get0() + "\t" + locale + "\t" + english.getName(dlocale) + "\t" + dlocale);
        }
        out.close();
    }

    private static String getDefaultContentLocale(String locale, Set<String> defaultContents) {
        String best = null;
        for (String s2 : defaultContents) {
            if (!s2.startsWith(locale)) continue;
            if (best == null) {
                best = s2;
                continue;
            }
            if (s2.length() >= best.length()) continue;
            best = s2;
        }
        if (best == null) {
            return locale;
        }
        return best;
    }

    private static void writeFile(String targetDir, String localeId, EnglishInfo englishInfo, CLDRFile cldrFile, boolean isEnglish, boolean filter) throws IOException {
        String extension = "xml";
        Relation<String, String> reasonsToPaths = Relation.of(new TreeMap(), TreeSet.class);
        HashSet<String> seenStarred = new HashSet<String>();
        Relation<String, Row.R2<PathInfo, String>> countItems = Relation.of(new TreeMap(), TreeSet.class);
        Matcher countMatcher = COUNT_OR_ALT_ATTRIBUTE.matcher("");
        int lineCount = 0;
        int wordCount = 0;
        int messageCount = 0;
        StringWriter buffer = new StringWriter();
        PrintWriter out1 = new PrintWriter(buffer);
        StringWriter buffer3 = new StringWriter();
        PrintWriter out3 = new PrintWriter(buffer3);
        UnicodeSet exemplars = GenerateXMB.getExemplars(cldrFile);
        for (PathInfo pathInfo : englishInfo) {
            XPathParts xpathParts;
            String draftValue;
            String fullPath;
            String path = pathInfo.getPath();
            String value = isEnglish ? pathInfo.englishValue : cldrFile.getStringValue(path);
            if (DisplayAndInputProcessor.NUMBER_FORMAT_XPATH.matcher(path).matches()) {
                value = value.replace("'", "");
            }
            if (!isEnglish && value != null && !keepFromRoot.reset(path).find()) {
                String locale = cldrFile.getSourceLocaleID(path, null);
                if (locale.equals("root")) {
                    reasonsToPaths.put("root", path + "\t" + value);
                    continue;
                }
                if (locale.equals("code-fallback")) {
                    reasonsToPaths.put("codeFallback", path + "\t" + value);
                    continue;
                }
            }
            boolean hasPlurals = PLURAL_XPATH.matcher(path).matches();
            if (filter && !hasPlurals) {
                String starred = pathInfo.getStarredPath();
                if (seenStarred.contains(starred)) continue;
                seenStarred.add(starred);
            }
            if (value == null) {
                reasonsToPaths.put("missing", path + "\t" + value);
                continue;
            }
            if (!isEnglish && (fullPath = cldrFile.getFullXPath(path)).contains("draft") && !(draftValue = (xpathParts = XPathParts.getFrozenInstance(fullPath)).getAttributeValue(-1, "draft")).equals("contributed")) {
                reasonsToPaths.put(draftValue, path + "\t" + value);
                continue;
            }
            if (!(isEnglish || exemplars.containsAll(value) || skipExemplarTest.reset(path).find())) {
                boolean bad = true;
                if (currencyDisplayName.reset(path).find()) {
                    String code = currencyDisplayName.group(1);
                    String value2 = value.replace(code, "");
                    boolean bl = bad = !exemplars.containsAll(value2);
                }
                if (bad) {
                    UnicodeSet diff = new UnicodeSet().addAll(value).removeAll(exemplars);
                    reasonsToPaths.put("exemplars", path + "\t" + value + "\t" + diff);
                    continue;
                }
            }
            if (hasPlurals) {
                countMatcher.reset(path).find();
                String countLessPath = countMatcher.replaceAll("");
                countItems.put(countLessPath, Row.of(pathInfo, value));
                continue;
            }
            if (!isEnglish && pathInfo.changedEnglish) {
                reasonsToPaths.put("changed-english", path);
            } else {
                GenerateXMB.writePathInfo(out1, pathInfo, value, isEnglish);
                ++messageCount;
            }
            if (isEnglish) {
                GenerateXMB.writeJavaInfo(out3, pathInfo.getStringId(), pathInfo.getPath(), value);
            }
            wordCount += pathInfo.wordCount;
            ++lineCount;
        }
        Row.R2<Integer, Integer> lineWordCount = GenerateXMB.writeCountPathInfo(out1, out3, cldrFile.getLocaleID(), countItems, isEnglish, filter);
        messageCount += ((Integer)lineWordCount.get0()).intValue();
        lineCount += ((Integer)lineWordCount.get0()).intValue();
        wordCount += ((Integer)lineWordCount.get1()).intValue();
        if (!filter && countItems.size() != ((Integer)lineWordCount.get0()).intValue()) {
            System.out.println(localeId + "\t" + countItems.size() + "\t" + (Integer)lineWordCount.get0());
        }
        out1.flush();
        out3.flush();
        String file = LanguageCodeConverter.toGoogleLocaleId(localeId);
        String localeName = englishInfo.getName(localeId);
        PrintWriter out = FileUtilities.openUTF8Writer(targetDir, file + "." + extension);
        if (isEnglish) {
            FileCopier.copy(GenerateXMB.class, "xmb-dtd.xml", out);
            out.println("<!-- " + localeName + " -->");
            out.println("<messagebundle class='" + projectId + "'> <!-- version: " + DTD_VERSION + ", date: " + DATE + " -->");
            out.println(buffer.toString());
            out.println("</messagebundle>");
            PrintWriter out3File = FileUtilities.openUTF8Writer(targetDir, "IdToPath.java");
            out3File.println("package org.unicode.cldr.tool;");
            out3File.println();
            out3File.println("import java.util.HashMap;");
            out3File.println();
            out3File.println("/**");
            out3File.println(" * Autogenerated by GenerateXMB for use by ConvertXTB.");
            out3File.println(" * Do not manually edit this file.");
            out3File.println(" */");
            out3File.println("public class IdToPath {");
            out3File.println("  static final HashMap<String,String> map = new HashMap<String,String>();");
            out3File.println("  public static String getPath(String id) {");
            out3File.println("      return map.get(id);");
            out3File.println("  }");
            out3File.println("  static {");
            out3File.println("      String[][] data = {");
            out3File.println(buffer3);
            out3File.println("      };");
            out3File.println("      for (String[] pair : data) {");
            out3File.println("          map.put(pair[0], pair[1]);");
            out3File.println("      }");
            out3File.println("  }");
            out3File.println("}");
            out3File.close();
        } else {
            FileCopier.copy(GenerateXMB.class, "wsb-dtd.xml", out);
            out.println("<!-- " + localeName + " -->");
            out.println("<worldserverbundles lazarus_id='dummy' date='" + DATE + "'> <!-- version: " + DTD_VERSION + " -->");
            out.println("  <worldserverbundle project_id='" + projectId + "' message_count='" + messageCount + "'>");
            out.println(buffer.toString());
            out.println("  </worldserverbundle>");
            out.println("</worldserverbundles>");
        }
        out.close();
        QuickCheck.check(new File(targetDir, file + "." + extension));
        if (!filter) {
            countFile.println(file + "\t" + lineCount + "\t" + wordCount);
        }
        if (!isEnglish && !filter) {
            GenerateXMB.writeReasons(reasonsToPaths, targetDir, file);
        }
    }

    private static void writeJavaInfo(PrintWriter out3, String id, String path, String value) {
        out3.println("              {\"" + id + "\",\"" + path.replace("\"", "\\\"") + "\",\"" + value.replace("\\", "\\\\").replace("\"", "\\\"") + "\"},");
    }

    private static UnicodeSet getExemplars(CLDRFile cldrFile) {
        UnicodeSet exemplars = cldrFile.getExemplarSet("", CLDRFile.WinningChoice.WINNING);
        boolean isLatin = exemplars.containsSome(ASCII_LATIN);
        exemplars.addAll(CheckExemplars.AlwaysOK);
        UnicodeSet auxExemplars = cldrFile.getExemplarSet("auxiliary", CLDRFile.WinningChoice.WINNING);
        if (auxExemplars != null) {
            exemplars.addAll(auxExemplars);
        }
        if (!isLatin) {
            exemplars.removeAll(LATIN);
        }
        exemplars.freeze();
        return exemplars;
    }

    private static Row.R2<Integer, Integer> writeCountPathInfo(PrintWriter out, PrintWriter out3, String locale, Relation<String, Row.R2<PathInfo, String>> countItems, boolean isEnglish, boolean filter) {
        Matcher m3 = COUNT_ATTRIBUTE.matcher("");
        int wordCount = 0;
        SupplementalDataInfo.PluralInfo pluralInfo = supplementalDataInfo.getPlurals(locale);
        int lineCount = 0;
        LinkedHashSet<String> errorSet = new LinkedHashSet<String>();
        for (Map.Entry<String, Set<Row.R2<PathInfo, String>>> entry : countItems.keyValuesSet()) {
            String countLessPath = entry.getKey();
            TreeMap<String, String> fullValues = new TreeMap<String, String>();
            PathInfo pathInfo = null;
            String value = null;
            for (Row.R2<PathInfo, String> entry2 : entry.getValue()) {
                PathInfo pathInfoN = (PathInfo)entry2.get0();
                m3.reset(pathInfoN.getPath()).find();
                String count = m3.group(1);
                if (count.equals("other")) {
                    pathInfo = pathInfoN;
                }
                value = (String)entry2.get1();
                fullValues.put(count, value);
            }
            if (pathInfo == null) continue;
            if (fullValues.size() < 2) {
                System.out.println(locale + "\tMust have 2 count values: " + entry.getKey());
                continue;
            }
            String fullPlurals = GenerateXMB.showPlurals(fullValues, locale, pathInfo, pluralInfo, isEnglish, errorSet);
            if (fullPlurals == null) {
                System.out.println(locale + "\tCan't format plurals for: " + entry.getKey() + "\t" + errorSet);
                ++errors;
                continue;
            }
            out.println();
            out.println("    <!--    " + countLessPath + "    -->");
            out.println("    <msg id='" + pathInfo.getStringId() + "' desc='" + pathInfo.description + "'");
            out.println("     >" + fullPlurals + "</msg>");
            GenerateXMB.writeJavaInfo(out3, pathInfo.getStringId(), countLessPath, value);
            out.flush();
            ++lineCount;
            wordCount += pathInfo.wordCount * 3;
            if (!filter) continue;
            break;
        }
        return Row.of(lineCount, wordCount);
    }

    private static String showPlurals(Map<String, String> values, String locale, PathInfo pathInfo, SupplementalDataInfo.PluralInfo pluralInfo, boolean isEnglish, Set<String> errorSet) {
        errorSet.clear();
        Matcher matcher = PLURAL_NUMBER.matcher(pathInfo.getPath());
        String var = null;
        var = matcher.find() ? matcher.group(1).toUpperCase() + "_NUMBER" : pathInfo.getFirstVariable();
        StringBuilder result = new StringBuilder();
        if (isEnglish) {
            result.append('{').append(var).append(",plural,");
        } else {
            result.append("<ph name='[PLURAL_").append(var).append("]'/>");
        }
        for (String key : PLURAL_KEYS) {
            String coreKey = key.startsWith("=") ? key.substring(1, 2) : key;
            String value = values.get(coreKey);
            if (value == null) {
                if (key.startsWith("=")) {
                    String stringCount = key.substring(1);
                    int intCount = Integer.parseInt(stringCount);
                    SupplementalDataInfo.PluralInfo.Count count = pluralInfo.getCount(intCount);
                    value = values.get(count.toString());
                    if (value == null) {
                        errorSet.add("Bad key/value " + key + "='" + value + "' in " + values);
                        return null;
                    }
                    value = value.replace("{0}", stringCount);
                } else {
                    value = values.get("other");
                    if (value == null) {
                        errorSet.add("No 'other' value in " + values);
                        return null;
                    }
                }
            }
            String newValue = MessageFormat.format(MessageFormat.autoQuoteApostrophe(value), key.startsWith("=") ? key.substring(1, 2) : "#");
            PlaceholderType type = isEnglish ? PlaceholderType.BRACES : PlaceholderType.XML;
            newValue = pathInfo.transformValue(newValue, type);
            if (isEnglish) {
                result.append("\n            ").append(key).append(" {").append(newValue).append('}');
                continue;
            }
            String prefix = key.toUpperCase(Locale.ENGLISH);
            result.append("<!--\n        --><ph name='[").append(prefix).append("]'/>").append(newValue);
        }
        if (isEnglish) {
            result.append('}');
        } else {
            result.append("<!--\n        --><ph name='[END_PLURAL]'/>");
        }
        return result.toString();
    }

    private static void writePathInfo(PrintWriter out, PathInfo pathInfo, String value, boolean isEnglish) {
        out.println();
        out.println("    <!--    " + pathInfo.getPath() + "    -->");
        out.println("    <msg id='" + pathInfo.getStringId() + "' desc='" + pathInfo.description + "'");
        PlaceholderType type = isEnglish ? PlaceholderType.XML_EXAMPLE : PlaceholderType.XML;
        String transformValue = pathInfo.transformValue(value, type);
        out.println("     >" + transformValue + "</msg>");
        value = TransliteratorUtilities.toHTML.transform(value);
        if (!(value.equals(transformValue) || isEnglish && pathInfo.placeholders == null)) {
            out.println("    <!-- English original:    " + value + "    -->");
        }
        out.flush();
    }

    private static void writeReasons(Relation<String, String> reasonsToPaths, String targetDir, String filename) throws IOException {
        targetDir = targetDir + "/skipped/";
        filename = filename + ".txt";
        PrintWriter out = FileUtilities.openUTF8Writer(targetDir, filename);
        out.println("# " + DATE);
        for (Map.Entry<String, Set<String>> reasonToSet : reasonsToPaths.keyValuesSet()) {
            for (String path : reasonToSet.getValue()) {
                out.println(reasonToSet.getKey() + "    " + path);
            }
        }
        out.close();
    }

    static void addSkipReasons(Relation<String, String> reasonsToPaths, String descriptionStatus, Level level, String path, String value) {
        reasonsToPaths.put(descriptionStatus + "\t" + (Object)((Object)level), path + "\t" + value);
    }

    private static long getDateTimeinMillis(int year, int month, int date) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, date);
        return cal.getTimeInMillis();
    }

    static void showMetazoneInfo() {
        System.out.println("\nZones in multiple metazones\n");
        for (String zone : sc.getCanonicalTimeZones()) {
            Set<SupplementalDataInfo.MetaZoneRange> metazoneRanges = supplementalDataInfo.getMetaZoneRanges(zone);
            if (metazoneRanges == null) {
                System.out.println("Zone doesn't have metazone! " + zone);
                continue;
            }
            if (metazoneRanges.size() == 1) continue;
            for (SupplementalDataInfo.MetaZoneRange range : metazoneRanges) {
                System.out.println(zone + ":\t" + range);
            }
            System.out.println();
        }
        System.out.println("\nMetazoneInfo\n");
        for (Object singleCountry : (Object)new boolean[]{false}) {
            for (boolean hasDaylight : new boolean[]{false, true}) {
                for (MetazoneInfo mzone : MetazoneInfo.METAZONE_LIST) {
                    if (mzone.hasDaylight != hasDaylight || mzone.singleCountry != singleCountry) continue;
                    System.out.println(mzone);
                }
            }
        }
    }

    private static void displayWsb(String file, EnglishInfo info) {
        try {
            String[] parts = file.split("/");
            ULocale locale = new ULocale(parts[parts.length - 2]);
            FileInputStream fis = new FileInputStream(file);
            XMLReader xmlReader = XMLFileReader.createXMLReader(false);
            xmlReader.setErrorHandler(new MyErrorHandler());
            TreeMap<String, String> data = new TreeMap<String, String>();
            xmlReader.setContentHandler(new MyContentHandler(locale, data, info));
            InputSource is = new InputSource(fis);
            is.setSystemId(file);
            xmlReader.parse(is);
            fis.close();
            for (Map.Entry entity : data.entrySet()) {
                String path = (String)entity.getKey();
                String value = (String)entity.getValue();
                PathInfo pathInfo = info.getPathInfo(path);
                System.out.println(value + "\t" + (pathInfo == null ? "?" : pathInfo.englishValue) + "\t" + path);
            }
        }
        catch (SAXParseException e) {
            System.out.println("\tCan't read " + file);
            System.out.println("\t" + e.getClass() + "\t" + e.getMessage());
        }
        catch (SAXException e) {
            System.out.println("\tCan't read " + file);
            System.out.println("\t" + e.getClass() + "\t" + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("\tCan't read " + file);
            System.out.println("\t" + e.getClass() + "\t" + e.getMessage());
        }
    }

    static {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        DATE = dateFormat.format(new Date());
        REGION_LOCALES = new HashSet<String>(Arrays.asList(stock.split("\\|")));
        myOptions = new Option.Options("In normal usage, you set the -t option for the target.").add("target", (Object)".*", CLDRPaths.TMP_DIRECTORY + "dropbox/xmb/", "The target directory for building. Will generate an English .xmb file, and .wsb files for other languages.").add("file", (Object)".*", stock, "Filter the information based on file name, using a regex argument. The '.xml' is removed from the file before filtering").add("path", ".*", "Filter the information based on path name, using a regex argument").add("content", ".*", "Filter the information based on content name, using a regex argument").add("jason", ".*", "Generate JSON versions instead").add("zone", null, "Show metazoneinfo and exit").add("wsb", ".*", "Show metazoneinfo and exit").add("kompare", (Object)".*", CLDRPaths.BASE_DIRECTORY + "../DATA/cldr/common/google-bulk-imports", "Compare data with directory; generate files in -target.").add("project_name", Character.valueOf('n'), ".*", "CLDR", "The ID of the project.");
        supplementalDataInfo = SupplementalDataInfo.getInstance();
        pathFindRemover = new RegexLookup().loadFromFile(GenerateXMB.class, "xmbSkip.txt");
        prettyPath = new PrettyPath();
        errors = 0;
        path2errors = Relation.of(new TreeMap(), TreeSet.class);
        datePatternMatcher = PatternCache.get("dates.*(pattern|available)").matcher("");
        SKIP_LOCALES = new HashSet<String>(Arrays.asList("en", "root"));
        matches = new Output();
        failures = new ArrayList<String>();
        matcherFound = new Output();
        COUNT_OR_ALT_ATTRIBUTE = PatternCache.get("\\[@(count)=\"([^\"]*)\"]");
        PLURAL_XPATH = Pattern.compile("//ldml/(units/unit|numbers/(decimal|currency)Formats).*\\[@count=\"\\w+\"].*");
        SKIP_EXEMPLAR_TEST = PatternCache.get("/(currencySpacing|hourFormat|exemplarCharacters|pattern|localizedPatternChars|segmentations|dateFormatItem|references|unitPattern|intervalFormatItem|localeDisplayNames/variants/|commonlyUsed|currency.*/symbol|symbols/(exponential|nan))");
        skipExemplarTest = SKIP_EXEMPLAR_TEST.matcher("");
        ASCII_LATIN = new UnicodeSet("[A-Za-z]").freeze();
        LATIN = new UnicodeSet("[:sc=Latn:]").freeze();
        keepFromRoot = PatternCache.get("/(exemplarCity|currencies/currency.*/symbol)").matcher("");
        currencyDisplayName = Pattern.compile("/currencies/currency\\[@type=\"([^\"]*)\"]/displayName").matcher("");
        COUNT_ATTRIBUTE = PatternCache.get("\\[@count=\"([^\"]*)\"]");
        PLURAL_NUMBER = PatternCache.get("(decimal|number)Format");
        PLURAL_KEYS = new String[]{"=0", "=1", "zero", "one", "two", "few", "many", "other"};
        EXTRA_PLURAL_KEYS = new String[]{"0", "1", "zero", "one", "two", "few", "many"};
        START_TIME = GenerateXMB.getDateTimeinMillis(2000, 1, 0);
        END_TIME = GenerateXMB.getDateTimeinMillis(2015, 1, 0);
        HashSet<String> hasDaylightTemp = new HashSet<String>();
        Date date = new Date();
        block0: for (String string : sc.getCanonicalTimeZones()) {
            TimeZone zone = TimeZone.getTimeZone(string);
            for (long time = START_TIME + 7776000000L; time < END_TIME; time += 7776000000L) {
                date.setTime(time);
                if (!zone.inDaylightTime(date)) continue;
                hasDaylightTemp.add(string);
                continue block0;
            }
        }
        HAS_DAYLIGHT = Collections.unmodifiableSet(hasDaylightTemp);
        HashSet<String> singularCountries = new HashSet<String>(Arrays.asList("CL EC ES NZ PT AQ FM GL KI UM PF".split(" ")));
        Map<String, Set<String>> countryToZoneSet = sc.getCountryToZoneSet();
        block2: for (Map.Entry entry : countryToZoneSet.entrySet()) {
            String country = (String)entry.getKey();
            if (country.equals("001")) continue;
            Set zones = (Set)entry.getValue();
            if (zones.size() == 1) {
                singularCountries.add(country);
                continue;
            }
            ArrayList<TimeZone> initial = new ArrayList<TimeZone>();
            for (String s2 : zones) {
                initial.add(TimeZone.getTimeZone(s2));
            }
            for (long time = START_TIME; time < END_TIME; time += 900000L) {
                int firstOffset = Integer.MIN_VALUE;
                for (TimeZone zone : initial) {
                    int offset = zone.getOffset(time);
                    if (firstOffset == Integer.MIN_VALUE) {
                        firstOffset = offset;
                        continue;
                    }
                    if (firstOffset == offset) continue;
                    continue block2;
                }
            }
            singularCountries.add(country);
        }
        SINGULAR_COUNTRIES = Collections.unmodifiableSet(singularCountries);
        PLURAL_TAGS = Builder.with(new HashMap()).put("[\u200b=0]", "0").put("[=1]", "1").put("[ZERO]", "zero").put("[ONE]", "one").put("[TWO]", "two").put("[FEW]", "few").put("[MANY]", "many").put("[OTHER]", "other").put("[END_PLURAL]", "").freeze();
    }

    static class EnglishInfo
    implements Iterable<PathInfo> {
        final Map<String, PathInfo> pathToPathInfo = new TreeMap<String, PathInfo>();
        final Map<Long, PathInfo> longToPathInfo = new HashMap<Long, PathInfo>();
        final CLDRFile english;

        PathInfo getPathInfo(long hash) {
            return this.longToPathInfo.get(hash);
        }

        public String getName(String localeId) {
            return this.english.getName(localeId);
        }

        PathInfo getPathInfo(String path) {
            return this.pathToPathInfo.get(path);
        }

        EnglishInfo(String targetDir, CLDRFile english, CLDRFile root) throws Exception {
            Map<String, String> oldPathValueMap = ReadXMB.load(CLDRPaths.BASE_DIRECTORY + "/cldr-tools/org/unicode/cldr/unittest/data/xmb/", "en.xml");
            PatternPlaceholders patternPlaceholders = PatternPlaceholders.getInstance();
            this.english = english;
            TreeMap<String, List<Set<String>>> starredPaths = new TreeMap<String, List<Set<String>>>();
            HashSet<String[]> metazonePaths = new HashSet<String[]>();
            for (MetazoneInfo metazoneInfo : MetazoneInfo.METAZONE_LIST) {
                for (String item : metazoneInfo.getTypes()) {
                    String[] path = "//ldml/dates/timeZoneNames/metazone[@type=\"" + metazoneInfo.metazoneId + "\"]" + item;
                    metazonePaths.add(path);
                }
            }
            HashSet<String> extraLanguages = new HashSet<String>();
            for (String langId : PathDescription.EXTRA_LANGUAGES) {
                String langPath = "//ldml/localeDisplayNames/languages/language[@type=\"" + langId + "\"]";
                extraLanguages.add(langPath);
            }
            Set set = Builder.with(new TreeSet()).addAll(english).removeAll(new Transform<String, Boolean>(){

                @Override
                public Boolean transform(String source) {
                    return source.startsWith("//ldml/dates/timeZoneNames/metazone") ? Boolean.TRUE : Boolean.FALSE;
                }
            }).get();
            set.addAll(metazonePaths);
            set.addAll(extraLanguages);
            HashMap<String, String> extras = new HashMap<String, String>();
            Matcher m3 = COUNT_ATTRIBUTE.matcher("");
            for (String path : set) {
                if (!path.contains("[@count=\"")) continue;
                m3.reset(path).find();
                for (String key : EXTRA_PLURAL_KEYS) {
                    String path2 = path.substring(0, m3.start(1)) + (String)key + path.substring(m3.end(1));
                    extras.put(path2, path);
                }
            }
            set.addAll(extras.keySet());
            Relation<String, String> reasonsToPaths = Relation.of(new TreeMap(), TreeSet.class);
            TreeSet<String> missingDescriptions = new TreeSet<String>();
            CoverageLevel2 coverageLevel = CoverageLevel2.getInstance("en");
            RegexLookup<Boolean> coverageAllow = new RegexLookup<Boolean>().add("^//ldml/localeDisplayNames/keys/key", Boolean.valueOf(true)).add("^//ldml/localeDisplayNames/languages/language\\[@type=\"(jv|zxx|gsw|eo)\"]", (Boolean)true).add("^//ldml/localeDisplayNames/scripts/script", (Boolean)true).add("^//ldml/localeDisplayNames/types/type", (Boolean)true).add("^//ldml/dates/calendars/calendar\\[@type=\"[^\"]*\"]/dayPeriods/dayPeriodContext\\[@type=\"format\"]", (Boolean)true);
            PathDescription pathDescription = new PathDescription(supplementalDataInfo, english, extras, starredPaths, PathDescription.ErrorHandling.SKIP);
            for (String path : set) {
                Long hash;
                if (path.contains(GenerateXMB.DEBUG_PATH)) {
                    boolean bl = false;
                }
                String string = english.getStringValue(path);
                Level level = coverageLevel.getLevel(path);
                if (string == null) {
                    String string2 = "[EMPTY]";
                    GenerateXMB.addSkipReasons(reasonsToPaths, "empty-value", level, path, string2);
                    continue;
                }
                if (pathMatcher != null && !pathMatcher.reset(path).find()) {
                    GenerateXMB.addSkipReasons(reasonsToPaths, "path-parameter", level, path, string);
                    continue;
                }
                PathStatus pathStatus = GenerateXMB.shouldSkipPath(path, string);
                if (pathStatus == PathStatus.SKIP) {
                    GenerateXMB.addSkipReasons(reasonsToPaths, "path-remove", level, path, string);
                    continue;
                }
                if (level.compareTo(Level.MODERN) > 0 && pathStatus != PathStatus.KEEP) {
                    if (coverageAllow.get(path) == null) {
                        GenerateXMB.addSkipReasons(reasonsToPaths, "coverage", level, path, string);
                        continue;
                    }
                    GenerateXMB.addSkipReasons(reasonsToPaths, "coverage*", level, path, string);
                    continue;
                }
                String description = pathDescription.getDescription(path, string, level, null);
                EnumSet<PathDescription.Status> descriptionStatus = pathDescription.getStatus();
                if (!descriptionStatus.isEmpty()) {
                    GenerateXMB.addSkipReasons(reasonsToPaths, descriptionStatus.toString(), level, path, string);
                    description = null;
                } else {
                    description = "[ICU CLDR] " + description;
                }
                String oldValue = oldPathValueMap.get(path);
                boolean changedEnglish = !string.equals(oldValue);
                PathInfo row = new PathInfo(path, string, changedEnglish, patternPlaceholders.get(path), description, pathDescription.getStarredPathOutput());
                if (description == "Before translating, please see http://cldr.org/translation.") {
                    missingDescriptions.add(pathDescription.getStarredPathOutput());
                }
                if (this.longToPathInfo.containsKey(hash = row.getId())) {
                    throw new IllegalArgumentException("Id collision for " + path + " and " + this.longToPathInfo.get(hash).getPath());
                }
                this.pathToPathInfo.put(path, row);
                this.longToPathInfo.put(hash, row);
                if (!string.contains("{0}") || patternPlaceholders.get(path) != null) continue;
                System.out.println("ERROR, no placeholders for {0}...: " + path + " ; " + string);
            }
            PrintWriter out = FileUtilities.openUTF8Writer(targetDir + "/log/", "en-paths.txt");
            out.println("# " + DATE);
            for (Map.Entry entry : starredPaths.entrySet()) {
                out.println((String)entry.getKey() + "\t\t" + entry.getValue());
            }
            out.close();
            out = FileUtilities.openUTF8Writer(targetDir + "/log/", "en-missingDescriptions.txt");
            out.println("# " + DATE);
            for (String string : missingDescriptions) {
                out.println(this.toRegexPath(string) + "\t;\tDESCRIPTION\t" + starredPaths.get(string));
            }
            out.close();
            GenerateXMB.writeReasons(reasonsToPaths, targetDir, "en");
        }

        private String toRegexPath(String starredPath) {
            String result = starredPath.replace("[", "\\[");
            result = result.replace("\".*\"", "\"([^\"]*)\"");
            return "^" + result;
        }

        @Override
        public Iterator<PathInfo> iterator() {
            return this.pathToPathInfo.values().iterator();
        }
    }

    static class SubmittedPathFixer {
        private static final Pattern PATH_FIX = PatternCache.get("\\[@alt=\"(?:proposed|((?!proposed)[-a-zA-Z0-9]*)-proposed)-u\\d+-implicit[0-9.]+(?:-proposed-u\\d+-implicit[0-9.]+)?\"]");
        static Matcher pathFix = PATH_FIX.matcher("");

        SubmittedPathFixer() {
        }

        public String fix(String path, boolean debug) {
            if (pathFix.reset(path).find()) {
                String group;
                if (debug) {
                    String string = "REGEX:\t" + RegexUtilities.showMismatch(PATH_FIX, (CharSequence)path.substring(pathFix.start(0)));
                }
                String replacement = (group = pathFix.group(1)) == null ? "" : "[@alt=\"" + group + "\"]";
                String trunkPath = path.substring(0, pathFix.start(0)) + replacement + path.substring(pathFix.end(0));
                if (trunkPath.startsWith("//ldml/numbers/symbols/")) {
                    trunkPath = "//ldml/numbers/symbols[@numberSystem=\"latn\"]/" + trunkPath.substring("//ldml/numbers/symbols/".length());
                }
                return trunkPath;
            }
            return path;
        }
    }

    static enum PathStatus {
        SKIP,
        KEEP,
        MAYBE;

    }

    static class PathInfo
    implements Comparable<PathInfo> {
        private static final Pattern PLACEHOLDER = PatternCache.get("\\{(\\d)}");
        private final String path;
        private final Long id;
        private final String stringId;
        private final String englishValue;
        private final boolean changedEnglish;
        private final Map<String, PatternPlaceholders.PlaceholderInfo> placeholders;
        private final String description;
        private final String starredPath;
        private final int wordCount;
        private static final BreakIterator bi = BreakIterator.getWordInstance(ULocale.ENGLISH);
        private static final UnicodeSet ALPHABETIC = new UnicodeSet("[:Alphabetic:]");

        public PathInfo(String path, String englishValue, boolean changedEnglish, Map<String, PatternPlaceholders.PlaceholderInfo> placeholders, String description, String starredPath) {
            if (path.contains(GenerateXMB.DEBUG_PATH)) {
                boolean bl = false;
            }
            if (description == null) {
                path2errors.put(path, "missing description");
            }
            this.path = path;
            long id = StringId.getId(path);
            this.id = id;
            this.stringId = String.valueOf(id);
            this.englishValue = englishValue;
            this.changedEnglish = changedEnglish;
            this.placeholders = placeholders;
            this.description = description == null ? null : description.intern();
            this.starredPath = starredPath;
            int tempCount = 0;
            bi.setText(englishValue);
            int start = bi.first();
            int end = bi.next();
            while (end != -1) {
                String word = englishValue.substring(start, end);
                if (ALPHABETIC.containsSome(word)) {
                    ++tempCount;
                }
                start = end;
                end = bi.next();
            }
            this.wordCount = tempCount == 0 ? 1 : tempCount;
        }

        public String getFirstVariable() {
            PatternPlaceholders.PlaceholderInfo info = this.placeholders.get("{0}");
            if (info == null) {
                throw new IllegalArgumentException("Missing {0} for " + this);
            }
            return info.name;
        }

        public String getPath() {
            return this.path;
        }

        public Long getId() {
            return this.id;
        }

        public String getStringId() {
            return this.stringId;
        }

        public String getEnglishValue() {
            return this.englishValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getStarredPath() {
            return this.starredPath;
        }

        public Map<String, String> getPlaceholderReplacementsToOriginal() {
            if (this.placeholders == null) {
                return null;
            }
            LinkedHashMap<String, String> placeholderOutput = new LinkedHashMap<String, String>();
            for (String id : this.placeholders.keySet()) {
                placeholderOutput.put(id, this.getPlaceholderWithExample(id));
            }
            return placeholderOutput;
        }

        private String getPlaceholderWithExample(String placeholder) {
            PatternPlaceholders.PlaceholderInfo info = this.placeholders.get(placeholder);
            return "<ph name='" + info.name + "'><ex>" + info.example + "</ex>" + placeholder + "</ph>";
        }

        private String transformValue(String value, PlaceholderType type) {
            value = TransliteratorUtilities.toHTML.transform(value);
            if (this.placeholders == null) {
                return value;
            }
            String placeholderFormat = "";
            switch (type) {
                case BRACES: {
                    placeholderFormat = "'{'{0}'}'";
                    break;
                }
                case XML: {
                    placeholderFormat = "<ph name=''[{0}]'' />";
                    break;
                }
                case XML_EXAMPLE: {
                    placeholderFormat = "<ph name=''{0}''><ex>{1}</ex>'{'{2}'}'</ph>";
                }
            }
            Matcher matcher = PLACEHOLDER.matcher(value);
            StringBuffer buffer = new StringBuffer();
            int start = 0;
            while (matcher.find()) {
                buffer.append(value.substring(start, matcher.start()));
                PatternPlaceholders.PlaceholderInfo info = this.placeholders.get(matcher.group());
                buffer.append(MessageFormat.format(placeholderFormat, info.name, info.example, matcher.group(1)));
                start = matcher.end();
            }
            buffer.append(value.substring(start));
            return buffer.toString();
        }

        private String replacePlaceholders(String value, String placeholderStart, String placeholderEnd) {
            Matcher matcher = PLACEHOLDER.matcher(value);
            StringBuffer buffer = new StringBuffer();
            int start = 0;
            while (matcher.find()) {
                buffer.append(value.substring(start, matcher.start()));
                String name = this.placeholders.get((Object)matcher.group()).name;
                buffer.append(placeholderStart).append(name).append(placeholderEnd);
                start = matcher.end();
            }
            buffer.append(value.substring(start));
            return buffer.toString();
        }

        @Override
        public int compareTo(PathInfo arg0) {
            return this.path.compareTo(arg0.path);
        }

        public String toString() {
            return this.path;
        }
    }

    static enum PlaceholderType {
        BRACES,
        XML,
        XML_EXAMPLE;

    }

    static final class MetazoneInfo {
        static final String[] GENERIC = new String[]{"/long/generic"};
        static final String[] DAYLIGHT = new String[]{"/long/generic", "/long/standard", "/long/daylight"};
        private final String metazoneId;
        private final String golden;
        private final boolean singleCountry;
        private final boolean hasDaylight;
        static final List<MetazoneInfo> METAZONE_LIST;

        public MetazoneInfo(String metazoneId, String golden, boolean singleCountry, boolean hasDaylight) {
            this.golden = golden;
            this.metazoneId = metazoneId;
            this.singleCountry = singleCountry;
            this.hasDaylight = hasDaylight;
        }

        public String[] getTypes() {
            return this.hasDaylight ? DAYLIGHT : GENERIC;
        }

        public String toString() {
            return sc.getZoneToCounty().get(this.golden) + "\t" + this.metazoneId + "\t" + this.golden + "\t" + (this.singleCountry ? "singleCountry" : "") + "\t" + (this.hasDaylight ? "useDaylightTime" : "");
        }

        static {
            ArrayList<MetazoneInfo> result = new ArrayList<MetazoneInfo>();
            Map<String, String> zoneToCountry = sc.getZoneToCounty();
            Map<String, Map<String, String>> metazoneToRegionToZone = supplementalDataInfo.getMetazoneToRegionToZone();
            for (String metazone : supplementalDataInfo.getAllMetazones()) {
                Map<String, String> regionToZone = metazoneToRegionToZone.get(metazone);
                String golden = regionToZone.get("001");
                if (golden == null) {
                    throw new IllegalArgumentException("Missing golden zone " + metazone + ", " + regionToZone);
                }
                String region = zoneToCountry.get(golden);
                boolean isSingleCountry = SINGULAR_COUNTRIES.contains(region);
                if (isSingleCountry) continue;
                Set<SupplementalDataInfo.MetaZoneRange> metazoneRanges = supplementalDataInfo.getMetaZoneRanges(golden);
                if (metazoneRanges == null) {
                    throw new IllegalArgumentException("Missing golden zone " + metazone + ", " + regionToZone);
                }
                MetazoneInfo item = new MetazoneInfo(metazone, golden, isSingleCountry, HAS_DAYLIGHT.contains(golden));
                result.add(item);
            }
            METAZONE_LIST = Collections.unmodifiableList(result);
        }
    }

    static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            System.out.println("\nerror: " + XMLFileReader.showSAX(exception));
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("\nfatalError: " + XMLFileReader.showSAX(exception));
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("\nwarning: " + XMLFileReader.showSAX(exception));
            throw exception;
        }
    }

    static class MyContentHandler
    implements ContentHandler {
        private static final boolean SHOW = false;
        private Map<String, String> myData;
        private EnglishInfo info;
        private PathInfo lastPathInfo;
        private StringBuilder currentText = new StringBuilder();
        private long lastId;
        private String lastPluralTag;
        private Map<String, String> pluralTags = new LinkedHashMap<String, String>();
        private Set<String> pluralKeywords;

        public MyContentHandler(ULocale locale, Map<String, String> data, EnglishInfo info) {
            this.myData = data;
            this.info = info;
            PluralRules rules = PluralRules.forLocale(locale);
            this.pluralKeywords = Builder.with(new HashSet()).addAll((Iterable<String>)rules.getKeywords()).add("0").add("1").freeze();
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            String chars = String.valueOf(arg0, arg1, arg2);
            this.currentText.append(chars);
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String arg0, String arg1, String qName) throws SAXException {
            if (qName.equals("msg")) {
                String chars = this.currentText.toString().replace("\n", "").trim();
                if (this.lastPathInfo == null) {
                    System.out.println("***Missing path info for " + this.lastId + "\t" + chars);
                } else if (this.pluralTags.size() != 0) {
                    for (Map.Entry<String, String> pluralTagEntry : this.pluralTags.entrySet()) {
                        String pluralTag = pluralTagEntry.getKey();
                        String pluralTagValue = pluralTagEntry.getValue();
                        if (this.pluralKeywords.contains(pluralTag)) {
                            String fixedCount = this.lastPathInfo.path.replace("other", pluralTag);
                            this.myData.put(fixedCount, pluralTagValue);
                            continue;
                        }
                        System.out.println("***Skipping " + pluralTag + "\t" + pluralTagValue);
                    }
                    this.pluralTags.clear();
                } else {
                    this.myData.put(this.lastPathInfo.path, chars);
                }
                this.currentText.setLength(0);
            }
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String arg0, String arg1, String qName, Attributes arg3) throws SAXException {
            if (qName.equals("msg")) {
                this.lastId = Long.parseLong(arg3.getValue("id"));
                this.lastPathInfo = this.info.getPathInfo(this.lastId);
                this.currentText.setLength(0);
            } else if (qName.equals("ph")) {
                String name = arg3.getValue("name");
                String original = this.lastPathInfo.getPlaceholderReplacementsToOriginal().get(name);
                if (original != null) {
                    this.currentText.append(original);
                } else if (name.startsWith("[PLURAL_")) {
                    this.pluralTags.clear();
                    this.lastPluralTag = "[START_PLURAL]";
                } else {
                    String pluralTag = PLURAL_TAGS.get(name);
                    if (pluralTag != null) {
                        String chars = this.currentText.toString().replace("\n", "").trim();
                        this.pluralTags.put(this.lastPluralTag, chars);
                        this.currentText.setLength(0);
                        this.lastPluralTag = pluralTag;
                    } else {
                        System.out.println("***Can't find " + name + " in " + this.lastPathInfo.getPlaceholderReplacementsToOriginal());
                    }
                }
            }
        }

        private String showAttributes(Attributes atts) {
            String result = "";
            for (int i = 0; i < atts.getLength(); ++i) {
                result = result + atts.getQName(i) + "=\"" + atts.getValue(i) + "\"\t";
            }
            return result;
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }
}

