/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.ToolUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.XPathParts;

public class PivotData {
    public static final boolean DEBUG = true;
    private static Matcher fileMatcher;
    private LocaleIDParser lidp = new LocaleIDParser();
    private Factory factory;
    private String outputDirectory;
    private String sourceDirectory;
    CldrUtility.SimpleLineComparator lineComparer = new CldrUtility.SimpleLineComparator(13);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        System.out.println("WARNING: Must be done in 3 phases. -DPhase=1, then -DPhase=2, then -DPhase=3\nThese are Lang+Script+Region, then Lang+Region, then Lang+Script\nInspect and check-in after each phase");
        fileMatcher = PatternCache.get(CldrUtility.getProperty("FILE", ".*")).matcher("");
        int phase = Integer.parseInt(CldrUtility.getProperty("phase", null));
        EnumSet<LocaleIDParser.Level> conditions = null;
        switch (phase) {
            case 1: {
                conditions = EnumSet.of(LocaleIDParser.Level.Language, LocaleIDParser.Level.Script, LocaleIDParser.Level.Region);
                break;
            }
            case 2: {
                conditions = EnumSet.of(LocaleIDParser.Level.Language, LocaleIDParser.Level.Region);
                break;
            }
            case 3: {
                conditions = EnumSet.of(LocaleIDParser.Level.Language, LocaleIDParser.Level.Script);
            }
        }
        try {
            Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
            PivotData pd = new PivotData(cldrFactory, CLDRPaths.MAIN_DIRECTORY, CLDRPaths.GEN_DIRECTORY + "pivot/");
            pd.pivotGroup(cldrFactory, conditions);
        }
        finally {
            System.out.println("DONE");
        }
    }

    private void pivotGroup(Factory cldrFactory, Set<LocaleIDParser.Level> conditions) throws IOException {
        String[] items;
        CLDRFile supplementalMetadata = cldrFactory.make("supplementalMetadata", false);
        String defaultContentList = supplementalMetadata.getFullXPath("//supplementalData/metadata/defaultContent", true);
        XPathParts parts = XPathParts.getFrozenInstance(defaultContentList);
        String list = parts.getAttributeValue(-1, "locales");
        for (String item : items = list.split("\\s+")) {
            if (!fileMatcher.reset(item).matches() || !this.lidp.set(item).getLevels().equals(conditions)) continue;
            this.writePivot(item);
        }
    }

    PivotData(Factory factory, String sourceDirectory, String targetDirectory) {
        this.factory = factory;
        this.sourceDirectory = sourceDirectory;
        this.outputDirectory = targetDirectory;
    }

    public int writePivot(String localeID) throws IOException {
        int countChanges = 0;
        CLDRFile me = this.factory.make(localeID, false);
        if (me.getFullXPath("//ldml/alias", true) != null) {
            throw new IllegalArgumentException("File cannot be completely aliased: " + localeID);
        }
        String parentID = LocaleIDParser.getParent(localeID);
        System.out.format("LocaleID: %s, %s\n", localeID, parentID);
        TreeSet<String> uniquePaths = new TreeSet<String>();
        CLDRFile resolvedParent = this.factory.make(parentID, true);
        if (resolvedParent.getFullXPath("//ldml/alias", true) != null) {
            throw new IllegalArgumentException("File cannot be completely aliased: " + localeID);
        }
        for (String path : me) {
            if (path.startsWith("//ldml/identity")) continue;
            String fullPath = me.getFullXPath(path);
            String value = me.getStringValue(path);
            String oldFullXPath = resolvedParent.getFullXPath(path);
            if (oldFullXPath == null) {
                uniquePaths.add(path);
                continue;
            }
            String oldValue = resolvedParent.getStringValue(path);
            CLDRFile.Status status = new CLDRFile.Status();
            if (fullPath.equals(oldFullXPath) && value.equals(oldValue)) continue;
            if (fullPath.contains("[@casing") != oldFullXPath.contains("[@casing") && resolvedParent.getSourceLocaleID(path, status).equals(parentID)) {
                throw new IllegalArgumentException("Mismatched casing: " + localeID + ", " + parentID + " For:" + "\n" + fullPath + "\n" + oldFullXPath);
            }
            uniquePaths.add(path);
        }
        if (uniquePaths.size() == 0) {
            System.out.format("LocaleID: %s is EMPTY, no changes necessary\n", localeID);
            return countChanges;
        }
        Set<String> siblings = this.lidp.set(localeID).getSiblings(this.factory.getAvailable());
        siblings.remove(localeID);
        System.out.format("Siblings: %s\n", siblings);
        CLDRFile newFile = SimpleFactory.makeFile(localeID);
        this.writeFile(newFile);
        System.out.format("%s changes in: %s\n", uniquePaths.size(), localeID);
        newFile = this.factory.make(parentID, false).cloneAsThawed();
        int deltaChangeCount = this.addPathsAndValuesFrom(newFile, uniquePaths, me, true);
        countChanges += deltaChangeCount;
        System.out.format("%s changes in: %s\n", deltaChangeCount, parentID);
        this.writeFile(newFile);
        for (String id : siblings) {
            newFile = this.factory.make(id, false).cloneAsThawed();
            if (newFile.getFullXPath("//ldml/alias", true) != null) {
                System.out.println("Skipping completely aliased file: " + id);
                continue;
            }
            deltaChangeCount = this.addPathsAndValuesFrom(newFile, uniquePaths, resolvedParent, false);
            countChanges += deltaChangeCount;
            System.out.format("%s changes in: %s\n", deltaChangeCount, id);
            this.writeFile(newFile);
        }
        return countChanges;
    }

    private int size(Iterator name) {
        int count = 0;
        while (name.hasNext()) {
            name.next();
            ++count;
        }
        return count;
    }

    private int addPathsAndValuesFrom(CLDRFile toModify, Set<String> uniquePaths, CLDRFile toAddFrom, boolean override) {
        int changeCount = 0;
        for (String path : uniquePaths) {
            String fullPath = null;
            String value = null;
            String oldFullXPath = null;
            String oldValue = null;
            fullPath = toAddFrom.getFullXPath(path);
            if (fullPath == null) continue;
            value = toAddFrom.getStringValue(path);
            oldFullXPath = toModify.getFullXPath(path);
            if (!override && oldFullXPath != null) continue;
            oldValue = toModify.getStringValue(path);
            if (fullPath.equals(oldFullXPath) && value.equals(oldValue)) continue;
            if (oldFullXPath != null && fullPath.contains("[@casing") != oldFullXPath.contains("[@casing")) {
                throw new IllegalArgumentException("Mismatched casing: " + toAddFrom.getLocaleID() + ", " + toModify.getLocaleID());
            }
            if (override && oldFullXPath != null) {
                XPathParts parts = XPathParts.getFrozenInstance(oldFullXPath);
                Map<String, String> attributes = parts.getAttributes(-1);
                String alt = attributes.get("alt");
                if (alt == null) {
                    attributes.put("alt", "proposed-x999");
                } else if (alt.contains("proposed")) {
                    attributes.put("alt", alt + "-x999");
                } else {
                    attributes.put("alt", alt + "-proposed-x999");
                }
                oldFullXPath = parts.toString();
                toModify.add(oldFullXPath, oldValue);
            }
            toModify.add(fullPath, value);
            ++changeCount;
        }
        return changeCount;
    }

    private void writeFile(CLDRFile newFile) throws IOException {
        String id = newFile.getLocaleID();
        PrintWriter out = FileUtilities.openUTF8Writer(this.outputDirectory, id + ".xml");
        newFile.write(out);
        out.println();
        out.close();
        ToolUtilities.generateBat(this.sourceDirectory, id + ".xml", this.outputDirectory, id + ".xml", this.lineComparer);
    }
}

