/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.SearchXml;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;

public class SearchCLDR {
    static final Option.Options myOptions = new Option.Options().add("source", (Object)".*", CLDRPaths.MAIN_DIRECTORY, "source directory").add("file", (Object)".*", ".*", "regex to filter files/locales.").add("path", (Object)".*", null, "regex to filter paths. ! in front selects items that don't match. example: -p relative.*@type=\\\"-?3\\\"").add("value", (Object)".*", null, "regex to filter values. ! in front selects items that don't match").add("level", (Object)".*", null, "regex to filter levels. ! in front selects items that don't match").add("count", null, null, "only count items").add("organization", (Object)".*", null, "show level for organization").add("z-showPath", null, null, "show paths").add("resolved", null, null, "use resolved locales").add("q-showParent", null, null, "show parent value").add("english", null, null, "show english value").add("Verbose", null, null, "verbose output").add("PathHeader", null, null, "show path header and string ID").add("diff", (Object)"\\d+(\\.\\d+)?", null, "show only paths whose values changed from specified version (and were present in that version)").add("Error", (Object)".*", null, "filter by errors, eg CheckForCopy, or CheckForCopy:sameAsCode");
    private static String fileMatcher;
    private static Matcher pathMatcher;
    private static boolean countOnly;
    private static boolean showPath;
    private static PathHeader.Factory PATH_HEADER_FACTORY;
    private static CheckCLDR.CheckStatus.Subtype subtype;
    private static CheckCLDR checkCldr;
    private static String organization;

    public static void main(String[] args) {
        myOptions.parse(args, true);
        long startTime = System.currentTimeMillis();
        String sourceDirectory = myOptions.get("source").getValue();
        Output<Boolean> exclude = new Output<Boolean>();
        fileMatcher = myOptions.get("file").getValue();
        pathMatcher = SearchCLDR.getMatcher(myOptions.get("path").getValue(), exclude);
        Boolean pathExclude = (Boolean)exclude.value;
        Set<Level> levelMatcher = SearchCLDR.getEnumMatcher(myOptions.get("level").getValue(), exclude);
        Matcher valueMatcher = SearchCLDR.getMatcher(myOptions.get("value").getValue(), exclude);
        Boolean valueExclude = (Boolean)exclude.value;
        countOnly = myOptions.get("count").doesOccur();
        boolean resolved = myOptions.get("resolved").doesOccur();
        showPath = myOptions.get("z-showPath").doesOccur();
        organization = myOptions.get("organization").getValue();
        CLDRFile english = CLDRConfig.getInstance().getEnglish();
        if (myOptions.get("PathHeader").doesOccur()) {
            PATH_HEADER_FACTORY = PathHeader.getFactory(english);
        }
        boolean showParent = myOptions.get("q-showParent").doesOccur();
        boolean showEnglish = myOptions.get("english").doesOccur();
        File[] paths = new File[]{new File(CLDRPaths.MAIN_DIRECTORY), new File(sourceDirectory)};
        Factory cldrFactory = SimpleFactory.make(paths, fileMatcher);
        TreeSet<String> locales = new TreeSet<String>(cldrFactory.getAvailable());
        String rawVersion = myOptions.get("diff").getValue();
        Factory cldrDiffFactory = null;
        if (rawVersion != null) {
            String base = SearchCLDR.getArchiveDirectory(VersionInfo.getInstance(rawVersion));
            File[] files = SearchCLDR.getCorrespondingDirectories(base, cldrFactory);
            cldrDiffFactory = SimpleFactory.make(files, ".*");
        }
        PathHeader.Factory pathHeaderFactory = PathHeader.getFactory(english);
        String errorMatcherText = myOptions.get("Error").getValue();
        subtype = null;
        checkCldr = null;
        if (errorMatcherText != null) {
            int errorSepPos = errorMatcherText.indexOf(58);
            if (errorSepPos >= 0) {
                subtype = CheckCLDR.CheckStatus.Subtype.valueOf(errorMatcherText.substring(errorSepPos + 1));
                errorMatcherText = errorMatcherText.substring(0, errorSepPos);
            }
            try {
                Class<?> checkCLDRClass = Class.forName("org.unicode.cldr.test." + errorMatcherText);
                Constructor<?> ctor = checkCLDRClass.getConstructor(Factory.class);
                checkCldr = (CheckCLDR)ctor.newInstance(cldrFactory);
            }
            catch (Exception e) {
                throw new ICUUncheckedIOException(e);
            }
            CheckCLDR.setDisplayInformation(english);
        }
        System.out.println("Searching...");
        System.out.println();
        System.out.flush();
        if (countOnly) {
            System.out.print("file");
            for (Level cLevel : Level.values()) {
                System.out.print("\t" + (Object)((Object)cLevel));
            }
            System.out.println();
        }
        ArrayList<CheckCLDR.CheckStatus> result = new ArrayList<CheckCLDR.CheckStatus>();
        HashMap<String, String> options = new HashMap<String, String>();
        int totalCount = 0;
        for (String locale : locales) {
            int localeCount = 0;
            Level organizationLevel = organization == null ? null : StandardCodes.make().getLocaleCoverageLevel(organization, locale);
            CLDRFile file = cldrFactory.make(locale, resolved);
            CLDRFile resolvedFile = resolved ? file : cldrFactory.make(locale, true);
            CLDRFile diffFile = null;
            if (checkCldr != null) {
                if (locale.equals("eo")) {
                    boolean bl = false;
                }
                result.clear();
                checkCldr.setCldrFileToCheck(resolvedFile, options, result);
            }
            if (cldrDiffFactory != null) {
                try {
                    diffFile = cldrDiffFactory.make(locale, resolved);
                }
                catch (Exception e) {
                    continue;
                }
            }
            Counter<Object> levelCounter = new Counter<Object>();
            boolean headerShown = false;
            CoverageLevel2 level = null;
            Level pathLevel = null;
            level = CoverageLevel2.getInstance(locale);
            CLDRFile.Status status = new CLDRFile.Status();
            TreeSet<PathHeader> sorted = new TreeSet<PathHeader>();
            for (String path : file.fullIterable()) {
                String stringValue;
                if (locale.equals("eo") && path.contains("type=\"MK\"")) {
                    boolean bl = false;
                }
                if ((stringValue = file.getStringValue(path)) == null) continue;
                if (diffFile != null) {
                    String stringValueWithBailey;
                    String string = diffFile.getWinningValueWithBailey(path);
                    if (string == null || (stringValueWithBailey = resolvedFile.getWinningValueWithBailey(path)) == null || string.equals(stringValueWithBailey)) continue;
                    stringValueWithBailey = resolvedFile.getWinningValueWithBailey(path);
                    boolean bl = false;
                }
                sorted.add(pathHeaderFactory.fromPath(path));
            }
            for (PathHeader pathHeader : sorted) {
                String resolvedSource;
                String path = pathHeader.getOriginalPath();
                String string = file.getFullXPath(path);
                String value = file.getStringValue(path);
                if (locale.equals("eo") && path.contains("type=\"MK\"")) {
                    boolean bl = false;
                }
                if (pathMatcher != null && pathExclude.booleanValue() == pathMatcher.reset(string).find()) continue;
                pathLevel = level.getLevel(path);
                levelCounter.add((Object)pathLevel, 1L);
                if (levelMatcher != null && !levelMatcher.contains((Object)pathLevel) || valueMatcher != null && valueExclude.booleanValue() == valueMatcher.reset(value).find()) continue;
                if (checkCldr != null) {
                    if (checkCldr.isSkipTest()) continue;
                    result.clear();
                    checkCldr.check(path, file.getFullXPath(path), value, options, result);
                    if (result.isEmpty()) continue;
                    int count = 0;
                    for (CheckCLDR.CheckStatus item : result) {
                        if (item.getSubtype() != subtype) continue;
                        ++count;
                    }
                    if (count == 0) continue;
                    boolean debug = false;
                    checkCldr.check(path, file.getFullXPath(path), value, options, result);
                }
                if (countOnly) continue;
                if (!headerShown) {
                    SearchCLDR.showLine(showPath, showParent, showEnglish, resolved, locale, "Path", "Full-Path", "Value", "PathHeader", "Parent-Value", "English-Value", "Source-Locale\tSource-Path", "Org-Level");
                    headerShown = true;
                }
                String cleanShort = pathHeader.toString().replace('\t', '|');
                String string2 = !resolved ? null : (resolvedSource = file.getSourceLocaleID(path, status) + (path.equals(status.pathWhereFound) ? "\t\u2263" : "\t" + status));
                if (checkCldr != null) {
                    SearchXml.show(SearchXml.ConfigOption.delete, "", locale, CLDRFile.getDistinguishingXPath(string, null), value, null, null, null);
                } else {
                    SearchCLDR.showLine(showPath, showParent, showEnglish, resolved, locale, path, string, value, cleanShort, !showParent ? null : english.getBaileyValue(path, null, null), english == null ? null : english.getStringValue(path), resolvedSource, Objects.toString((Object)pathLevel));
                }
                ++totalCount;
                ++localeCount;
            }
            if (countOnly) {
                System.out.print(locale);
                for (Iterator<String> iterator : Level.values()) {
                    System.out.print("\t" + levelCounter.get(iterator));
                }
            }
            if (localeCount != 0) {
                System.out.println("# " + locale + " Total " + localeCount + " found");
            }
            System.out.flush();
        }
        System.out.println("# All Total " + totalCount + " found\nDone -- Elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 60000.0 + " minutes");
    }

    private static File[] getCorrespondingDirectories(String base, Factory cldrFactory) {
        File[] sourceDirs = cldrFactory.getSourceDirectories();
        File[] newDirs = new File[sourceDirs.length];
        int item = 0;
        for (File s2 : sourceDirs) {
            String path = PathUtilities.getNormalizedPathString(s2);
            int baseLoc = path.lastIndexOf("/cldr/");
            if (baseLoc < 0) {
                throw new ICUUncheckedIOException("source doesn't contain /cldr/");
            }
            newDirs[item++] = new File(base, path.substring(baseLoc + 5));
        }
        return newDirs;
    }

    private static String getArchiveDirectory(VersionInfo versionInfo) {
        return CLDRPaths.ARCHIVE_DIRECTORY + "cldr-" + versionInfo.getVersionString(2, 3) + "/";
    }

    private static void showLine(boolean showPath, boolean showParent, boolean showEnglish, boolean resolved, String locale, String path, String fullPath, String value, String shortPath, String parentValue, String englishValue, String resolvedSource, String organizationLevel) {
        PathHeader pathHeader;
        String pathHeaderInfo = "";
        if (PATH_HEADER_FACTORY != null && (pathHeader = PATH_HEADER_FACTORY.fromPath(path)) != null) {
            pathHeaderInfo = "\n\t" + pathHeader + "\n\t" + pathHeader.getUrl(PathHeader.BaseUrl.PRODUCTION, locale);
        }
        System.out.println("# " + locale + "\t\u27ea" + value + "\u27eb" + (showEnglish ? "\t\u27ea" + englishValue + "\u27eb" : "") + (!showParent ? "" : (Objects.equals(value, parentValue) ? "\t\u2263" : "\t\u27ea" + parentValue + "\u27eb")) + "\t" + shortPath + (showPath ? "\t" + fullPath : "") + (resolved ? "\t" + resolvedSource : "") + (organizationLevel != null ? "\t" + organizationLevel : "") + pathHeaderInfo);
    }

    private static Matcher getMatcher(String property, Output<Boolean> exclude) {
        exclude.value = false;
        if (property == null) {
            return null;
        }
        if (property.startsWith("!")) {
            exclude.value = true;
            property = property.substring(1);
        }
        return PatternCache.get(property).matcher("");
    }

    private static Set<Level> getEnumMatcher(String property, Output<Boolean> exclude) {
        exclude.value = false;
        if (property == null) {
            return null;
        }
        if (property.startsWith("!")) {
            exclude.value = true;
            property = property.substring(1);
        }
        EnumSet<Level> result = EnumSet.noneOf(Level.class);
        Matcher matcher = Pattern.compile(property, 2).matcher("");
        for (Level level : Level.values()) {
            if (matcher.reset(level.toString()).matches() == ((Boolean)exclude.value).booleanValue()) continue;
            result.add(level);
        }
        return ImmutableSet.copyOf(result);
    }

    static {
        PATH_HEADER_FACTORY = null;
    }
}

