/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.UnicodeRegex;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XMLFileReader;

@CLDRTool(alias="searchxml", description="Search CLDR XML for matching paths or values")
public class SearchXml {
    private static Matcher fileMatcher;
    private static Matcher pathMatcher;
    private static Matcher valueMatcher;
    private static Matcher levelMatcher;
    private static boolean showFiles;
    private static boolean showValues;
    private static boolean replaceValues;
    private static int total;
    private static boolean countOnly;
    private static boolean verbose;
    private static boolean pathExclude;
    private static boolean levelExclude;
    private static boolean valueExclude;
    private static boolean fileExclude;
    private static boolean unique;
    private static boolean groups;
    private static Counter<String> uniqueData;
    private static String valuePattern;
    private static File comparisonDirectory;
    private static boolean recursive;
    private static Counter<String> kountRegexMatches;
    private static Counter<String> starCounter;
    private static final Set<String> ERRORS;
    private static final PathStarrer pathStarrer;
    private static PathHeader.Factory PATH_HEADER_FACTORY;
    static final Option.Options myOptions;
    static DiffInfo DIFF_INFO;
    static final Transliterator showInvisibles;
    static Set<String> defaultContent;

    public static void main(String[] args) throws IOException {
        double startTime = System.currentTimeMillis();
        myOptions.parse(args, true);
        verbose = myOptions.get("Verbose").doesOccur();
        String sourceDirectory = myOptions.get("source").getValue();
        if (sourceDirectory == null) {
            System.out.println("#Need Source Directory! ");
            return;
        }
        Output<Boolean> exclude = new Output<Boolean>();
        fileMatcher = SearchXml.getMatcher(myOptions.get("file").getValue(), exclude);
        fileExclude = (Boolean)exclude.value;
        pathMatcher = SearchXml.getMatcher(myOptions.get("path").getValue(), exclude);
        pathExclude = (Boolean)exclude.value;
        levelMatcher = SearchXml.getMatcher(myOptions.get("level").getValue(), exclude);
        levelExclude = (Boolean)exclude.value;
        valueMatcher = SearchXml.getMatcher(myOptions.get("value").getValue(), exclude);
        valueExclude = (Boolean)exclude.value;
        if (myOptions.get("Star").doesOccur()) {
            starCounter = new Counter();
        }
        if (pathMatcher != null && valueMatcher != null) {
            valuePattern = valueMatcher.pattern().toString();
            if (PatternCache.get("\\$\\d.*").matcher(valuePattern).find()) {
                replaceValues = true;
            }
        }
        if (myOptions.get("PathHeader").doesOccur()) {
            PATH_HEADER_FACTORY = PathHeader.getFactory(ToolConfig.getToolInstance().getEnglish());
        }
        unique = myOptions.get("unique").doesOccur();
        groups = myOptions.get("groups").doesOccur();
        countOnly = myOptions.get("count").doesOccur();
        kountRegexMatches = myOptions.get("kount").doesOccur() ? new Counter() : null;
        recursive = myOptions.get("recursive").doesOccur();
        File src = new File(sourceDirectory);
        if (!src.isDirectory()) {
            System.err.println("#" + sourceDirectory + " must be a directory");
            return;
        }
        String comparisonDirectoryString = myOptions.get("other").getValue();
        if (comparisonDirectoryString != null && !(comparisonDirectory = new File(comparisonDirectoryString)).isDirectory()) {
            System.err.println("#" + comparisonDirectoryString + " must be a directory");
            return;
        }
        if (countOnly) {
            System.out.print("file");
            for (Level cLevel : Level.values()) {
                System.out.print("\t" + cLevel);
            }
            System.out.println();
        }
        SearchXml.processDirectory(src);
        if (kountRegexMatches != null) {
            for (String item : kountRegexMatches.getKeysetSortedByCount(false)) {
                System.out.println("#" + kountRegexMatches.getCount(item) + "\t" + item);
            }
        }
        if (unique) {
            for (String item : uniqueData.getKeysetSortedByCount(false)) {
                System.out.println("#" + uniqueData.getCount(item) + item);
            }
        }
        if (starCounter != null) {
            for (String path : starCounter.getKeysetSortedByCount(false)) {
                System.out.println("#" + starCounter.get(path) + "\t" + path);
            }
        }
        double deltaTime = (double)System.currentTimeMillis() - startTime;
        System.out.println("#Elapsed: " + deltaTime / 1000.0 + " seconds");
        System.out.println("#Instances found: " + total);
    }

    private static Matcher getMatcher(String property, Output<Boolean> exclude) {
        exclude.value = false;
        if (property == null) {
            return null;
        }
        if (property.startsWith("!")) {
            exclude.value = true;
            property = property.substring(1);
        }
        Matcher result = UnicodeRegex.compile(property).matcher("");
        return result;
    }

    private static void processDirectory(File src) throws IOException {
        if (comparisonDirectory != null) {
            System.out.println("#Locale\tFile\tBase\tSame\tDeletions\tAdditions\tChanges\n#\tValue\tOtherValue\tPath");
        }
        for (File file : src.listFiles()) {
            if (recursive && file.isDirectory()) {
                SearchXml.processDirectory(file);
                continue;
            }
            if (file.length() == 0L) continue;
            String fileName = file.getName();
            String canonicalFile = PathUtilities.getNormalizedPathString(file);
            if (!fileName.endsWith(".xml")) continue;
            String coreName = fileName.substring(0, fileName.length() - 4);
            if (fileMatcher != null && fileExclude == fileMatcher.reset(coreName).find()) {
                if (!verbose) continue;
                System.out.println("#* Skipping " + canonicalFile);
                continue;
            }
            if (verbose) {
                System.out.println("#Searching " + canonicalFile);
            }
            if (showFiles) {
                System.out.println("#* " + canonicalFile);
            }
            Relation<String, String> source = SearchXml.getXmlFileAsRelation(src, fileName);
            Relation<String, String> other = null;
            if (comparisonDirectory != null) {
                other = SearchXml.getXmlFileAsRelation(comparisonDirectory, fileName);
            }
            SearchXml.checkFiles(recursive ? file.getParent() : null, fileName, coreName, source, other);
            System.out.flush();
        }
        System.out.println("#\t\tSame\tDeletions\tAdditions\tChanges");
        DIFF_INFO.showValues("TOTAL");
        for (String error : ERRORS) {
            System.err.println("#" + error);
        }
    }

    private static Relation<String, String> getXmlFileAsRelation(File directory, String fileName) {
        ListHandler listHandler = new ListHandler();
        XMLFileReader xfr = new XMLFileReader().setHandler(listHandler);
        try {
            String fileName2 = PathUtilities.getNormalizedPathString(directory) + "/" + fileName;
            xfr.read(fileName2, XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, false);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter arg0 = new PrintWriter(stringWriter);
            e.printStackTrace(arg0);
            arg0.flush();
            ERRORS.add("Can't read " + directory + "/" + fileName + "\n" + stringWriter);
        }
        return listHandler.data;
    }

    private static void checkFiles(String filePath, String fileName, String coreName, Relation<String, String> source, Relation<String, String> other) {
        CoverageLevel2 level = null;
        Counter<Level> levelCounter = new Counter<Level>();
        String canonicalFile = fileName;
        String firstMessage = "* " + canonicalFile;
        String file = canonicalFile;
        DiffInfo diffInfo = new DiffInfo();
        if (levelMatcher != null || countOnly) {
            try {
                level = CoverageLevel2.getInstance(canonicalFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (countOnly) {
            System.out.print(fileName);
            for (Level cLevel : Level.values()) {
                System.out.print("\t" + levelCounter.get(cLevel));
            }
            System.out.println();
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>(source.keySet());
        if (other != null) {
            keys.addAll(other.keySet());
        }
        for (String path : keys) {
            Set<String> otherValues;
            if (path.startsWith("//ldml/identity/") || pathMatcher != null && pathExclude == pathMatcher.reset(path).find()) continue;
            Level pathLevel = null;
            pathLevel = level == null ? Level.COMPREHENSIVE : level.getLevel(path);
            levelCounter.add(pathLevel, 1L);
            if (levelMatcher != null && levelExclude == levelMatcher.reset(pathLevel.toString()).find()) continue;
            Set<String> values = source.get(path);
            Set<String> set = otherValues = other == null ? null : other.get(path);
            if (other != null) {
                if (values == otherValues) continue;
                boolean diff = true;
                if (values == null) {
                    diffInfo.additionCount += otherValues.size();
                } else if (otherValues == null) {
                    diffInfo.deletionCount += values.size();
                } else if (!values.equals(otherValues)) {
                    diffInfo.changed2Values += values.size() + otherValues.size();
                } else {
                    diff = false;
                    diffInfo.sameCount += values.size();
                }
                if (!diff || !showValues) continue;
                SearchXml.show(ConfigOption.add, filePath, file, null, null, path, values, otherValues);
                continue;
            }
            for (String value : values) {
                String data;
                if (replaceValues) {
                    String pattern = valuePattern;
                    for (int i = 0; i <= pathMatcher.groupCount(); ++i) {
                        pattern = pattern.replace("$" + i, pathMatcher.group(i));
                    }
                    valueMatcher = PatternCache.get(pattern).matcher("");
                }
                if (valueMatcher != null && valueExclude == valueMatcher.reset(value).find()) continue;
                if (kountRegexMatches != null && pathMatcher != null) {
                    kountRegexMatches.add(pathMatcher.group(1), 1L);
                }
                if (starCounter != null) {
                    starCounter.add(pathStarrer.set(path), 1L);
                }
                ++total;
                if (firstMessage != null) {
                    firstMessage = null;
                }
                if (countOnly) continue;
                String string = data = groups ? SearchXml.group(value, valueMatcher) + "\t" + SearchXml.group(path, pathMatcher) : value + "\t" + path;
                if (!unique) {
                    PathHeader pathHeader;
                    String pathHeaderInfo = "";
                    if (PATH_HEADER_FACTORY != null && (pathHeader = PATH_HEADER_FACTORY.fromPath(path)) != null) {
                        pathHeaderInfo = "\n\t" + pathHeader + "\n\t" + pathHeader.getUrl(PathHeader.BaseUrl.PRODUCTION, coreName);
                    }
                    if (!groups && pathHeaderInfo.isEmpty()) {
                        SearchXml.show(ConfigOption.add, filePath, file, null, null, path, Collections.singleton(value), null);
                        continue;
                    }
                    System.out.println("#?" + (recursive ? filePath + "\t" : "") + file + "\t" + data + pathHeaderInfo);
                    continue;
                }
                uniqueData.add(data, 1L);
            }
        }
        if (other != null) {
            ULocale locale = new ULocale(fileName.substring(0, fileName.length() - 4));
            String localeName = locale.getDisplayName(ULocale.ENGLISH);
            String title = localeName + "\t" + fileName + "\t" + SearchXml.getType(locale);
            diffInfo.showValues(title);
        }
    }

    public static void show(ConfigOption configOption, String fileParent, String localeOrFile, String match_path, String match_value, String new_path, Set<String> new_values, Set<String> otherValues) {
        String fileWithoutSuffix;
        int extensionPos = localeOrFile.lastIndexOf(46);
        String string = fileWithoutSuffix = extensionPos >= 0 ? localeOrFile.substring(0, extensionPos) : localeOrFile;
        String values2 = new_values == null ? null : (new_values.size() != 1 ? new_values.toString() : new_values.iterator().next());
        System.out.println(fileParent + ";\tlocale=" + fileWithoutSuffix + ";\taction=" + (Object)((Object)configOption) + (match_value == null ? "" : ";\tvalue=" + SearchXml.escape(match_value)) + (match_path == null ? "" : ";\tpath=" + match_path) + (values2 == null ? "" : ";\tnew_value=" + SearchXml.escape(values2)) + (new_path == null ? "" : ";\tnew_path=" + new_path) + (otherValues == null ? "" : ";\tother_value=" + otherValues));
    }

    private static String escape(String source) {
        return showInvisibles.transform(source);
    }

    private static String getType(ULocale locale) {
        if (defaultContent.contains(locale.toString())) {
            return "DC";
        }
        if (locale.getCountry().isEmpty()) {
            return "Base";
        }
        return "Region";
    }

    private static String group(String item, Matcher matcher) {
        if (matcher == null) {
            return item;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            b.append(matcher.group(i));
        }
        return b.toString();
    }

    static {
        showValues = true;
        total = 0;
        countOnly = false;
        verbose = false;
        pathExclude = false;
        levelExclude = false;
        valueExclude = false;
        fileExclude = false;
        unique = false;
        groups = false;
        uniqueData = new Counter();
        ERRORS = new LinkedHashSet<String>();
        pathStarrer = new PathStarrer();
        PATH_HEADER_FACTORY = null;
        myOptions = new Option.Options().add("source", (Object)".*", CLDRPaths.MAIN_DIRECTORY, "source directory (use also " + CLDRPaths.AUX_DIRECTORY + ")").add("file", (Object)".*", null, "regex to filter files. ! in front selects items that don't match.").add("path", (Object)".*", null, "regex to filter paths. ! in front selects items that don't match. example: -p relative.*@type=\\\"-?3\\\"").add("value", (Object)".*", null, "regex to filter values. ! in front selects items that don't match").add("level", (Object)".*", null, "regex to filter levels. ! in front selects items that don't match").add("count", null, null, "only count items").add("kount", null, null, "count regex group matches in pattern").add("other", (Object)".+", null, "compare against other directory").add("unique", null, null, "only unique lines").add("groups", null, null, "only retain capturing groups in path/value, eg in -p @modifiers=\\\"([^\\\"]*+)\\\", output the part in (...)").add("Verbose", null, null, "verbose output").add("recursive", null, null, "recurse directories").add("Star", null, null, "get statistics on starred paths").add("PathHeader", null, null, "show path header and string ID");
        DIFF_INFO = new DiffInfo();
        showInvisibles = Transliterator.getInstance("[[:whitespace:][:cf:]-[\\u0020]]hex/perl");
        defaultContent = SupplementalDataInfo.getInstance().getDefaultContentLocales();
    }

    static class DiffInfo {
        static final String DiffInfoHeader = "\tSame\tDeletions\tAdditions\tChanges";
        int additionCount = 0;
        int deletionCount = 0;
        int changed2Values = 0;
        int sameCount = 0;

        DiffInfo() {
        }

        public void showValues(String title) {
            System.out.println("#" + title + "\t" + this.sameCount + "\t" + this.deletionCount + "\t" + this.additionCount + "\t" + this.changed2Values / 2);
            SearchXml.DIFF_INFO.additionCount += this.additionCount;
            SearchXml.DIFF_INFO.deletionCount += this.deletionCount;
            SearchXml.DIFF_INFO.changed2Values += this.changed2Values;
            SearchXml.DIFF_INFO.sameCount += this.sameCount;
        }
    }

    static class ListHandler
    extends XMLFileReader.SimpleHandler {
        public Relation<String, String> data = Relation.of(new LinkedHashMap(), LinkedHashSet.class);

        ListHandler() {
        }

        @Override
        public void handlePathValue(String path, String value) {
            this.data.put(path, value);
        }
    }

    static enum ConfigOption {
        delete,
        add,
        addNew,
        replace;

    }
}

