/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.tool.ToolUtilities;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.ExtractCollationRules;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.StringId;
import org.unicode.cldr.util.TransliteratorUtilities;

public class ShowData {
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int MATCH = 4;
    private static final int GET_SCRIPTS = 5;
    private static final int LAST_DIR = 6;
    private static final int COVERAGE = 7;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault(CLDRPaths.MAIN_DIRECTORY), UOption.DESTDIR().setDefault(CLDRPaths.CHART_DIRECTORY + "summary/"), UOption.create("match", 'm', 1).setDefault(".*"), UOption.create("getscript", 'g', 0), UOption.create("last", 'l', 1).setDefault(CLDRPaths.LAST_RELEASE_DIRECTORY + "common/main/"), UOption.create("coverage", 'c', 1).setDefault(Level.MODERN.toString())};
    static RuleBasedCollator uca = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);
    static PathHeader.Factory prettyPathMaker = PathHeader.getFactory(CLDRConfig.getInstance().getEnglish());
    static CLDRFile english;
    static Set<String> locales;
    static Relation<String, String> parentToChildren;
    static Factory cldrFactory;
    static Set<String> UnicodeScripts;
    static DataShower dataShower;
    static final LikelySubtags LIKELY;

    public ShowData() {
        uca.setNumericCollation(true);
    }

    public static String dateFooter() {
        return "<p>Generation: " + CldrUtility.isoFormatDateOnly(new Date()) + "</p>" + System.lineSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        double deltaTime = System.currentTimeMillis();
        try {
            CLDRConfig testInfo = ToolConfig.getToolInstance();
            UOption.parseArgs(args, options);
            String sourceDir = ShowData.options[2].value;
            String targetDir = ShowData.options[3].value;
            cldrFactory = CLDRConfig.getInstance().getMainAndAnnotationsFactory();
            english = cldrFactory.make("en", true);
            String lastSourceDir = ShowData.options[6].value;
            Level requiredCoverage = Level.fromString(options[7].toString());
            if (ShowData.options[5].doesOccur) {
                ShowData.getScripts();
                return;
            }
            FileCopier.ensureDirectoryExists(ShowData.options[3].value);
            FileCopier.copy(ShowData.class, "summary-index.css", ShowData.options[3].value, "index.css");
            FileCopier.copy(ShowData.class, "summary-index.html", ShowData.options[3].value, "index.html");
            FormattedFileWriter.copyIncludeHtmls(ShowData.options[3].value);
            ToolUtilities.registerExtraTransliterators();
            locales = new TreeSet<String>(cldrFactory.getAvailable());
            new CldrUtility.MatcherFilter(ShowData.options[4].value).retainAll(locales);
            TreeSet<PathHeader> prettySet = new TreeSet<PathHeader>();
            CLDRFile.Status status = new CLDRFile.Status();
            LocaleIDParser localeIDParser = new LocaleIDParser();
            TreeMap<PathHeader, Relation<String, String>> pathHeaderToValuesToLocale = new TreeMap<PathHeader, Relation<String, String>>();
            Set<String> defaultContents = testInfo.getSupplementalDataInfo().getDefaultContentLocales();
            LanguageTagParser ltp = new LanguageTagParser();
            LikelySubtags ls = new LikelySubtags();
            for (String string : locales) {
                String baseLanguage;
                if (defaultContents.contains(string) || string.startsWith("supplem") || string.startsWith("character") || string.equals("root")) continue;
                String max = ls.maximize(string);
                if (max == null) {
                    max = string;
                }
                if ((baseLanguage = ls.minimize(ltp.set(max).getLanguageScript())).equals(string)) {
                    parentToChildren.put("root", string);
                    parentToChildren.put(string, string);
                    continue;
                }
                parentToChildren.put(baseLanguage, string);
            }
            for (Map.Entry entry : parentToChildren.keyValuesSet()) {
                String locale = (String)entry.getKey();
                Set children = (Set)entry.getValue();
                TreeMap<String, CLDRFile> sublocales = new TreeMap<String, CLDRFile>();
                boolean doResolved = localeIDParser.set(locale).getRegion().length() == 0;
                String languageSubtag = localeIDParser.getLanguage();
                CLDRFile file = cldrFactory.make(locale, true);
                if (file.isNonInheriting()) continue;
                HashSet allPaths = new HashSet();
                file.forEach(allPaths::add);
                if (!locale.equals("root")) {
                    for (String childLocale : children) {
                        CLDRFile childCldrFile = cldrFactory.make(childLocale, false);
                        if (childCldrFile != null) {
                            childCldrFile.forEach(allPaths::add);
                        }
                        sublocales.put(childLocale, childCldrFile);
                    }
                }
                boolean showEnglish = !languageSubtag.equals("en");
                CoverageLevel2 coverageLevel = CoverageLevel2.getInstance(testInfo.getSupplementalDataInfo(), locale);
                int skippedCount = 0;
                int aliasedCount = 0;
                int inheritedCount = 0;
                prettySet.clear();
                for (String path : allPaths) {
                    if (path.indexOf("/alias") >= 0) {
                        ++skippedCount;
                        continue;
                    }
                    if (path.indexOf("/usesMetazone") >= 0) {
                        ++skippedCount;
                        continue;
                    }
                    if (path.indexOf("/references") >= 0) {
                        ++skippedCount;
                        continue;
                    }
                    if (path.indexOf("[@alt=\"proposed") >= 0) {
                        ++skippedCount;
                        continue;
                    }
                    if (path.indexOf("/identity") >= 0) {
                        ++skippedCount;
                        continue;
                    }
                    PathHeader prettyString = prettyPathMaker.fromPath(path);
                    if (prettyString.getSectionId() == PathHeader.SectionId.Special) continue;
                    prettySet.add(prettyString);
                }
                PrintWriter pw = FileUtilities.openUTF8Writer(targetDir, locale + ".html");
                String[] headerAndFooter = new String[2];
                ShowData.getChartTemplate("Locale Data Summary for " + ShowData.getLocaleNameAndCode(locale), ToolConstants.CHART_DISPLAY_VERSION, "<script>" + System.lineSeparator() + "if (location.href.split('?')[1].split(',')[0]=='hide') {" + System.lineSeparator() + "document.write('<style>');" + System.lineSeparator() + "document.write('.xx {display:none}');" + System.lineSeparator() + "document.write('</style>');" + System.lineSeparator() + "}" + System.lineSeparator() + "</script>", headerAndFooter, locale.equals("root") ? "Main Charts Index" : null, false);
                pw.println(headerAndFooter[0]);
                ShowData.showLinks(pw, locale);
                ShowData.showChildren(pw, locale);
                pw.println("<p><b>Aliased/Inherited: </b><a href='" + locale + ".html?hide'>Hide</a> <a href='" + locale + ".html'>Show </a></p>");
                pw.println("<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\">");
                pw.println("<tr><th>No</th><th width='10%'>Section</th><th width='10%'>Page</th><th width='10%'>Header</th><th width='10%'>Code</th>" + (showEnglish ? "<th>English</th>" : "") + "<th>Native</th><th>Sublocales\u2026</th></tr>");
                int count = 0;
                PathHeader oldParts = null;
                Relation<String, String> childValueToLocales = Relation.of(new TreeMap(), TreeSet.class);
                for (PathHeader prettyPath : prettySet) {
                    boolean hide;
                    boolean isInherited;
                    boolean isAliased;
                    String path = prettyPath.getOriginalPath();
                    boolean zeroOutEnglish = path.indexOf("/references") < 0;
                    String source = file.getSourceLocaleID(path, status);
                    boolean bl = isAliased = !status.pathWhereFound.equals(path);
                    if (isAliased) {
                        ++aliasedCount;
                        continue;
                    }
                    String value = file.getStringValue(path);
                    boolean bl2 = isInherited = !source.equals(locale);
                    if (isInherited) {
                        ++inheritedCount;
                    }
                    String lastValue = null;
                    boolean lastEquals = false;
                    childValueToLocales.clear();
                    for (Map.Entry s2 : sublocales.entrySet()) {
                        String newChildValue = ((CLDRFile)s2.getValue()).getStringValue(path);
                        if (newChildValue == null || CldrUtility.equals(newChildValue, value) || CldrUtility.INHERITANCE_MARKER.equals(newChildValue)) continue;
                        childValueToLocales.put(newChildValue, (String)s2.getKey());
                    }
                    String englishValue = null;
                    if (zeroOutEnglish) {
                        englishValue = "";
                    }
                    if (!showEnglish || null != (englishValue = english.getStringValue(path))) {
                        // empty if block
                    }
                    String statusClass = isAliased ? (isInherited ? " class='ah'" : " class='a'") : (isInherited ? " class='h'" : "");
                    boolean bl3 = hide = isAliased || isInherited;
                    if (!hide) {
                        Relation<String, String> valuesToLocales = (Relation<String, String>)pathHeaderToValuesToLocale.get(prettyPath);
                        if (valuesToLocales == null) {
                            valuesToLocales = Relation.of(new TreeMap(), TreeSet.class);
                            pathHeaderToValuesToLocale.put(prettyPath, valuesToLocales);
                        }
                        valuesToLocales.put(lastValue + "\u2192\u2192" + value, locale);
                    }
                    pw.println((hide ? "<tr class='xx'><td" : "<tr><td") + statusClass + ">" + CldrUtility.getDoubleLinkedText(Long.toHexString(StringId.getId(path)), String.valueOf(++count)) + ShowData.addPart(oldParts == null ? null : oldParts.getSection(), prettyPath.getSection()) + ShowData.addPart(oldParts == null ? null : oldParts.getPage(), prettyPath.getPage()) + ShowData.addPart(oldParts == null ? null : oldParts.getHeader(), prettyPath.getHeader()) + ShowData.addPart(oldParts == null ? null : oldParts.getCode(), prettyPath.getCode()) + ShowData.showValue(showEnglish, englishValue, value, false) + "</td>");
                    boolean isExemplar = path.contains("/exemplar");
                    ShowData.showValue(pw, value, null, isExemplar);
                    if (!childValueToLocales.keyValuesSet().isEmpty()) {
                        for (Map.Entry x : childValueToLocales.keyValuesSet()) {
                            ShowData.showValue(pw, (String)x.getKey(), x.getValue(), isExemplar);
                        }
                        pw.println("<td class='info'><a class='rightLink' target='CLDR-ST-DOCS' href='http://cldr.org/index/charts#TOC-Summary'>\u24d8</a></td>");
                    }
                    pw.println("</tr>");
                    oldParts = prettyPath;
                }
                pw.println("</table><br><table>");
                pw.println("<tr><td class='a'>Aliased items: </td><td>" + aliasedCount + "</td></tr>");
                pw.println("<tr><td class='h'>Inherited items:</td><td>" + inheritedCount + "</td></tr>");
                if (skippedCount != 0) {
                    pw.println("<tr><td>Omitted items:</td><td>" + skippedCount + "</td></tr>");
                }
                pw.println("</table>");
                pw.println(headerAndFooter[1]);
                pw.close();
            }
            PrintWriter pw = FileUtilities.openUTF8Writer(targetDir, "all-changed.html");
            String[] stringArray = new String[2];
            ShowData.getChartTemplate("Locale Data Summary for ALL-CHANGED", ToolConstants.CHART_DISPLAY_VERSION, "", stringArray, null, false);
            pw.println(stringArray[0]);
            pw.println("<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\">");
            pw.println("<tr><th>Section</th><th>Page</th><th>Header</th><th>Code</th><th>Old</th><th>Changed</th><th>Locales</th></tr>");
            for (Map.Entry entry : pathHeaderToValuesToLocale.entrySet()) {
                PathHeader ph = (PathHeader)entry.getKey();
                Set keyValuesSet = ((Relation)entry.getValue()).keyValuesSet();
                String rowspan = keyValuesSet.size() == 1 ? ">" : " rowSpan='" + keyValuesSet.size() + "'>";
                pw.append("<tr><td class='g'").append(rowspan).append(ph.getSectionId().toString()).append("</td><td class='g'").append(rowspan).append(ph.getPageId().toString()).append("</td><td class='g'").append(rowspan).append(ph.getHeader() == null ? "<i>n/a</i>" : ph.getHeader()).append("</td><td class='g'").append(rowspan).append(ph.getCode()).append("</td>");
                boolean addRow = false;
                for (Map.Entry s3 : keyValuesSet) {
                    String value = (String)s3.getKey();
                    int breakPoint = value.indexOf("\u2192\u2192");
                    if (addRow) {
                        pw.append("<tr>");
                    }
                    pw.append("<td>").append(DataShower.getPrettyValue(value.substring(0, breakPoint))).append("</td><td class='v'>").append(DataShower.getPrettyValue(value.substring(breakPoint + 2))).append("</td><td>").append(Joiner.on(", ").join(s3.getValue())).append("</td></tr>").append(System.lineSeparator());
                    addRow = true;
                }
            }
            pw.println(stringArray[1]);
            pw.close();
        }
        finally {
            deltaTime = (double)System.currentTimeMillis() - deltaTime;
            System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
            System.out.println("Done");
        }
    }

    public static void showValue(PrintWriter pw, String value, Set<String> locales, boolean isExemplar) {
        boolean noLocales = locales == null || locales.isEmpty();
        pw.println("<td" + (isExemplar ? " style='max-width:20%'" : "") + (noLocales ? "" : " title='" + Joiner.on(", ").join(locales) + "'") + (value == null ? "></i>n/a</i>" : " class='v'" + DataShower.getBidiStyle(value) + ">" + DataShower.getPrettyValue(value)) + "</td>");
    }

    private static String addPart(String oldPart, String newPart) {
        String prefix = newPart.equals(oldPart) ? "</td><td class='n'>" : (newPart.length() == 0 ? "</td><td>" : "</td><td class='g'>");
        return prefix + TransliteratorUtilities.toHTML.transform(newPart);
    }

    private static void getScripts() throws IOException {
        Set<String> locales = cldrFactory.getAvailableLanguages();
        TreeSet<String> scripts = new TreeSet<String>();
        TreeMap script_name_locales = new TreeMap();
        PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "scriptNames.txt");
        for (String locale : locales) {
            System.out.println(locale);
            CLDRFile file = cldrFactory.make(locale, false);
            if (file.isNonInheriting()) continue;
            String localeName = file.getName(locale);
            ShowData.getScripts(localeName, scripts);
            if (!scripts.contains("Latn")) {
                out.println(locale + "\t" + english.getName(locale) + "\t" + localeName);
            }
            for (String script : UnicodeScripts) {
                TreeSet<String> localeSet;
                String name;
                if (script.equals("Latn") || !ShowData.getScripts(name = file.getName(1, script), scripts).contains(script)) continue;
                TreeMap<String, TreeSet<String>> names_locales = (TreeMap<String, TreeSet<String>>)script_name_locales.get(script);
                if (names_locales == null) {
                    names_locales = new TreeMap<String, TreeSet<String>>();
                    script_name_locales.put(script, names_locales);
                }
                if ((localeSet = (TreeSet<String>)names_locales.get(name)) == null) {
                    localeSet = new TreeSet<String>();
                    names_locales.put(name, localeSet);
                }
                localeSet.add(ShowData.getLocaleNameAndCode(locale));
            }
        }
        for (String script : UnicodeScripts) {
            Object names = script_name_locales.get(script);
            out.println(script + "\t(" + english.getName(1, script) + ")\t" + names);
        }
        out.close();
    }

    private static Set<String> getScripts(String exemplars, Set<String> results) {
        results.clear();
        if (exemplars == null) {
            return results;
        }
        UnicodeSetIterator it = new UnicodeSetIterator(new UnicodeSet().addAll(exemplars));
        while (it.next()) {
            int cp = it.codepoint;
            int script = UScript.getScript(cp);
            results.add(UScript.getShortName(script));
        }
        return results;
    }

    private static void showCollation(Factory collationFactory, String locale, ExtractCollationRules collationRules) {
        CLDRFile collationFile;
        try {
            collationFile = collationFactory.make(locale, false);
        }
        catch (RuntimeException e) {
            return;
        }
        collationRules.set(collationFile);
        Iterator<String> it = collationRules.iterator();
        while (it.hasNext()) {
            String key = it.next();
            System.out.println(key + ": ");
            String rules = collationRules.getRules(key);
            System.out.println(rules);
        }
    }

    private static String showValue(boolean showEnglish, String comparisonValue, String mainValue, boolean lastEquals) {
        return !showEnglish ? "" : (comparisonValue == null ? (lastEquals ? "</td><td>=" : "</td><td><i>n/a</i>") : (comparisonValue.length() == 0 ? "</td><td>&nbsp;" : (comparisonValue.equals(mainValue) ? "</td><td>=" : "</td><td class='e'" + DataShower.getBidiStyle(comparisonValue) + ">" + DataShower.getPrettyValue(comparisonValue))));
    }

    private static String getNda(Set<String> skipList, Map<String, String> nonDistinguishingAttributes, CLDRFile file, String path, String parentFullPath, StringBuffer draftRef) {
        draftRef.setLength(0);
        if (parentFullPath != null && !parentFullPath.equals(path)) {
            file.getNonDistinguishingAttributes(parentFullPath, nonDistinguishingAttributes, skipList);
            if (nonDistinguishingAttributes.size() != 0) {
                String parentNda = "";
                for (String key : nonDistinguishingAttributes.keySet()) {
                    String value = nonDistinguishingAttributes.get(key);
                    if (key.equals("draft") && !value.equals("contributed")) {
                        if (draftRef.length() != 0) {
                            draftRef.append(",");
                        }
                        draftRef.append("d");
                        continue;
                    }
                    if (key.equals("alt")) {
                        if (draftRef.length() != 0) {
                            draftRef.append(",");
                        }
                        draftRef.append("a");
                        continue;
                    }
                    if (key.equals("references")) {
                        if (draftRef.length() != 0) {
                            draftRef.append(",");
                        }
                        draftRef.append(nonDistinguishingAttributes.get(key));
                        continue;
                    }
                    if (parentNda.length() != 0) {
                        parentNda = parentNda + ", ";
                    }
                    parentNda = parentNda + key + "=" + nonDistinguishingAttributes.get(key);
                }
                if (parentNda.length() != 0) {
                    parentNda = parentNda.replaceAll("[/]", "/\u200b");
                    parentNda = "[" + parentNda + "]";
                }
                return parentNda;
            }
        }
        return "";
    }

    private static void showLinks(PrintWriter pw, String locale) {
        pw.print("<p>");
        ShowData.showLinks2(pw, locale);
        pw.println("</p>");
    }

    private static void showLinks2(PrintWriter pw, String locale) {
        String parent = LocaleIDParser.getParent(locale);
        if (parent != null) {
            ShowData.showLinks2(pw, parent);
            pw.print(" &gt; ");
        }
        pw.println(ShowData.getLinkedLocaleName(locale));
    }

    private static void showChildren(PrintWriter pw, String locale) {
        LanguageTagParser ltp = new LanguageTagParser();
        TreeMap<String, String> nameToLocale = new TreeMap<String, String>();
        for (String sublocale : parentToChildren.get(locale)) {
            String minimized = LIKELY.minimize(sublocale);
            nameToLocale.put(ShowData.getEnglishLocaleName(sublocale), minimized == null ? sublocale : minimized);
        }
        boolean isRoot = locale.equals("root");
        char lastFirstChar = '\u0000';
        boolean first = true;
        for (Map.Entry nameAndCode : nameToLocale.entrySet()) {
            String name = (String)nameAndCode.getKey();
            String localeCode = (String)nameAndCode.getValue();
            if (localeCode.equals(locale)) continue;
            char firstChar = name.charAt(0);
            if (first) {
                pw.print(System.lineSeparator() + "<p style='margin-left:5em'>&gt; ");
                lastFirstChar = firstChar;
                first = false;
            } else if (firstChar != lastFirstChar) {
                pw.print("</p>" + System.lineSeparator() + "<p style='margin-left:5em'> ");
                lastFirstChar = firstChar;
            } else {
                pw.print(", ");
            }
            if (isRoot) {
                pw.print(ShowData.getLinkedLocaleName(localeCode));
                continue;
            }
            pw.print(ShowData.getLocaleMinusBaseAndCode(localeCode));
        }
        if (first) {
            pw.println("</p>");
        }
    }

    public static String getLinkedLocaleName(String locale) {
        return "<a href='" + locale + ".html'>" + ShowData.getEnglishLocaleName(locale) + "</a> [" + locale + "]";
    }

    public static String getEnglishLocaleName(String locale) {
        return english.getName(locale, true, CLDRFile.SHORT_ALTS);
    }

    private static String getLocaleNameAndCode(String locale) {
        return ShowData.getEnglishLocaleName(locale) + " [" + locale + "]";
    }

    private static String getLocaleMinusBaseAndCode(String locale) {
        String full = ShowData.getEnglishLocaleName(locale);
        int leftParen = full.indexOf(40);
        if (leftParen >= 0) {
            full = full.substring(leftParen + 1, full.lastIndexOf(41));
        }
        return full + " [" + locale + "]";
    }

    public static void getChartTemplate(String title, String version, String header, String[] headerAndFooter, String indexTitle, boolean showDate) throws IOException {
        String line;
        if (version == null) {
            version = ToolConstants.CHART_DISPLAY_VERSION;
        }
        CldrUtility.VariableReplacer langTag = new CldrUtility.VariableReplacer().add("%title%", title).add("%header%", header).add("%index-title%", "Index").add("%index%", "index.html").add("%header%", header).add("%version%", version).add("%date%", showDate ? CldrUtility.isoFormatDateOnly(new Date()) : "");
        if (indexTitle != null) {
            langTag.add("%index-title%", indexTitle).add("%index%", "../index.html");
        }
        BufferedReader input = ToolUtilities.getUTF8Data("chart-template.html");
        StringBuffer result = new StringBuffer();
        while ((line = input.readLine()) != null) {
            String langTagPattern = langTag.replace(line);
            if (line.indexOf("%body%") >= 0) {
                headerAndFooter[0] = result.toString();
                result.setLength(0);
                continue;
            }
            result.append(langTagPattern).append(System.lineSeparator());
        }
        headerAndFooter[1] = result.toString();
    }

    static {
        parentToChildren = Relation.of(new TreeMap(), TreeSet.class);
        UnicodeScripts = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("Arab", "Armn", "Bali", "Beng", "Bopo", "Brai", "Bugi", "Buhd", "Cans", "Cher", "Copt", "Cprt", "Cyrl", "Deva", "Dsrt", "Ethi", "Geor", "Glag", "Goth", "Grek", "Gujr", "Guru", "Hang", "Hani", "Hano", "Hebr", "Hira", "Hrkt", "Ital", "Kana", "Khar", "Khmr", "Knda", "Laoo", "Latn", "Limb", "Linb", "Mlym", "Mong", "Mymr", "Nkoo", "Ogam", "Orya", "Osma", "Phag", "Phnx", "Qaai", "Runr", "Shaw", "Sinh", "Sylo", "Syrc", "Tagb", "Tale", "Talu", "Taml", "Telu", "Tfng", "Tglg", "Thaa", "Thai", "Tibt", "Ugar", "Xpeo", "Xsux", "Yiii")));
        dataShower = new DataShower();
        LIKELY = new LikelySubtags();
    }

    public static class DataShower {
        static Transliterator toLatin = Transliterator.getInstance("any-latin");
        static UnicodeSet BIDI_R = new UnicodeSet("[[:Bidi_Class=R:][:Bidi_Class=AL:]]");

        static String getBidiStyle(String cellValue) {
            return BIDI_R.containsSome(cellValue) ? " style='direction:rtl'" : "";
        }

        public static String getPrettyValue(String textToInsert) {
            String outValue = TransliteratorUtilities.toHTML.transliterate(textToInsert);
            String transValue = textToInsert;
            try {
                transValue = toLatin.transliterate(textToInsert);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!transValue.equals(textToInsert)) {
                outValue = "<span title='" + TransliteratorUtilities.toXML.transliterate(transValue) + "'>" + outValue + "</span>";
            }
            return outValue;
        }
    }
}

