/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.GeneratePluralRanges;
import org.unicode.cldr.tool.PluralMinimalPairs;
import org.unicode.cldr.tool.PluralRulesFactory;
import org.unicode.cldr.tool.ShowLanguages;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagCanonicalizer;
import org.unicode.cldr.util.PluralSnapshot;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ShowPlurals {
    private static final String NO_PLURAL_DIFFERENCES = "<i>no plural differences</i>";
    private static final String NOT_AVAILABLE = "<i>Not available.<br>Please <a target='_blank' href='https://cldr.unicode.org/index/bug-reports#TOC-Filing-a-Ticket'>file a ticket</a> to supply.</i>";
    final SupplementalDataInfo supplementalDataInfo;

    public ShowPlurals() {
        this.supplementalDataInfo = CLDRConfig.getInstance().getSupplementalDataInfo();
    }

    public ShowPlurals(SupplementalDataInfo supplementalDataInfo) {
        this.supplementalDataInfo = supplementalDataInfo;
    }

    public void printPlurals(CLDRFile english, String localeFilter, PrintWriter index, Factory factory) throws IOException {
        String section1 = "Rules";
        String section2 = "Comparison";
        String title = "Language Plural Rules";
        PrintWriter pw = new PrintWriter(new FormattedFileWriter(null, "Language Plural Rules", null, ShowLanguages.SUPPLEMENTAL_INDEX_ANCHORS));
        pw.append("<div style='margin-right:2em; margin-left:2em'>\n");
        ShowLanguages.showContents(pw, "rules", "Rules", "comparison", "Comparison");
        pw.append("<h2>" + CldrUtility.getDoubleLinkedText("rules", "1. " + section1) + "</h2>" + System.lineSeparator());
        pw.append("<div style='margin-right:2em; margin-left:2em'>\n");
        this.printPluralTable(english, localeFilter, pw, factory);
        pw.append("</div>\n");
        pw.append("<h2>" + CldrUtility.getDoubleLinkedText("comparison", "2. " + section2) + "</h2>" + System.lineSeparator());
        pw.append("<p style='text-align:left'>The plural forms are abbreviated by first letter, with 'x' for 'other'. If values are made redundant by explicit 0 and 1, they are underlined. The fractional and integral results are separated for clarity.</p>" + System.lineSeparator());
        pw.append("<div style='margin-right:2em; margin-left:2em'>\n");
        PluralSnapshot.writeTables(english, pw);
        pw.append("</div>\n");
        pw.append("</div>\n");
        ShowPlurals.appendBlanksForScrolling(pw);
        pw.close();
    }

    public static void appendBlanksForScrolling(Appendable pw) {
        try {
            pw.append(Utility.repeat("<br>", 100)).append(System.lineSeparator());
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printPluralTable(CLDRFile english, String localeFilter, Appendable appendable, Factory factory) throws IOException {
        TablePrinter tablePrinter = new TablePrinter().setTableAttributes("class='dtf-table'").addColumn("Name", "class='source'", null, "class='source'", true).setSortPriority(0).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").setBreakSpans(true).setRepeatHeader(true).addColumn("Code", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").addColumn("Type", "class='source'", null, "class='source'", true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").setBreakSpans(true).addColumn("Category", "class='target'", null, "class='target'", true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").setSpanRows(false).addColumn("Examples", "class='target'", null, "class='target'", true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").addColumn("Minimal Pairs", "class='target'", null, "class='target'", true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").addColumn("Rules", "class='target'", null, "class='target' nowrap", true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").setSpanRows(false);
        PluralRulesFactory prf = PluralRulesFactory.getInstance(this.supplementalDataInfo);
        Set<String> cardinalLocales = this.supplementalDataInfo.getPluralLocales(SupplementalDataInfo.PluralType.cardinal);
        Set<String> ordinalLocales = this.supplementalDataInfo.getPluralLocales(SupplementalDataInfo.PluralType.ordinal);
        LinkedHashSet<String> all = new LinkedHashSet<String>(cardinalLocales);
        all.addAll(ordinalLocales);
        LanguageTagCanonicalizer canonicalizer = new LanguageTagCanonicalizer();
        for (String locale : this.supplementalDataInfo.getPluralLocales()) {
            void var15_20;
            if (localeFilter != null && !localeFilter.equals(locale) || locale.equals("root")) continue;
            String name = english.getName(locale);
            String canonicalLocale = canonicalizer.transform(locale);
            if (!locale.equals(canonicalLocale)) {
                String string = "<i>=<a href='#" + canonicalLocale + "'>" + canonicalLocale + "</a></i>";
                tablePrinter.addRow().addCell((Comparable)((Object)name)).addCell((Comparable)((Object)locale)).addCell((Comparable)((Object)string)).addCell((Comparable)((Object)string)).addCell((Comparable)((Object)string)).addCell((Comparable)((Object)string)).addCell((Comparable)((Object)string)).finishRow();
                continue;
            }
            for (SupplementalDataInfo.PluralType pluralType : SupplementalDataInfo.PluralType.values()) {
                if (pluralType == SupplementalDataInfo.PluralType.ordinal && !ordinalLocales.contains(locale) || pluralType == SupplementalDataInfo.PluralType.cardinal && !cardinalLocales.contains(locale)) continue;
                SupplementalDataInfo.PluralInfo plurals = this.supplementalDataInfo.getPlurals(pluralType, locale);
                ULocale locale2 = new ULocale(locale);
                PluralMinimalPairs samplePatterns = PluralMinimalPairs.getInstance(locale2.toString());
                NumberFormat nf = NumberFormat.getInstance(locale2);
                String rules = plurals.getRules();
                rules = rules + (rules.length() == 0 ? "other:<i>everything</i>" : ";other:<i>everything else</i>");
                rules = rules.replace(":", " \u2192 ").replace(";", ";<br>");
                PluralRules pluralRules = plurals.getPluralRules();
                Set<SupplementalDataInfo.PluralInfo.Count> counts = plurals.getCounts();
                for (SupplementalDataInfo.PluralInfo.Count count : counts) {
                    String samplePattern;
                    String sample;
                    String rule;
                    String keyword = count.toString();
                    PluralRules.FixedDecimalSamples exampleList = pluralRules.getDecimalSamples(keyword, PluralRules.SampleType.INTEGER);
                    PluralRules.FixedDecimalSamples exampleList2 = pluralRules.getDecimalSamples(keyword, PluralRules.SampleType.DECIMAL);
                    if (exampleList == null) {
                        exampleList = exampleList2;
                        exampleList2 = null;
                    }
                    String examples = this.getExamples(exampleList);
                    if (exampleList2 != null) {
                        examples = examples + "<br>" + this.getExamples(exampleList2);
                    }
                    rule = (rule = pluralRules.getRules(keyword)) != null ? rule.replace(":", " \u2192 ").replace(" and ", " and<br>&nbsp;&nbsp;").replace(" or ", " or<br>") : (counts.size() == 1 ? "<i>everything</i>" : "<i>everything else</i>");
                    String string = sample = counts.size() == 1 ? NO_PLURAL_DIFFERENCES : NOT_AVAILABLE;
                    if (samplePatterns != null && (samplePattern = samplePatterns.get(pluralType.standardType, SupplementalDataInfo.PluralInfo.Count.valueOf(keyword))) != null) {
                        PluralRules.FixedDecimal sampleDecimal = SupplementalDataInfo.PluralInfo.getNonZeroSampleIfPossible(exampleList);
                        sample = this.getSample(sampleDecimal, samplePattern, nf);
                        if (exampleList2 != null) {
                            sampleDecimal = SupplementalDataInfo.PluralInfo.getNonZeroSampleIfPossible(exampleList2);
                            sample = sample + "<br>" + this.getSample(sampleDecimal, samplePattern, nf);
                        }
                    }
                    tablePrinter.addRow().addCell((Comparable)((Object)name)).addCell((Comparable)((Object)locale)).addCell((Comparable)((Object)pluralType.toString())).addCell((Comparable)((Object)count.toString())).addCell((Comparable)((Object)examples.toString())).addCell((Comparable)((Object)sample)).addCell((Comparable)((Object)rule)).finishRow();
                }
            }
            Object var15_18 = null;
            try {
                List<GeneratePluralRanges.RangeSample> list = new GeneratePluralRanges(this.supplementalDataInfo).getRangeInfo(factory.make(locale, true));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (var15_20 != null) {
                for (GeneratePluralRanges.RangeSample item : var15_20) {
                    tablePrinter.addRow().addCell((Comparable)((Object)name)).addCell((Comparable)((Object)locale)).addCell((Comparable)((Object)"range")).addCell((Comparable)((Object)((Object)((Object)item.start) + "+" + (Object)((Object)item.end)))).addCell((Comparable)((Object)(item.min + "\u2013" + item.max))).addCell((Comparable)((Object)item.resultExample.replace(". ", ".<br>"))).addCell((Comparable)((Object)((Object)((Object)item.start) + " + " + (Object)((Object)item.end) + " \u2192 " + (Object)((Object)item.result)))).finishRow();
                }
                continue;
            }
            String message = this.supplementalDataInfo.getPlurals(SupplementalDataInfo.PluralType.cardinal, locale).getCounts().size() == 1 ? NO_PLURAL_DIFFERENCES : NOT_AVAILABLE;
            tablePrinter.addRow().addCell((Comparable)((Object)name)).addCell((Comparable)((Object)locale)).addCell((Comparable)((Object)"range")).addCell((Comparable)((Object)"<i>n/a</i>")).addCell((Comparable)((Object)"<i>n/a</i>")).addCell((Comparable)((Object)message)).addCell((Comparable)((Object)"<i>n/a</i>")).finishRow();
        }
        appendable.append(tablePrinter.toTable()).append(System.lineSeparator());
    }

    private String getExamples(PluralRules.FixedDecimalSamples exampleList) {
        return Joiner.on(", ").join(exampleList.getSamples()) + (exampleList.bounded ? "" : ", \u2026");
    }

    private String getSample(PluralRules.FixedDecimal numb, String samplePattern, NumberFormat nf) {
        nf.setMaximumFractionDigits(numb.getVisibleDecimalDigitCount());
        nf.setMinimumFractionDigits(numb.getVisibleDecimalDigitCount());
        String sample = samplePattern.replace('\u00a0', ' ').replace("{0}", nf.format(numb.getSource())).replace(". ", ".<br>");
        return sample;
    }
}

