/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.ULocale;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DayPeriodsOld {
    private static final int HOUR = 3600000;
    private final ULocale locale;
    private final DayPeriod[] timeMap;
    private final Map<DayPeriod, String> samples;
    private static final Map<ULocale, DayPeriodsOld> DATA = new LinkedHashMap<ULocale, DayPeriodsOld>();

    public DayPeriod get(long millisInDay) {
        long hours = millisInDay / 3600000L;
        int hoursInDay = (int)(hours % 24L);
        if (hoursInDay < 0) {
            hoursInDay += 24;
        }
        return this.timeMap[hoursInDay];
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public String getSample(DayPeriod dayPeriod) {
        return this.samples.get((Object)dayPeriod);
    }

    public Set<DayPeriod> getDayPeriods() {
        return this.samples.keySet();
    }

    public static DayPeriodsOld getInstance(ULocale loc) {
        ULocale base = new ULocale(loc.getLanguage());
        DayPeriodsOld result = DATA.get(base);
        return result;
    }

    public static Set<ULocale> getAvailable() {
        return DATA.keySet();
    }

    private DayPeriodsOld(ULocale base, DayPeriod[] map, EnumMap<DayPeriod, String> samples2) {
        this.locale = base;
        this.fix(map, samples2, DayPeriod.MORNING2, DayPeriod.MORNING1);
        this.fix(map, samples2, DayPeriod.AFTERNOON2, DayPeriod.AFTERNOON1);
        this.fix(map, samples2, DayPeriod.EVENING2, DayPeriod.EVENING1);
        this.fix(map, samples2, DayPeriod.NIGHT2, DayPeriod.NIGHT1);
        this.timeMap = map;
        this.samples = Collections.unmodifiableMap(samples2);
    }

    private void fix(DayPeriod[] map, EnumMap<DayPeriod, String> samples2, DayPeriod dayPeriod2, DayPeriod dayPeriod1) {
        if (samples2.containsKey((Object)dayPeriod2) && !samples2.containsKey((Object)dayPeriod1)) {
            samples2.put(dayPeriod1, samples2.get((Object)dayPeriod2));
            samples2.remove((Object)dayPeriod2);
            for (int i = 0; i < map.length; ++i) {
                if (map[i] != dayPeriod2) continue;
                map[i] = dayPeriod1;
            }
        }
    }

    private static DayPeriodBuilder make(String locale) {
        return new DayPeriodBuilder(locale);
    }

    static {
        DayPeriodsOld.make("en").add("NIGHT1", "night", 0, 1, 2, 3, 4, 5, 21, 22, 23).add("MORNING1", "morning", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "afternoon", 12, 13, 14, 15, 16, 17).add("EVENING1", "evening", 18, 19, 20).build();
        DayPeriodsOld.make("af").add("MORNING", "oggend", 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "middag", 12, 13, 14, 15, 16, 17).add("EVENING", "aand", 18, 19, 20, 21, 22, 23).add("NIGHT", "nag", 0, 1, 2, 3, 4).build();
        DayPeriodsOld.make("nl").add("MORNING", "ochtend", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "middag", 12, 13, 14, 15, 16, 17).add("EVENING", "avond", 18, 19, 20, 21, 22, 23).add("NIGHT", "nacht", 0, 1, 2, 3, 4, 5).build();
        DayPeriodsOld.make("de").add("EARLY_MORNING", "Morgen", 5, 6, 7, 8, 9).add("MORNING", "Vormittag", 10, 11).add("AFTERNOON", "Mittag", 12).add("EVENING", "Nachmittag", 13, 14, 15, 16, 17).add("NIGHT", "Abend", 18, 19, 20, 21, 22, 23).add("LATE_NIGHT", "Nacht", 0, 1, 2, 3, 4).build();
        DayPeriodsOld.make("da").add("EARLY_MORNING", "morgen", 5, 6, 7, 8, 9).add("MORNING", "formiddag", 10, 11).add("AFTERNOON", "eftermiddag", 12, 13, 14, 15, 16, 17).add("EVENING", "aften", 18, 19, 20, 21, 22, 23).add("NIGHT", "nat", 0, 1, 2, 3, 4).build();
        DayPeriodsOld.make("no").add("EARLY_MORNING", "morgen", 6, 7, 8, 9).add("MORNING", "formiddag", 10, 11).add("AFTERNOON", "ettermiddag", 12, 13, 14, 15, 16, 17).add("EVENING", "kveld", 18, 19, 20, 21, 22, 23).add("NIGHT", "natt", 0, 1, 2, 3, 4, 5).build();
        DayPeriodsOld.make("sv").add("EARLY_MORNING", "morgon", 5, 6, 7, 8, 9).add("MORNING", "f\u00f6rmiddag", 10, 11).add("AFTERNOON", "eftermiddag", 12, 13, 14, 15, 16, 17).add("EVENING", "kv\u00e4ll", 18, 19, 20, 21, 22, 23).add("NIGHT", "natt", 0, 1, 2, 3, 4).build();
        DayPeriodsOld.make("is").add("MORNING", "morgunn", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "eftir h\u00e1degi", 12, 13, 14, 15, 16, 17).add("EVENING", "kv\u00f6ld", 18, 19, 20, 21, 22, 23).add("NIGHT", "n\u00f3tt", 0, 1, 2, 3, 4, 5).build();
        DayPeriodsOld.make("pt").add("MORNING", "manh\u00e3", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "tarde", 12, 13, 14, 15, 16, 17, 18).add("EVENING", "noite", 19, 20, 21, 22, 23).add("NIGHT", "madrugada", 0, 1, 2, 3, 4, 5).build();
        DayPeriodsOld.make("gl").add("EARLY_MORNING", "madrugada", 0, 1, 2, 3, 4, 5).add("MORNING", "ma\u00f1\u00e1", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "mediod\u00eda", 12).add("EVENING", "tarde", 13, 14, 15, 16, 17, 18, 19, 20).add("NIGHT", "noite", 21, 22, 23).build();
        DayPeriodsOld.make("es").add("MORNING", "ma\u00f1ana", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "tarde", 12, 13, 14, 15, 16, 17, 18, 19).add("EVENING", "noche", 20, 21, 22, 23).add("NIGHT", "madrugada", 0, 1, 2, 3, 4, 5).build();
        DayPeriodsOld.make("ca").add("EARLY_MORNING", "matinada", 0, 1, 2, 3, 4, 5).add("MORNING", "mat\u00ed", 6, 7, 8, 9, 10, 11).add("EARLY_AFTERNOON", "migdia", 12).add("AFTERNOON", "tarda", 13, 14, 15, 16, 17, 18).add("EVENING", "vespre", 19, 20).add("NIGHT", "nit", 21, 22, 23).build();
        DayPeriodsOld.make("it").add("MORNING", "mattina", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "pomeriggio", 12, 13, 14, 15, 16, 17).add("EVENING", "sera", 18, 19, 20, 21, 22, 23).add("NIGHT", "notte", 0, 1, 2, 3, 4, 5).build();
        DayPeriodsOld.make("ro").add("MORNING", "diminea\u021b\u0103", 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "dup\u0103-amiaz\u0103", 12, 13, 14, 15, 16, 17).add("EVENING", "sear\u0103", 18, 19, 20, 21).add("NIGHT", "noapte", 0, 1, 2, 3, 4, 22, 23).build();
        DayPeriodsOld.make("fr").add("MORNING", "matin", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "apr\u00e8s-midi", 12, 13, 14, 15, 16, 17).add("EVENING", "soir", 18, 19, 20, 21, 22, 23).add("NIGHT", "nuit", 0, 1, 2, 3).build();
        DayPeriodsOld.make("hr").add("MORNING", "jutro", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "popodne", 12, 13, 14, 15, 16, 17).add("EVENING", "ve\u010der", 18, 19, 20).add("NIGHT", "no\u0107", 0, 1, 2, 3, 21, 22, 23).build();
        DayPeriodsOld.make("bs").add("MORNING", "jutro", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "popodne", 12, 13, 14, 15, 16, 17).add("EVENING", "ve\u010de", 18, 19, 20).add("NIGHT", "no\u0107", 0, 1, 2, 3, 21, 22, 23).build();
        DayPeriodsOld.make("sr").add("MORNING", "\u0458\u0443\u0442\u0440\u043e", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u043f\u043e\u043f\u043e\u0434\u043d\u0435", 12, 13, 14, 15, 16, 17).add("EVENING", "\u0432\u0435\u0447\u0435", 18, 19, 20).add("NIGHT", "\u043d\u043e\u045b", 0, 1, 2, 3, 4, 5, 21, 22, 23).build();
        DayPeriodsOld.make("sl").add("EARLY_MORNING", "jutro", 6, 7, 8, 9).add("MORNING", "dopoldne", 10, 11).add("AFTERNOON", "popoldne", 12, 13, 14, 15, 16, 17).add("EVENING", "ve\u010der", 18, 19, 20, 21).add("NIGHT", "no\u010d", 0, 1, 2, 3, 4, 5, 22, 23).build();
        DayPeriodsOld.make("cs").add("EARLY_MORNING", "r\u00e1no", 4, 5, 6, 7, 8).add("MORNING", "dopoledne", 9, 10, 11).add("AFTERNOON", "odpoledne", 12, 13, 14, 15, 16, 17).add("EVENING", "ve\u010der", 18, 19, 20, 21).add("NIGHT", "noc", 0, 1, 2, 3, 22, 23).build();
        DayPeriodsOld.make("sk").add("EARLY_MORNING", "r\u00e1no", 4, 5, 6, 7, 8).add("MORNING", "dopoludnie", 9, 10, 11).add("AFTERNOON", "popoludnie", 12, 13, 14, 15, 16, 17).add("EVENING", "ve\u010der", 18, 19, 20, 21).add("NIGHT", "noc", 0, 1, 2, 3, 22, 23).build();
        DayPeriodsOld.make("pl").add("EARLY_MORNING", "rano", 6, 7, 8, 9).add("MORNING", "przedpo\u0142udnie", 10, 11).add("AFTERNOON", "popo\u0142udnie", 12, 13, 14, 15, 16, 17).add("EVENING", "wiecz\u00f3r", 18, 19, 20).add("NIGHT", "noc", 0, 1, 2, 3, 4, 5, 21, 22, 23).build();
        DayPeriodsOld.make("bg").add("MORNING", "\u0441\u0443\u0442\u0440\u0438\u043d\u0442\u0430", 4, 5, 6, 7, 8, 9, 10).add("EARLY_AFTERNOON", "\u043d\u0430 \u043e\u0431\u044f\u0434", 11, 12, 13).add("AFTERNOON", "\u0441\u043b\u0435\u0434\u043e\u0431\u044f\u0434", 14, 15, 16, 17).add("EVENING", "\u0432\u0435\u0447\u0435\u0440\u0442\u0430", 18, 19, 20, 21).add("NIGHT", "\u043d\u043e\u0449", 0, 1, 2, 3, 22, 23).build();
        DayPeriodsOld.make("mk").add("EARLY_MORNING", "\u043d\u0430\u0443\u0442\u0440\u043e", 4, 5, 6, 7, 8, 9).add("MORNING", "\u043f\u0440\u0435\u0442\u043f\u043b\u0430\u0434\u043d\u0435", 10, 11).add("AFTERNOON", "\u043f\u043e\u043f\u043b\u0430\u0434\u043d\u0435", 12, 13, 14, 15, 16, 17).add("EVENING", "\u043d\u0430\u0432\u0435\u0447\u0435\u0440", 18, 19, 20, 21, 22, 23).add("NIGHT", "\u043f\u043e \u043f\u043e\u043b\u043d\u043e\u045c", 0, 1, 2, 3).build();
        DayPeriodsOld.make("ru").add("MORNING", "\u0443\u0442\u0440\u043e", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0434\u0435\u043d\u044c", 12, 13, 14, 15, 16, 17).add("EVENING", "\u0432\u0435\u0447\u0435\u0440", 18, 19, 20, 21, 22, 23).add("NIGHT", "\u043d\u043e\u0447\u044c", 0, 1, 2, 3).build();
        DayPeriodsOld.make("uk").add("MORNING", "\u0440\u0430\u043d\u043e\u043a", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0434\u0435\u043d\u044c", 12, 13, 14, 15, 16, 17).add("EVENING", "\u0432\u0435\u0447\u0456\u0440", 18, 19, 20, 21, 22, 23).add("NIGHT", "\u043d\u0456\u0447", 0, 1, 2, 3).build();
        DayPeriodsOld.make("lt").add("MORNING", "rytas", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "diena", 12, 13, 14, 15, 16, 17).add("EVENING", "vakaras", 18, 19, 20, 21, 22, 23).add("NIGHT", "naktis", 0, 1, 2, 3, 4, 5).build();
        DayPeriodsOld.make("lv").add("MORNING", "r\u012bts", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "p\u0113cpusdiena", 12, 13, 14, 15, 16, 17).add("EVENING", "vakars", 18, 19, 20, 21, 22).add("NIGHT", "nakts", 0, 1, 2, 3, 4, 5, 23).build();
        DayPeriodsOld.make("el").add("EARLY_MORNING", "\u03bc\u03b5\u03c3\u03ac\u03bd\u03c5\u03c7\u03c4\u03b1", 0).add("MORNING", "\u03c0\u03c1\u03c9\u03af", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u03bc\u03b5\u03c3\u03b7\u03bc\u03ad\u03c1\u03b9", 12, 13, 14, 15, 16).add("EVENING", "\u03b1\u03c0\u03cc\u03b3\u03b5\u03c5\u03bc\u03b1", 17, 18, 19).add("NIGHT", "\u03b2\u03c1\u03ac\u03b4\u03c5", 1, 2, 3, 20, 21, 22, 23).build();
        DayPeriodsOld.make("fa").add("MORNING", "\u0635\u0628\u062d", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0628\u0639\u062f \u0627\u0632 \u0638\u0647\u0631", 12, 13, 14, 15, 16).add("EVENING", "\u0639\u0635\u0631", 17, 18).add("NIGHT", "\u0634\u0628", 0, 1, 2, 3, 19, 20, 21, 22, 23).build();
        DayPeriodsOld.make("hy").add("MORNING", "\u0561\u057c\u0561\u057e\u0578\u057f", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0581\u0565\u0580\u0565\u056f", 12, 13, 14, 15, 16, 17).add("EVENING", "\u0565\u0580\u0565\u056f\u0578", 18, 19, 20, 21, 22, 23).add("NIGHT", "\u0563\u056b\u0577\u0565\u0580", 0, 1, 2, 3, 4, 5).build();
        DayPeriodsOld.make("ka").add("MORNING", "\u10d3\u10d8\u10da\u10d0", 5, 6, 7, 8, 9, 10, 11).add("EARLY_AFTERNOON", "\u10db\u10d4\u10dd\u10e0\u10d4 \u10dc\u10d0\u10ee\u10d4\u10d5\u10d0\u10e0\u10d8", 12, 13, 14, 15, 16).add("AFTERNOON", "\u10db\u10d4\u10d8\u10e0\u10d4 \u10dc\u10d0\u10ee\u10d4\u10d5\u10d0\u10e0\u10d8", 17).add("EVENING", "\u10e1\u10d0\u10e6\u10d0\u10db\u10dd", 18, 19, 20).add("NIGHT", "\u10e6\u10d0\u10db\u10d4", 0, 1, 2, 3, 4, 21, 22, 23).build();
        DayPeriodsOld.make("sq").add("EARLY_MORNING", "m\u00ebngjes", 4, 5, 6, 7, 8).add("MORNING", "paradite", 9, 10, 11).add("AFTERNOON", "pasdite", 12, 13, 14, 15, 16, 17).add("EVENING", "mbr\u00ebmje", 18, 19, 20, 21, 22, 23).add("NIGHT", "nat\u00eb", 0, 1, 2, 3).build();
        DayPeriodsOld.make("ur").add("MORNING", "\u0635\u0628\u062d", 4, 5, 6, 7, 8, 9, 10, 11).add("EARLY_AFTERNOON", "\u062f\u0648\u067e\u06c1\u0631", 12, 13, 14, 15).add("AFTERNOON", "\u0633\u06c1 \u067e\u06c1\u0631", 16, 17).add("EVENING", "\u0634\u0627\u0645", 18, 19).add("NIGHT", "\u0631\u0627\u062a", 0, 1, 2, 3, 20, 21, 22, 23).build();
        DayPeriodsOld.make("hi").add("MORNING", "\u0938\u0941\u092c\u0939", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0926\u094b\u092a\u0939\u0930", 12, 13, 14, 15).add("EVENING", "\u0936\u093e\u092e", 16, 17, 18, 19).add("NIGHT", "\u0930\u093e\u0924", 0, 1, 2, 3, 20, 21, 22, 23).build();
        DayPeriodsOld.make("bn").add("EARLY_MORNING", "\u09ad\u09cb\u09b0", 4, 5).add("MORNING", "\u09b8\u0995\u09be\u09b2", 6, 7, 8, 9, 10, 11).add("EARLY_AFTERNOON", "\u09a6\u09c1\u09aa\u09c1\u09b0", 12, 13, 14, 15).add("AFTERNOON", "\u09ac\u09bf\u0995\u09be\u09b2", 16, 17).add("EVENING", "\u09b8\u09a8\u09cd\u09a7\u09cd\u09af\u09be", 18, 19).add("NIGHT", "\u09b0\u09be\u09a4\u09cd\u09b0\u09bf", 0, 1, 2, 3, 20, 21, 22, 23).build();
        DayPeriodsOld.make("gu").add("MORNING", "\u0ab8\u0ab5\u0abe\u0ab0", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0aac\u0aaa\u0acb\u0ab0", 12, 13, 14, 15).add("EVENING", "\u0ab8\u0abe\u0a82\u0a9c", 16, 17, 18, 19).add("NIGHT", "\u0ab0\u0abe\u0aa4", 0, 1, 2, 3, 20, 21, 22, 23).build();
        DayPeriodsOld.make("mr").add("EARLY_MORNING", "\u092a\u0939\u093e\u091f\u0947", 4, 5).add("MORNING", "\u0938\u0915\u093e\u0933\u0940", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0926\u0941\u092a\u093e\u0930\u0940", 12, 13, 14, 15).add("EVENING", "\u0938\u0902\u0927\u094d\u092f\u093e\u0915\u093e\u0933\u0940", 16, 17, 18, 19).add("NIGHT", "\u0930\u093e\u0924\u094d\u0930\u0940", 0, 1, 2, 20, 21, 22, 23).add("LATE_NIGHT", "\u0930\u093e\u0924\u094d\u0930", 3).build();
        DayPeriodsOld.make("ne").add("MORNING", "\u0935\u093f\u0939\u093e\u0928", 4, 5, 6, 7, 8, 9, 10, 11).add("EARLY_AFTERNOON", "\u0905\u092a\u0930\u093e\u0928\u094d\u0939", 12, 13, 14, 15).add("AFTERNOON", "\u0938\u093e\u0901\u091d", 16, 17, 18).add("EVENING", "\u092c\u0947\u0932\u0941\u0915\u093e", 19, 20, 21).add("NIGHT", "\u0930\u093e\u0924", 0, 1, 2, 3, 22, 23).build();
        DayPeriodsOld.make("pa").add("MORNING", "\u0a38\u0a35\u0a47\u0a30", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0a26\u0a41\u0a2a\u0a39\u0a3f\u0a30", 12, 13, 14, 15).add("EVENING", "\u0a36\u0a3e\u0a2e", 16, 17, 18, 19, 20).add("NIGHT", "\u0a30\u0a3e\u0a24", 0, 1, 2, 3, 21, 22, 23).build();
        DayPeriodsOld.make("si").add("EARLY_MORNING", "\u0db4\u0dcf\u0db1\u0dca\u0daf\u0dbb", 1, 2, 3, 4, 5).add("MORNING", "\u0d8b\u0daf\u0dda", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0daf\u0dc0\u0dbd\u0dca", 12, 13).add("EVENING", "\u0dc4\u0dc0\u0dc3", 14, 15, 16, 17).add("NIGHT", "\u0dbb\u0dd1", 18, 19, 20, 21, 22, 23).add("LATE_NIGHT", "\u0db8\u0dd0\u0daf\u0dd2\u0dba\u0db8\u0da7 \u0db4\u0dc3\u0dd4", 0).build();
        DayPeriodsOld.make("ta").add("EARLY_MORNING", "\u0b85\u0ba4\u0bbf\u0b95\u0bbe\u0bb2\u0bc8", 3, 4).add("MORNING", "\u0b95\u0bbe\u0bb2\u0bc8", 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0baa\u0bbf\u0bb1\u0bcd\u0baa\u0b95\u0bb2\u0bcd", 12, 13, 16, 17).add("EVENING", "\u0bae\u0bbe\u0bb2\u0bc8", 14, 15, 18, 19, 20).add("NIGHT", "\u0b87\u0bb0\u0bb5\u0bc1", 0, 1, 2, 21, 22, 23).build();
        DayPeriodsOld.make("te").add("MORNING", "\u0c09\u0c26\u0c2f\u0c02", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0c2e\u0c27\u0c4d\u0c2f\u0c3e\u0c39\u0c4d\u0c28\u0c02", 12, 13, 14, 15, 16, 17).add("EVENING", "\u0c38\u0c3e\u0c2f\u0c02\u0c24\u0c4d\u0c30\u0c02", 18, 19, 20).add("NIGHT", "\u0c30\u0c3e\u0c24\u0c4d\u0c30\u0c3f", 0, 1, 2, 3, 4, 5, 21, 22, 23).build();
        DayPeriodsOld.make("ml").add("EARLY_MORNING", "\u0d2a\u0d41\u0d32\u0d7c\u0d1a\u0d4d\u0d1a\u0d46", 3, 4, 5).add("MORNING", "\u0d30\u0d3e\u0d35\u0d3f\u0d32\u0d46", 6, 7, 8, 9, 10, 11).add("EARLY_AFTERNOON", "\u0d09\u0d1a\u0d4d\u0d1a\u0d2f\u0d4d\u0d15\u0d4d\u0d15\u0d4d", 12, 13).add("AFTERNOON", "\u0d09\u0d1a\u0d4d\u0d1a\u0d24\u0d3f\u0d30\u0d3f\u0d1e\u0d4d\u0d1e\u0d4d", 14).add("EARLY_EVENING", "\u0d35\u0d48\u0d15\u0d41\u0d28\u0d4d\u0d28\u0d47\u0d30\u0d02", 15, 16, 17).add("EVENING", "\u0d38\u0d28\u0d4d\u0d27\u0d4d\u0d2f\u0d2f\u0d4d\u0d15\u0d4d\u0d15\u0d4d", 18).add("NIGHT", "\u0d30\u0d3e\u0d24\u0d4d\u0d30\u0d3f", 0, 1, 2, 19, 20, 21, 22, 23).build();
        DayPeriodsOld.make("kn").add("MORNING", "\u0cac\u0cc6\u0cb3\u0c97\u0ccd\u0c97\u0cc6", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0cae\u0ca7\u0ccd\u0caf\u0cbe\u0cb9\u0ccd\u0ca8", 12, 13, 14, 15, 16, 17).add("EVENING", "\u0cb8\u0c82\u0c9c\u0cc6", 18, 19, 20).add("NIGHT", "\u0cb0\u0cbe\u0ca4\u0ccd\u0cb0\u0cbf", 0, 1, 2, 3, 4, 5, 21, 22, 23).build();
        DayPeriodsOld.make("zh").add("EARLY_MORNING", "\u65e9\u4e0a", 5, 6, 7).add("MORNING", "\u4e0a\u5348", 8, 9, 10, 11).add("AFTERNOON", "\u4e2d\u5348", 12).add("EVENING", "\u4e0b\u5348", 13, 14, 15, 16, 17, 18).add("NIGHT", "\u665a\u4e0a", 19, 20, 21, 22, 23).add("LATE_NIGHT", "\u51cc\u6668", 0, 1, 2, 3, 4).build();
        DayPeriodsOld.make("ja").add("EARLY_MORNING", "\u671d", 6, 7, 8).add("MORNING", "\u5348\u524d", 9, 10, 11).add("EARLY_AFTERNOON", "\u5348\u5f8c", 12, 13, 14, 15).add("AFTERNOON", "\u5915\u65b9", 16, 17, 18).add("EVENING", "\u591c", 19, 20, 21, 22).add("NIGHT", "\u591c\u4e2d", 0, 1, 2, 3, 23).add("LATE_NIGHT", "\u660e\u3051\u65b9", 4, 5).build();
        DayPeriodsOld.make("ko").add("EARLY_MORNING", "\uc0c8\ubcbd", 3, 4, 5).add("MORNING", "\uc624\uc804", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\uc624\ud6c4", 12, 13, 14, 15, 16, 17).add("EVENING", "\uc800\ub141", 18, 19, 20).add("NIGHT", "\ubc24", 0, 1, 2, 21, 22, 23).build();
        DayPeriodsOld.make("tr").add("EARLY_MORNING", "sabah", 6, 7, 8, 9, 10).add("MORNING", "\u00f6\u011fleden \u00f6nce", 11).add("EARLY_AFTERNOON", "\u00f6\u011fleden sonra", 12, 13, 14, 15, 16, 17).add("AFTERNOON", "ak\u015fam\u00fcst\u00fc", 18).add("EVENING", "ak\u015fam", 19, 20).add("NIGHT", "gece", 0, 1, 2, 3, 4, 5, 21, 22, 23).build();
        DayPeriodsOld.make("az").add("EARLY_MORNING", "s\u00fcbh", 4, 5).add("MORNING", "s\u0259h\u0259r", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "g\u00fcnd\u00fcz", 12, 13, 14, 15, 16).add("EVENING", "ax\u015fam\u00fcst\u00fc", 17, 18).add("NIGHT", "ax\u015fam", 19, 20, 21, 22, 23).add("LATE_NIGHT", "gec\u0259", 0, 1, 2, 3).build();
        DayPeriodsOld.make("kk").add("MORNING", "\u0442\u0430\u04a3", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0442\u04af\u0441", 12, 13, 14, 15, 16, 17).add("EVENING", "\u043a\u0435\u0448", 18, 19, 20).add("NIGHT", "\u0442\u04af\u043d", 0, 1, 2, 3, 4, 5, 21, 22, 23).build();
        DayPeriodsOld.make("ky").add("MORNING", "\u044d\u0440\u0442\u0435\u04a3 \u043c\u0435\u043d\u0435\u043d", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u0442\u04af\u0448\u0442\u04e9\u043d \u043a\u0438\u0439\u0438\u043d", 12, 13, 14, 15, 16, 17).add("EVENING", "\u043a\u0435\u0447\u043a\u0443\u0440\u0443\u043d", 18, 19, 20).add("NIGHT", "\u0442\u04af\u043d", 0, 1, 2, 3, 4, 5, 21, 22, 23).build();
        DayPeriodsOld.make("uz").add("MORNING", "ertalab", 6, 7, 8, 9, 10).add("AFTERNOON", "kunduz", 11, 12, 13, 14, 15, 16, 17).add("EVENING", "kechqurun", 18, 19, 20, 21).add("NIGHT", "tun", 0, 1, 2, 3, 4, 5, 22, 23).build();
        DayPeriodsOld.make("et").add("MORNING", "hommik", 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "p\u00e4rastl\u00f5una", 12, 13, 14, 15, 16, 17).add("EVENING", "\u00f5htu", 18, 19, 20, 21, 22).add("NIGHT", "\u00f6\u00f6", 0, 1, 2, 3, 4, 23).build();
        DayPeriodsOld.make("fi").add("EARLY_MORNING", "aamu", 5, 6, 7, 8, 9).add("MORNING", "aamup\u00e4iv\u00e4", 10, 11).add("AFTERNOON", "iltap\u00e4iv\u00e4", 12, 13, 14, 15, 16, 17).add("EVENING", "ilta", 18, 19, 20, 21, 22).add("NIGHT", "y\u00f6", 0, 1, 2, 3, 4, 23).build();
        DayPeriodsOld.make("hu").add("EARLY_MORNING", "reggel", 6, 7, 8).add("MORNING", "d\u00e9lel\u0151tt", 9, 10, 11).add("AFTERNOON", "d\u00e9lut\u00e1n", 12, 13, 14, 15, 16, 17).add("EVENING", "este", 18, 19, 20).add("NIGHT", "\u00e9jjel", 0, 1, 2, 3, 21, 22, 23).add("LATE_NIGHT", "hajnal", 4, 5).build();
        DayPeriodsOld.make("th").add("MORNING", "\u0e40\u0e0a\u0e49\u0e32", 6, 7, 8, 9, 10, 11).add("EARLY_AFTERNOON", "\u0e40\u0e17\u0e35\u0e48\u0e22\u0e07", 12).add("AFTERNOON", "\u0e1a\u0e48\u0e32\u0e22", 13, 14, 15).add("EARLY_EVENING", "\u0e40\u0e22\u0e47\u0e19", 16, 17).add("EVENING", "\u0e04\u0e48\u0e33", 18, 19, 20).add("NIGHT", "\u0e01\u0e25\u0e32\u0e07\u0e04\u0e37\u0e19", 0, 1, 2, 3, 4, 5, 21, 22, 23).build();
        DayPeriodsOld.make("lo").add("EARLY_MORNING", "\u200b\u0e81\u0eb2\u0e87\u200b\u0e84\u0eb7\u0e99", 0, 1, 2, 3, 4).add("MORNING", "\u200b\u0ec0\u0e8a\u0ebb\u0ec9\u0eb2", 5, 6, 7, 8, 9, 10, 11).add("EARLY_AFTERNOON", "\u200b\u0eaa\u0ea7\u0eb2\u0e8d", 12, 13, 14, 15).add("AFTERNOON", "\u0ec1\u0ea5\u0e87", 16).add("EVENING", "\u200b\u0ec1\u0ea5\u0e87", 17, 18, 19).add("NIGHT", "\u200b\u0e84\u0ec8\u0eb3", 20, 21, 22, 23).build();
        DayPeriodsOld.make("ar").add("EARLY_MORNING", "\u0641\u062c\u0631\u0627", 3, 4, 5).add("MORNING", "\u0635\u0628\u0627\u062d\u0627", 6, 7, 8, 9, 10, 11).add("EARLY_AFTERNOON", "\u0638\u0647\u0631\u0627", 12).add("AFTERNOON", "\u0628\u0639\u062f \u0627\u0644\u0638\u0647\u0631", 13, 14, 15, 16, 17).add("EVENING", "\u0645\u0633\u0627\u0621", 18, 19, 20, 21, 22, 23).add("NIGHT", " \u0645\u0646\u062a\u0635\u0641 \u0627\u0644\u0644\u064a\u0644", 0).add("LATE_NIGHT", "\u0644\u064a\u0644\u0627", 1, 2).build();
        DayPeriodsOld.make("he").add("MORNING", "\u05d1\u05d5\u05e7\u05e8", 5, 6, 7, 8, 9, 10).add("EARLY_AFTERNOON", "\u05e6\u05d4\u05e8\u05d9\u05d9\u05dd", 11, 12, 13, 14).add("AFTERNOON", "\u05d0\u05d7\u05e8 \u05d4\u05e6\u05d4\u05e8\u05d9\u05d9\u05dd", 15, 16, 17).add("EVENING", "\u05e2\u05e8\u05d1", 18, 19, 20, 21).add("NIGHT", "\u05dc\u05d9\u05dc\u05d4", 0, 1, 2, 3, 4, 22, 23).build();
        DayPeriodsOld.make("id").add("MORNING", "pagi", 0, 1, 2, 3, 4, 5, 6, 7, 8, 9).add("AFTERNOON", "siang", 10, 11, 12, 13, 14).add("EVENING", "sore", 15, 16, 17).add("NIGHT", "malam", 18, 19, 20, 21, 22, 23).build();
        DayPeriodsOld.make("ms").add("EARLY_MORNING", "tengah malam", 0).add("MORNING", "pagi", 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "tengah hari", 12, 13).add("EVENING", "petang", 14, 15, 16, 17, 18).add("NIGHT", "malam", 19, 20, 21, 22, 23).build();
        DayPeriodsOld.make("fil").add("EARLY_MORNING", "madaling-araw", 0, 1, 2, 3, 4, 5).add("MORNING", "umaga", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "tanghali", 12, 13, 14, 15).add("EVENING", "hapon", 16, 17).add("NIGHT", "gabi", 18, 19, 20, 21, 22, 23).build();
        DayPeriodsOld.make("vi").add("MORNING", "s\u00e1ng", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "chi\u1ec1u", 12, 13, 14, 15, 16, 17).add("EVENING", "t\u1ed1i", 18, 19, 20).add("NIGHT", "\u0111\u00eam", 0, 1, 2, 3, 21, 22, 23).build();
        DayPeriodsOld.make("km").add("MORNING", "\u1796\u17d2\u179a\u17b9\u1780", 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u179a\u179f\u17c0\u179b", 12, 13, 14, 15, 16, 17).add("EVENING", "\u179b\u17d2\u1784\u17b6\u1785", 18, 19, 20).add("NIGHT", "\u1799\u1794\u17cb", 21, 22, 23).build();
        DayPeriodsOld.make("sw").add("EARLY_MORNING", "alfajiri", 4, 5, 6).add("MORNING", "asubuhi", 7, 8, 9, 10, 11).add("AFTERNOON", "mchana", 12, 13, 14, 15).add("EVENING", "jioni", 16, 17, 18).add("NIGHT", "usiku", 0, 1, 2, 3, 19, 20, 21, 22, 23).build();
        DayPeriodsOld.make("zu").add("EARLY_MORNING", "ntathakusa", 0, 1, 2, 3, 4, 5).add("MORNING", "ekuseni", 6, 7, 8, 9).add("AFTERNOON", "emini", 10, 11, 12).add("EVENING", "ntambama", 13, 14, 15, 16, 17, 18).add("NIGHT", "ebusuku", 19, 20, 21, 22, 23).build();
        DayPeriodsOld.make("am").add("MORNING", "\u1325\u12cb\u1275", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u12a8\u1230\u12d3\u1275 \u1260\u128b\u120b", 12, 13, 14, 15, 16, 17).add("EVENING", "\u121b\u1273", 18, 19, 20, 21, 22, 23).add("NIGHT", "\u120c\u120a\u1275", 0, 1, 2, 3, 4, 5).build();
        DayPeriodsOld.make("eu").add("EARLY_MORNING", "goizaldea", 0, 1, 2, 3, 4, 5).add("MORNING", "goiza", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "eguerdia", 12, 13).add("EVENING", "arratsaldea", 14, 15, 16, 17, 18, 19, 20).add("NIGHT", "gaua", 21, 22, 23).build();
        DayPeriodsOld.make("mn").add("MORNING", "\u04e9\u0433\u043b\u04e9\u04e9", 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u04e9\u0434\u04e9\u0440", 12, 13, 14, 15, 16, 17).add("EVENING", "\u043e\u0440\u043e\u0439", 18, 19, 20).add("NIGHT", "\u0448\u04e9\u043d\u04e9", 0, 1, 2, 3, 4, 5, 21, 22, 23).build();
        DayPeriodsOld.make("my").add("MORNING", "\u1014\u1036\u1014\u1000\u103a", 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON", "\u1014\u1031\u1037\u101c\u100a\u103a", 12, 13, 14, 15).add("EVENING", "\u100a\u1014\u1031", 16, 17, 18).add("NIGHT", "\u100a", 19, 20, 21, 22, 23).build();
    }

    public static enum DayPeriod {
        MORNING1("EARLY_MORNING"),
        MORNING2("MORNING"),
        AFTERNOON1("EARLY_AFTERNOON"),
        AFTERNOON2("AFTERNOON"),
        EVENING1("EARLY_EVENING"),
        EVENING2("EVENING"),
        NIGHT1("NIGHT"),
        NIGHT2("LATE_NIGHT");

        public final String name;

        private DayPeriod(String name) {
            this.name = name;
        }

        public static DayPeriod get(String dayPeriod) {
            for (DayPeriod d : DayPeriod.values()) {
                if (!dayPeriod.equals(d.name)) continue;
                return d;
            }
            return DayPeriod.valueOf(dayPeriod);
        }
    }

    private static class DayPeriodBuilder {
        private final ULocale locale;
        private final DayPeriod[] timeMap = new DayPeriod[24];
        private final EnumMap<DayPeriod, String> samples = new EnumMap(DayPeriod.class);

        DayPeriodBuilder(String locale) {
            this.locale = new ULocale(locale);
        }

        public DayPeriodBuilder add(String dayPeriod, String localeName, int ... hours) {
            DayPeriod dayPeriodEnum = DayPeriod.get(dayPeriod);
            String previous = this.samples.put(dayPeriodEnum, localeName);
            if (previous != null) {
                throw new IllegalArgumentException(this.locale + " Collision");
            }
            for (int i : hours) {
                if (this.timeMap[i] != null) {
                    throw new IllegalArgumentException(this.locale + " Collision " + i + ", " + (Object)((Object)this.timeMap[i]) + ", " + (Object)((Object)dayPeriodEnum));
                }
                this.timeMap[i] = dayPeriodEnum;
            }
            return this;
        }

        public DayPeriodsOld build() {
            for (int i = 0; i < this.timeMap.length; ++i) {
                DayPeriod dp = this.timeMap[i];
                if (dp != null) continue;
                throw new IllegalArgumentException(this.locale + " Missing item: " + i);
            }
            DayPeriodsOld item = new DayPeriodsOld(this.locale, this.timeMap, this.samples);
            DATA.put(this.locale, item);
            return item;
        }
    }
}

